"use strict";
/// !cdk-integ canary-one
Object.defineProperty(exports, "__esModule", { value: true });
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const synthetics = require("../lib");
/*
 * Stack verification steps:
 *
 * -- aws synthetics get-canary --name canary-one has a state of 'RUNNING'
 */
const app = new cdk.App();
const stack = new cdk.Stack(app, 'canary-one');
const bucket = new s3.Bucket(stack, 'mytestbucket');
const prefix = 'integ';
new synthetics.Canary(stack, 'MyCanary', {
    canaryName: 'canary-integ',
    test: synthetics.Test.custom({
        handler: 'index.handler',
        code: synthetics.Code.fromInline(`
      exports.handler = async () => {
        console.log(\'hello world\');
      };`),
    }),
    runtime: synthetics.Runtime.SYNTHETICS_1_0,
    schedule: synthetics.Schedule.rate(cdk.Duration.minutes(1)),
    artifactsBucketLocation: { bucket, prefix },
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuY2FuYXJ5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuY2FuYXJ5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSx5QkFBeUI7O0FBRXpCLHNDQUFzQztBQUN0QyxxQ0FBcUM7QUFDckMscUNBQXFDO0FBRXJDOzs7O0dBSUc7QUFDSCxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUMxQixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLFlBQVksQ0FBQyxDQUFDO0FBRS9DLE1BQU0sTUFBTSxHQUFHLElBQUksRUFBRSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsY0FBYyxDQUFDLENBQUM7QUFDcEQsTUFBTSxNQUFNLEdBQUcsT0FBTyxDQUFDO0FBRXZCLElBQUksVUFBVSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsVUFBVSxFQUFFO0lBQ3ZDLFVBQVUsRUFBRSxjQUFjO0lBQzFCLElBQUksRUFBRSxVQUFVLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQztRQUMzQixPQUFPLEVBQUUsZUFBZTtRQUN4QixJQUFJLEVBQUUsVUFBVSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUM7OztTQUc1QixDQUFDO0tBQ1AsQ0FBQztJQUNGLE9BQU8sRUFBRSxVQUFVLENBQUMsT0FBTyxDQUFDLGNBQWM7SUFDMUMsUUFBUSxFQUFFLFVBQVUsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQzNELHVCQUF1QixFQUFFLEVBQUUsTUFBTSxFQUFFLE1BQU0sRUFBRTtDQUM1QyxDQUFDLENBQUM7QUFFSCxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLy8gIWNkay1pbnRlZyBjYW5hcnktb25lXG5cbmltcG9ydCAqIGFzIHMzIGZyb20gJ0Bhd3MtY2RrL2F3cy1zMyc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBzeW50aGV0aWNzIGZyb20gJy4uL2xpYic7XG5cbi8qXG4gKiBTdGFjayB2ZXJpZmljYXRpb24gc3RlcHM6XG4gKlxuICogLS0gYXdzIHN5bnRoZXRpY3MgZ2V0LWNhbmFyeSAtLW5hbWUgY2FuYXJ5LW9uZSBoYXMgYSBzdGF0ZSBvZiAnUlVOTklORydcbiAqL1xuY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcbmNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjayhhcHAsICdjYW5hcnktb25lJyk7XG5cbmNvbnN0IGJ1Y2tldCA9IG5ldyBzMy5CdWNrZXQoc3RhY2ssICdteXRlc3RidWNrZXQnKTtcbmNvbnN0IHByZWZpeCA9ICdpbnRlZyc7XG5cbm5ldyBzeW50aGV0aWNzLkNhbmFyeShzdGFjaywgJ015Q2FuYXJ5Jywge1xuICBjYW5hcnlOYW1lOiAnY2FuYXJ5LWludGVnJyxcbiAgdGVzdDogc3ludGhldGljcy5UZXN0LmN1c3RvbSh7XG4gICAgaGFuZGxlcjogJ2luZGV4LmhhbmRsZXInLFxuICAgIGNvZGU6IHN5bnRoZXRpY3MuQ29kZS5mcm9tSW5saW5lKGBcbiAgICAgIGV4cG9ydHMuaGFuZGxlciA9IGFzeW5jICgpID0+IHtcbiAgICAgICAgY29uc29sZS5sb2coXFwnaGVsbG8gd29ybGRcXCcpO1xuICAgICAgfTtgKSxcbiAgfSksXG4gIHJ1bnRpbWU6IHN5bnRoZXRpY3MuUnVudGltZS5TWU5USEVUSUNTXzFfMCxcbiAgc2NoZWR1bGU6IHN5bnRoZXRpY3MuU2NoZWR1bGUucmF0ZShjZGsuRHVyYXRpb24ubWludXRlcygxKSksXG4gIGFydGlmYWN0c0J1Y2tldExvY2F0aW9uOiB7IGJ1Y2tldCwgcHJlZml4IH0sXG59KTtcblxuYXBwLnN5bnRoKCk7Il19