# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['bx_django_utils',
 'bx_django_utils.admin_extra_views',
 'bx_django_utils.admin_extra_views.management',
 'bx_django_utils.admin_extra_views.management.commands',
 'bx_django_utils.admin_extra_views.tests',
 'bx_django_utils.admin_utils',
 'bx_django_utils.approve_workflow',
 'bx_django_utils.data_types',
 'bx_django_utils.data_types.gtin',
 'bx_django_utils.dbperf',
 'bx_django_utils.humanize',
 'bx_django_utils.models',
 'bx_django_utils.templatetags',
 'bx_django_utils.test_utils',
 'bx_django_utils.user_timezone',
 'bx_django_utils.user_timezone.templatetags',
 'bx_django_utils.view_utils',
 'bx_django_utils_tests',
 'bx_django_utils_tests.approve_workflow_test_app',
 'bx_django_utils_tests.approve_workflow_test_app.migrations',
 'bx_django_utils_tests.test_app',
 'bx_django_utils_tests.test_app.management',
 'bx_django_utils_tests.test_app.management.commands',
 'bx_django_utils_tests.test_app.migrations',
 'bx_django_utils_tests.test_app.tests',
 'bx_django_utils_tests.test_app.tests.fixtures',
 'bx_django_utils_tests.test_app.views',
 'bx_django_utils_tests.test_project',
 'bx_django_utils_tests.tests',
 'bx_django_utils_tests.tests.admin_utils',
 'bx_django_utils_tests.tests.test_user_timezone']

package_data = \
{'': ['*'],
 'bx_django_utils': ['locale/de/LC_MESSAGES/*', 'locale/en/LC_MESSAGES/*'],
 'bx_django_utils.approve_workflow': ['locale/de/LC_MESSAGES/*',
                                      'locale/en/LC_MESSAGES/*',
                                      'templates/approve_workflow/*'],
 'bx_django_utils.user_timezone': ['static/*', 'templates/user_timezone/*'],
 'bx_django_utils_tests.test_app': ['templates/admin_extra_views/*',
                                    'templates/dynamic_view_menu/*'],
 'bx_django_utils_tests.test_project': ['templates/admin/*']}

install_requires = \
['bx_py_utils', 'django>=3.2,<4.2', 'python-stdnum']

entry_points = \
{'console_scripts': ['publish = '
                     'bx_django_utils_tests.test_project.publish:publish']}

setup_kwargs = {
    'name': 'bx-django-utils',
    'version': '38',
    'description': 'Various Django utility functions',
    'long_description': '# Boxine - bx_django_utils\n\nVarious Django utility functions\n\n[![unittests](https://github.com/boxine/bx_django_utils/actions/workflows/pythonapp.yml/badge.svg?branch=master)](https://github.com/boxine/bx_django_utils/actions/workflows/pythonapp.yml) [![Coverage Status on codecov.io](https://codecov.io/gh/boxine/bx_django_utils/branch/master/graph/badge.svg)](https://codecov.io/gh/boxine/bx_django_utils)\n\n[![bx_django_utils @ PyPi](https://img.shields.io/pypi/v/bx_django_utils?label=bx_django_utils%20%40%20PyPi)](https://pypi.org/project/bx_django_utils/)\n[![Python Versions](https://img.shields.io/pypi/pyversions/bx_django_utils)](https://gitlab.com/boxine/bx_django_utils/-/blob/main/pyproject.toml)\n[![License MIT](https://img.shields.io/pypi/l/bx_django_utils)](https://gitlab.com/boxine/bx_django_utils/-/blob/main/LICENSE)\n\n\n## Quickstart\n\n```bash\npip install bx_django_utils\n```\n\n\n## Existing stuff\n\nHere only a simple list about existing utilities.\nPlease take a look into the sources and tests for deeper informations.\n\n[comment]: <> (✂✂✂ auto generated start ✂✂✂)\n\n### bx_django_utils.admin_extra_views\n\nDjango Admin extra views: https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_extra_views/README.md\n\n\n#### bx_django_utils.admin_extra_views.admin_config\n\nActivate "ExtraViewAdminSite" by set this as default admin site\n\n* [`CustomAdminConfig()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_extra_views/admin_config.py#L7-L12) - Change Django Admin Site to ExtraViewAdminSite for the extra views.\n\n#### bx_django_utils.admin_extra_views.apps\n\n* [`AdminExtraViewsAppConfig()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_extra_views/apps.py#L6-L18) - App config to auto discover all extra views.\n\n#### bx_django_utils.admin_extra_views.conditions\n\n* [`only_staff_user()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_extra_views/conditions.py#L4-L15) - Pass only active staff users. The default condition for all admin extra views.\n\n#### bx_django_utils.admin_extra_views.datatypes\n\n* [`AdminExtraMeta()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_extra_views/datatypes.py#L15-L58) - Stores information for pseudo app and pseudo models.\n* [`PseudoApp()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_extra_views/datatypes.py#L61-L91) - Represents information about a Django App. Instance must be pass to @register_admin_view()\n\n###### bx_django_utils.admin_extra_views.management.commands.admin_extra_views\n\n* [`Command()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_extra_views/management/commands/admin_extra_views.py#L7-L26) - Manage command "admin_extra_views": Info about registered admin extra views\n\n#### bx_django_utils.admin_extra_views.registry\n\n* [`AdminExtraViewRegistry()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_extra_views/registry.py#L11-L97) - Hold all information about all admin extra views to expand urls and admin app list.\n* [`register_admin_view()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_extra_views/registry.py#L103-L116) - Decorator to add a normal view as pseudo App/Model to the admin.\n\n#### bx_django_utils.admin_extra_views.site\n\n* [`ExtraViewAdminSite()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_extra_views/site.py#L6-L13) - An AdminSite object encapsulates an instance of the Django admin application, ready\n\n##### bx_django_utils.admin_extra_views.tests.test_admin_extra_views\n\n* [`AdminExtraViewsTestCase()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_extra_views/tests/test_admin_extra_views.py#L10-L39) - Integrations tests for Admin Extra Views.\n\n#### bx_django_utils.admin_extra_views.utils\n\n* [`iter_admin_extra_views_urls()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_extra_views/utils.py#L20-L26) - Iterate over all registered admin extra view urls.\n* [`reverse_admin_extra_view()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_extra_views/utils.py#L10-L17) - Get the URL of a Admin Extra View, e.g.: url=reverse_admin_extra_view(YouAdminExtraView)\n\n#### bx_django_utils.admin_extra_views.views\n\n* [`Redirect2AdminExtraView()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_extra_views/views.py#L7-L23) - Redirect to a Admin Extra Views.\n\n#### bx_django_utils.admin_utils.admin_urls\n\nHelpers to build Admin URLs\n\n* [`admin_change_url()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_utils/admin_urls.py#L62-L78) - Shortcut to generate Django admin "change" url for a model instance.\n* [`admin_changelist_url()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_utils/admin_urls.py#L119-L134) - Shortcut to generate Django admin "changelist" url for a model or instance.\n* [`admin_delete_url()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_utils/admin_urls.py#L100-L116) - Shortcut to generate Django admin "delete" url for a model instance.\n* [`admin_history_url()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_utils/admin_urls.py#L81-L97) - Shortcut to generate Django admin "history" url for a model instance.\n* [`admin_model_url()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_utils/admin_urls.py#L15-L59) - Build Admin change, add, changelist, etc. links with optional filter parameters.\n\n#### bx_django_utils.admin_utils.filters\n\n* [`ExistingCountedListFilter()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_utils/filters.py#L26-L62) - Advanced SimpleListFilter that list only existing filter values with counts.\n* [`NotAllSimpleListFilter()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/admin_utils/filters.py#L8-L23) - Similar to SimpleListFilter, but don\'t add "All" choice.\n\n### bx_django_utils.approve_workflow\n\nBase model/admin/form classes to implement a model with draft/approve versions workflow\n\n\n#### bx_django_utils.approve_workflow.admin\n\n* [`BaseApproveModelAdmin()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/approve_workflow/admin.py#L15-L107) - Base admin class for a draft/approve Model\n\n#### bx_django_utils.approve_workflow.forms\n\n* [`PublishAdminForm()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/approve_workflow/forms.py#L7-L46) - Activate models REQUIRED_FIELDS_PUBLIC on approve\n\n#### bx_django_utils.approve_workflow.models\n\n* [`BaseApproveModel()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/approve_workflow/models.py#L14-L202) - Base model class for approve models *and* this relation models.\n* [`BaseApproveWorkflowModel()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/approve_workflow/models.py#L205-L255) - Base model for approve workflow models.\n\n### bx_django_utils.cached_dataclasses\n\n* [`CachedDataclassBase()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/cached_dataclasses.py#L7-L59) - A Base dataclass that can be easy store/restore to Django cache.\n\n#### bx_django_utils.data_types.gtin\n\nModelField, FormField and validators for GTIN/UPC/EAN numbers\n\n\n##### bx_django_utils.data_types.gtin.form_fields\n\n* [`GtinFormField()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/data_types/gtin/form_fields.py#L8-L28) - Form field with GTIN validator.\n\n##### bx_django_utils.data_types.gtin.model_fields\n\n* [`GtinModelField()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/data_types/gtin/model_fields.py#L10-L33) - GTIN model field\n\n##### bx_django_utils.data_types.gtin.validators\n\n* [`GtinValidator()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/data_types/gtin/validators.py#L33-L52) - Validate GTIN number\n* [`validate_gtin()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/data_types/gtin/validators.py#L12-L30) - It\'s the same as stdnum.ean.validate() but also accept ISBN-10\n\n#### bx_django_utils.dbperf.cursor\n\n* [`RecordingCursorWrapper()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/dbperf/cursor.py#L17-L136) - An implementation of django.db.backends.utils.CursorWrapper.\n\n#### bx_django_utils.dbperf.query_recorder\n\n* [`SQLQueryRecorder()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/dbperf/query_recorder.py#L95-L176) - A context manager that allows recording SQL queries executed during its lifetime.\n\n### bx_django_utils.filename\n\n* [`clean_filename()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/filename.py#L34-L64) - Convert filename to ASCII only via slugify.\n* [`filename2human_name()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/filename.py#L7-L31) - Convert filename to a capitalized name.\n\n#### bx_django_utils.humanize.pformat\n\n* [`pformat()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/humanize/pformat.py#L6-L20) - Better `pretty-print-format` using `DjangoJSONEncoder` with fallback to `pprint.pformat()`\n\n#### bx_django_utils.humanize.time\n\n* [`human_timedelta()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/humanize/time.py#L18-L63) - Converts a time duration into a friendly text representation. (`X ms`, `sec`, `minutes` etc.)\n\n### bx_django_utils.json_utils\n\n* [`make_json_serializable()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/json_utils.py#L20-L37) - Convert value to a JSON serializable value, with convert callback for special objects.\n* [`to_json()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/json_utils.py#L40-L56) - Convert value to JSON via make_json_serializable() and DjangoJSONEncoder()\n\n#### bx_django_utils.models.color_field\n\n* [`ColorModelField()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/models/color_field.py#L14-L29) - Hex color model field, e.g.: "#0055ff" (It\'s not a html color picker widget)\n* [`HexColorValidator()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/models/color_field.py#L6-L11) - Hex color validator (seven-character hexadecimal notation, e.g.: "#0055ff")\n\n#### bx_django_utils.models.manipulate\n\nUtilities to manipulate objects in database via models:\n\n* [`CreateOrUpdateResult()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/models/manipulate.py#L39-L63) - Result object returned by create_or_update2() with all information about create/save a model.\n* [`InvalidStoreBehavior()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/models/manipulate.py#L19-L23) - Exception used in create_or_update() if "store_behavior" contains not existing field names.\n* [`create()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/models/manipulate.py#L26-L36) - Create a new model instance with optional validate before create.\n* [`create_or_update()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/models/manipulate.py#L197-L217) - Create a new model instance or update a existing one. Deprecated! Use: create_or_update2()\n* [`create_or_update2()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/models/manipulate.py#L66-L194) - Create a new model instance or update a existing one and returns CreateOrUpdateResult instance\n\n#### bx_django_utils.models.queryset_utils\n\n* [`remove_filter()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/models/queryset_utils.py#L8-L33) - Remove an applied .filter() from a QuerySet\n* [`remove_model_filter()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/models/queryset_utils.py#L36-L58) - Remove an applied .filter() from a QuerySet if it contains references to the specified model\n\n#### bx_django_utils.models.timetracking\n\n* [`TimetrackingBaseModel()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/models/timetracking.py#L8-L62) - Abstract base model that will automaticly set create/update Datetimes.\n\n### bx_django_utils.stacktrace\n\n* [`StackTrace()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/stacktrace.py#L21-L22) - Built-in mutable sequence.\n* [`StacktraceAfter()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/stacktrace.py#L83-L111) - Generate a stack trace after a package was visited.\n* [`get_stacktrace()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/stacktrace.py#L63-L80) - Returns a StackTrace object, which is a list of FrameInfo objects.\n\n#### bx_django_utils.templatetags.humanize_time\n\n* [`human_duration()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/templatetags/humanize_time.py#L15-L45) - Verbose time since template tag, e.g.: `<span title="Jan. 1, 2000, noon">2.0 seconds</span>`\n\n### bx_django_utils.test_utils\n\nUtilities / helper for writing tests.\n\n\n#### bx_django_utils.test_utils.assert_queries\n\n* [`AssertQueries()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/assert_queries.py#L34-L281) - Assert executed database queries: Check table names, duplicate/similar Queries.\n\n#### bx_django_utils.test_utils.cache\n\n* [`ClearCacheMixin()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/cache.py#L100-L111) - TestCase mixin to clear the Django cache in setUp/tearDown\n* [`MockCache()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/cache.py#L55-L97) - Mock Django cache backend, so it\'s easy to check/manipulate the cache content\n\n#### bx_django_utils.test_utils.content_types\n\n* [`ContentTypeCacheFixMixin()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/content_types.py#L7-L35) - TestCase mixin to fill the ContentType cache to avoid flaky database queries.\n\n#### bx_django_utils.test_utils.datetime\n\n* [`MockDatetimeGenerator()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/datetime.py#L4-L50) - Mock django `timezone.now()` with generic time stamps in tests.\n\n#### bx_django_utils.test_utils.fixtures\n\nUtilities to manage text fixtures in JSON files.\n\n* [`BaseFixtures()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/fixtures.py#L27-L60) - Base class for JSON dump fixtures.\n* [`FixturesRegistry()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/fixtures.py#L97-L127) - Registry to collect a list of all existing fixture classes.\n* [`RenewAllFixturesBaseCommand()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/fixtures.py#L159-L191) - A base Django manage command to renew all existing fixture JSON dump files\n* [`SerializerFixtures()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/fixtures.py#L63-L94) - Helper to store/restore model instances serialized into a JSON file.\n* [`autodiscover()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/fixtures.py#L133-L156) - Register all fixtures by import all **/fixtures/**/*.py files\n\n#### bx_django_utils.test_utils.forms\n\n* [`AssertFormFields()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/forms.py#L13-L86) - Helper to check the existing form fields.\n\n#### bx_django_utils.test_utils.html_assertion\n\n* [`HtmlAssertionMixin()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/html_assertion.py#L38-L140) - Unittest mixin class with useful assertments around Django test client tests\n* [`assert_html_response_snapshot()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/html_assertion.py#L9-L35) - Assert a HttpResponse via snapshot file using assert_html_snapshot() from bx_py_utils.\n\n#### bx_django_utils.test_utils.model_clean_assert\n\n* [`AssertModelCleanCalled()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/model_clean_assert.py#L35-L86) - Context manager for assert that full_clean() was called for every model instance.\n* [`CleanMock()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/model_clean_assert.py#L6-L32) - Track if full_clean() was called.\n\n#### bx_django_utils.test_utils.playwright\n\nUse Playwright in Unittest + Fast Django user login\n\n* [`PlaywrightConfig()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/playwright.py#L13-L31) - PlaywrightTestCase config from environment (PWBROWSER, PWHEADLESS, PWSKIP, PWSLOWMO)\n* [`PlaywrightTestCase()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/playwright.py#L34-L91) - StaticLiveServerTestCase with helpers for writing frontend tests using Playwright.\n\n#### bx_django_utils.test_utils.users\n\n* [`assert_permissions()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/users.py#L31-L46) - Check user permissions.\n* [`assert_user_properties()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/users.py#L149-L171) - Check a user instance with all properties and password (optional)\n* [`filter_permission_names()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/users.py#L10-L28) - Generate a Permission model query filtered by names, e.g.: [\'<app_label>.<codename>\', ...]\n* [`make_max_test_user()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/users.py#L112-L146) - Create a test user with all permissions *except* the {exclude_permissions} ones.\n* [`make_minimal_test_user()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/users.py#L85-L109) - Create a test user and set given permissions.\n* [`make_test_user()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/test_utils/users.py#L49-L82) - Create a test user and set given permissions.\n\n### bx_django_utils.user_timezone\n\nAutomatic local user timezone: https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/user_timezone/README.md\n\n\n#### bx_django_utils.user_timezone.apps\n\n* [`UserTimezoneAppConfig()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/user_timezone/apps.py#L4-L14) - Django app to set the user local time zone.\n\n#### bx_django_utils.user_timezone.humanize\n\n* [`human_timezone_datetime()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/user_timezone/humanize.py#L7-L21) - Render a datetime with timezone information.\n\n#### bx_django_utils.user_timezone.middleware\n\n* [`UserTimezoneMiddleware()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/user_timezone/middleware.py#L10-L31) - Activate Timezone by "UserTimeZone" cookie\n\n##### bx_django_utils.user_timezone.templatetags.user_timezone\n\n* [`humane_timezone_dt()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/user_timezone/templatetags/user_timezone.py#L9-L14) - Template filter to render a datetime with timezone information.\n\n#### bx_django_utils.view_utils.dynamic_menu_urls\n\n* [`DynamicViewMenu()`](https://github.com/boxine/bx_django_utils/blob/master/bx_django_utils/view_utils/dynamic_menu_urls.py#L4-L45) - Simple storage for store information about views/urls to build a menu.\n\n[comment]: <> (✂✂✂ auto generated end ✂✂✂)\n\n## developing\n\nTo start developing e.g.:\n\n```bash\n~$ git clone https://github.com/boxine/bx_django_utils.git\n~$ cd bx_django_utils\n~/bx_django_utils$ make\nhelp                 List all commands\ninstall-poetry       install poetry\ninstall              install via poetry\nupdate               Update the dependencies as according to the pyproject.toml file\nlint                 Run code formatters and linter\nfix-code-style       Fix code formatting\ntox-listenvs         List all tox test environments\ntox                  Run unittests via tox with all environments\ntest                 Run unittests\npublish              Release new version to PyPi\ndocker-test          Run tests in docker\nmakemessages         Make and compile locales message files\nstart-dev-server     Start Django dev. server with the test project\nclean                Remove created files from the test project (e.g.: SQlite, static files)\nplaywright-install   Install test browser for Playwright tests\nplaywright-inspector Run Playwright inspector\nplaywright-tests     Run only the Playwright tests\n```\n\nYou can start the test project with the Django developing server, e.g.:\n```bash\n~/bx_django_utils$ make start-dev-server\n```\nThis is a own manage command, that will create migrations files from our test app, migrate, collectstatic and create a super user if no user exists ;)\n\nIf you like to start from stretch, just delete related test project files with:\n```bash\n~/bx_django_utils$ make clean\n```\n...and start the test server again ;)\n\n\n## License\n\n[MIT](LICENSE). Patches welcome!\n\n\n## About us\n\nWe’ve been rethinking the listening experience for kids and have created an ecosystem where haptic and listening experience are combined via smart technology - the Toniebox.\n\nWe are constantly looking for engineers to join our team in different areas. If you’d be interested in contributing to our platform, have a look at: https://tonies.com/jobs/\n\n\n## Links\n\n* https://pypi.org/project/bx-django-utils/\n',
    'author': 'Jens Diemer',
    'author_email': 'jens.diemer@boxine.de',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/boxine/bx_django_utils/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0.0',
}


setup(**setup_kwargs)
