# this is auto-generated by swagger-marshmallow-codegen
from __future__ import annotations
from dataclasses import dataclass
from marshmallow import (
    Schema,
    fields,
    INCLUDE,
    post_load,
)
from marshmallow.validate import (
    Length,
    OneOf,
    Regexp,
)
from swagger_marshmallow_codegen.validate import (
    ItemsRange,
    Range,
)
import re


class AnnotationComponent(Schema):
    pk = fields.Integer(required=True, dump_only=True)
    name = fields.String(validate=[Length(min=None, max=128, equal=None)])
    allowed_values = fields.List(fields.String(validate=[Length(min=None, max=128, equal=None)]), description='Comma separated list of possible value, leave it empty for free input.', allow_none=True)

    class Meta:
        unknown = INCLUDE



class AnnotationTaxonomy(Schema):
    pk = fields.Integer(required=True, dump_only=True)
    document = fields.Integer(allow_none=True)
    name = fields.String(required=True, validate=[Length(min=None, max=64, equal=None)])
    marker_type = fields.Integer(validate=[OneOf(choices=[1, 2, 3, 4, 5, 6], labels=[])])
    marker_detail = fields.String(allow_none=True, validate=[Length(min=None, max=7, equal=None)])
    has_comments = fields.Boolean()
    typology = fields.Nested(lambda: AnnotationType())
    components = fields.List(fields.Nested(lambda: AnnotationComponent()))

    class Meta:
        unknown = INCLUDE



class AnnotationType(Schema):
    pk = fields.Integer(required=True, dump_only=True)
    name = fields.String(required=True, validate=[Length(min=None, max=128, equal=None)])

    class Meta:
        unknown = INCLUDE



class AuthToken(Schema):
    username = fields.String(required=True)
    password = fields.String(required=True)
    token = fields.String(required=True, dump_only=True)

    class Meta:
        unknown = INCLUDE



class Block(Schema):
    pk = fields.Integer(required=True, dump_only=True)
    document_part = fields.Integer(required=True)
    external_id = fields.String(allow_none=True, validate=[Length(min=None, max=128, equal=None)])
    order = fields.Integer(required=True, dump_only=True)
    box = fields.Dict(keys=fields.String(), values=fields.Field(), required=True)
    typology = fields.Integer(allow_none=True)

    class Meta:
        unknown = INCLUDE



class BlockType(Schema):
    pk = fields.Integer(required=True, dump_only=True)
    name = fields.String(required=True, validate=[Length(min=None, max=128, equal=None)])

    class Meta:
        unknown = INCLUDE



class DetailedLine(Schema):
    pk = fields.Integer()
    document_part = fields.Integer(required=True)
    external_id = fields.String(allow_none=True, validate=[Length(min=None, max=128, equal=None)])
    order = fields.Integer(required=True, dump_only=True)
    region = fields.Integer(allow_none=True)
    baseline = fields.Dict(keys=fields.String(), values=fields.Field(), allow_none=True)
    mask = fields.Dict(keys=fields.String(), values=fields.Field(), allow_none=True)
    typology = fields.Integer(allow_none=True)
    transcriptions = fields.List(fields.Nested(lambda: LineTranscription()))

    class Meta:
        unknown = INCLUDE



class ImageAnnotation(Schema):
    pk = fields.Integer(required=True, dump_only=True)
    part = fields.Integer(required=True)
    comments = fields.List(fields.String(), allow_none=True)
    coordinates = fields.List(fields.List(fields.Integer(validate=[Range(min=-2147483648, max=2147483647, min_inclusive=True, max_inclusive=True)]), validate=[ItemsRange(min=None, max=2, min_inclusive=True, max_inclusive=True)]), required=True)
    taxonomy = fields.Integer(required=True)
    components = fields.List(fields.Nested(lambda: ImageAnnotationComponent()), required=True)
    as_w3c = fields.String(required=True, dump_only=True)

    class Meta:
        unknown = INCLUDE



class ImageAnnotationComponent(Schema):
    pk = fields.Integer(required=True, dump_only=True)
    component = fields.Integer(required=True)
    value = fields.String(required=True, allow_none=True)

    class Meta:
        unknown = INCLUDE



class Line(Schema):
    pk = fields.Integer()
    document_part = fields.Integer(required=True)
    external_id = fields.String(allow_none=True, validate=[Length(min=None, max=128, equal=None)])
    order = fields.Integer(required=True, dump_only=True)
    region = fields.Integer(allow_none=True)
    baseline = fields.Dict(keys=fields.String(), values=fields.Field(), allow_none=True)
    mask = fields.Dict(keys=fields.String(), values=fields.Field(), allow_none=True)
    typology = fields.Integer(allow_none=True)

    class Meta:
        unknown = INCLUDE



class LineTranscription(Schema):
    pk = fields.Integer(required=True, dump_only=True)
    line = fields.Integer(required=True, allow_none=True)
    transcription = fields.Integer(required=True)
    content = fields.String(validate=[Length(min=None, max=2048, equal=None)])
    graphs = fields.Dict(keys=fields.String(), values=fields.Field(), allow_none=True)
    versions = fields.Dict(keys=fields.String(), values=fields.Field(), required=True, dump_only=True)
    version_author = fields.String(required=True, dump_only=True)
    version_source = fields.String(required=True, dump_only=True)
    version_updated_at = fields.AwareDateTime(required=True, dump_only=True)

    class Meta:
        unknown = INCLUDE



class LineType(Schema):
    pk = fields.Integer(required=True, dump_only=True)
    name = fields.String(required=True, validate=[Length(min=None, max=128, equal=None)])

    class Meta:
        unknown = INCLUDE



class OcrModel(Schema):
    pk = fields.Integer(required=True, dump_only=True)
    name = fields.String(required=True, validate=[Length(min=None, max=256, equal=None)])
    file = fields.String(allow_none=True, validate=[Regexp(regex=re.compile('(?:mlmodel)$'))])
    file_size = fields.Integer()
    job = fields.Integer(required=True, validate=[OneOf(choices=[1, 2], labels=[])])
    owner = fields.String(required=True, description='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', dump_only=True)
    training = fields.Boolean(required=True, dump_only=True)
    versions = fields.Dict(keys=fields.String(), values=fields.Field(), required=True, dump_only=True)

    class Meta:
        unknown = INCLUDE



class PaginatedAnnotationTaxonomyList(Schema):
    count = fields.Integer()
    next = fields.String(allow_none=True)
    previous = fields.String(allow_none=True)
    results = fields.List(fields.Nested(lambda: AnnotationTaxonomy()))

    class Meta:
        unknown = INCLUDE



class PaginatedAnnotationTypeList(Schema):
    count = fields.Integer()
    next = fields.String(allow_none=True)
    previous = fields.String(allow_none=True)
    results = fields.List(fields.Nested(lambda: AnnotationType()))

    class Meta:
        unknown = INCLUDE



class PaginatedBlockList(Schema):
    count = fields.Integer()
    next = fields.String(allow_none=True)
    previous = fields.String(allow_none=True)
    results = fields.List(fields.Nested(lambda: Block()))

    class Meta:
        unknown = INCLUDE



class PaginatedBlockTypeList(Schema):
    count = fields.Integer()
    next = fields.String(allow_none=True)
    previous = fields.String(allow_none=True)
    results = fields.List(fields.Nested(lambda: BlockType()))

    class Meta:
        unknown = INCLUDE



class PaginatedImageAnnotationList(Schema):
    count = fields.Integer()
    next = fields.String(allow_none=True)
    previous = fields.String(allow_none=True)
    results = fields.List(fields.Nested(lambda: ImageAnnotation()))

    class Meta:
        unknown = INCLUDE



class PaginatedLineList(Schema):
    count = fields.Integer()
    next = fields.String(allow_none=True)
    previous = fields.String(allow_none=True)
    results = fields.List(fields.Nested(lambda: Line()))

    class Meta:
        unknown = INCLUDE



class PaginatedLineTypeList(Schema):
    count = fields.Integer()
    next = fields.String(allow_none=True)
    previous = fields.String(allow_none=True)
    results = fields.List(fields.Nested(lambda: LineType()))

    class Meta:
        unknown = INCLUDE



class PaginatedOcrModelList(Schema):
    count = fields.Integer()
    next = fields.String(allow_none=True)
    previous = fields.String(allow_none=True)
    results = fields.List(fields.Nested(lambda: OcrModel()))

    class Meta:
        unknown = INCLUDE



class PaginatedPartList(Schema):
    count = fields.Integer()
    next = fields.String(allow_none=True)
    previous = fields.String(allow_none=True)
    results = fields.List(fields.Nested(lambda: Part()))

    class Meta:
        unknown = INCLUDE



class PaginatedProjectList(Schema):
    count = fields.Integer()
    next = fields.String(allow_none=True)
    previous = fields.String(allow_none=True)
    results = fields.List(fields.Nested(lambda: Project()))

    class Meta:
        unknown = INCLUDE



class PaginatedScriptList(Schema):
    count = fields.Integer()
    next = fields.String(allow_none=True)
    previous = fields.String(allow_none=True)
    results = fields.List(fields.Nested(lambda: Script()))

    class Meta:
        unknown = INCLUDE



class PaginatedTagDocumentList(Schema):
    count = fields.Integer()
    next = fields.String(allow_none=True)
    previous = fields.String(allow_none=True)
    results = fields.List(fields.Nested(lambda: TagDocument()))

    class Meta:
        unknown = INCLUDE



class PaginatedTextAnnotationList(Schema):
    count = fields.Integer()
    next = fields.String(allow_none=True)
    previous = fields.String(allow_none=True)
    results = fields.List(fields.Nested(lambda: TextAnnotation()))

    class Meta:
        unknown = INCLUDE



class PaginatedUserOnboardingList(Schema):
    count = fields.Integer()
    next = fields.String(allow_none=True)
    previous = fields.String(allow_none=True)
    results = fields.List(fields.Nested(lambda: UserOnboarding()))

    class Meta:
        unknown = INCLUDE



class Part(Schema):
    pk = fields.Integer(required=True, dump_only=True)
    name = fields.String(validate=[Length(min=None, max=512, equal=None)])
    filename = fields.String(required=True, dump_only=True)
    title = fields.String(required=True, dump_only=True)
    typology = fields.Integer(allow_none=True)
    image = fields.String()
    image_file_size = fields.Integer()
    bw_image = fields.String()
    workflow = fields.Dict(keys=fields.String(), values=fields.Field(), required=True, dump_only=True)
    order = fields.Integer(required=True, dump_only=True)
    recoverable = fields.String(required=True, dump_only=True)
    transcription_progress = fields.Integer(required=True, dump_only=True)
    source = fields.String(validate=[Length(min=None, max=1024, equal=None)])

    class Meta:
        unknown = INCLUDE



class PartDetail(Schema):
    pk = fields.Integer(required=True, dump_only=True)
    name = fields.String(validate=[Length(min=None, max=512, equal=None)])
    filename = fields.String(required=True, dump_only=True)
    title = fields.String(required=True, dump_only=True)
    typology = fields.Integer(allow_none=True)
    image = fields.String()
    image_file_size = fields.Integer()
    bw_image = fields.String()
    workflow = fields.Dict(keys=fields.String(), values=fields.Field(), required=True, dump_only=True)
    order = fields.Integer(required=True, dump_only=True)
    recoverable = fields.String(required=True, dump_only=True)
    transcription_progress = fields.Integer(required=True, dump_only=True)
    source = fields.String(validate=[Length(min=None, max=1024, equal=None)])
    regions = fields.List(fields.Nested(lambda: Block()), required=True)
    lines = fields.List(fields.Nested(lambda: Line()), required=True)
    previous = fields.String(required=True, dump_only=True)
    next = fields.String(required=True, dump_only=True)

    class Meta:
        unknown = INCLUDE



class PatchedAnnotationTaxonomy(Schema):
    pk = fields.Integer(dump_only=True)
    document = fields.Integer(allow_none=True)
    name = fields.String(validate=[Length(min=None, max=64, equal=None)])
    marker_type = fields.Integer(validate=[OneOf(choices=[1, 2, 3, 4, 5, 6], labels=[])])
    marker_detail = fields.String(allow_none=True, validate=[Length(min=None, max=7, equal=None)])
    has_comments = fields.Boolean()
    typology = fields.Nested(lambda: AnnotationType())
    components = fields.List(fields.Nested(lambda: AnnotationComponent()))

    class Meta:
        unknown = INCLUDE



class PatchedAnnotationType(Schema):
    pk = fields.Integer(dump_only=True)
    name = fields.String(validate=[Length(min=None, max=128, equal=None)])

    class Meta:
        unknown = INCLUDE



class PatchedBlock(Schema):
    pk = fields.Integer(dump_only=True)
    document_part = fields.Integer()
    external_id = fields.String(allow_none=True, validate=[Length(min=None, max=128, equal=None)])
    order = fields.Integer(dump_only=True)
    box = fields.Dict(keys=fields.String(), values=fields.Field())
    typology = fields.Integer(allow_none=True)

    class Meta:
        unknown = INCLUDE



class PatchedBlockType(Schema):
    pk = fields.Integer(dump_only=True)
    name = fields.String(validate=[Length(min=None, max=128, equal=None)])

    class Meta:
        unknown = INCLUDE



class PatchedImageAnnotation(Schema):
    pk = fields.Integer(dump_only=True)
    part = fields.Integer()
    comments = fields.List(fields.String(), allow_none=True)
    coordinates = fields.List(fields.List(fields.Integer(validate=[Range(min=-2147483648, max=2147483647, min_inclusive=True, max_inclusive=True)]), validate=[ItemsRange(min=None, max=2, min_inclusive=True, max_inclusive=True)]))
    taxonomy = fields.Integer()
    components = fields.List(fields.Nested(lambda: ImageAnnotationComponent()))
    as_w3c = fields.String(dump_only=True)

    class Meta:
        unknown = INCLUDE



class PatchedLine(Schema):
    pk = fields.Integer()
    document_part = fields.Integer()
    external_id = fields.String(allow_none=True, validate=[Length(min=None, max=128, equal=None)])
    order = fields.Integer(dump_only=True)
    region = fields.Integer(allow_none=True)
    baseline = fields.Dict(keys=fields.String(), values=fields.Field(), allow_none=True)
    mask = fields.Dict(keys=fields.String(), values=fields.Field(), allow_none=True)
    typology = fields.Integer(allow_none=True)

    class Meta:
        unknown = INCLUDE



class PatchedLineType(Schema):
    pk = fields.Integer(dump_only=True)
    name = fields.String(validate=[Length(min=None, max=128, equal=None)])

    class Meta:
        unknown = INCLUDE



class PatchedOcrModel(Schema):
    pk = fields.Integer(dump_only=True)
    name = fields.String(validate=[Length(min=None, max=256, equal=None)])
    file = fields.String(allow_none=True, validate=[Regexp(regex=re.compile('(?:mlmodel)$'))])
    file_size = fields.Integer()
    job = fields.Integer(validate=[OneOf(choices=[1, 2], labels=[])])
    owner = fields.String(description='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', dump_only=True)
    training = fields.Boolean(dump_only=True)
    versions = fields.Dict(keys=fields.String(), values=fields.Field(), dump_only=True)

    class Meta:
        unknown = INCLUDE



class PatchedPart(Schema):
    pk = fields.Integer(dump_only=True)
    name = fields.String(validate=[Length(min=None, max=512, equal=None)])
    filename = fields.String(dump_only=True)
    title = fields.String(dump_only=True)
    typology = fields.Integer(allow_none=True)
    image = fields.String()
    image_file_size = fields.Integer()
    bw_image = fields.String()
    workflow = fields.Dict(keys=fields.String(), values=fields.Field(), dump_only=True)
    order = fields.Integer(dump_only=True)
    recoverable = fields.String(dump_only=True)
    transcription_progress = fields.Integer(dump_only=True)
    source = fields.String(validate=[Length(min=None, max=1024, equal=None)])

    class Meta:
        unknown = INCLUDE



class PatchedProject(Schema):
    id = fields.Integer(dump_only=True)
    name = fields.String(validate=[Length(min=None, max=512, equal=None)])
    slug = fields.String(validate=[Length(min=None, max=50, equal=None), Regexp(regex=re.compile('^[-a-zA-Z0-9_]+$'))])
    created_at = fields.AwareDateTime(dump_only=True)
    updated_at = fields.AwareDateTime(dump_only=True)
    owner = fields.Integer(allow_none=True)
    shared_with_users = fields.List(fields.Integer())
    shared_with_groups = fields.List(fields.Integer())

    class Meta:
        unknown = INCLUDE



class PatchedTagDocument(Schema):
    pk = fields.Integer(dump_only=True)
    name = fields.String(validate=[Length(min=None, max=100, equal=None)])
    color = fields.String(validate=[Length(min=None, max=7, equal=None)])

    class Meta:
        unknown = INCLUDE



class PatchedTextAnnotation(Schema):
    pk = fields.Integer(dump_only=True)
    part = fields.Integer()
    comments = fields.List(fields.String(), allow_none=True)
    taxonomy = fields.Integer()
    components = fields.List(fields.Nested(lambda: TextAnnotationComponent()))
    start_line = fields.Integer()
    start_offset = fields.Integer(validate=[Range(min=0, max=2147483647, min_inclusive=True, max_inclusive=True)])
    end_line = fields.Integer()
    end_offset = fields.Integer(validate=[Range(min=0, max=2147483647, min_inclusive=True, max_inclusive=True)])
    as_w3c = fields.String(dump_only=True)

    class Meta:
        unknown = INCLUDE



class PatchedTranscription(Schema):
    pk = fields.Integer(dump_only=True)
    name = fields.String(validate=[Length(min=None, max=512, equal=None)])

    class Meta:
        unknown = INCLUDE



class PatchedUserOnboarding(Schema):
    onboarding = fields.Boolean()

    class Meta:
        unknown = INCLUDE



class Project(Schema):
    id = fields.Integer(required=True, dump_only=True)
    name = fields.String(required=True, validate=[Length(min=None, max=512, equal=None)])
    slug = fields.String(required=True, validate=[Length(min=None, max=50, equal=None), Regexp(regex=re.compile('^[-a-zA-Z0-9_]+$'))])
    created_at = fields.AwareDateTime(required=True, dump_only=True)
    updated_at = fields.AwareDateTime(required=True, dump_only=True)
    owner = fields.Integer(allow_none=True)
    shared_with_users = fields.List(fields.Integer())
    shared_with_groups = fields.List(fields.Integer())

    class Meta:
        unknown = INCLUDE



class Script(Schema):
    id = fields.Integer(required=True, dump_only=True)
    name = fields.String(required=True, validate=[Length(min=None, max=128, equal=None)])
    name_fr = fields.String(validate=[Length(min=None, max=128, equal=None)])
    iso_code = fields.String(validate=[Length(min=None, max=4, equal=None)])
    text_direction = fields.String(validate=[OneOf(choices=['horizontal-lr', 'horizontal-rl', 'vertical-lr', 'vertical-rl', 'ttb'], labels=[])])

    class Meta:
        unknown = INCLUDE



class TagDocument(Schema):
    pk = fields.Integer(required=True, dump_only=True)
    name = fields.String(required=True, validate=[Length(min=None, max=100, equal=None)])
    color = fields.String(validate=[Length(min=None, max=7, equal=None)])

    class Meta:
        unknown = INCLUDE



class TextAnnotation(Schema):
    pk = fields.Integer(required=True, dump_only=True)
    part = fields.Integer(required=True)
    comments = fields.List(fields.String(), allow_none=True)
    taxonomy = fields.Integer(required=True)
    components = fields.List(fields.Nested(lambda: TextAnnotationComponent()), required=True)
    start_line = fields.Integer(required=True)
    start_offset = fields.Integer(required=True, validate=[Range(min=0, max=2147483647, min_inclusive=True, max_inclusive=True)])
    end_line = fields.Integer(required=True)
    end_offset = fields.Integer(required=True, validate=[Range(min=0, max=2147483647, min_inclusive=True, max_inclusive=True)])
    as_w3c = fields.String(required=True, dump_only=True)

    class Meta:
        unknown = INCLUDE



class TextAnnotationComponent(Schema):
    pk = fields.Integer(required=True, dump_only=True)
    component = fields.Integer(required=True)
    value = fields.String(required=True, allow_none=True)

    class Meta:
        unknown = INCLUDE

# @dataclass(frozen=True)
# class Transcription:
#     pk: int
#     name: str


class Transcription(Schema):
    pk = fields.Integer(required=True, dump_only=True)
    name = fields.String(required=True, validate=[Length(min=None, max=512, equal=None)])

    class Meta:
        unknown = INCLUDE
        
    # @post_load
    # def make_Transcription(self, data, **kwargs):
    #     return Transcription(**data)



class UserOnboarding(Schema):
    onboarding = fields.Boolean()

    class Meta:
        unknown = INCLUDE
