/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.disp.txt;

import com.cmayes.common.CommonConstants;
import com.cmayes.common.MediaType;
import com.google.common.base.Strings;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import org.cmayes.hartree.disp.Display;
import org.cmayes.hartree.model.DihedralPair;
import org.cmayes.hartree.model.NormalMode;
import org.cmayes.hartree.model.NormalModeCalculation;
import org.cmayes.hartree.model.NormalModeReport;
import org.cmayes.hartree.model.NormalModeSummary;

public class NormalModeTextDisplay
implements Display<NormalModeCalculation> {
    private static final MediaType TYPE = MediaType.TEXT;
    private volatile boolean writeMulti = false;

    @Override
    public boolean isWriteMulti() {
        return this.writeMulti;
    }

    @Override
    public void setWriteMulti(boolean wMulti) {
        this.writeMulti = wMulti;
    }

    @Override
    public MediaType getMediaType() {
        return TYPE;
    }

    @Override
    public void write(Writer writer, NormalModeCalculation calc) {
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.printf("Normal mode summary for file %s%s", calc.getSourceName(), CommonConstants.NL);
        printWriter.println();
        if (calc.getNormalModes().size() == 0) {
            printWriter.println("No normal mode data found.");
            printWriter.flush();
            return;
        }
        printWriter.println("Highest DoF percentages by dihedral:");
        printWriter.println("    pair   | mode |   %   | freq ");
        printWriter.println(Strings.repeat("-", 34));
        NormalModeReport normReport = calc.generateReport();
        for (Map.Entry<DihedralPair, NormalMode> hiEntry : normReport.findHighestDihedrals().entrySet()) {
            DihedralPair dhPair = hiEntry.getKey();
            NormalMode topMode = hiEntry.getValue();
            int modeIdx = calc.getNormalModes().indexOf(topMode);
            double pairPercent = normReport.getSummaries().get(topMode).getDihedralPairWeights().get(dhPair);
            printWriter.printf("(%3d, %3d) | %3d  | %5.2f | %.2f%s", dhPair.getLower(), dhPair.getHigher(), modeIdx + 1, pairPercent, calc.getFrequencyValues().get(modeIdx), CommonConstants.NL);
        }
        int i = 1;
        for (Map.Entry<NormalMode, NormalModeSummary> entries : normReport.getSummaries().entrySet()) {
            NormalModeSummary sum = entries.getValue();
            printWriter.printf("%s=== Normal mode %3d ===%s", CommonConstants.NL, i, CommonConstants.NL);
            printWriter.printf("Frequency          : %.2f%s", calc.getFrequencyValues().get(i - 1), CommonConstants.NL);
            printWriter.printf("Angle Bending   (A): %.2f%s", sum.getAngleBendingWeight(), CommonConstants.NL);
            printWriter.printf("Bond Stretching (R): %.2f%s", sum.getBondStretchingWeight(), CommonConstants.NL);
            printWriter.println("Dihedral pairs  (D):");
            for (Map.Entry<DihedralPair, Double> dhPair : sum.getDihedralPairWeights().entrySet()) {
                DihedralPair key = dhPair.getKey();
                printWriter.printf("         (%3d, %3d): %.2f%s", key.getLower(), key.getHigher(), dhPair.getValue(), CommonConstants.NL);
            }
            ++i;
        }
        printWriter.flush();
    }

    @Override
    public void finish(Writer writer) {
    }
}

