"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainExtension = exports.DomainExtensionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const slb_generated_1 = require("./slb.generated");
Object.defineProperty(exports, "DomainExtensionProperty", { enumerable: true, get: function () { return slb_generated_1.RosDomainExtension; } });
/**
 * A ROS resource type:  `ALIYUN::SLB::DomainExtension`
 */
class DomainExtension extends ros.Resource {
    /**
     * Create a new `ALIYUN::SLB::DomainExtension`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDomainExtension = new slb_generated_1.RosDomainExtension(this, id, {
            listenerPort: props.listenerPort,
            serverCertificateId: props.serverCertificateId,
            loadBalancerId: props.loadBalancerId,
            domain: props.domain,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDomainExtension;
        this.attrDomainExtensionId = rosDomainExtension.attrDomainExtensionId;
        this.attrListenerPort = rosDomainExtension.attrListenerPort;
    }
}
exports.DomainExtension = DomainExtension;
//# sourceMappingURL=data:application/json;base64,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