# OAuth 2.x/OpenID Connect

The aegisx.ext.oauth module provides comprehensive support for the
OAuth 2.x and OpenID Connect (OIDC) protocols. It includes utilities,
abstractions, and policy-enforcement components designed to simplify
secure authorization flows for modern applications. The extension
is built with extensibility and interoperability in mind, enabling
integration with custom token handling, identity providers, and
advanced use cases like token exchange, fine-grained scopes, and
dynamic client registration.

## Standards

- RFC 6749 The OAuth 2.0 Authorization Framework
- RFC 6750 The OAuth 2.0 Authorization Framework: Bearer Token Usage
- RFC 7009 OAuth 2.0 Token Revocation
- RFC 7519 JSON Web Token (JWT)
- RFC 7662 OAuth 2.0 Token Introspection
- RFC 8414 OAuth 2.0 Authorization Server Metadata
- RFC 8642 OAuth 2.0 Device Authorization Grant
- RFC 8693 OAuth 2.0 Token Exchange
- RFC 8747 Proof-of-Possession Key Semantics for CBOR Web Tokens (CWTs)
- RFC 9200 Authentication and Authorization for Constrained Environments Using the OAuth 2.0 Framework (ACE-OAuth)
- RFC 9201 Additional OAuth Parameters for Authentication and Authorization for Constrained Environments (ACE)
- RFC 9207 OAuth 2.0 Authorization Server Issuer Identification
- RFC 9449 OAuth 2.0 Demonstrating Proof of Possession (DPoP)
- OpenID Connect Core 1.0 incorporating errata set 2
- OpenID Connect Front-Channel Logout 1.0
- JWT Secured Authorization Response Mode for OAuth 2.0 (JARM)
