import pydantic

from ._authorizationresponsebase import AuthorizationResponseBase


class CodeAuthorizationResponse(AuthorizationResponseBase):
    # TODO: Google adds certain non-standard parameters to the
    # response.
    model_config = {'extra': 'ignore'}

    code: str | None = pydantic.Field(
        default=None,
        title="Code",
        description=(
            "Present if the `code` was in the requested `response_type`. The "
            "authorization code generated by the authorization server. The "
            "authorization code MUST expire shortly after it is issued to "
            "mitigate the risk of leaks.  A maximum authorization code lifetime "
            "of 10 minutes is RECOMMENDED. The client MUST NOT use the authorization "
            "code more than once. If an authorization code is used more than once, "
            "the authorization server denies the request and revokes (when possible) "
            "all tokens previously issued based on that authorization code. "
            "The authorization code is bound to the client identifier and "
            "redirection URI."
        )
    )

    def is_encrypted(self) -> bool:
        return False

    def is_signed(self) -> bool:
        return False