#  Copyright (c) 2020. Brendan Johnson. All Rights Reserved.
#import connect
#import config

class Antimalware:
    def __init__(self, config, connection):
        self._config=config
        self._connection = connection
    ##Antimalware config
    def list(self):
        return self._connection.get(url='/antimalwareconfigurations')
    def create(self, payload):
        return self._connection.post(url='/antimalwareconfigurations', data=payload)
    def describe(self, antimalwareID):
        return self._connection.get(url='/antimalwareconfigurations/' + str(antimalwareID))
    def modify(self, antimalwareID, payload):
        return self._connection.post(url='/antimalwareconfigurations/' + str(antimalwareID), data=payload)
    def delete(self, antimalwareID):
        return self._connection.delete(url='/antimalwareconfigurations/' + str(antimalwareID))
    def search(self, payload):
        return self._connection.post(url='/antimalwareconfigurations/search', data=payload)
    ##Directory lists
    def listdirectorylists(self):
        return self._connection.get(url='/directorylists')
    def createdirectorylist(self, payload):
        return self._connection.post(url='/directorylists', data=payload)
    def describedirectorylist(self, directoryListID):
        return self._connection.get(url='/directorylists/' + str(directoryListID))
    def modifydirectorylist(self, directoryListID, payload):
        return self._connection.post(url='/directorylists/' + str(directoryListID), data=payload)
    def deletedirectorylist(self, directoryListID):
        return self._connection.delete(url='/directorylists/' + str(directoryListID))
    def searchdirectorylist(self, payload):
        return self._connection.post(url='/directorylists/search', data=payload)
    ##File Extension
    def listfileExtensionlists(self):
        return self._connection.get(url='/fileextensionlists')
    def createdfileExtensionlist(self, payload):
        return self._connection.post(url='/fileextensionlists', data=payload)
    def describefileExtensionlist(self, fileExtensionListID):
        return self._connection.get(url='/fileextensionlists/' + str(fileExtensionListID))
    def modifyfileExtensionlist(self, fileExtensionListID, payload):
        return self._connection.post(url='/fileextensionlists/' + str(fileExtensionListID), data=payload)
    def deletefileExtensionlist(self, fileExtensionListID):
        return self._connection.delete(url='/fileextensionlists/' + str(fileExtensionListID))
    def searchfileExtensionlist(self, payload):
        return self._connection.post(url='/fileextensionlists/search', data=payload)
    ##File
    def listfilelists(self):
        return self._connection.get(url='/filelists')
    def createdfilelist(self, payload):
        return self._connection.post(url='/filelists', data=payload)
    def describefilelist(self, fileListID):
        return self._connection.get(url='/filelists/' + str(fileListID))
    def modifyfilelist(self, fileListID, payload):
        return self._connection.post(url='/filelists/' + str(fileListID), data=payload)
    def deletefilelist(self, fileListID):
        return self._connection.delete(url='/filelists/' + str(fileListID))
    def searchfilelist(self, payload):
        return self._connection.post(url='/filelists/search', data=payload)
    ##Schedules
    def listschedules(self):
        return self._connection.get(url='/schedules')
    def createdschedules(self, payload):
        return self._connection.post(url='/schedules', data=payload)
    def describeschedule(self, schedulesID):
        return self._connection.get(url='/schedules/' + str(schedulesID))
    def modifyschedule(self, schedulesID, payload):
        return self._connection.post(url='/schedules/' + str(schedulesID), data=payload)
    def deleteschedule(self, schedulesID):
        return self._connection.delete(url='/schedules/' + str(schedulesID))
    def searchschedule(self, payload):
        return self._connection.post(url='/schedules/search', data=payload)


