# -*- coding: utf-8 -*-
# Generated by Django 1.9.11 on 2016-11-14 15:36
from django.db import migrations


_OLD_MODEL = """

from django.utils.translation import ugettext_lazy as _
from django.contrib.auth.models import AbstractUser

class User(AbstractUser):

    class Meta(AbstractUser.Meta):
        swappable = 'AUTH_USER_MODEL'
        ordering = ['-date_joined', '-pk']
        verbose_name = _('user')
        verbose_name_plural = _('users')
        db_table = 'spirit_user_user'
"""


def user_model_checker(apps, schema_editor):
    from ...core.conf import settings

    if not hasattr(settings, 'AUTH_USER_MODEL'):
        return

    user = apps.get_model(settings.AUTH_USER_MODEL)

    if user._meta.db_table == 'spirit_user_user':
        raise Exception(
            '`spirit_user.User` was deprecated on '
            'v0.2 and it is being removed now. It '
            'seems the `table` generated by that model '
            'contains user data, this exception '
            'has prevented any lost.\n'
            'Make sure you have a backup of your '
            'database and follow these steps:\n'
            '* Run `python manage.py makemigrations` there '
            'should be no new migrations for user, '
            'if there are, are you also upgrading the '
            'Django version? if so, DO NOT do that now, do it later.\n'
            '* Run `python manage.py migrate --fake spirit_user 0007_auto_20161114_1536` '
            'this will skip this exception you are reading now.\n'
            '* Run `python manage.py migrate --fake spirit_user 0008_auto_20161114_1707` '
            'this will skip the migration that removes the user model table.\n'
            '* Create your own custom user app. Should '
            'contain a `models.py` file (see required user '
            'model below) and an empty `migrations` package.\n'
            '* Add `AUTH_USER_MODEL = \'my_custom_user.User\'` in settings.py.\n'
            '* Run `python manage.py makemigrations`, '
            'there should be new migrations in the custom user app.\n'
            '* Run `python manage.py migrate --fake-initial my_custom_user` '
            'where `my_custom_user` is the name of the custom user app.\n'
            'Required user model:' + _OLD_MODEL)


class Migration(migrations.Migration):

    dependencies = [
        ('spirit_user', '0006_auto_20160606_0607'),
    ]

    operations = [
        migrations.RunPython(user_model_checker, lambda *args: None),
    ]
