# API Reference

**Classes**

Name|Description
----|-----------
[DataSetConstruct](#cdk-quicksight-constructs-datasetconstruct)|*No description*
[DataSourceConstruct](#cdk-quicksight-constructs-datasourceconstruct)|*No description*


**Structs**

Name|Description
----|-----------
[AccountCustomization](#cdk-quicksight-constructs-accountcustomization)|*No description*
[AccountSettings](#cdk-quicksight-constructs-accountsettings)|*No description*
[ActiveIAMPolicyAssignment](#cdk-quicksight-constructs-activeiampolicyassignment)|*No description*
[AdHocFilteringOption](#cdk-quicksight-constructs-adhocfilteringoption)|*No description*
[AmazonElasticsearchParameters](#cdk-quicksight-constructs-amazonelasticsearchparameters)|*No description*
[Analysis](#cdk-quicksight-constructs-analysis)|*No description*
[AnalysisError](#cdk-quicksight-constructs-analysiserror)|*No description*
[AnalysisSearchFilter](#cdk-quicksight-constructs-analysissearchfilter)|*No description*
[AnalysisSourceEntity](#cdk-quicksight-constructs-analysissourceentity)|*No description*
[AnalysisSourceTemplate](#cdk-quicksight-constructs-analysissourcetemplate)|*No description*
[AnalysisSummary](#cdk-quicksight-constructs-analysissummary)|*No description*
[AthenaParameters](#cdk-quicksight-constructs-athenaparameters)|*No description*
[AuroraParameters](#cdk-quicksight-constructs-auroraparameters)|*No description*
[AuroraPostgreSqlParameters](#cdk-quicksight-constructs-aurorapostgresqlparameters)|*No description*
[AwsIotAnalyticsParameters](#cdk-quicksight-constructs-awsiotanalyticsparameters)|*No description*
[BorderStyle](#cdk-quicksight-constructs-borderstyle)|*No description*
[CalculatedColumn](#cdk-quicksight-constructs-calculatedcolumn)|*No description*
[CancelIngestionRequest](#cdk-quicksight-constructs-cancelingestionrequest)|*No description*
[CancelIngestionResponse](#cdk-quicksight-constructs-cancelingestionresponse)|*No description*
[CastColumnTypeOperation](#cdk-quicksight-constructs-castcolumntypeoperation)|*No description*
[ClientApiVersions](#cdk-quicksight-constructs-clientapiversions)|*No description*
[ColumnDescription](#cdk-quicksight-constructs-columndescription)|*No description*
[ColumnGroup](#cdk-quicksight-constructs-columngroup)|*No description*
[ColumnGroupColumnSchema](#cdk-quicksight-constructs-columngroupcolumnschema)|*No description*
[ColumnGroupSchema](#cdk-quicksight-constructs-columngroupschema)|*No description*
[ColumnLevelPermissionRule](#cdk-quicksight-constructs-columnlevelpermissionrule)|*No description*
[ColumnSchema](#cdk-quicksight-constructs-columnschema)|*No description*
[ColumnTag](#cdk-quicksight-constructs-columntag)|*No description*
[CreateAccountCustomizationRequest](#cdk-quicksight-constructs-createaccountcustomizationrequest)|*No description*
[CreateAccountCustomizationResponse](#cdk-quicksight-constructs-createaccountcustomizationresponse)|*No description*
[CreateAnalysisRequest](#cdk-quicksight-constructs-createanalysisrequest)|*No description*
[CreateAnalysisResponse](#cdk-quicksight-constructs-createanalysisresponse)|*No description*
[CreateColumnsOperation](#cdk-quicksight-constructs-createcolumnsoperation)|*No description*
[CreateDashboardRequest](#cdk-quicksight-constructs-createdashboardrequest)|*No description*
[CreateDashboardResponse](#cdk-quicksight-constructs-createdashboardresponse)|*No description*
[CreateDataSetRequest](#cdk-quicksight-constructs-createdatasetrequest)|*No description*
[CreateDataSetResponse](#cdk-quicksight-constructs-createdatasetresponse)|*No description*
[CreateDataSourceRequest](#cdk-quicksight-constructs-createdatasourcerequest)|*No description*
[CreateDataSourceResponse](#cdk-quicksight-constructs-createdatasourceresponse)|*No description*
[CreateGroupMembershipRequest](#cdk-quicksight-constructs-creategroupmembershiprequest)|*No description*
[CreateGroupMembershipResponse](#cdk-quicksight-constructs-creategroupmembershipresponse)|*No description*
[CreateGroupRequest](#cdk-quicksight-constructs-creategrouprequest)|*No description*
[CreateGroupResponse](#cdk-quicksight-constructs-creategroupresponse)|*No description*
[CreateIAMPolicyAssignmentRequest](#cdk-quicksight-constructs-createiampolicyassignmentrequest)|*No description*
[CreateIAMPolicyAssignmentResponse](#cdk-quicksight-constructs-createiampolicyassignmentresponse)|*No description*
[CreateIngestionRequest](#cdk-quicksight-constructs-createingestionrequest)|*No description*
[CreateIngestionResponse](#cdk-quicksight-constructs-createingestionresponse)|*No description*
[CreateNamespaceRequest](#cdk-quicksight-constructs-createnamespacerequest)|*No description*
[CreateNamespaceResponse](#cdk-quicksight-constructs-createnamespaceresponse)|*No description*
[CreateTemplateAliasRequest](#cdk-quicksight-constructs-createtemplatealiasrequest)|*No description*
[CreateTemplateAliasResponse](#cdk-quicksight-constructs-createtemplatealiasresponse)|*No description*
[CreateTemplateRequest](#cdk-quicksight-constructs-createtemplaterequest)|*No description*
[CreateTemplateResponse](#cdk-quicksight-constructs-createtemplateresponse)|*No description*
[CreateThemeAliasRequest](#cdk-quicksight-constructs-createthemealiasrequest)|*No description*
[CreateThemeAliasResponse](#cdk-quicksight-constructs-createthemealiasresponse)|*No description*
[CreateThemeRequest](#cdk-quicksight-constructs-createthemerequest)|*No description*
[CreateThemeResponse](#cdk-quicksight-constructs-createthemeresponse)|*No description*
[CredentialPair](#cdk-quicksight-constructs-credentialpair)|*No description*
[CustomSql](#cdk-quicksight-constructs-customsql)|*No description*
[Dashboard](#cdk-quicksight-constructs-dashboard)|*No description*
[DashboardError](#cdk-quicksight-constructs-dashboarderror)|*No description*
[DashboardPublishOptions](#cdk-quicksight-constructs-dashboardpublishoptions)|*No description*
[DashboardSearchFilter](#cdk-quicksight-constructs-dashboardsearchfilter)|*No description*
[DashboardSourceEntity](#cdk-quicksight-constructs-dashboardsourceentity)|*No description*
[DashboardSourceTemplate](#cdk-quicksight-constructs-dashboardsourcetemplate)|*No description*
[DashboardSummary](#cdk-quicksight-constructs-dashboardsummary)|*No description*
[DashboardVersion](#cdk-quicksight-constructs-dashboardversion)|*No description*
[DashboardVersionSummary](#cdk-quicksight-constructs-dashboardversionsummary)|*No description*
[DataColorPalette](#cdk-quicksight-constructs-datacolorpalette)|*No description*
[DataSet](#cdk-quicksight-constructs-dataset)|*No description*
[DataSetConfiguration](#cdk-quicksight-constructs-datasetconfiguration)|*No description*
[DataSetProps](#cdk-quicksight-constructs-datasetprops)|*No description*
[DataSetReference](#cdk-quicksight-constructs-datasetreference)|*No description*
[DataSetSchema](#cdk-quicksight-constructs-datasetschema)|*No description*
[DataSetSummary](#cdk-quicksight-constructs-datasetsummary)|*No description*
[DataSource](#cdk-quicksight-constructs-datasource)|*No description*
[DataSourceCredentials](#cdk-quicksight-constructs-datasourcecredentials)|*No description*
[DataSourceErrorInfo](#cdk-quicksight-constructs-datasourceerrorinfo)|*No description*
[DataSourceParameters](#cdk-quicksight-constructs-datasourceparameters)|*No description*
[DataSourceProps](#cdk-quicksight-constructs-datasourceprops)|*No description*
[DateTimeParameter](#cdk-quicksight-constructs-datetimeparameter)|*No description*
[DecimalParameter](#cdk-quicksight-constructs-decimalparameter)|*No description*
[DeleteAccountCustomizationRequest](#cdk-quicksight-constructs-deleteaccountcustomizationrequest)|*No description*
[DeleteAccountCustomizationResponse](#cdk-quicksight-constructs-deleteaccountcustomizationresponse)|*No description*
[DeleteAnalysisRequest](#cdk-quicksight-constructs-deleteanalysisrequest)|*No description*
[DeleteAnalysisResponse](#cdk-quicksight-constructs-deleteanalysisresponse)|*No description*
[DeleteDashboardRequest](#cdk-quicksight-constructs-deletedashboardrequest)|*No description*
[DeleteDashboardResponse](#cdk-quicksight-constructs-deletedashboardresponse)|*No description*
[DeleteDataSetRequest](#cdk-quicksight-constructs-deletedatasetrequest)|*No description*
[DeleteDataSetResponse](#cdk-quicksight-constructs-deletedatasetresponse)|*No description*
[DeleteDataSourceRequest](#cdk-quicksight-constructs-deletedatasourcerequest)|*No description*
[DeleteDataSourceResponse](#cdk-quicksight-constructs-deletedatasourceresponse)|*No description*
[DeleteGroupMembershipRequest](#cdk-quicksight-constructs-deletegroupmembershiprequest)|*No description*
[DeleteGroupMembershipResponse](#cdk-quicksight-constructs-deletegroupmembershipresponse)|*No description*
[DeleteGroupRequest](#cdk-quicksight-constructs-deletegrouprequest)|*No description*
[DeleteGroupResponse](#cdk-quicksight-constructs-deletegroupresponse)|*No description*
[DeleteIAMPolicyAssignmentRequest](#cdk-quicksight-constructs-deleteiampolicyassignmentrequest)|*No description*
[DeleteIAMPolicyAssignmentResponse](#cdk-quicksight-constructs-deleteiampolicyassignmentresponse)|*No description*
[DeleteNamespaceRequest](#cdk-quicksight-constructs-deletenamespacerequest)|*No description*
[DeleteNamespaceResponse](#cdk-quicksight-constructs-deletenamespaceresponse)|*No description*
[DeleteTemplateAliasRequest](#cdk-quicksight-constructs-deletetemplatealiasrequest)|*No description*
[DeleteTemplateAliasResponse](#cdk-quicksight-constructs-deletetemplatealiasresponse)|*No description*
[DeleteTemplateRequest](#cdk-quicksight-constructs-deletetemplaterequest)|*No description*
[DeleteTemplateResponse](#cdk-quicksight-constructs-deletetemplateresponse)|*No description*
[DeleteThemeAliasRequest](#cdk-quicksight-constructs-deletethemealiasrequest)|*No description*
[DeleteThemeAliasResponse](#cdk-quicksight-constructs-deletethemealiasresponse)|*No description*
[DeleteThemeRequest](#cdk-quicksight-constructs-deletethemerequest)|*No description*
[DeleteThemeResponse](#cdk-quicksight-constructs-deletethemeresponse)|*No description*
[DeleteUserByPrincipalIdRequest](#cdk-quicksight-constructs-deleteuserbyprincipalidrequest)|*No description*
[DeleteUserByPrincipalIdResponse](#cdk-quicksight-constructs-deleteuserbyprincipalidresponse)|*No description*
[DeleteUserRequest](#cdk-quicksight-constructs-deleteuserrequest)|*No description*
[DeleteUserResponse](#cdk-quicksight-constructs-deleteuserresponse)|*No description*
[DescribeAccountCustomizationRequest](#cdk-quicksight-constructs-describeaccountcustomizationrequest)|*No description*
[DescribeAccountCustomizationResponse](#cdk-quicksight-constructs-describeaccountcustomizationresponse)|*No description*
[DescribeAccountSettingsRequest](#cdk-quicksight-constructs-describeaccountsettingsrequest)|*No description*
[DescribeAccountSettingsResponse](#cdk-quicksight-constructs-describeaccountsettingsresponse)|*No description*
[DescribeAnalysisPermissionsRequest](#cdk-quicksight-constructs-describeanalysispermissionsrequest)|*No description*
[DescribeAnalysisPermissionsResponse](#cdk-quicksight-constructs-describeanalysispermissionsresponse)|*No description*
[DescribeAnalysisRequest](#cdk-quicksight-constructs-describeanalysisrequest)|*No description*
[DescribeAnalysisResponse](#cdk-quicksight-constructs-describeanalysisresponse)|*No description*
[DescribeDashboardPermissionsRequest](#cdk-quicksight-constructs-describedashboardpermissionsrequest)|*No description*
[DescribeDashboardPermissionsResponse](#cdk-quicksight-constructs-describedashboardpermissionsresponse)|*No description*
[DescribeDashboardRequest](#cdk-quicksight-constructs-describedashboardrequest)|*No description*
[DescribeDashboardResponse](#cdk-quicksight-constructs-describedashboardresponse)|*No description*
[DescribeDataSetPermissionsRequest](#cdk-quicksight-constructs-describedatasetpermissionsrequest)|*No description*
[DescribeDataSetPermissionsResponse](#cdk-quicksight-constructs-describedatasetpermissionsresponse)|*No description*
[DescribeDataSetRequest](#cdk-quicksight-constructs-describedatasetrequest)|*No description*
[DescribeDataSetResponse](#cdk-quicksight-constructs-describedatasetresponse)|*No description*
[DescribeDataSourcePermissionsRequest](#cdk-quicksight-constructs-describedatasourcepermissionsrequest)|*No description*
[DescribeDataSourcePermissionsResponse](#cdk-quicksight-constructs-describedatasourcepermissionsresponse)|*No description*
[DescribeDataSourceRequest](#cdk-quicksight-constructs-describedatasourcerequest)|*No description*
[DescribeDataSourceResponse](#cdk-quicksight-constructs-describedatasourceresponse)|*No description*
[DescribeGroupRequest](#cdk-quicksight-constructs-describegrouprequest)|*No description*
[DescribeGroupResponse](#cdk-quicksight-constructs-describegroupresponse)|*No description*
[DescribeIAMPolicyAssignmentRequest](#cdk-quicksight-constructs-describeiampolicyassignmentrequest)|*No description*
[DescribeIAMPolicyAssignmentResponse](#cdk-quicksight-constructs-describeiampolicyassignmentresponse)|*No description*
[DescribeIngestionRequest](#cdk-quicksight-constructs-describeingestionrequest)|*No description*
[DescribeIngestionResponse](#cdk-quicksight-constructs-describeingestionresponse)|*No description*
[DescribeNamespaceRequest](#cdk-quicksight-constructs-describenamespacerequest)|*No description*
[DescribeNamespaceResponse](#cdk-quicksight-constructs-describenamespaceresponse)|*No description*
[DescribeTemplateAliasRequest](#cdk-quicksight-constructs-describetemplatealiasrequest)|*No description*
[DescribeTemplateAliasResponse](#cdk-quicksight-constructs-describetemplatealiasresponse)|*No description*
[DescribeTemplatePermissionsRequest](#cdk-quicksight-constructs-describetemplatepermissionsrequest)|*No description*
[DescribeTemplatePermissionsResponse](#cdk-quicksight-constructs-describetemplatepermissionsresponse)|*No description*
[DescribeTemplateRequest](#cdk-quicksight-constructs-describetemplaterequest)|*No description*
[DescribeTemplateResponse](#cdk-quicksight-constructs-describetemplateresponse)|*No description*
[DescribeThemeAliasRequest](#cdk-quicksight-constructs-describethemealiasrequest)|*No description*
[DescribeThemeAliasResponse](#cdk-quicksight-constructs-describethemealiasresponse)|*No description*
[DescribeThemePermissionsRequest](#cdk-quicksight-constructs-describethemepermissionsrequest)|*No description*
[DescribeThemePermissionsResponse](#cdk-quicksight-constructs-describethemepermissionsresponse)|*No description*
[DescribeThemeRequest](#cdk-quicksight-constructs-describethemerequest)|*No description*
[DescribeThemeResponse](#cdk-quicksight-constructs-describethemeresponse)|*No description*
[DescribeUserRequest](#cdk-quicksight-constructs-describeuserrequest)|*No description*
[DescribeUserResponse](#cdk-quicksight-constructs-describeuserresponse)|*No description*
[ErrorInfo](#cdk-quicksight-constructs-errorinfo)|*No description*
[ExportToCSVOption](#cdk-quicksight-constructs-exporttocsvoption)|*No description*
[FieldFolder](#cdk-quicksight-constructs-fieldfolder)|*No description*
[FilterOperation](#cdk-quicksight-constructs-filteroperation)|*No description*
[GeoSpatialColumnGroup](#cdk-quicksight-constructs-geospatialcolumngroup)|*No description*
[GetDashboardEmbedUrlRequest](#cdk-quicksight-constructs-getdashboardembedurlrequest)|*No description*
[GetDashboardEmbedUrlResponse](#cdk-quicksight-constructs-getdashboardembedurlresponse)|*No description*
[GetSessionEmbedUrlRequest](#cdk-quicksight-constructs-getsessionembedurlrequest)|*No description*
[GetSessionEmbedUrlResponse](#cdk-quicksight-constructs-getsessionembedurlresponse)|*No description*
[Group](#cdk-quicksight-constructs-group)|*No description*
[GroupMember](#cdk-quicksight-constructs-groupmember)|*No description*
[GutterStyle](#cdk-quicksight-constructs-gutterstyle)|*No description*
[Ingestion](#cdk-quicksight-constructs-ingestion)|*No description*
[InputColumn](#cdk-quicksight-constructs-inputcolumn)|*No description*
[IntegerParameter](#cdk-quicksight-constructs-integerparameter)|*No description*
[JiraParameters](#cdk-quicksight-constructs-jiraparameters)|*No description*
[JoinInstruction](#cdk-quicksight-constructs-joininstruction)|*No description*
[JoinKeyProperties](#cdk-quicksight-constructs-joinkeyproperties)|*No description*
[ListAnalysesRequest](#cdk-quicksight-constructs-listanalysesrequest)|*No description*
[ListAnalysesResponse](#cdk-quicksight-constructs-listanalysesresponse)|*No description*
[ListDashboardVersionsRequest](#cdk-quicksight-constructs-listdashboardversionsrequest)|*No description*
[ListDashboardVersionsResponse](#cdk-quicksight-constructs-listdashboardversionsresponse)|*No description*
[ListDashboardsRequest](#cdk-quicksight-constructs-listdashboardsrequest)|*No description*
[ListDashboardsResponse](#cdk-quicksight-constructs-listdashboardsresponse)|*No description*
[ListDataSetsRequest](#cdk-quicksight-constructs-listdatasetsrequest)|*No description*
[ListDataSetsResponse](#cdk-quicksight-constructs-listdatasetsresponse)|*No description*
[ListDataSourcesRequest](#cdk-quicksight-constructs-listdatasourcesrequest)|*No description*
[ListDataSourcesResponse](#cdk-quicksight-constructs-listdatasourcesresponse)|*No description*
[ListGroupMembershipsRequest](#cdk-quicksight-constructs-listgroupmembershipsrequest)|*No description*
[ListGroupMembershipsResponse](#cdk-quicksight-constructs-listgroupmembershipsresponse)|*No description*
[ListGroupsRequest](#cdk-quicksight-constructs-listgroupsrequest)|*No description*
[ListGroupsResponse](#cdk-quicksight-constructs-listgroupsresponse)|*No description*
[ListIAMPolicyAssignmentsForUserRequest](#cdk-quicksight-constructs-listiampolicyassignmentsforuserrequest)|*No description*
[ListIAMPolicyAssignmentsForUserResponse](#cdk-quicksight-constructs-listiampolicyassignmentsforuserresponse)|*No description*
[ListIAMPolicyAssignmentsRequest](#cdk-quicksight-constructs-listiampolicyassignmentsrequest)|*No description*
[ListIAMPolicyAssignmentsResponse](#cdk-quicksight-constructs-listiampolicyassignmentsresponse)|*No description*
[ListIngestionsRequest](#cdk-quicksight-constructs-listingestionsrequest)|*No description*
[ListIngestionsResponse](#cdk-quicksight-constructs-listingestionsresponse)|*No description*
[ListNamespacesRequest](#cdk-quicksight-constructs-listnamespacesrequest)|*No description*
[ListNamespacesResponse](#cdk-quicksight-constructs-listnamespacesresponse)|*No description*
[ListTagsForResourceRequest](#cdk-quicksight-constructs-listtagsforresourcerequest)|*No description*
[ListTagsForResourceResponse](#cdk-quicksight-constructs-listtagsforresourceresponse)|*No description*
[ListTemplateAliasesRequest](#cdk-quicksight-constructs-listtemplatealiasesrequest)|*No description*
[ListTemplateAliasesResponse](#cdk-quicksight-constructs-listtemplatealiasesresponse)|*No description*
[ListTemplateVersionsRequest](#cdk-quicksight-constructs-listtemplateversionsrequest)|*No description*
[ListTemplateVersionsResponse](#cdk-quicksight-constructs-listtemplateversionsresponse)|*No description*
[ListTemplatesRequest](#cdk-quicksight-constructs-listtemplatesrequest)|*No description*
[ListTemplatesResponse](#cdk-quicksight-constructs-listtemplatesresponse)|*No description*
[ListThemeAliasesRequest](#cdk-quicksight-constructs-listthemealiasesrequest)|*No description*
[ListThemeAliasesResponse](#cdk-quicksight-constructs-listthemealiasesresponse)|*No description*
[ListThemeVersionsRequest](#cdk-quicksight-constructs-listthemeversionsrequest)|*No description*
[ListThemeVersionsResponse](#cdk-quicksight-constructs-listthemeversionsresponse)|*No description*
[ListThemesRequest](#cdk-quicksight-constructs-listthemesrequest)|*No description*
[ListThemesResponse](#cdk-quicksight-constructs-listthemesresponse)|*No description*
[ListUserGroupsRequest](#cdk-quicksight-constructs-listusergroupsrequest)|*No description*
[ListUserGroupsResponse](#cdk-quicksight-constructs-listusergroupsresponse)|*No description*
[ListUsersRequest](#cdk-quicksight-constructs-listusersrequest)|*No description*
[ListUsersResponse](#cdk-quicksight-constructs-listusersresponse)|*No description*
[LogicalTable](#cdk-quicksight-constructs-logicaltable)|*No description*
[LogicalTableSource](#cdk-quicksight-constructs-logicaltablesource)|*No description*
[ManifestFileLocation](#cdk-quicksight-constructs-manifestfilelocation)|*No description*
[MarginStyle](#cdk-quicksight-constructs-marginstyle)|*No description*
[MariaDbParameters](#cdk-quicksight-constructs-mariadbparameters)|*No description*
[MySqlParameters](#cdk-quicksight-constructs-mysqlparameters)|*No description*
[NamespaceError](#cdk-quicksight-constructs-namespaceerror)|*No description*
[NamespaceInfoV2](#cdk-quicksight-constructs-namespaceinfov2)|*No description*
[OracleParameters](#cdk-quicksight-constructs-oracleparameters)|*No description*
[OutputColumn](#cdk-quicksight-constructs-outputcolumn)|*No description*
[Parameters](#cdk-quicksight-constructs-parameters)|*No description*
[PhysicalTable](#cdk-quicksight-constructs-physicaltable)|*No description*
[PostgreSqlParameters](#cdk-quicksight-constructs-postgresqlparameters)|*No description*
[PrestoParameters](#cdk-quicksight-constructs-prestoparameters)|*No description*
[ProjectOperation](#cdk-quicksight-constructs-projectoperation)|*No description*
[QSCommonProps](#cdk-quicksight-constructs-qscommonprops)|*No description*
[QueueInfo](#cdk-quicksight-constructs-queueinfo)|*No description*
[RdsParameters](#cdk-quicksight-constructs-rdsparameters)|*No description*
[RedshiftParameters](#cdk-quicksight-constructs-redshiftparameters)|*No description*
[RegisterUserRequest](#cdk-quicksight-constructs-registeruserrequest)|*No description*
[RegisterUserResponse](#cdk-quicksight-constructs-registeruserresponse)|*No description*
[RelationalTable](#cdk-quicksight-constructs-relationaltable)|*No description*
[RenameColumnOperation](#cdk-quicksight-constructs-renamecolumnoperation)|*No description*
[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)|*No description*
[RestoreAnalysisRequest](#cdk-quicksight-constructs-restoreanalysisrequest)|*No description*
[RestoreAnalysisResponse](#cdk-quicksight-constructs-restoreanalysisresponse)|*No description*
[RowInfo](#cdk-quicksight-constructs-rowinfo)|*No description*
[RowLevelPermissionDataSet](#cdk-quicksight-constructs-rowlevelpermissiondataset)|*No description*
[S3Parameters](#cdk-quicksight-constructs-s3parameters)|*No description*
[S3Source](#cdk-quicksight-constructs-s3source)|*No description*
[SearchAnalysesRequest](#cdk-quicksight-constructs-searchanalysesrequest)|*No description*
[SearchAnalysesResponse](#cdk-quicksight-constructs-searchanalysesresponse)|*No description*
[SearchDashboardsRequest](#cdk-quicksight-constructs-searchdashboardsrequest)|*No description*
[SearchDashboardsResponse](#cdk-quicksight-constructs-searchdashboardsresponse)|*No description*
[ServiceNowParameters](#cdk-quicksight-constructs-servicenowparameters)|*No description*
[Sheet](#cdk-quicksight-constructs-sheet)|*No description*
[SheetControlsOption](#cdk-quicksight-constructs-sheetcontrolsoption)|*No description*
[SheetStyle](#cdk-quicksight-constructs-sheetstyle)|*No description*
[SnowflakeParameters](#cdk-quicksight-constructs-snowflakeparameters)|*No description*
[SparkParameters](#cdk-quicksight-constructs-sparkparameters)|*No description*
[SqlServerParameters](#cdk-quicksight-constructs-sqlserverparameters)|*No description*
[SslProperties](#cdk-quicksight-constructs-sslproperties)|*No description*
[StringParameter](#cdk-quicksight-constructs-stringparameter)|*No description*
[Tag](#cdk-quicksight-constructs-tag)|*No description*
[TagColumnOperation](#cdk-quicksight-constructs-tagcolumnoperation)|*No description*
[TagResourceRequest](#cdk-quicksight-constructs-tagresourcerequest)|*No description*
[TagResourceResponse](#cdk-quicksight-constructs-tagresourceresponse)|*No description*
[Template](#cdk-quicksight-constructs-template)|*No description*
[TemplateAlias](#cdk-quicksight-constructs-templatealias)|*No description*
[TemplateError](#cdk-quicksight-constructs-templateerror)|*No description*
[TemplateSourceAnalysis](#cdk-quicksight-constructs-templatesourceanalysis)|*No description*
[TemplateSourceEntity](#cdk-quicksight-constructs-templatesourceentity)|*No description*
[TemplateSourceTemplate](#cdk-quicksight-constructs-templatesourcetemplate)|*No description*
[TemplateSummary](#cdk-quicksight-constructs-templatesummary)|*No description*
[TemplateVersion](#cdk-quicksight-constructs-templateversion)|*No description*
[TemplateVersionSummary](#cdk-quicksight-constructs-templateversionsummary)|*No description*
[TeradataParameters](#cdk-quicksight-constructs-teradataparameters)|*No description*
[Theme](#cdk-quicksight-constructs-theme)|*No description*
[ThemeAlias](#cdk-quicksight-constructs-themealias)|*No description*
[ThemeConfiguration](#cdk-quicksight-constructs-themeconfiguration)|*No description*
[ThemeError](#cdk-quicksight-constructs-themeerror)|*No description*
[ThemeSummary](#cdk-quicksight-constructs-themesummary)|*No description*
[ThemeVersion](#cdk-quicksight-constructs-themeversion)|*No description*
[ThemeVersionSummary](#cdk-quicksight-constructs-themeversionsummary)|*No description*
[TileLayoutStyle](#cdk-quicksight-constructs-tilelayoutstyle)|*No description*
[TileStyle](#cdk-quicksight-constructs-tilestyle)|*No description*
[TransformOperation](#cdk-quicksight-constructs-transformoperation)|*No description*
[TwitterParameters](#cdk-quicksight-constructs-twitterparameters)|*No description*
[UIColorPalette](#cdk-quicksight-constructs-uicolorpalette)|*No description*
[UntagResourceRequest](#cdk-quicksight-constructs-untagresourcerequest)|*No description*
[UntagResourceResponse](#cdk-quicksight-constructs-untagresourceresponse)|*No description*
[UpdateAccountCustomizationRequest](#cdk-quicksight-constructs-updateaccountcustomizationrequest)|*No description*
[UpdateAccountCustomizationResponse](#cdk-quicksight-constructs-updateaccountcustomizationresponse)|*No description*
[UpdateAccountSettingsRequest](#cdk-quicksight-constructs-updateaccountsettingsrequest)|*No description*
[UpdateAccountSettingsResponse](#cdk-quicksight-constructs-updateaccountsettingsresponse)|*No description*
[UpdateAnalysisPermissionsRequest](#cdk-quicksight-constructs-updateanalysispermissionsrequest)|*No description*
[UpdateAnalysisPermissionsResponse](#cdk-quicksight-constructs-updateanalysispermissionsresponse)|*No description*
[UpdateAnalysisRequest](#cdk-quicksight-constructs-updateanalysisrequest)|*No description*
[UpdateAnalysisResponse](#cdk-quicksight-constructs-updateanalysisresponse)|*No description*
[UpdateDashboardPermissionsRequest](#cdk-quicksight-constructs-updatedashboardpermissionsrequest)|*No description*
[UpdateDashboardPermissionsResponse](#cdk-quicksight-constructs-updatedashboardpermissionsresponse)|*No description*
[UpdateDashboardPublishedVersionRequest](#cdk-quicksight-constructs-updatedashboardpublishedversionrequest)|*No description*
[UpdateDashboardPublishedVersionResponse](#cdk-quicksight-constructs-updatedashboardpublishedversionresponse)|*No description*
[UpdateDashboardRequest](#cdk-quicksight-constructs-updatedashboardrequest)|*No description*
[UpdateDashboardResponse](#cdk-quicksight-constructs-updatedashboardresponse)|*No description*
[UpdateDataSetPermissionsRequest](#cdk-quicksight-constructs-updatedatasetpermissionsrequest)|*No description*
[UpdateDataSetPermissionsResponse](#cdk-quicksight-constructs-updatedatasetpermissionsresponse)|*No description*
[UpdateDataSetRequest](#cdk-quicksight-constructs-updatedatasetrequest)|*No description*
[UpdateDataSetResponse](#cdk-quicksight-constructs-updatedatasetresponse)|*No description*
[UpdateDataSourcePermissionsRequest](#cdk-quicksight-constructs-updatedatasourcepermissionsrequest)|*No description*
[UpdateDataSourcePermissionsResponse](#cdk-quicksight-constructs-updatedatasourcepermissionsresponse)|*No description*
[UpdateDataSourceRequest](#cdk-quicksight-constructs-updatedatasourcerequest)|*No description*
[UpdateDataSourceResponse](#cdk-quicksight-constructs-updatedatasourceresponse)|*No description*
[UpdateGroupRequest](#cdk-quicksight-constructs-updategrouprequest)|*No description*
[UpdateGroupResponse](#cdk-quicksight-constructs-updategroupresponse)|*No description*
[UpdateIAMPolicyAssignmentRequest](#cdk-quicksight-constructs-updateiampolicyassignmentrequest)|*No description*
[UpdateIAMPolicyAssignmentResponse](#cdk-quicksight-constructs-updateiampolicyassignmentresponse)|*No description*
[UpdateTemplateAliasRequest](#cdk-quicksight-constructs-updatetemplatealiasrequest)|*No description*
[UpdateTemplateAliasResponse](#cdk-quicksight-constructs-updatetemplatealiasresponse)|*No description*
[UpdateTemplatePermissionsRequest](#cdk-quicksight-constructs-updatetemplatepermissionsrequest)|*No description*
[UpdateTemplatePermissionsResponse](#cdk-quicksight-constructs-updatetemplatepermissionsresponse)|*No description*
[UpdateTemplateRequest](#cdk-quicksight-constructs-updatetemplaterequest)|*No description*
[UpdateTemplateResponse](#cdk-quicksight-constructs-updatetemplateresponse)|*No description*
[UpdateThemeAliasRequest](#cdk-quicksight-constructs-updatethemealiasrequest)|*No description*
[UpdateThemeAliasResponse](#cdk-quicksight-constructs-updatethemealiasresponse)|*No description*
[UpdateThemePermissionsRequest](#cdk-quicksight-constructs-updatethemepermissionsrequest)|*No description*
[UpdateThemePermissionsResponse](#cdk-quicksight-constructs-updatethemepermissionsresponse)|*No description*
[UpdateThemeRequest](#cdk-quicksight-constructs-updatethemerequest)|*No description*
[UpdateThemeResponse](#cdk-quicksight-constructs-updatethemeresponse)|*No description*
[UpdateUserRequest](#cdk-quicksight-constructs-updateuserrequest)|*No description*
[UpdateUserResponse](#cdk-quicksight-constructs-updateuserresponse)|*No description*
[UploadSettings](#cdk-quicksight-constructs-uploadsettings)|*No description*
[User](#cdk-quicksight-constructs-user)|*No description*
[VpcConnectionProperties](#cdk-quicksight-constructs-vpcconnectionproperties)|*No description*


**Interfaces**

Name|Description
----|-----------
[IAMPolicyAssignment](#cdk-quicksight-constructs-iampolicyassignment)|*No description*
[IAMPolicyAssignmentSummary](#cdk-quicksight-constructs-iampolicyassignmentsummary)|*No description*



## class DataSetConstruct  <a id="cdk-quicksight-constructs-datasetconstruct"></a>



__Implements__: [IConstruct](#constructs-iconstruct), [IConstruct](#aws-cdk-core-iconstruct), [IConstruct](#constructs-iconstruct), [IDependable](#aws-cdk-core-idependable)
__Extends__: [Construct](#aws-cdk-core-construct)

### Initializer




```ts
new DataSetConstruct(scope: Construct, id: string, props: DataSetProps)
```

* **scope** (<code>[Construct](#aws-cdk-core-construct)</code>)  *No description*
* **id** (<code>string</code>)  *No description*
* **props** (<code>[DataSetProps](#cdk-quicksight-constructs-datasetprops)</code>)  *No description*
  * **name** (<code>string</code>)  *No description* 
  * **users** (<code>Array<string></code>)  QuickSight Users you want to give access to. In the end the permission arn are looking like arn:aws:quicksight:us-east-1:1234:user/default/martin.mueller@take2.co. 
  * **logicalTableMap** (<code>Map<string, [LogicalTable](#cdk-quicksight-constructs-logicaltable)></code>)  *No description* 
  * **physicalTableMap** (<code>Map<string, [PhysicalTable](#cdk-quicksight-constructs-physicaltable)></code>)  *No description* 




## class DataSourceConstruct  <a id="cdk-quicksight-constructs-datasourceconstruct"></a>



__Implements__: [IConstruct](#constructs-iconstruct), [IConstruct](#aws-cdk-core-iconstruct), [IConstruct](#constructs-iconstruct), [IDependable](#aws-cdk-core-idependable)
__Extends__: [Construct](#aws-cdk-core-construct)

### Initializer




```ts
new DataSourceConstruct(scope: Construct, id: string, props: DataSourceProps)
```

* **scope** (<code>[Construct](#aws-cdk-core-construct)</code>)  *No description*
* **id** (<code>string</code>)  *No description*
* **props** (<code>[DataSourceProps](#cdk-quicksight-constructs-datasourceprops)</code>)  *No description*
  * **name** (<code>string</code>)  *No description* 
  * **users** (<code>Array<string></code>)  QuickSight Users you want to give access to. In the end the permission arn are looking like arn:aws:quicksight:us-east-1:1234:user/default/martin.mueller@take2.co. 
  * **dataSourceParameters** (<code>[DataSourceParameters](#cdk-quicksight-constructs-datasourceparameters)</code>)  *No description* 
  * **type** (<code>string</code>)  *No description* 



### Properties


Name | Type | Description 
-----|------|-------------
**dataSourceArn** | <code>string</code> | <span></span>



## struct AccountCustomization  <a id="cdk-quicksight-constructs-accountcustomization"></a>






Name | Type | Description 
-----|------|-------------
**defaultTheme**? | <code>string</code> | The default theme for this QuickSight subscription.<br/>__*Optional*__



## struct AccountSettings  <a id="cdk-quicksight-constructs-accountsettings"></a>






Name | Type | Description 
-----|------|-------------
**accountName**? | <code>string</code> | The "account name" you provided for the QuickSight subscription in your AWS account.<br/>__*Optional*__
**defaultNamespace**? | <code>string</code> | The default QuickSight namespace for your AWS account.<br/>__*Optional*__
**edition**? | <code>string</code> | The edition of QuickSight that you're currently subscribed to: Enterprise edition or Standard edition.<br/>__*Optional*__
**notificationEmail**? | <code>string</code> | The main notification email for your QuickSight subscription.<br/>__*Optional*__



## struct ActiveIAMPolicyAssignment  <a id="cdk-quicksight-constructs-activeiampolicyassignment"></a>






Name | Type | Description 
-----|------|-------------
**assignmentName**? | <code>string</code> | A name for the IAM policy assignment.<br/>__*Optional*__
**policyArn**? | <code>string</code> | The Amazon Resource Name (ARN) of the resource.<br/>__*Optional*__



## struct AdHocFilteringOption  <a id="cdk-quicksight-constructs-adhocfilteringoption"></a>






Name | Type | Description 
-----|------|-------------
**availabilityStatus**? | <code>string</code> | Availability status.<br/>__*Optional*__



## struct AmazonElasticsearchParameters  <a id="cdk-quicksight-constructs-amazonelasticsearchparameters"></a>






Name | Type | Description 
-----|------|-------------
**domain** | <code>string</code> | The Amazon Elasticsearch Service domain.



## struct Analysis  <a id="cdk-quicksight-constructs-analysis"></a>






Name | Type | Description 
-----|------|-------------
**analysisId**? | <code>string</code> | The ID of the analysis.<br/>__*Optional*__
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the analysis.<br/>__*Optional*__
**createdTime**? | <code>date</code> | The time that the analysis was created.<br/>__*Optional*__
**dataSetArns**? | <code>Array<string></code> | The ARNs of the datasets of the analysis.<br/>__*Optional*__
**errors**? | <code>Array<[AnalysisError](#cdk-quicksight-constructs-analysiserror)></code> | Errors associated with the analysis.<br/>__*Optional*__
**lastUpdatedTime**? | <code>date</code> | The time that the analysis was last updated.<br/>__*Optional*__
**name**? | <code>string</code> | The descriptive name of the analysis.<br/>__*Optional*__
**sheets**? | <code>Array<[Sheet](#cdk-quicksight-constructs-sheet)></code> | A list of the associated sheets with the unique identifier and name of each sheet.<br/>__*Optional*__
**status**? | <code>string</code> | Status associated with the analysis.<br/>__*Optional*__
**themeArn**? | <code>string</code> | The ARN of the theme of the analysis.<br/>__*Optional*__



## struct AnalysisError  <a id="cdk-quicksight-constructs-analysiserror"></a>






Name | Type | Description 
-----|------|-------------
**message**? | <code>string</code> | The message associated with the analysis error.<br/>__*Optional*__
**type**? | <code>string</code> | The type of the analysis error.<br/>__*Optional*__



## struct AnalysisSearchFilter  <a id="cdk-quicksight-constructs-analysissearchfilter"></a>






Name | Type | Description 
-----|------|-------------
**name**? | <code>string</code> | The name of the value that you want to use as a filter, for example "Name": "QUICKSIGHT_USER".<br/>__*Optional*__
**operator**? | <code>string</code> | The comparison operator that you want to use as a filter, for example "Operator": "StringEquals".<br/>__*Optional*__
**value**? | <code>string</code> | The value of the named item, in this case QUICKSIGHT_USER, that you want to use as a filter, for example "Value".<br/>__*Optional*__



## struct AnalysisSourceEntity  <a id="cdk-quicksight-constructs-analysissourceentity"></a>






Name | Type | Description 
-----|------|-------------
**sourceTemplate**? | <code>[AnalysisSourceTemplate](#cdk-quicksight-constructs-analysissourcetemplate)</code> | The source template for the source entity of the analysis.<br/>__*Optional*__



## struct AnalysisSourceTemplate  <a id="cdk-quicksight-constructs-analysissourcetemplate"></a>






Name | Type | Description 
-----|------|-------------
**arn** | <code>string</code> | The Amazon Resource Name (ARN) of the source template of an analysis.
**dataSetReferences** | <code>Array<[DataSetReference](#cdk-quicksight-constructs-datasetreference)></code> | The dataset references of the source template of an analysis.



## struct AnalysisSummary  <a id="cdk-quicksight-constructs-analysissummary"></a>






Name | Type | Description 
-----|------|-------------
**analysisId**? | <code>string</code> | The ID of the analysis.<br/>__*Optional*__
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) for the analysis.<br/>__*Optional*__
**createdTime**? | <code>date</code> | The time that the analysis was created.<br/>__*Optional*__
**lastUpdatedTime**? | <code>date</code> | The time that the analysis was last updated.<br/>__*Optional*__
**name**? | <code>string</code> | The name of the analysis.<br/>__*Optional*__
**status**? | <code>string</code> | The last known status for the analysis.<br/>__*Optional*__



## struct AthenaParameters  <a id="cdk-quicksight-constructs-athenaparameters"></a>






Name | Type | Description 
-----|------|-------------
**workGroup**? | <code>string</code> | The workgroup that Amazon Athena uses.<br/>__*Optional*__



## struct AuroraParameters  <a id="cdk-quicksight-constructs-auroraparameters"></a>






Name | Type | Description 
-----|------|-------------
**database** | <code>string</code> | Database.
**host** | <code>string</code> | Host.
**port** | <code>number</code> | Port.



## struct AuroraPostgreSqlParameters  <a id="cdk-quicksight-constructs-aurorapostgresqlparameters"></a>






Name | Type | Description 
-----|------|-------------
**database** | <code>string</code> | Database.
**host** | <code>string</code> | Host.
**port** | <code>number</code> | Port.



## struct AwsIotAnalyticsParameters  <a id="cdk-quicksight-constructs-awsiotanalyticsparameters"></a>






Name | Type | Description 
-----|------|-------------
**dataSetName** | <code>string</code> | Dataset name.



## struct BorderStyle  <a id="cdk-quicksight-constructs-borderstyle"></a>






Name | Type | Description 
-----|------|-------------
**show**? | <code>boolean</code> | The option to enable display of borders for visuals.<br/>__*Optional*__



## struct CalculatedColumn  <a id="cdk-quicksight-constructs-calculatedcolumn"></a>






Name | Type | Description 
-----|------|-------------
**columnId** | <code>string</code> | A unique ID to identify a calculated column.
**columnName** | <code>string</code> | Column name.
**expression** | <code>string</code> | An expression that defines the calculated column.



## struct CancelIngestionRequest  <a id="cdk-quicksight-constructs-cancelingestionrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID.
**dataSetId** | <code>string</code> | The ID of the dataset used in the ingestion.
**ingestionId** | <code>string</code> | An ID for the ingestion.



## struct CancelIngestionResponse  <a id="cdk-quicksight-constructs-cancelingestionresponse"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) for the data ingestion.<br/>__*Optional*__
**ingestionId**? | <code>string</code> | An ID for the ingestion.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct CastColumnTypeOperation  <a id="cdk-quicksight-constructs-castcolumntypeoperation"></a>






Name | Type | Description 
-----|------|-------------
**columnName** | <code>string</code> | Column name.
**newColumnType** | <code>string</code> | New column data type.
**format**? | <code>string</code> | When casting a column from string to datetime type, you can supply a string in a format supported by Amazon QuickSight to denote the source data format.<br/>__*Optional*__



## struct ClientApiVersions  <a id="cdk-quicksight-constructs-clientapiversions"></a>






Name | Type | Description 
-----|------|-------------
**apiVersion**? | <code>string</code> | A string in YYYY-MM-DD format that represents the latest possible API version that can be used in this service.<br/>__*Optional*__



## struct ColumnDescription  <a id="cdk-quicksight-constructs-columndescription"></a>






Name | Type | Description 
-----|------|-------------
**text**? | <code>string</code> | The text of a description for a column.<br/>__*Optional*__



## struct ColumnGroup  <a id="cdk-quicksight-constructs-columngroup"></a>






Name | Type | Description 
-----|------|-------------
**geoSpatialColumnGroup**? | <code>[GeoSpatialColumnGroup](#cdk-quicksight-constructs-geospatialcolumngroup)</code> | Geospatial column group that denotes a hierarchy.<br/>__*Optional*__



## struct ColumnGroupColumnSchema  <a id="cdk-quicksight-constructs-columngroupcolumnschema"></a>






Name | Type | Description 
-----|------|-------------
**name**? | <code>string</code> | The name of the column group's column schema.<br/>__*Optional*__



## struct ColumnGroupSchema  <a id="cdk-quicksight-constructs-columngroupschema"></a>






Name | Type | Description 
-----|------|-------------
**columnGroupColumnSchemaList**? | <code>Array<[ColumnGroupColumnSchema](#cdk-quicksight-constructs-columngroupcolumnschema)></code> | A structure containing the list of schemas for column group columns.<br/>__*Optional*__
**name**? | <code>string</code> | The name of the column group schema.<br/>__*Optional*__



## struct ColumnLevelPermissionRule  <a id="cdk-quicksight-constructs-columnlevelpermissionrule"></a>






Name | Type | Description 
-----|------|-------------
**columnNames**? | <code>Array<string></code> | An array of column names.<br/>__*Optional*__
**principals**? | <code>Array<string></code> | An array of Amazon Resource Names (ARNs) for QuickSight users or groups.<br/>__*Optional*__



## struct ColumnSchema  <a id="cdk-quicksight-constructs-columnschema"></a>






Name | Type | Description 
-----|------|-------------
**dataType**? | <code>string</code> | The data type of the column schema.<br/>__*Optional*__
**geographicRole**? | <code>string</code> | The geographic role of the column schema.<br/>__*Optional*__
**name**? | <code>string</code> | The name of the column schema.<br/>__*Optional*__



## struct ColumnTag  <a id="cdk-quicksight-constructs-columntag"></a>






Name | Type | Description 
-----|------|-------------
**columnDescription**? | <code>[ColumnDescription](#cdk-quicksight-constructs-columndescription)</code> | A description for a column.<br/>__*Optional*__
**columnGeographicRole**? | <code>string</code> | A geospatial role for a column.<br/>__*Optional*__



## struct CreateAccountCustomizationRequest  <a id="cdk-quicksight-constructs-createaccountcustomizationrequest"></a>






Name | Type | Description 
-----|------|-------------
**accountCustomization** | <code>[AccountCustomization](#cdk-quicksight-constructs-accountcustomization)</code> | The QuickSight customizations you're adding in the current AWS Region.
**awsAccountId** | <code>string</code> | The ID for the AWS account that you want to customize QuickSight for.
**namespace**? | <code>string</code> | The QuickSight namespace that you want to add customizations to.<br/>__*Optional*__
**tags**? | <code>Array<[Tag](#cdk-quicksight-constructs-tag)></code> | A list of the tags that you want to attach to this resource.<br/>__*Optional*__



## struct CreateAccountCustomizationResponse  <a id="cdk-quicksight-constructs-createaccountcustomizationresponse"></a>






Name | Type | Description 
-----|------|-------------
**accountCustomization**? | <code>[AccountCustomization](#cdk-quicksight-constructs-accountcustomization)</code> | The QuickSight customizations you're adding in the current AWS Region.<br/>__*Optional*__
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) for the customization that you created for this AWS account.<br/>__*Optional*__
**awsAccountId**? | <code>string</code> | The ID for the AWS account that you want to customize QuickSight for.<br/>__*Optional*__
**namespace**? | <code>string</code> | The namespace associated with the customization you're creating.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct CreateAnalysisRequest  <a id="cdk-quicksight-constructs-createanalysisrequest"></a>






Name | Type | Description 
-----|------|-------------
**analysisId** | <code>string</code> | The ID for the analysis that you're creating.
**awsAccountId** | <code>string</code> | The ID of the AWS account where you are creating an analysis.
**name** | <code>string</code> | A descriptive name for the analysis that you're creating.
**sourceEntity** | <code>[AnalysisSourceEntity](#cdk-quicksight-constructs-analysissourceentity)</code> | A source entity to use for the analysis that you're creating.
**parameters**? | <code>[Parameters](#cdk-quicksight-constructs-parameters)</code> | The parameter names and override values that you want to use.<br/>__*Optional*__
**permissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A structure that describes the principals and the resource-level permissions on an analysis.<br/>__*Optional*__
**tags**? | <code>Array<[Tag](#cdk-quicksight-constructs-tag)></code> | Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.<br/>__*Optional*__
**themeArn**? | <code>string</code> | The ARN for the theme to apply to the analysis that you're creating.<br/>__*Optional*__



## struct CreateAnalysisResponse  <a id="cdk-quicksight-constructs-createanalysisresponse"></a>






Name | Type | Description 
-----|------|-------------
**analysisId**? | <code>string</code> | The ID of the analysis.<br/>__*Optional*__
**arn**? | <code>string</code> | The ARN for the analysis.<br/>__*Optional*__
**creationStatus**? | <code>string</code> | The status of the creation of the analysis.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct CreateColumnsOperation  <a id="cdk-quicksight-constructs-createcolumnsoperation"></a>






Name | Type | Description 
-----|------|-------------
**columns** | <code>Array<[CalculatedColumn](#cdk-quicksight-constructs-calculatedcolumn)></code> | Calculated columns to create.



## struct CreateDashboardRequest  <a id="cdk-quicksight-constructs-createdashboardrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account where you want to create the dashboard.
**dashboardId** | <code>string</code> | The ID for the dashboard, also added to the IAM policy.
**name** | <code>string</code> | The display name of the dashboard.
**sourceEntity** | <code>[DashboardSourceEntity](#cdk-quicksight-constructs-dashboardsourceentity)</code> | The entity that you are using as a source when you create the dashboard.
**dashboardPublishOptions**? | <code>[DashboardPublishOptions](#cdk-quicksight-constructs-dashboardpublishoptions)</code> | Options for publishing the dashboard when you create it:    AvailabilityStatus for AdHocFilteringOption - This status can be either ENABLED or DISABLED.<br/>__*Optional*__
**parameters**? | <code>[Parameters](#cdk-quicksight-constructs-parameters)</code> | The parameters for the creation of the dashboard, which you want to use to override the default settings.<br/>__*Optional*__
**permissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A structure that contains the permissions of the dashboard.<br/>__*Optional*__
**tags**? | <code>Array<[Tag](#cdk-quicksight-constructs-tag)></code> | Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.<br/>__*Optional*__
**themeArn**? | <code>string</code> | The Amazon Resource Name (ARN) of the theme that is being used for this dashboard.<br/>__*Optional*__
**versionDescription**? | <code>string</code> | A description for the first version of the dashboard being created.<br/>__*Optional*__



## struct CreateDashboardResponse  <a id="cdk-quicksight-constructs-createdashboardresponse"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The ARN of the dashboard.<br/>__*Optional*__
**creationStatus**? | <code>string</code> | The status of the dashboard creation request.<br/>__*Optional*__
**dashboardId**? | <code>string</code> | The ID for the dashboard.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**versionArn**? | <code>string</code> | The ARN of the dashboard, including the version number of the first version that is created.<br/>__*Optional*__



## struct CreateDataSetRequest  <a id="cdk-quicksight-constructs-createdatasetrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID.
**dataSetId** | <code>string</code> | An ID for the dataset that you want to create.
**importMode** | <code>string</code> | Indicates whether you want to import the data into SPICE.
**name** | <code>string</code> | The display name for the dataset.
**physicalTableMap** | <code>Map<string, [PhysicalTable](#cdk-quicksight-constructs-physicaltable)></code> | Declares the physical tables that are available in the underlying data sources.
**columnGroups**? | <code>Array<[ColumnGroup](#cdk-quicksight-constructs-columngroup)></code> | Groupings of columns that work together in certain QuickSight features.<br/>__*Optional*__
**columnLevelPermissionRules**? | <code>Array<[ColumnLevelPermissionRule](#cdk-quicksight-constructs-columnlevelpermissionrule)></code> | A set of one or more definitions of a  ColumnLevelPermissionRule .<br/>__*Optional*__
**fieldFolders**? | <code>Map<string, [FieldFolder](#cdk-quicksight-constructs-fieldfolder)></code> | The folder that contains fields and nested subfolders for your dataset.<br/>__*Optional*__
**logicalTableMap**? | <code>Map<string, [LogicalTable](#cdk-quicksight-constructs-logicaltable)></code> | Configures the combination and transformation of the data from the physical tables.<br/>__*Optional*__
**permissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A list of resource permissions on the dataset.<br/>__*Optional*__
**rowLevelPermissionDataSet**? | <code>[RowLevelPermissionDataSet](#cdk-quicksight-constructs-rowlevelpermissiondataset)</code> | The row-level security configuration for the data that you want to create.<br/>__*Optional*__
**tags**? | <code>Array<[Tag](#cdk-quicksight-constructs-tag)></code> | Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.<br/>__*Optional*__



## struct CreateDataSetResponse  <a id="cdk-quicksight-constructs-createdatasetresponse"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the dataset.<br/>__*Optional*__
**dataSetId**? | <code>string</code> | The ID for the dataset that you want to create.<br/>__*Optional*__
**ingestionArn**? | <code>string</code> | The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.<br/>__*Optional*__
**ingestionId**? | <code>string</code> | The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct CreateDataSourceRequest  <a id="cdk-quicksight-constructs-createdatasourcerequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID.
**dataSourceId** | <code>string</code> | An ID for the data source.
**name** | <code>string</code> | A display name for the data source.
**type** | <code>string</code> | The type of the data source.
**credentials**? | <code>[DataSourceCredentials](#cdk-quicksight-constructs-datasourcecredentials)</code> | The credentials QuickSight that uses to connect to your underlying source.<br/>__*Optional*__
**dataSourceParameters**? | <code>[DataSourceParameters](#cdk-quicksight-constructs-datasourceparameters)</code> | The parameters that QuickSight uses to connect to your underlying source.<br/>__*Optional*__
**permissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A list of resource permissions on the data source.<br/>__*Optional*__
**sslProperties**? | <code>[SslProperties](#cdk-quicksight-constructs-sslproperties)</code> | Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying source.<br/>__*Optional*__
**tags**? | <code>Array<[Tag](#cdk-quicksight-constructs-tag)></code> | Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.<br/>__*Optional*__
**vpcConnectionProperties**? | <code>[VpcConnectionProperties](#cdk-quicksight-constructs-vpcconnectionproperties)</code> | Use this parameter only when you want QuickSight to use a VPC connection when connecting to your underlying source.<br/>__*Optional*__



## struct CreateDataSourceResponse  <a id="cdk-quicksight-constructs-createdatasourceresponse"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the data source.<br/>__*Optional*__
**creationStatus**? | <code>string</code> | The status of creating the data source.<br/>__*Optional*__
**dataSourceId**? | <code>string</code> | The ID of the data source.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct CreateGroupMembershipRequest  <a id="cdk-quicksight-constructs-creategroupmembershiprequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that the group is in.
**groupName** | <code>string</code> | The name of the group that you want to add the user to.
**memberName** | <code>string</code> | The name of the user that you want to add to the group membership.
**namespace** | <code>string</code> | The namespace.



## struct CreateGroupMembershipResponse  <a id="cdk-quicksight-constructs-creategroupmembershipresponse"></a>






Name | Type | Description 
-----|------|-------------
**groupMember**? | <code>[GroupMember](#cdk-quicksight-constructs-groupmember)</code> | The group member.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct CreateGroupRequest  <a id="cdk-quicksight-constructs-creategrouprequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that the group is in.
**groupName** | <code>string</code> | A name for the group that you want to create.
**namespace** | <code>string</code> | The namespace.
**description**? | <code>string</code> | A description for the group that you want to create.<br/>__*Optional*__



## struct CreateGroupResponse  <a id="cdk-quicksight-constructs-creategroupresponse"></a>






Name | Type | Description 
-----|------|-------------
**group**? | <code>[Group](#cdk-quicksight-constructs-group)</code> | The name of the group.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct CreateIAMPolicyAssignmentRequest  <a id="cdk-quicksight-constructs-createiampolicyassignmentrequest"></a>






Name | Type | Description 
-----|------|-------------
**assignmentName** | <code>string</code> | The name of the assignment, also called a rule.
**assignmentStatus** | <code>string</code> | The status of the assignment.
**awsAccountId** | <code>string</code> | The ID of the AWS account where you want to assign an IAM policy to QuickSight users or groups.
**namespace** | <code>string</code> | The namespace that contains the assignment.
**identities**? | <code>Map<string, Array<string>></code> | The QuickSight users, groups, or both that you want to assign the policy to.<br/>__*Optional*__
**policyArn**? | <code>string</code> | The ARN for the IAM policy to apply to the QuickSight users and groups specified in this assignment.<br/>__*Optional*__



## struct CreateIAMPolicyAssignmentResponse  <a id="cdk-quicksight-constructs-createiampolicyassignmentresponse"></a>






Name | Type | Description 
-----|------|-------------
**assignmentId**? | <code>string</code> | The ID for the assignment.<br/>__*Optional*__
**assignmentName**? | <code>string</code> | The name of the assignment.<br/>__*Optional*__
**assignmentStatus**? | <code>string</code> | The status of the assignment.<br/>__*Optional*__
**identities**? | <code>Map<string, Array<string>></code> | The QuickSight users, groups, or both that the IAM policy is assigned to.<br/>__*Optional*__
**policyArn**? | <code>string</code> | The ARN for the IAM policy that is applied to the QuickSight users and groups specified in this assignment.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct CreateIngestionRequest  <a id="cdk-quicksight-constructs-createingestionrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID.
**dataSetId** | <code>string</code> | The ID of the dataset used in the ingestion.
**ingestionId** | <code>string</code> | An ID for the ingestion.



## struct CreateIngestionResponse  <a id="cdk-quicksight-constructs-createingestionresponse"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) for the data ingestion.<br/>__*Optional*__
**ingestionId**? | <code>string</code> | An ID for the ingestion.<br/>__*Optional*__
**ingestionStatus**? | <code>string</code> | The ingestion status.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct CreateNamespaceRequest  <a id="cdk-quicksight-constructs-createnamespacerequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that you want to create the QuickSight namespace in.
**identityStore** | <code>string</code> | Specifies the type of your user identity directory.
**namespace** | <code>string</code> | The name that you want to use to describe the new namespace.
**tags**? | <code>Array<[Tag](#cdk-quicksight-constructs-tag)></code> | The tags that you want to associate with the namespace that you're creating.<br/>__*Optional*__



## struct CreateNamespaceResponse  <a id="cdk-quicksight-constructs-createnamespaceresponse"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The ARN of the QuickSight namespace you created.<br/>__*Optional*__
**capacityRegion**? | <code>string</code> | The AWS Region that you want to use for the free SPICE capacity for the new namespace.<br/>__*Optional*__
**creationStatus**? | <code>string</code> | The status of the creation of the namespace.<br/>__*Optional*__
**identityStore**? | <code>string</code> | Specifies the type of your user identity directory.<br/>__*Optional*__
**name**? | <code>string</code> | The name of the new namespace that you created.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct CreateTemplateAliasRequest  <a id="cdk-quicksight-constructs-createtemplatealiasrequest"></a>






Name | Type | Description 
-----|------|-------------
**aliasName** | <code>string</code> | The name that you want to give to the template alias that you're creating.
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the template that you creating an alias for.
**templateId** | <code>string</code> | An ID for the template.
**templateVersionNumber** | <code>number</code> | The version number of the template.



## struct CreateTemplateAliasResponse  <a id="cdk-quicksight-constructs-createtemplatealiasresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**templateAlias**? | <code>[TemplateAlias](#cdk-quicksight-constructs-templatealias)</code> | Information about the template alias.<br/>__*Optional*__



## struct CreateTemplateRequest  <a id="cdk-quicksight-constructs-createtemplaterequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that the group is in.
**sourceEntity** | <code>[TemplateSourceEntity](#cdk-quicksight-constructs-templatesourceentity)</code> | The entity that you are using as a source when you create the template.
**templateId** | <code>string</code> | An ID for the template that you want to create.
**name**? | <code>string</code> | A display name for the template.<br/>__*Optional*__
**permissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A list of resource permissions to be set on the template.<br/>__*Optional*__
**tags**? | <code>Array<[Tag](#cdk-quicksight-constructs-tag)></code> | Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.<br/>__*Optional*__
**versionDescription**? | <code>string</code> | A description of the current template version being created.<br/>__*Optional*__



## struct CreateTemplateResponse  <a id="cdk-quicksight-constructs-createtemplateresponse"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The ARN for the template.<br/>__*Optional*__
**creationStatus**? | <code>string</code> | The template creation status.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**templateId**? | <code>string</code> | The ID of the template.<br/>__*Optional*__
**versionArn**? | <code>string</code> | The ARN for the template, including the version information of the first version.<br/>__*Optional*__



## struct CreateThemeAliasRequest  <a id="cdk-quicksight-constructs-createthemealiasrequest"></a>






Name | Type | Description 
-----|------|-------------
**aliasName** | <code>string</code> | The name that you want to give to the theme alias that you are creating.
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the theme for the new theme alias.
**themeId** | <code>string</code> | An ID for the theme alias.
**themeVersionNumber** | <code>number</code> | The version number of the theme.



## struct CreateThemeAliasResponse  <a id="cdk-quicksight-constructs-createthemealiasresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**themeAlias**? | <code>[ThemeAlias](#cdk-quicksight-constructs-themealias)</code> | Information about the theme alias.<br/>__*Optional*__



## struct CreateThemeRequest  <a id="cdk-quicksight-constructs-createthemerequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account where you want to store the new theme.
**baseThemeId** | <code>string</code> | The ID of the theme that a custom theme will inherit from.
**configuration** | <code>[ThemeConfiguration](#cdk-quicksight-constructs-themeconfiguration)</code> | The theme configuration, which contains the theme display properties.
**name** | <code>string</code> | A display name for the theme.
**themeId** | <code>string</code> | An ID for the theme that you want to create.
**permissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A valid grouping of resource permissions to apply to the new theme.<br/>__*Optional*__
**tags**? | <code>Array<[Tag](#cdk-quicksight-constructs-tag)></code> | A map of the key-value pairs for the resource tag or tags that you want to add to the resource.<br/>__*Optional*__
**versionDescription**? | <code>string</code> | A description of the first version of the theme that you're creating.<br/>__*Optional*__



## struct CreateThemeResponse  <a id="cdk-quicksight-constructs-createthemeresponse"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) for the theme.<br/>__*Optional*__
**creationStatus**? | <code>string</code> | The theme creation status.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**themeId**? | <code>string</code> | The ID of the theme.<br/>__*Optional*__
**versionArn**? | <code>string</code> | The Amazon Resource Name (ARN) for the new theme.<br/>__*Optional*__



## struct CredentialPair  <a id="cdk-quicksight-constructs-credentialpair"></a>






Name | Type | Description 
-----|------|-------------
**password** | <code>string</code> | Password.
**username** | <code>string</code> | User name.
**alternateDataSourceParameters**? | <code>Array<[DataSourceParameters](#cdk-quicksight-constructs-datasourceparameters)></code> | A set of alternate data source parameters that you want to share for these credentials.<br/>__*Optional*__



## struct CustomSql  <a id="cdk-quicksight-constructs-customsql"></a>






Name | Type | Description 
-----|------|-------------
**dataSourceArn** | <code>string</code> | The Amazon Resource Name (ARN) of the data source.
**name** | <code>string</code> | A display name for the SQL query result.
**sqlQuery** | <code>string</code> | The SQL query.
**columns**? | <code>Array<[InputColumn](#cdk-quicksight-constructs-inputcolumn)></code> | The column schema from the SQL query result set.<br/>__*Optional*__



## struct Dashboard  <a id="cdk-quicksight-constructs-dashboard"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the resource.<br/>__*Optional*__
**createdTime**? | <code>date</code> | The time that this dataset was created.<br/>__*Optional*__
**dashboardId**? | <code>string</code> | Dashboard ID.<br/>__*Optional*__
**lastPublishedTime**? | <code>date</code> | The last time that this dataset was published.<br/>__*Optional*__
**lastUpdatedTime**? | <code>date</code> | The last time that this dataset was updated.<br/>__*Optional*__
**name**? | <code>string</code> | A display name for the dashboard.<br/>__*Optional*__
**version**? | <code>[DashboardVersion](#cdk-quicksight-constructs-dashboardversion)</code> | Version.<br/>__*Optional*__



## struct DashboardError  <a id="cdk-quicksight-constructs-dashboarderror"></a>






Name | Type | Description 
-----|------|-------------
**message**? | <code>string</code> | Message.<br/>__*Optional*__
**type**? | <code>string</code> | Type.<br/>__*Optional*__



## struct DashboardPublishOptions  <a id="cdk-quicksight-constructs-dashboardpublishoptions"></a>






Name | Type | Description 
-----|------|-------------
**adHocFilteringOption**? | <code>[AdHocFilteringOption](#cdk-quicksight-constructs-adhocfilteringoption)</code> | Ad hoc (one-time) filtering option.<br/>__*Optional*__
**exportToCSVOption**? | <code>[ExportToCSVOption](#cdk-quicksight-constructs-exporttocsvoption)</code> | Export to .csv option.<br/>__*Optional*__
**sheetControlsOption**? | <code>[SheetControlsOption](#cdk-quicksight-constructs-sheetcontrolsoption)</code> | Sheet controls option.<br/>__*Optional*__



## struct DashboardSearchFilter  <a id="cdk-quicksight-constructs-dashboardsearchfilter"></a>






Name | Type | Description 
-----|------|-------------
**operator** | <code>string</code> | The comparison operator that you want to use as a filter, for example, "Operator": "StringEquals".
**name**? | <code>string</code> | The name of the value that you want to use as a filter, for example, "Name": "QUICKSIGHT_USER".<br/>__*Optional*__
**value**? | <code>string</code> | The value of the named item, in this case QUICKSIGHT_USER, that you want to use as a filter, for example, "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1".<br/>__*Optional*__



## struct DashboardSourceEntity  <a id="cdk-quicksight-constructs-dashboardsourceentity"></a>






Name | Type | Description 
-----|------|-------------
**sourceTemplate**? | <code>[DashboardSourceTemplate](#cdk-quicksight-constructs-dashboardsourcetemplate)</code> | Source template.<br/>__*Optional*__



## struct DashboardSourceTemplate  <a id="cdk-quicksight-constructs-dashboardsourcetemplate"></a>






Name | Type | Description 
-----|------|-------------
**arn** | <code>string</code> | The Amazon Resource Name (ARN) of the resource.
**dataSetReferences** | <code>Array<[DataSetReference](#cdk-quicksight-constructs-datasetreference)></code> | Dataset references.



## struct DashboardSummary  <a id="cdk-quicksight-constructs-dashboardsummary"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the resource.<br/>__*Optional*__
**createdTime**? | <code>date</code> | The time that this dashboard was created.<br/>__*Optional*__
**dashboardId**? | <code>string</code> | Dashboard ID.<br/>__*Optional*__
**lastPublishedTime**? | <code>date</code> | The last time that this dashboard was published.<br/>__*Optional*__
**lastUpdatedTime**? | <code>date</code> | The last time that this dashboard was updated.<br/>__*Optional*__
**name**? | <code>string</code> | A display name for the dashboard.<br/>__*Optional*__
**publishedVersionNumber**? | <code>number</code> | Published version number.<br/>__*Optional*__



## struct DashboardVersion  <a id="cdk-quicksight-constructs-dashboardversion"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the resource.<br/>__*Optional*__
**createdTime**? | <code>date</code> | The time that this dashboard version was created.<br/>__*Optional*__
**dataSetArns**? | <code>Array<string></code> | The Amazon Resource Numbers (ARNs) for the datasets that are associated with this version of the dashboard.<br/>__*Optional*__
**description**? | <code>string</code> | Description.<br/>__*Optional*__
**errors**? | <code>Array<[DashboardError](#cdk-quicksight-constructs-dashboarderror)></code> | Errors associated with this dashboard version.<br/>__*Optional*__
**sheets**? | <code>Array<[Sheet](#cdk-quicksight-constructs-sheet)></code> | A list of the associated sheets with the unique identifier and name of each sheet.<br/>__*Optional*__
**sourceEntityArn**? | <code>string</code> | Source entity ARN.<br/>__*Optional*__
**status**? | <code>string</code> | The HTTP status of the request.<br/>__*Optional*__
**themeArn**? | <code>string</code> | The ARN of the theme associated with a version of the dashboard.<br/>__*Optional*__
**versionNumber**? | <code>number</code> | Version number for this version of the dashboard.<br/>__*Optional*__



## struct DashboardVersionSummary  <a id="cdk-quicksight-constructs-dashboardversionsummary"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the resource.<br/>__*Optional*__
**createdTime**? | <code>date</code> | The time that this dashboard version was created.<br/>__*Optional*__
**description**? | <code>string</code> | Description.<br/>__*Optional*__
**sourceEntityArn**? | <code>string</code> | Source entity ARN.<br/>__*Optional*__
**status**? | <code>string</code> | The HTTP status of the request.<br/>__*Optional*__
**versionNumber**? | <code>number</code> | Version number.<br/>__*Optional*__



## struct DataColorPalette  <a id="cdk-quicksight-constructs-datacolorpalette"></a>






Name | Type | Description 
-----|------|-------------
**colors**? | <code>Array<string></code> | The hexadecimal codes for the colors.<br/>__*Optional*__
**emptyFillColor**? | <code>string</code> | The hexadecimal code of a color that applies to charts where a lack of data is highlighted.<br/>__*Optional*__
**minMaxGradient**? | <code>Array<string></code> | The minimum and maximum hexadecimal codes that describe a color gradient.<br/>__*Optional*__



## struct DataSet  <a id="cdk-quicksight-constructs-dataset"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the resource.<br/>__*Optional*__
**columnGroups**? | <code>Array<[ColumnGroup](#cdk-quicksight-constructs-columngroup)></code> | Groupings of columns that work together in certain Amazon QuickSight features.<br/>__*Optional*__
**columnLevelPermissionRules**? | <code>Array<[ColumnLevelPermissionRule](#cdk-quicksight-constructs-columnlevelpermissionrule)></code> | A set of one or more definitions of a  ColumnLevelPermissionRule .<br/>__*Optional*__
**consumedSpiceCapacityInBytes**? | <code>number</code> | The amount of SPICE capacity used by this dataset.<br/>__*Optional*__
**createdTime**? | <code>date</code> | The time that this dataset was created.<br/>__*Optional*__
**dataSetId**? | <code>string</code> | The ID of the dataset.<br/>__*Optional*__
**fieldFolders**? | <code>Map<string, [FieldFolder](#cdk-quicksight-constructs-fieldfolder)></code> | The folder that contains fields and nested subfolders for your dataset.<br/>__*Optional*__
**importMode**? | <code>string</code> | A value that indicates whether you want to import the data into SPICE.<br/>__*Optional*__
**lastUpdatedTime**? | <code>date</code> | The last time that this dataset was updated.<br/>__*Optional*__
**logicalTableMap**? | <code>Map<string, [LogicalTable](#cdk-quicksight-constructs-logicaltable)></code> | Configures the combination and transformation of the data from the physical tables.<br/>__*Optional*__
**name**? | <code>string</code> | A display name for the dataset.<br/>__*Optional*__
**outputColumns**? | <code>Array<[OutputColumn](#cdk-quicksight-constructs-outputcolumn)></code> | The list of columns after all transforms.<br/>__*Optional*__
**physicalTableMap**? | <code>Map<string, [PhysicalTable](#cdk-quicksight-constructs-physicaltable)></code> | Declares the physical tables that are available in the underlying data sources.<br/>__*Optional*__
**rowLevelPermissionDataSet**? | <code>[RowLevelPermissionDataSet](#cdk-quicksight-constructs-rowlevelpermissiondataset)</code> | The row-level security configuration for the dataset.<br/>__*Optional*__



## struct DataSetConfiguration  <a id="cdk-quicksight-constructs-datasetconfiguration"></a>






Name | Type | Description 
-----|------|-------------
**columnGroupSchemaList**? | <code>Array<[ColumnGroupSchema](#cdk-quicksight-constructs-columngroupschema)></code> | A structure containing the list of column group schemas.<br/>__*Optional*__
**dataSetSchema**? | <code>[DataSetSchema](#cdk-quicksight-constructs-datasetschema)</code> | Dataset schema.<br/>__*Optional*__
**placeholder**? | <code>string</code> | Placeholder.<br/>__*Optional*__



## struct DataSetProps  <a id="cdk-quicksight-constructs-datasetprops"></a>






Name | Type | Description 
-----|------|-------------
**logicalTableMap** | <code>Map<string, [LogicalTable](#cdk-quicksight-constructs-logicaltable)></code> | <span></span>
**name** | <code>string</code> | <span></span>
**physicalTableMap** | <code>Map<string, [PhysicalTable](#cdk-quicksight-constructs-physicaltable)></code> | <span></span>
**users** | <code>Array<string></code> | QuickSight Users you want to give access to. In the end the permission arn are looking like arn:aws:quicksight:us-east-1:1234:user/default/martin.mueller@take2.co.



## struct DataSetReference  <a id="cdk-quicksight-constructs-datasetreference"></a>






Name | Type | Description 
-----|------|-------------
**dataSetArn** | <code>string</code> | Dataset Amazon Resource Name (ARN).
**dataSetPlaceholder** | <code>string</code> | Dataset placeholder.



## struct DataSetSchema  <a id="cdk-quicksight-constructs-datasetschema"></a>






Name | Type | Description 
-----|------|-------------
**columnSchemaList**? | <code>Array<[ColumnSchema](#cdk-quicksight-constructs-columnschema)></code> | A structure containing the list of column schemas.<br/>__*Optional*__



## struct DataSetSummary  <a id="cdk-quicksight-constructs-datasetsummary"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the dataset.<br/>__*Optional*__
**columnLevelPermissionRulesApplied**? | <code>boolean</code> | A value that indicates if the dataset has column level permission configured.<br/>__*Optional*__
**createdTime**? | <code>date</code> | The time that this dataset was created.<br/>__*Optional*__
**dataSetId**? | <code>string</code> | The ID of the dataset.<br/>__*Optional*__
**importMode**? | <code>string</code> | A value that indicates whether you want to import the data into SPICE.<br/>__*Optional*__
**lastUpdatedTime**? | <code>date</code> | The last time that this dataset was updated.<br/>__*Optional*__
**name**? | <code>string</code> | A display name for the dataset.<br/>__*Optional*__
**rowLevelPermissionDataSet**? | <code>[RowLevelPermissionDataSet](#cdk-quicksight-constructs-rowlevelpermissiondataset)</code> | The row-level security configuration for the dataset.<br/>__*Optional*__



## struct DataSource  <a id="cdk-quicksight-constructs-datasource"></a>






Name | Type | Description 
-----|------|-------------
**alternateDataSourceParameters**? | <code>Array<[DataSourceParameters](#cdk-quicksight-constructs-datasourceparameters)></code> | A set of alternate data source parameters that you want to share for the credentials stored with this data source.<br/>__*Optional*__
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the data source.<br/>__*Optional*__
**createdTime**? | <code>date</code> | The time that this data source was created.<br/>__*Optional*__
**dataSourceId**? | <code>string</code> | The ID of the data source.<br/>__*Optional*__
**dataSourceParameters**? | <code>[DataSourceParameters](#cdk-quicksight-constructs-datasourceparameters)</code> | The parameters that Amazon QuickSight uses to connect to your underlying source.<br/>__*Optional*__
**errorInfo**? | <code>[DataSourceErrorInfo](#cdk-quicksight-constructs-datasourceerrorinfo)</code> | Error information from the last update or the creation of the data source.<br/>__*Optional*__
**lastUpdatedTime**? | <code>date</code> | The last time that this data source was updated.<br/>__*Optional*__
**name**? | <code>string</code> | A display name for the data source.<br/>__*Optional*__
**sslProperties**? | <code>[SslProperties](#cdk-quicksight-constructs-sslproperties)</code> | Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying source.<br/>__*Optional*__
**status**? | <code>string</code> | The HTTP status of the request.<br/>__*Optional*__
**type**? | <code>string</code> | The type of the data source.<br/>__*Optional*__
**vpcConnectionProperties**? | <code>[VpcConnectionProperties](#cdk-quicksight-constructs-vpcconnectionproperties)</code> | The VPC connection information.<br/>__*Optional*__



## struct DataSourceCredentials  <a id="cdk-quicksight-constructs-datasourcecredentials"></a>






Name | Type | Description 
-----|------|-------------
**copySourceArn**? | <code>string</code> | The Amazon Resource Name (ARN) of a data source that has the credential pair that you want to use.<br/>__*Optional*__
**credentialPair**? | <code>[CredentialPair](#cdk-quicksight-constructs-credentialpair)</code> | Credential pair.<br/>__*Optional*__



## struct DataSourceErrorInfo  <a id="cdk-quicksight-constructs-datasourceerrorinfo"></a>






Name | Type | Description 
-----|------|-------------
**message**? | <code>string</code> | Error message.<br/>__*Optional*__
**type**? | <code>string</code> | Error type.<br/>__*Optional*__



## struct DataSourceParameters  <a id="cdk-quicksight-constructs-datasourceparameters"></a>






Name | Type | Description 
-----|------|-------------
**amazonElasticsearchParameters**? | <code>[AmazonElasticsearchParameters](#cdk-quicksight-constructs-amazonelasticsearchparameters)</code> | Amazon Elasticsearch Service parameters.<br/>__*Optional*__
**athenaParameters**? | <code>[AthenaParameters](#cdk-quicksight-constructs-athenaparameters)</code> | Amazon Athena parameters.<br/>__*Optional*__
**auroraParameters**? | <code>[AuroraParameters](#cdk-quicksight-constructs-auroraparameters)</code> | Amazon Aurora MySQL parameters.<br/>__*Optional*__
**auroraPostgreSqlParameters**? | <code>[AuroraPostgreSqlParameters](#cdk-quicksight-constructs-aurorapostgresqlparameters)</code> | Aurora PostgreSQL parameters.<br/>__*Optional*__
**awsIotAnalyticsParameters**? | <code>[AwsIotAnalyticsParameters](#cdk-quicksight-constructs-awsiotanalyticsparameters)</code> | AWS IoT Analytics parameters.<br/>__*Optional*__
**jiraParameters**? | <code>[JiraParameters](#cdk-quicksight-constructs-jiraparameters)</code> | Jira parameters.<br/>__*Optional*__
**mariaDbParameters**? | <code>[MariaDbParameters](#cdk-quicksight-constructs-mariadbparameters)</code> | MariaDB parameters.<br/>__*Optional*__
**mySqlParameters**? | <code>[MySqlParameters](#cdk-quicksight-constructs-mysqlparameters)</code> | MySQL parameters.<br/>__*Optional*__
**oracleParameters**? | <code>[OracleParameters](#cdk-quicksight-constructs-oracleparameters)</code> | Oracle parameters.<br/>__*Optional*__
**postgreSqlParameters**? | <code>[PostgreSqlParameters](#cdk-quicksight-constructs-postgresqlparameters)</code> | PostgreSQL parameters.<br/>__*Optional*__
**prestoParameters**? | <code>[PrestoParameters](#cdk-quicksight-constructs-prestoparameters)</code> | Presto parameters.<br/>__*Optional*__
**rdsParameters**? | <code>[RdsParameters](#cdk-quicksight-constructs-rdsparameters)</code> | Amazon RDS parameters.<br/>__*Optional*__
**redshiftParameters**? | <code>[RedshiftParameters](#cdk-quicksight-constructs-redshiftparameters)</code> | Amazon Redshift parameters.<br/>__*Optional*__
**s3Parameters**? | <code>[S3Parameters](#cdk-quicksight-constructs-s3parameters)</code> | S3 parameters.<br/>__*Optional*__
**serviceNowParameters**? | <code>[ServiceNowParameters](#cdk-quicksight-constructs-servicenowparameters)</code> | ServiceNow parameters.<br/>__*Optional*__
**snowflakeParameters**? | <code>[SnowflakeParameters](#cdk-quicksight-constructs-snowflakeparameters)</code> | Snowflake parameters.<br/>__*Optional*__
**sparkParameters**? | <code>[SparkParameters](#cdk-quicksight-constructs-sparkparameters)</code> | Spark parameters.<br/>__*Optional*__
**sqlServerParameters**? | <code>[SqlServerParameters](#cdk-quicksight-constructs-sqlserverparameters)</code> | SQL Server parameters.<br/>__*Optional*__
**teradataParameters**? | <code>[TeradataParameters](#cdk-quicksight-constructs-teradataparameters)</code> | Teradata parameters.<br/>__*Optional*__
**twitterParameters**? | <code>[TwitterParameters](#cdk-quicksight-constructs-twitterparameters)</code> | Twitter parameters.<br/>__*Optional*__



## struct DataSourceProps  <a id="cdk-quicksight-constructs-datasourceprops"></a>






Name | Type | Description 
-----|------|-------------
**dataSourceParameters** | <code>[DataSourceParameters](#cdk-quicksight-constructs-datasourceparameters)</code> | <span></span>
**name** | <code>string</code> | <span></span>
**type** | <code>string</code> | <span></span>
**users** | <code>Array<string></code> | QuickSight Users you want to give access to. In the end the permission arn are looking like arn:aws:quicksight:us-east-1:1234:user/default/martin.mueller@take2.co.



## struct DateTimeParameter  <a id="cdk-quicksight-constructs-datetimeparameter"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | A display name for the date-time parameter.
**values** | <code>Array<date></code> | The values for the date-time parameter.



## struct DecimalParameter  <a id="cdk-quicksight-constructs-decimalparameter"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | A display name for the decimal parameter.
**values** | <code>Array<number></code> | The values for the decimal parameter.



## struct DeleteAccountCustomizationRequest  <a id="cdk-quicksight-constructs-deleteaccountcustomizationrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that you want to delete QuickSight customizations from in this AWS Region.
**namespace**? | <code>string</code> | The QuickSight namespace that you're deleting the customizations from.<br/>__*Optional*__



## struct DeleteAccountCustomizationResponse  <a id="cdk-quicksight-constructs-deleteaccountcustomizationresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DeleteAnalysisRequest  <a id="cdk-quicksight-constructs-deleteanalysisrequest"></a>






Name | Type | Description 
-----|------|-------------
**analysisId** | <code>string</code> | The ID of the analysis that you're deleting.
**awsAccountId** | <code>string</code> | The ID of the AWS account where you want to delete an analysis.
**forceDeleteWithoutRecovery**? | <code>boolean</code> | This option defaults to the value NoForceDeleteWithoutRecovery.<br/>__*Optional*__
**recoveryWindowInDays**? | <code>number</code> | A value that specifies the number of days that QuickSight waits before it deletes the analysis.<br/>__*Optional*__



## struct DeleteAnalysisResponse  <a id="cdk-quicksight-constructs-deleteanalysisresponse"></a>






Name | Type | Description 
-----|------|-------------
**analysisId**? | <code>string</code> | The ID of the deleted analysis.<br/>__*Optional*__
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the deleted analysis.<br/>__*Optional*__
**deletionTime**? | <code>date</code> | The date and time that the analysis is scheduled to be deleted.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DeleteDashboardRequest  <a id="cdk-quicksight-constructs-deletedashboardrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the dashboard that you're deleting.
**dashboardId** | <code>string</code> | The ID for the dashboard.
**versionNumber**? | <code>number</code> | The version number of the dashboard.<br/>__*Optional*__



## struct DeleteDashboardResponse  <a id="cdk-quicksight-constructs-deletedashboardresponse"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Secure Socket Layer (SSL) properties that apply for the resource.<br/>__*Optional*__
**dashboardId**? | <code>string</code> | The ID of the dashboard.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DeleteDataSetRequest  <a id="cdk-quicksight-constructs-deletedatasetrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID.
**dataSetId** | <code>string</code> | The ID for the dataset that you want to create.



## struct DeleteDataSetResponse  <a id="cdk-quicksight-constructs-deletedatasetresponse"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the dataset.<br/>__*Optional*__
**dataSetId**? | <code>string</code> | The ID for the dataset that you want to create.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DeleteDataSourceRequest  <a id="cdk-quicksight-constructs-deletedatasourcerequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID.
**dataSourceId** | <code>string</code> | The ID of the data source.



## struct DeleteDataSourceResponse  <a id="cdk-quicksight-constructs-deletedatasourceresponse"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the data source that you deleted.<br/>__*Optional*__
**dataSourceId**? | <code>string</code> | The ID of the data source.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DeleteGroupMembershipRequest  <a id="cdk-quicksight-constructs-deletegroupmembershiprequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that the group is in.
**groupName** | <code>string</code> | The name of the group that you want to delete the user from.
**memberName** | <code>string</code> | The name of the user that you want to delete from the group membership.
**namespace** | <code>string</code> | The namespace.



## struct DeleteGroupMembershipResponse  <a id="cdk-quicksight-constructs-deletegroupmembershipresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DeleteGroupRequest  <a id="cdk-quicksight-constructs-deletegrouprequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that the group is in.
**groupName** | <code>string</code> | The name of the group that you want to delete.
**namespace** | <code>string</code> | The namespace.



## struct DeleteGroupResponse  <a id="cdk-quicksight-constructs-deletegroupresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DeleteIAMPolicyAssignmentRequest  <a id="cdk-quicksight-constructs-deleteiampolicyassignmentrequest"></a>






Name | Type | Description 
-----|------|-------------
**assignmentName** | <code>string</code> | The name of the assignment.
**awsAccountId** | <code>string</code> | The AWS account ID where you want to delete the IAM policy assignment.
**namespace** | <code>string</code> | The namespace that contains the assignment.



## struct DeleteIAMPolicyAssignmentResponse  <a id="cdk-quicksight-constructs-deleteiampolicyassignmentresponse"></a>






Name | Type | Description 
-----|------|-------------
**assignmentName**? | <code>string</code> | The name of the assignment.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DeleteNamespaceRequest  <a id="cdk-quicksight-constructs-deletenamespacerequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that you want to delete the QuickSight namespace from.
**namespace** | <code>string</code> | The namespace that you want to delete.



## struct DeleteNamespaceResponse  <a id="cdk-quicksight-constructs-deletenamespaceresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DeleteTemplateAliasRequest  <a id="cdk-quicksight-constructs-deletetemplatealiasrequest"></a>






Name | Type | Description 
-----|------|-------------
**aliasName** | <code>string</code> | The name for the template alias.
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the item to delete.
**templateId** | <code>string</code> | The ID for the template that the specified alias is for.



## struct DeleteTemplateAliasResponse  <a id="cdk-quicksight-constructs-deletetemplatealiasresponse"></a>






Name | Type | Description 
-----|------|-------------
**aliasName**? | <code>string</code> | The name for the template alias.<br/>__*Optional*__
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the template you want to delete.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**templateId**? | <code>string</code> | An ID for the template associated with the deletion.<br/>__*Optional*__



## struct DeleteTemplateRequest  <a id="cdk-quicksight-constructs-deletetemplaterequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the template that you're deleting.
**templateId** | <code>string</code> | An ID for the template you want to delete.
**versionNumber**? | <code>number</code> | Specifies the version of the template that you want to delete.<br/>__*Optional*__



## struct DeleteTemplateResponse  <a id="cdk-quicksight-constructs-deletetemplateresponse"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the resource.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**templateId**? | <code>string</code> | An ID for the template.<br/>__*Optional*__



## struct DeleteThemeAliasRequest  <a id="cdk-quicksight-constructs-deletethemealiasrequest"></a>






Name | Type | Description 
-----|------|-------------
**aliasName** | <code>string</code> | The unique name for the theme alias to delete.
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the theme alias to delete.
**themeId** | <code>string</code> | The ID for the theme that the specified alias is for.



## struct DeleteThemeAliasResponse  <a id="cdk-quicksight-constructs-deletethemealiasresponse"></a>






Name | Type | Description 
-----|------|-------------
**aliasName**? | <code>string</code> | The name for the theme alias.<br/>__*Optional*__
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the theme resource using the deleted alias.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**themeId**? | <code>string</code> | An ID for the theme associated with the deletion.<br/>__*Optional*__



## struct DeleteThemeRequest  <a id="cdk-quicksight-constructs-deletethemerequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the theme that you're deleting.
**themeId** | <code>string</code> | An ID for the theme that you want to delete.
**versionNumber**? | <code>number</code> | The version of the theme that you want to delete.<br/>__*Optional*__



## struct DeleteThemeResponse  <a id="cdk-quicksight-constructs-deletethemeresponse"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the resource.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**themeId**? | <code>string</code> | An ID for the theme.<br/>__*Optional*__



## struct DeleteUserByPrincipalIdRequest  <a id="cdk-quicksight-constructs-deleteuserbyprincipalidrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that the user is in.
**namespace** | <code>string</code> | The namespace.
**principalId** | <code>string</code> | The principal ID of the user.



## struct DeleteUserByPrincipalIdResponse  <a id="cdk-quicksight-constructs-deleteuserbyprincipalidresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DeleteUserRequest  <a id="cdk-quicksight-constructs-deleteuserrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that the user is in.
**namespace** | <code>string</code> | The namespace.
**userName** | <code>string</code> | The name of the user that you want to delete.



## struct DeleteUserResponse  <a id="cdk-quicksight-constructs-deleteuserresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DescribeAccountCustomizationRequest  <a id="cdk-quicksight-constructs-describeaccountcustomizationrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that you want to describe QuickSight customizations for.
**namespace**? | <code>string</code> | The QuickSight namespace that you want to describe QuickSight customizations for.<br/>__*Optional*__
**resolved**? | <code>boolean</code> | The Resolved flag works with the other parameters to determine which view of QuickSight customizations is returned.<br/>__*Optional*__



## struct DescribeAccountCustomizationResponse  <a id="cdk-quicksight-constructs-describeaccountcustomizationresponse"></a>






Name | Type | Description 
-----|------|-------------
**accountCustomization**? | <code>[AccountCustomization](#cdk-quicksight-constructs-accountcustomization)</code> | The QuickSight customizations that exist in the current AWS Region.<br/>__*Optional*__
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the customization that's associated with this AWS account.<br/>__*Optional*__
**awsAccountId**? | <code>string</code> | The ID for the AWS account that you're describing.<br/>__*Optional*__
**namespace**? | <code>string</code> | The QuickSight namespace that you're describing.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DescribeAccountSettingsRequest  <a id="cdk-quicksight-constructs-describeaccountsettingsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that contains the settings that you want to list.



## struct DescribeAccountSettingsResponse  <a id="cdk-quicksight-constructs-describeaccountsettingsresponse"></a>






Name | Type | Description 
-----|------|-------------
**accountSettings**? | <code>[AccountSettings](#cdk-quicksight-constructs-accountsettings)</code> | The QuickSight settings for this AWS account.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DescribeAnalysisPermissionsRequest  <a id="cdk-quicksight-constructs-describeanalysispermissionsrequest"></a>






Name | Type | Description 
-----|------|-------------
**analysisId** | <code>string</code> | The ID of the analysis whose permissions you're describing.
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the analysis whose permissions you're describing.



## struct DescribeAnalysisPermissionsResponse  <a id="cdk-quicksight-constructs-describeanalysispermissionsresponse"></a>






Name | Type | Description 
-----|------|-------------
**analysisArn**? | <code>string</code> | The Amazon Resource Name (ARN) of the analysis whose permissions you're describing.<br/>__*Optional*__
**analysisId**? | <code>string</code> | The ID of the analysis whose permissions you're describing.<br/>__*Optional*__
**permissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A structure that describes the principals and the resource-level permissions on an analysis.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DescribeAnalysisRequest  <a id="cdk-quicksight-constructs-describeanalysisrequest"></a>






Name | Type | Description 
-----|------|-------------
**analysisId** | <code>string</code> | The ID of the analysis that you're describing.
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the analysis.



## struct DescribeAnalysisResponse  <a id="cdk-quicksight-constructs-describeanalysisresponse"></a>






Name | Type | Description 
-----|------|-------------
**analysis**? | <code>[Analysis](#cdk-quicksight-constructs-analysis)</code> | A metadata structure that contains summary information for the analysis that you're describing.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DescribeDashboardPermissionsRequest  <a id="cdk-quicksight-constructs-describedashboardpermissionsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the dashboard that you're describing permissions for.
**dashboardId** | <code>string</code> | The ID for the dashboard, also added to the IAM policy.



## struct DescribeDashboardPermissionsResponse  <a id="cdk-quicksight-constructs-describedashboardpermissionsresponse"></a>






Name | Type | Description 
-----|------|-------------
**dashboardArn**? | <code>string</code> | The Amazon Resource Name (ARN) of the dashboard.<br/>__*Optional*__
**dashboardId**? | <code>string</code> | The ID for the dashboard.<br/>__*Optional*__
**permissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A structure that contains the permissions for the dashboard.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DescribeDashboardRequest  <a id="cdk-quicksight-constructs-describedashboardrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the dashboard that you're describing.
**dashboardId** | <code>string</code> | The ID for the dashboard.
**aliasName**? | <code>string</code> | The alias name.<br/>__*Optional*__
**versionNumber**? | <code>number</code> | The version number for the dashboard.<br/>__*Optional*__



## struct DescribeDashboardResponse  <a id="cdk-quicksight-constructs-describedashboardresponse"></a>






Name | Type | Description 
-----|------|-------------
**dashboard**? | <code>[Dashboard](#cdk-quicksight-constructs-dashboard)</code> | Information about the dashboard.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of this request.<br/>__*Optional*__



## struct DescribeDataSetPermissionsRequest  <a id="cdk-quicksight-constructs-describedatasetpermissionsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID.
**dataSetId** | <code>string</code> | The ID for the dataset that you want to create.



## struct DescribeDataSetPermissionsResponse  <a id="cdk-quicksight-constructs-describedatasetpermissionsresponse"></a>






Name | Type | Description 
-----|------|-------------
**dataSetArn**? | <code>string</code> | The Amazon Resource Name (ARN) of the dataset.<br/>__*Optional*__
**dataSetId**? | <code>string</code> | The ID for the dataset that you want to create.<br/>__*Optional*__
**permissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A list of resource permissions on the dataset.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DescribeDataSetRequest  <a id="cdk-quicksight-constructs-describedatasetrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID.
**dataSetId** | <code>string</code> | The ID for the dataset that you want to create.



## struct DescribeDataSetResponse  <a id="cdk-quicksight-constructs-describedatasetresponse"></a>






Name | Type | Description 
-----|------|-------------
**dataSet**? | <code>[DataSet](#cdk-quicksight-constructs-dataset)</code> | Information on the dataset.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DescribeDataSourcePermissionsRequest  <a id="cdk-quicksight-constructs-describedatasourcepermissionsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID.
**dataSourceId** | <code>string</code> | The ID of the data source.



## struct DescribeDataSourcePermissionsResponse  <a id="cdk-quicksight-constructs-describedatasourcepermissionsresponse"></a>






Name | Type | Description 
-----|------|-------------
**dataSourceArn**? | <code>string</code> | The Amazon Resource Name (ARN) of the data source.<br/>__*Optional*__
**dataSourceId**? | <code>string</code> | The ID of the data source.<br/>__*Optional*__
**permissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A list of resource permissions on the data source.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DescribeDataSourceRequest  <a id="cdk-quicksight-constructs-describedatasourcerequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID.
**dataSourceId** | <code>string</code> | The ID of the data source.



## struct DescribeDataSourceResponse  <a id="cdk-quicksight-constructs-describedatasourceresponse"></a>






Name | Type | Description 
-----|------|-------------
**dataSource**? | <code>[DataSource](#cdk-quicksight-constructs-datasource)</code> | The information on the data source.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DescribeGroupRequest  <a id="cdk-quicksight-constructs-describegrouprequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that the group is in.
**groupName** | <code>string</code> | The name of the group that you want to describe.
**namespace** | <code>string</code> | The namespace.



## struct DescribeGroupResponse  <a id="cdk-quicksight-constructs-describegroupresponse"></a>






Name | Type | Description 
-----|------|-------------
**group**? | <code>[Group](#cdk-quicksight-constructs-group)</code> | The name of the group.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DescribeIAMPolicyAssignmentRequest  <a id="cdk-quicksight-constructs-describeiampolicyassignmentrequest"></a>






Name | Type | Description 
-----|------|-------------
**assignmentName** | <code>string</code> | The name of the assignment, also called a rule.
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the assignment that you want to describe.
**namespace** | <code>string</code> | The namespace that contains the assignment.



## struct DescribeIAMPolicyAssignmentResponse  <a id="cdk-quicksight-constructs-describeiampolicyassignmentresponse"></a>






Name | Type | Description 
-----|------|-------------
**iAMPolicyAssignment**? | <code>[IAMPolicyAssignment](#cdk-quicksight-constructs-iampolicyassignment)</code> | Information describing the IAM policy assignment.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DescribeIngestionRequest  <a id="cdk-quicksight-constructs-describeingestionrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID.
**dataSetId** | <code>string</code> | The ID of the dataset used in the ingestion.
**ingestionId** | <code>string</code> | An ID for the ingestion.



## struct DescribeIngestionResponse  <a id="cdk-quicksight-constructs-describeingestionresponse"></a>






Name | Type | Description 
-----|------|-------------
**ingestion**? | <code>[Ingestion](#cdk-quicksight-constructs-ingestion)</code> | Information about the ingestion.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DescribeNamespaceRequest  <a id="cdk-quicksight-constructs-describenamespacerequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that contains the QuickSight namespace that you want to describe.
**namespace** | <code>string</code> | The namespace that you want to describe.



## struct DescribeNamespaceResponse  <a id="cdk-quicksight-constructs-describenamespaceresponse"></a>






Name | Type | Description 
-----|------|-------------
**namespace**? | <code>[NamespaceInfoV2](#cdk-quicksight-constructs-namespaceinfov2)</code> | The information about the namespace that you're describing.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct DescribeTemplateAliasRequest  <a id="cdk-quicksight-constructs-describetemplatealiasrequest"></a>






Name | Type | Description 
-----|------|-------------
**aliasName** | <code>string</code> | The name of the template alias that you want to describe.
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the template alias that you're describing.
**templateId** | <code>string</code> | The ID for the template.



## struct DescribeTemplateAliasResponse  <a id="cdk-quicksight-constructs-describetemplatealiasresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**templateAlias**? | <code>[TemplateAlias](#cdk-quicksight-constructs-templatealias)</code> | Information about the template alias.<br/>__*Optional*__



## struct DescribeTemplatePermissionsRequest  <a id="cdk-quicksight-constructs-describetemplatepermissionsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the template that you're describing.
**templateId** | <code>string</code> | The ID for the template.



## struct DescribeTemplatePermissionsResponse  <a id="cdk-quicksight-constructs-describetemplatepermissionsresponse"></a>






Name | Type | Description 
-----|------|-------------
**permissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A list of resource permissions to be set on the template.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**templateArn**? | <code>string</code> | The Amazon Resource Name (ARN) of the template.<br/>__*Optional*__
**templateId**? | <code>string</code> | The ID for the template.<br/>__*Optional*__



## struct DescribeTemplateRequest  <a id="cdk-quicksight-constructs-describetemplaterequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the template that you're describing.
**templateId** | <code>string</code> | The ID for the template.
**aliasName**? | <code>string</code> | The alias of the template that you want to describe.<br/>__*Optional*__
**versionNumber**? | <code>number</code> | (Optional) The number for the version to describe.<br/>__*Optional*__



## struct DescribeTemplateResponse  <a id="cdk-quicksight-constructs-describetemplateresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**template**? | <code>[Template](#cdk-quicksight-constructs-template)</code> | The template structure for the object you want to describe.<br/>__*Optional*__



## struct DescribeThemeAliasRequest  <a id="cdk-quicksight-constructs-describethemealiasrequest"></a>






Name | Type | Description 
-----|------|-------------
**aliasName** | <code>string</code> | The name of the theme alias that you want to describe.
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the theme alias that you're describing.
**themeId** | <code>string</code> | The ID for the theme.



## struct DescribeThemeAliasResponse  <a id="cdk-quicksight-constructs-describethemealiasresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**themeAlias**? | <code>[ThemeAlias](#cdk-quicksight-constructs-themealias)</code> | Information about the theme alias.<br/>__*Optional*__



## struct DescribeThemePermissionsRequest  <a id="cdk-quicksight-constructs-describethemepermissionsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the theme that you're describing.
**themeId** | <code>string</code> | The ID for the theme that you want to describe permissions for.



## struct DescribeThemePermissionsResponse  <a id="cdk-quicksight-constructs-describethemepermissionsresponse"></a>






Name | Type | Description 
-----|------|-------------
**permissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A list of resource permissions set on the theme.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**themeArn**? | <code>string</code> | The Amazon Resource Name (ARN) of the theme.<br/>__*Optional*__
**themeId**? | <code>string</code> | The ID for the theme.<br/>__*Optional*__



## struct DescribeThemeRequest  <a id="cdk-quicksight-constructs-describethemerequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the theme that you're describing.
**themeId** | <code>string</code> | The ID for the theme.
**aliasName**? | <code>string</code> | The alias of the theme that you want to describe.<br/>__*Optional*__
**versionNumber**? | <code>number</code> | The version number for the version to describe.<br/>__*Optional*__



## struct DescribeThemeResponse  <a id="cdk-quicksight-constructs-describethemeresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**theme**? | <code>[Theme](#cdk-quicksight-constructs-theme)</code> | The information about the theme that you are describing.<br/>__*Optional*__



## struct DescribeUserRequest  <a id="cdk-quicksight-constructs-describeuserrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that the user is in.
**namespace** | <code>string</code> | The namespace.
**userName** | <code>string</code> | The name of the user that you want to describe.



## struct DescribeUserResponse  <a id="cdk-quicksight-constructs-describeuserresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**user**? | <code>[User](#cdk-quicksight-constructs-user)</code> | The user name.<br/>__*Optional*__



## struct ErrorInfo  <a id="cdk-quicksight-constructs-errorinfo"></a>






Name | Type | Description 
-----|------|-------------
**message**? | <code>string</code> | Error message.<br/>__*Optional*__
**type**? | <code>string</code> | Error type.<br/>__*Optional*__



## struct ExportToCSVOption  <a id="cdk-quicksight-constructs-exporttocsvoption"></a>






Name | Type | Description 
-----|------|-------------
**availabilityStatus**? | <code>string</code> | Availability status.<br/>__*Optional*__



## struct FieldFolder  <a id="cdk-quicksight-constructs-fieldfolder"></a>






Name | Type | Description 
-----|------|-------------
**columns**? | <code>Array<string></code> | A folder has a list of columns.<br/>__*Optional*__
**description**? | <code>string</code> | The description for a field folder.<br/>__*Optional*__



## struct FilterOperation  <a id="cdk-quicksight-constructs-filteroperation"></a>






Name | Type | Description 
-----|------|-------------
**conditionExpression** | <code>string</code> | An expression that must evaluate to a Boolean value.



## struct GeoSpatialColumnGroup  <a id="cdk-quicksight-constructs-geospatialcolumngroup"></a>






Name | Type | Description 
-----|------|-------------
**columns** | <code>Array<string></code> | Columns in this hierarchy.
**countryCode** | <code>string</code> | Country code.
**name** | <code>string</code> | A display name for the hierarchy.



## struct GetDashboardEmbedUrlRequest  <a id="cdk-quicksight-constructs-getdashboardembedurlrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that contains the dashboard that you're embedding.
**dashboardId** | <code>string</code> | The ID for the dashboard, also added to the AWS Identity and Access Management (IAM) policy.
**identityType** | <code>string</code> | The authentication method that the user uses to sign in.
**additionalDashboardIds**? | <code>Array<string></code> | A list of one or more dashboard IDs that you want to add to a session that includes anonymous users.<br/>__*Optional*__
**namespace**? | <code>string</code> | The QuickSight namespace that contains the dashboard IDs in this request.<br/>__*Optional*__
**resetDisabled**? | <code>boolean</code> | Remove the reset button on the embedded dashboard.<br/>__*Optional*__
**sessionLifetimeInMinutes**? | <code>number</code> | How many minutes the session is valid.<br/>__*Optional*__
**statePersistenceEnabled**? | <code>boolean</code> | Adds persistence of state for the user session in an embedded dashboard.<br/>__*Optional*__
**undoRedoDisabled**? | <code>boolean</code> | Remove the undo/redo button on the embedded dashboard.<br/>__*Optional*__
**userArn**? | <code>string</code> | The Amazon QuickSight user's Amazon Resource Name (ARN), for use with QUICKSIGHT identity type.<br/>__*Optional*__



## struct GetDashboardEmbedUrlResponse  <a id="cdk-quicksight-constructs-getdashboardembedurlresponse"></a>






Name | Type | Description 
-----|------|-------------
**embedUrl**? | <code>string</code> | A single-use URL that you can put into your server-side webpage to embed your dashboard.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct GetSessionEmbedUrlRequest  <a id="cdk-quicksight-constructs-getsessionembedurlrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account associated with your QuickSight subscription.
**entryPoint**? | <code>string</code> | The URL you use to access the embedded session.<br/>__*Optional*__
**sessionLifetimeInMinutes**? | <code>number</code> | How many minutes the session is valid.<br/>__*Optional*__
**userArn**? | <code>string</code> | The Amazon QuickSight user's Amazon Resource Name (ARN), for use with QUICKSIGHT identity type.<br/>__*Optional*__



## struct GetSessionEmbedUrlResponse  <a id="cdk-quicksight-constructs-getsessionembedurlresponse"></a>






Name | Type | Description 
-----|------|-------------
**embedUrl**? | <code>string</code> | A single-use URL that you can put into your server-side web page to embed your QuickSight session.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct Group  <a id="cdk-quicksight-constructs-group"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) for the group.<br/>__*Optional*__
**description**? | <code>string</code> | The group description.<br/>__*Optional*__
**groupName**? | <code>string</code> | The name of the group.<br/>__*Optional*__
**principalId**? | <code>string</code> | The principal ID of the group.<br/>__*Optional*__



## struct GroupMember  <a id="cdk-quicksight-constructs-groupmember"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) for the group member (user).<br/>__*Optional*__
**memberName**? | <code>string</code> | The name of the group member (user).<br/>__*Optional*__



## struct GutterStyle  <a id="cdk-quicksight-constructs-gutterstyle"></a>






Name | Type | Description 
-----|------|-------------
**show**? | <code>boolean</code> | This Boolean value controls whether to display a gutter space between sheet tiles.<br/>__*Optional*__



## interface IAMPolicyAssignment  <a id="cdk-quicksight-constructs-iampolicyassignment"></a>




### Properties


Name | Type | Description 
-----|------|-------------
**assignmentId**? | <code>string</code> | Assignment ID.<br/>__*Optional*__
**assignmentName**? | <code>string</code> | Assignment name.<br/>__*Optional*__
**assignmentStatus**? | <code>string</code> | Assignment status.<br/>__*Optional*__
**awsAccountId**? | <code>string</code> | The AWS account ID.<br/>__*Optional*__
**identities**? | <code>Map<string, Array<string>></code> | Identities.<br/>__*Optional*__
**policyArn**? | <code>string</code> | The Amazon Resource Name (ARN) for the IAM policy.<br/>__*Optional*__



## interface IAMPolicyAssignmentSummary  <a id="cdk-quicksight-constructs-iampolicyassignmentsummary"></a>




### Properties


Name | Type | Description 
-----|------|-------------
**assignmentName**? | <code>string</code> | Assignment name.<br/>__*Optional*__
**assignmentStatus**? | <code>string</code> | Assignment status.<br/>__*Optional*__



## struct Ingestion  <a id="cdk-quicksight-constructs-ingestion"></a>






Name | Type | Description 
-----|------|-------------
**arn** | <code>string</code> | The Amazon Resource Name (ARN) of the resource.
**createdTime** | <code>date</code> | The time that this ingestion started.
**ingestionStatus** | <code>string</code> | Ingestion status.
**errorInfo**? | <code>[ErrorInfo](#cdk-quicksight-constructs-errorinfo)</code> | Error information for this ingestion.<br/>__*Optional*__
**ingestionId**? | <code>string</code> | Ingestion ID.<br/>__*Optional*__
**ingestionSizeInBytes**? | <code>number</code> | The size of the data ingested, in bytes.<br/>__*Optional*__
**ingestionTimeInSeconds**? | <code>number</code> | The time that this ingestion took, measured in seconds.<br/>__*Optional*__
**queueInfo**? | <code>[QueueInfo](#cdk-quicksight-constructs-queueinfo)</code> | __*Optional*__
**requestSource**? | <code>string</code> | Event source for this ingestion.<br/>__*Optional*__
**requestType**? | <code>string</code> | Type of this ingestion.<br/>__*Optional*__
**rowInfo**? | <code>[RowInfo](#cdk-quicksight-constructs-rowinfo)</code> | __*Optional*__



## struct InputColumn  <a id="cdk-quicksight-constructs-inputcolumn"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | The name of this column in the underlying data source.
**type** | <code>string</code> | The data type of the column.



## struct IntegerParameter  <a id="cdk-quicksight-constructs-integerparameter"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | The name of the integer parameter.
**values** | <code>Array<number></code> | The values for the integer parameter.



## struct JiraParameters  <a id="cdk-quicksight-constructs-jiraparameters"></a>






Name | Type | Description 
-----|------|-------------
**siteBaseUrl** | <code>string</code> | The base URL of the Jira site.



## struct JoinInstruction  <a id="cdk-quicksight-constructs-joininstruction"></a>






Name | Type | Description 
-----|------|-------------
**leftOperand** | <code>string</code> | The operand on the left side of a join.
**onClause** | <code>string</code> | The join instructions provided in the ON clause of a join.
**rightOperand** | <code>string</code> | The operand on the right side of a join.
**type** | <code>string</code> | The type of join that it is.
**leftJoinKeyProperties**? | <code>[JoinKeyProperties](#cdk-quicksight-constructs-joinkeyproperties)</code> | Join key properties of the left operand.<br/>__*Optional*__
**rightJoinKeyProperties**? | <code>[JoinKeyProperties](#cdk-quicksight-constructs-joinkeyproperties)</code> | Join key properties of the right operand.<br/>__*Optional*__



## struct JoinKeyProperties  <a id="cdk-quicksight-constructs-joinkeyproperties"></a>






Name | Type | Description 
-----|------|-------------
**uniqueKey**? | <code>boolean</code> | A value that indicates that a row in a table is uniquely identified by the columns in a join key.<br/>__*Optional*__



## struct ListAnalysesRequest  <a id="cdk-quicksight-constructs-listanalysesrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the analyses.
**maxResults**? | <code>number</code> | The maximum number of results to return.<br/>__*Optional*__
**nextToken**? | <code>string</code> | A pagination token that can be used in a subsequent request.<br/>__*Optional*__



## struct ListAnalysesResponse  <a id="cdk-quicksight-constructs-listanalysesresponse"></a>






Name | Type | Description 
-----|------|-------------
**analysisSummaryList**? | <code>Array<[AnalysisSummary](#cdk-quicksight-constructs-analysissummary)></code> | Metadata describing each of the analyses that are listed.<br/>__*Optional*__
**nextToken**? | <code>string</code> | A pagination token that can be used in a subsequent request.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct ListDashboardVersionsRequest  <a id="cdk-quicksight-constructs-listdashboardversionsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the dashboard that you're listing versions for.
**dashboardId** | <code>string</code> | The ID for the dashboard.
**maxResults**? | <code>number</code> | The maximum number of results to be returned per request.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__



## struct ListDashboardVersionsResponse  <a id="cdk-quicksight-constructs-listdashboardversionsresponse"></a>






Name | Type | Description 
-----|------|-------------
**dashboardVersionSummaryList**? | <code>Array<[DashboardVersionSummary](#cdk-quicksight-constructs-dashboardversionsummary)></code> | A structure that contains information about each version of the dashboard.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct ListDashboardsRequest  <a id="cdk-quicksight-constructs-listdashboardsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the dashboards that you're listing.
**maxResults**? | <code>number</code> | The maximum number of results to be returned per request.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__



## struct ListDashboardsResponse  <a id="cdk-quicksight-constructs-listdashboardsresponse"></a>






Name | Type | Description 
-----|------|-------------
**dashboardSummaryList**? | <code>Array<[DashboardSummary](#cdk-quicksight-constructs-dashboardsummary)></code> | A structure that contains all of the dashboards in your AWS account.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct ListDataSetsRequest  <a id="cdk-quicksight-constructs-listdatasetsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID.
**maxResults**? | <code>number</code> | The maximum number of results to be returned per request.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__



## struct ListDataSetsResponse  <a id="cdk-quicksight-constructs-listdatasetsresponse"></a>






Name | Type | Description 
-----|------|-------------
**dataSetSummaries**? | <code>Array<[DataSetSummary](#cdk-quicksight-constructs-datasetsummary)></code> | The list of dataset summaries.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct ListDataSourcesRequest  <a id="cdk-quicksight-constructs-listdatasourcesrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID.
**maxResults**? | <code>number</code> | The maximum number of results to be returned per request.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__



## struct ListDataSourcesResponse  <a id="cdk-quicksight-constructs-listdatasourcesresponse"></a>






Name | Type | Description 
-----|------|-------------
**dataSources**? | <code>Array<[DataSource](#cdk-quicksight-constructs-datasource)></code> | A list of data sources.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct ListGroupMembershipsRequest  <a id="cdk-quicksight-constructs-listgroupmembershipsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that the group is in.
**groupName** | <code>string</code> | The name of the group that you want to see a membership list of.
**namespace** | <code>string</code> | The namespace.
**maxResults**? | <code>number</code> | The maximum number of results to return from this request.<br/>__*Optional*__
**nextToken**? | <code>string</code> | A pagination token that can be used in a subsequent request.<br/>__*Optional*__



## struct ListGroupMembershipsResponse  <a id="cdk-quicksight-constructs-listgroupmembershipsresponse"></a>






Name | Type | Description 
-----|------|-------------
**groupMemberList**? | <code>Array<[GroupMember](#cdk-quicksight-constructs-groupmember)></code> | The list of the members of the group.<br/>__*Optional*__
**nextToken**? | <code>string</code> | A pagination token that can be used in a subsequent request.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct ListGroupsRequest  <a id="cdk-quicksight-constructs-listgroupsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that the group is in.
**namespace** | <code>string</code> | The namespace.
**maxResults**? | <code>number</code> | The maximum number of results to return.<br/>__*Optional*__
**nextToken**? | <code>string</code> | A pagination token that can be used in a subsequent request.<br/>__*Optional*__



## struct ListGroupsResponse  <a id="cdk-quicksight-constructs-listgroupsresponse"></a>






Name | Type | Description 
-----|------|-------------
**groupList**? | <code>Array<[Group](#cdk-quicksight-constructs-group)></code> | The list of the groups.<br/>__*Optional*__
**nextToken**? | <code>string</code> | A pagination token that can be used in a subsequent request.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct ListIAMPolicyAssignmentsForUserRequest  <a id="cdk-quicksight-constructs-listiampolicyassignmentsforuserrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the assignments.
**namespace** | <code>string</code> | The namespace of the assignment.
**userName** | <code>string</code> | The name of the user.
**maxResults**? | <code>number</code> | The maximum number of results to be returned per request.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__



## struct ListIAMPolicyAssignmentsForUserResponse  <a id="cdk-quicksight-constructs-listiampolicyassignmentsforuserresponse"></a>






Name | Type | Description 
-----|------|-------------
**activeAssignments**? | <code>Array<[ActiveIAMPolicyAssignment](#cdk-quicksight-constructs-activeiampolicyassignment)></code> | The active assignments for this user.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct ListIAMPolicyAssignmentsRequest  <a id="cdk-quicksight-constructs-listiampolicyassignmentsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains these IAM policy assignments.
**namespace** | <code>string</code> | The namespace for the assignments.
**assignmentStatus**? | <code>string</code> | The status of the assignments.<br/>__*Optional*__
**maxResults**? | <code>number</code> | The maximum number of results to be returned per request.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__



## struct ListIAMPolicyAssignmentsResponse  <a id="cdk-quicksight-constructs-listiampolicyassignmentsresponse"></a>






Name | Type | Description 
-----|------|-------------
**iAMPolicyAssignments**? | <code>Array<[IAMPolicyAssignmentSummary](#cdk-quicksight-constructs-iampolicyassignmentsummary)></code> | Information describing the IAM policy assignments.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct ListIngestionsRequest  <a id="cdk-quicksight-constructs-listingestionsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID.
**dataSetId** | <code>string</code> | The ID of the dataset used in the ingestion.
**maxResults**? | <code>number</code> | The maximum number of results to be returned per request.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__



## struct ListIngestionsResponse  <a id="cdk-quicksight-constructs-listingestionsresponse"></a>






Name | Type | Description 
-----|------|-------------
**ingestions**? | <code>Array<[Ingestion](#cdk-quicksight-constructs-ingestion)></code> | A list of the ingestions.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct ListNamespacesRequest  <a id="cdk-quicksight-constructs-listnamespacesrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that contains the QuickSight namespaces that you want to list.
**maxResults**? | <code>number</code> | The maximum number of results to return.<br/>__*Optional*__
**nextToken**? | <code>string</code> | A pagination token that can be used in a subsequent request.<br/>__*Optional*__



## struct ListNamespacesResponse  <a id="cdk-quicksight-constructs-listnamespacesresponse"></a>






Name | Type | Description 
-----|------|-------------
**namespaces**? | <code>Array<[NamespaceInfoV2](#cdk-quicksight-constructs-namespaceinfov2)></code> | The information about the namespaces in this AWS account.<br/>__*Optional*__
**nextToken**? | <code>string</code> | A pagination token that can be used in a subsequent request.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct ListTagsForResourceRequest  <a id="cdk-quicksight-constructs-listtagsforresourcerequest"></a>






Name | Type | Description 
-----|------|-------------
**resourceArn** | <code>string</code> | The Amazon Resource Name (ARN) of the resource that you want a list of tags for.



## struct ListTagsForResourceResponse  <a id="cdk-quicksight-constructs-listtagsforresourceresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**tags**? | <code>Array<[Tag](#cdk-quicksight-constructs-tag)></code> | Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.<br/>__*Optional*__



## struct ListTemplateAliasesRequest  <a id="cdk-quicksight-constructs-listtemplatealiasesrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the template aliases that you're listing.
**templateId** | <code>string</code> | The ID for the template.
**maxResults**? | <code>number</code> | The maximum number of results to be returned per request.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__



## struct ListTemplateAliasesResponse  <a id="cdk-quicksight-constructs-listtemplatealiasesresponse"></a>






Name | Type | Description 
-----|------|-------------
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**templateAliasList**? | <code>Array<[TemplateAlias](#cdk-quicksight-constructs-templatealias)></code> | A structure containing the list of the template's aliases.<br/>__*Optional*__



## struct ListTemplateVersionsRequest  <a id="cdk-quicksight-constructs-listtemplateversionsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the templates that you're listing.
**templateId** | <code>string</code> | The ID for the template.
**maxResults**? | <code>number</code> | The maximum number of results to be returned per request.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__



## struct ListTemplateVersionsResponse  <a id="cdk-quicksight-constructs-listtemplateversionsresponse"></a>






Name | Type | Description 
-----|------|-------------
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**templateVersionSummaryList**? | <code>Array<[TemplateVersionSummary](#cdk-quicksight-constructs-templateversionsummary)></code> | A structure containing a list of all the versions of the specified template.<br/>__*Optional*__



## struct ListTemplatesRequest  <a id="cdk-quicksight-constructs-listtemplatesrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the templates that you're listing.
**maxResults**? | <code>number</code> | The maximum number of results to be returned per request.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__



## struct ListTemplatesResponse  <a id="cdk-quicksight-constructs-listtemplatesresponse"></a>






Name | Type | Description 
-----|------|-------------
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**templateSummaryList**? | <code>Array<[TemplateSummary](#cdk-quicksight-constructs-templatesummary)></code> | A structure containing information about the templates in the list.<br/>__*Optional*__



## struct ListThemeAliasesRequest  <a id="cdk-quicksight-constructs-listthemealiasesrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the theme aliases that you're listing.
**themeId** | <code>string</code> | The ID for the theme.
**maxResults**? | <code>number</code> | The maximum number of results to be returned per request.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__



## struct ListThemeAliasesResponse  <a id="cdk-quicksight-constructs-listthemealiasesresponse"></a>






Name | Type | Description 
-----|------|-------------
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**themeAliasList**? | <code>Array<[ThemeAlias](#cdk-quicksight-constructs-themealias)></code> | A structure containing the list of the theme's aliases.<br/>__*Optional*__



## struct ListThemeVersionsRequest  <a id="cdk-quicksight-constructs-listthemeversionsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the themes that you're listing.
**themeId** | <code>string</code> | The ID for the theme.
**maxResults**? | <code>number</code> | The maximum number of results to be returned per request.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__



## struct ListThemeVersionsResponse  <a id="cdk-quicksight-constructs-listthemeversionsresponse"></a>






Name | Type | Description 
-----|------|-------------
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**themeVersionSummaryList**? | <code>Array<[ThemeVersionSummary](#cdk-quicksight-constructs-themeversionsummary)></code> | A structure containing a list of all the versions of the specified theme.<br/>__*Optional*__



## struct ListThemesRequest  <a id="cdk-quicksight-constructs-listthemesrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the themes that you're listing.
**maxResults**? | <code>number</code> | The maximum number of results to be returned per request.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__
**type**? | <code>string</code> | The type of themes that you want to list.<br/>__*Optional*__



## struct ListThemesResponse  <a id="cdk-quicksight-constructs-listthemesresponse"></a>






Name | Type | Description 
-----|------|-------------
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**themeSummaryList**? | <code>Array<[ThemeSummary](#cdk-quicksight-constructs-themesummary)></code> | Information about the themes in the list.<br/>__*Optional*__



## struct ListUserGroupsRequest  <a id="cdk-quicksight-constructs-listusergroupsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID that the user is in.
**namespace** | <code>string</code> | The namespace.
**userName** | <code>string</code> | The Amazon QuickSight user name that you want to list group memberships for.
**maxResults**? | <code>number</code> | The maximum number of results to return from this request.<br/>__*Optional*__
**nextToken**? | <code>string</code> | A pagination token that can be used in a subsequent request.<br/>__*Optional*__



## struct ListUserGroupsResponse  <a id="cdk-quicksight-constructs-listusergroupsresponse"></a>






Name | Type | Description 
-----|------|-------------
**groupList**? | <code>Array<[Group](#cdk-quicksight-constructs-group)></code> | The list of groups the user is a member of.<br/>__*Optional*__
**nextToken**? | <code>string</code> | A pagination token that can be used in a subsequent request.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct ListUsersRequest  <a id="cdk-quicksight-constructs-listusersrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that the user is in.
**namespace** | <code>string</code> | The namespace.
**maxResults**? | <code>number</code> | The maximum number of results to return from this request.<br/>__*Optional*__
**nextToken**? | <code>string</code> | A pagination token that can be used in a subsequent request.<br/>__*Optional*__



## struct ListUsersResponse  <a id="cdk-quicksight-constructs-listusersresponse"></a>






Name | Type | Description 
-----|------|-------------
**nextToken**? | <code>string</code> | A pagination token that can be used in a subsequent request.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**userList**? | <code>Array<[User](#cdk-quicksight-constructs-user)></code> | The list of users.<br/>__*Optional*__



## struct LogicalTable  <a id="cdk-quicksight-constructs-logicaltable"></a>






Name | Type | Description 
-----|------|-------------
**alias** | <code>string</code> | A display name for the logical table.
**source** | <code>[LogicalTableSource](#cdk-quicksight-constructs-logicaltablesource)</code> | Source of this logical table.
**dataTransforms**? | <code>Array<[TransformOperation](#cdk-quicksight-constructs-transformoperation)></code> | Transform operations that act on this logical table.<br/>__*Optional*__



## struct LogicalTableSource  <a id="cdk-quicksight-constructs-logicaltablesource"></a>






Name | Type | Description 
-----|------|-------------
**joinInstruction**? | <code>[JoinInstruction](#cdk-quicksight-constructs-joininstruction)</code> | Specifies the result of a join of two logical tables.<br/>__*Optional*__
**physicalTableId**? | <code>string</code> | Physical table ID.<br/>__*Optional*__



## struct ManifestFileLocation  <a id="cdk-quicksight-constructs-manifestfilelocation"></a>






Name | Type | Description 
-----|------|-------------
**bucket** | <code>string</code> | Amazon S3 bucket.
**key** | <code>string</code> | Amazon S3 key that identifies an object.



## struct MarginStyle  <a id="cdk-quicksight-constructs-marginstyle"></a>






Name | Type | Description 
-----|------|-------------
**show**? | <code>boolean</code> | This Boolean value controls whether to display sheet margins.<br/>__*Optional*__



## struct MariaDbParameters  <a id="cdk-quicksight-constructs-mariadbparameters"></a>






Name | Type | Description 
-----|------|-------------
**database** | <code>string</code> | Database.
**host** | <code>string</code> | Host.
**port** | <code>number</code> | Port.



## struct MySqlParameters  <a id="cdk-quicksight-constructs-mysqlparameters"></a>






Name | Type | Description 
-----|------|-------------
**database** | <code>string</code> | Database.
**host** | <code>string</code> | Host.
**port** | <code>number</code> | Port.



## struct NamespaceError  <a id="cdk-quicksight-constructs-namespaceerror"></a>






Name | Type | Description 
-----|------|-------------
**message**? | <code>string</code> | The message for the error.<br/>__*Optional*__
**type**? | <code>string</code> | The error type.<br/>__*Optional*__



## struct NamespaceInfoV2  <a id="cdk-quicksight-constructs-namespaceinfov2"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The namespace ARN.<br/>__*Optional*__
**capacityRegion**? | <code>string</code> | The namespace AWS Region.<br/>__*Optional*__
**creationStatus**? | <code>string</code> | The creation status of a namespace that is not yet completely created.<br/>__*Optional*__
**identityStore**? | <code>string</code> | The identity store used for the namespace.<br/>__*Optional*__
**name**? | <code>string</code> | The name of the error.<br/>__*Optional*__
**namespaceError**? | <code>[NamespaceError](#cdk-quicksight-constructs-namespaceerror)</code> | An error that occurred when the namespace was created.<br/>__*Optional*__



## struct OracleParameters  <a id="cdk-quicksight-constructs-oracleparameters"></a>






Name | Type | Description 
-----|------|-------------
**database** | <code>string</code> | Database.
**host** | <code>string</code> | An Oracle host.
**port** | <code>number</code> | Port.



## struct OutputColumn  <a id="cdk-quicksight-constructs-outputcolumn"></a>






Name | Type | Description 
-----|------|-------------
**description**? | <code>string</code> | A description for a column.<br/>__*Optional*__
**name**? | <code>string</code> | A display name for the dataset.<br/>__*Optional*__
**type**? | <code>string</code> | Type.<br/>__*Optional*__



## struct Parameters  <a id="cdk-quicksight-constructs-parameters"></a>






Name | Type | Description 
-----|------|-------------
**dateTimeParameters**? | <code>Array<[DateTimeParameter](#cdk-quicksight-constructs-datetimeparameter)></code> | Date-time parameters.<br/>__*Optional*__
**decimalParameters**? | <code>Array<[DecimalParameter](#cdk-quicksight-constructs-decimalparameter)></code> | Decimal parameters.<br/>__*Optional*__
**integerParameters**? | <code>Array<[IntegerParameter](#cdk-quicksight-constructs-integerparameter)></code> | Integer parameters.<br/>__*Optional*__
**stringParameters**? | <code>Array<[StringParameter](#cdk-quicksight-constructs-stringparameter)></code> | String parameters.<br/>__*Optional*__



## struct PhysicalTable  <a id="cdk-quicksight-constructs-physicaltable"></a>






Name | Type | Description 
-----|------|-------------
**customSql**? | <code>[CustomSql](#cdk-quicksight-constructs-customsql)</code> | A physical table type built from the results of the custom SQL query.<br/>__*Optional*__
**relationalTable**? | <code>[RelationalTable](#cdk-quicksight-constructs-relationaltable)</code> | A physical table type for relational data sources.<br/>__*Optional*__
**s3Source**? | <code>[S3Source](#cdk-quicksight-constructs-s3source)</code> | A physical table type for as S3 data source.<br/>__*Optional*__



## struct PostgreSqlParameters  <a id="cdk-quicksight-constructs-postgresqlparameters"></a>






Name | Type | Description 
-----|------|-------------
**database** | <code>string</code> | Database.
**host** | <code>string</code> | Host.
**port** | <code>number</code> | Port.



## struct PrestoParameters  <a id="cdk-quicksight-constructs-prestoparameters"></a>






Name | Type | Description 
-----|------|-------------
**catalog** | <code>string</code> | Catalog.
**host** | <code>string</code> | Host.
**port** | <code>number</code> | Port.



## struct ProjectOperation  <a id="cdk-quicksight-constructs-projectoperation"></a>






Name | Type | Description 
-----|------|-------------
**projectedColumns** | <code>Array<string></code> | Projected columns.



## struct QSCommonProps  <a id="cdk-quicksight-constructs-qscommonprops"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | <span></span>
**users** | <code>Array<string></code> | QuickSight Users you want to give access to. In the end the permission arn are looking like arn:aws:quicksight:us-east-1:1234:user/default/martin.mueller@take2.co.



## struct QueueInfo  <a id="cdk-quicksight-constructs-queueinfo"></a>






Name | Type | Description 
-----|------|-------------
**queuedIngestion** | <code>string</code> | The ID of the ongoing ingestion.
**waitingOnIngestion** | <code>string</code> | The ID of the queued ingestion.



## struct RdsParameters  <a id="cdk-quicksight-constructs-rdsparameters"></a>






Name | Type | Description 
-----|------|-------------
**database** | <code>string</code> | Database.
**instanceId** | <code>string</code> | Instance ID.



## struct RedshiftParameters  <a id="cdk-quicksight-constructs-redshiftparameters"></a>






Name | Type | Description 
-----|------|-------------
**database** | <code>string</code> | Database.
**clusterId**? | <code>string</code> | Cluster ID.<br/>__*Optional*__
**host**? | <code>string</code> | Host.<br/>__*Optional*__
**port**? | <code>number</code> | Port.<br/>__*Optional*__



## struct RegisterUserRequest  <a id="cdk-quicksight-constructs-registeruserrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that the user is in.
**email** | <code>string</code> | The email address of the user that you want to register.
**identityType** | <code>string</code> | Amazon QuickSight supports several ways of managing the identity of users.
**namespace** | <code>string</code> | The namespace.
**userRole** | <code>string</code> | The Amazon QuickSight role for the user.
**customPermissionsName**? | <code>string</code> | (Enterprise edition only) The name of the custom permissions profile that you want to assign to this user.<br/>__*Optional*__
**iamArn**? | <code>string</code> | The ARN of the IAM user or role that you are registering with Amazon QuickSight.<br/>__*Optional*__
**sessionName**? | <code>string</code> | You need to use this parameter only when you register one or more users using an assumed IAM role.<br/>__*Optional*__
**userName**? | <code>string</code> | The Amazon QuickSight user name that you want to create for the user you are registering.<br/>__*Optional*__



## struct RegisterUserResponse  <a id="cdk-quicksight-constructs-registeruserresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**user**? | <code>[User](#cdk-quicksight-constructs-user)</code> | The user's user name.<br/>__*Optional*__
**userInvitationUrl**? | <code>string</code> | The URL the user visits to complete registration and provide a password.<br/>__*Optional*__



## struct RelationalTable  <a id="cdk-quicksight-constructs-relationaltable"></a>






Name | Type | Description 
-----|------|-------------
**dataSourceArn** | <code>string</code> | The Amazon Resource Name (ARN) for the data source.
**inputColumns** | <code>Array<[InputColumn](#cdk-quicksight-constructs-inputcolumn)></code> | The column schema of the table.
**name** | <code>string</code> | The name of the relational table.
**catalog**? | <code>string</code> | The catalog associated with a table.<br/>__*Optional*__
**schema**? | <code>string</code> | The schema name.<br/>__*Optional*__



## struct RenameColumnOperation  <a id="cdk-quicksight-constructs-renamecolumnoperation"></a>






Name | Type | Description 
-----|------|-------------
**columnName** | <code>string</code> | The name of the column to be renamed.
**newColumnName** | <code>string</code> | The new name for the column.



## struct ResourcePermission  <a id="cdk-quicksight-constructs-resourcepermission"></a>






Name | Type | Description 
-----|------|-------------
**actions** | <code>Array<string></code> | The IAM action to grant or revoke permissions on.
**principal** | <code>string</code> | The Amazon Resource Name (ARN) of the principal.



## struct RestoreAnalysisRequest  <a id="cdk-quicksight-constructs-restoreanalysisrequest"></a>






Name | Type | Description 
-----|------|-------------
**analysisId** | <code>string</code> | The ID of the analysis that you're restoring.
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the analysis.



## struct RestoreAnalysisResponse  <a id="cdk-quicksight-constructs-restoreanalysisresponse"></a>






Name | Type | Description 
-----|------|-------------
**analysisId**? | <code>string</code> | The ID of the analysis that you're restoring.<br/>__*Optional*__
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the analysis that you're restoring.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct RowInfo  <a id="cdk-quicksight-constructs-rowinfo"></a>






Name | Type | Description 
-----|------|-------------
**rowsDropped**? | <code>number</code> | The number of rows that were not ingested.<br/>__*Optional*__
**rowsIngested**? | <code>number</code> | The number of rows that were ingested.<br/>__*Optional*__



## struct RowLevelPermissionDataSet  <a id="cdk-quicksight-constructs-rowlevelpermissiondataset"></a>






Name | Type | Description 
-----|------|-------------
**arn** | <code>string</code> | The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.
**permissionPolicy** | <code>string</code> | The type of permissions to use when interpretting the permissions for RLS.
**namespace**? | <code>string</code> | The namespace associated with the dataset that contains permissions for RLS.<br/>__*Optional*__



## struct S3Parameters  <a id="cdk-quicksight-constructs-s3parameters"></a>






Name | Type | Description 
-----|------|-------------
**manifestFileLocation** | <code>[ManifestFileLocation](#cdk-quicksight-constructs-manifestfilelocation)</code> | Location of the Amazon S3 manifest file.



## struct S3Source  <a id="cdk-quicksight-constructs-s3source"></a>






Name | Type | Description 
-----|------|-------------
**dataSourceArn** | <code>string</code> | The Amazon Resource Name (ARN) for the data source.
**inputColumns** | <code>Array<[InputColumn](#cdk-quicksight-constructs-inputcolumn)></code> | A physical table type for as S3 data source.
**uploadSettings**? | <code>[UploadSettings](#cdk-quicksight-constructs-uploadsettings)</code> | Information about the format for the S3 source file or files.<br/>__*Optional*__



## struct SearchAnalysesRequest  <a id="cdk-quicksight-constructs-searchanalysesrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the analyses that you're searching for.
**filters** | <code>Array<[AnalysisSearchFilter](#cdk-quicksight-constructs-analysissearchfilter)></code> | The structure for the search filters that you want to apply to your search.
**maxResults**? | <code>number</code> | The maximum number of results to return.<br/>__*Optional*__
**nextToken**? | <code>string</code> | A pagination token that can be used in a subsequent request.<br/>__*Optional*__



## struct SearchAnalysesResponse  <a id="cdk-quicksight-constructs-searchanalysesresponse"></a>






Name | Type | Description 
-----|------|-------------
**analysisSummaryList**? | <code>Array<[AnalysisSummary](#cdk-quicksight-constructs-analysissummary)></code> | Metadata describing the analyses that you searched for.<br/>__*Optional*__
**nextToken**? | <code>string</code> | A pagination token that can be used in a subsequent request.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct SearchDashboardsRequest  <a id="cdk-quicksight-constructs-searchdashboardsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the user whose dashboards you're searching for.
**filters** | <code>Array<[DashboardSearchFilter](#cdk-quicksight-constructs-dashboardsearchfilter)></code> | The filters to apply to the search.
**maxResults**? | <code>number</code> | The maximum number of results to be returned per request.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__



## struct SearchDashboardsResponse  <a id="cdk-quicksight-constructs-searchdashboardsresponse"></a>






Name | Type | Description 
-----|------|-------------
**dashboardSummaryList**? | <code>Array<[DashboardSummary](#cdk-quicksight-constructs-dashboardsummary)></code> | The list of dashboards owned by the user specified in Filters in your request.<br/>__*Optional*__
**nextToken**? | <code>string</code> | The token for the next set of results, or null if there are no more results.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct ServiceNowParameters  <a id="cdk-quicksight-constructs-servicenowparameters"></a>






Name | Type | Description 
-----|------|-------------
**siteBaseUrl** | <code>string</code> | URL of the base site.



## struct Sheet  <a id="cdk-quicksight-constructs-sheet"></a>






Name | Type | Description 
-----|------|-------------
**name**? | <code>string</code> | The name of a sheet.<br/>__*Optional*__
**sheetId**? | <code>string</code> | The unique identifier associated with a sheet.<br/>__*Optional*__



## struct SheetControlsOption  <a id="cdk-quicksight-constructs-sheetcontrolsoption"></a>






Name | Type | Description 
-----|------|-------------
**visibilityState**? | <code>string</code> | Visibility state.<br/>__*Optional*__



## struct SheetStyle  <a id="cdk-quicksight-constructs-sheetstyle"></a>






Name | Type | Description 
-----|------|-------------
**tile**? | <code>[TileStyle](#cdk-quicksight-constructs-tilestyle)</code> | The display options for tiles.<br/>__*Optional*__
**tileLayout**? | <code>[TileLayoutStyle](#cdk-quicksight-constructs-tilelayoutstyle)</code> | The layout options for tiles.<br/>__*Optional*__



## struct SnowflakeParameters  <a id="cdk-quicksight-constructs-snowflakeparameters"></a>






Name | Type | Description 
-----|------|-------------
**database** | <code>string</code> | Database.
**host** | <code>string</code> | Host.
**warehouse** | <code>string</code> | Warehouse.



## struct SparkParameters  <a id="cdk-quicksight-constructs-sparkparameters"></a>






Name | Type | Description 
-----|------|-------------
**host** | <code>string</code> | Host.
**port** | <code>number</code> | Port.



## struct SqlServerParameters  <a id="cdk-quicksight-constructs-sqlserverparameters"></a>






Name | Type | Description 
-----|------|-------------
**database** | <code>string</code> | Database.
**host** | <code>string</code> | Host.
**port** | <code>number</code> | Port.



## struct SslProperties  <a id="cdk-quicksight-constructs-sslproperties"></a>






Name | Type | Description 
-----|------|-------------
**disableSsl**? | <code>boolean</code> | A Boolean option to control whether SSL should be disabled.<br/>__*Optional*__



## struct StringParameter  <a id="cdk-quicksight-constructs-stringparameter"></a>






Name | Type | Description 
-----|------|-------------
**name** | <code>string</code> | A display name for a string parameter.
**values** | <code>Array<string></code> | The values of a string parameter.



## struct Tag  <a id="cdk-quicksight-constructs-tag"></a>






Name | Type | Description 
-----|------|-------------
**key** | <code>string</code> | Tag key.
**value** | <code>string</code> | Tag value.



## struct TagColumnOperation  <a id="cdk-quicksight-constructs-tagcolumnoperation"></a>






Name | Type | Description 
-----|------|-------------
**columnName** | <code>string</code> | The column that this operation acts on.
**tags** | <code>Array<[ColumnTag](#cdk-quicksight-constructs-columntag)></code> | The dataset column tag, currently only used for geospatial type tagging.



## struct TagResourceRequest  <a id="cdk-quicksight-constructs-tagresourcerequest"></a>






Name | Type | Description 
-----|------|-------------
**resourceArn** | <code>string</code> | The Amazon Resource Name (ARN) of the resource that you want to tag.
**tags** | <code>Array<[Tag](#cdk-quicksight-constructs-tag)></code> | Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.



## struct TagResourceResponse  <a id="cdk-quicksight-constructs-tagresourceresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct Template  <a id="cdk-quicksight-constructs-template"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the template.<br/>__*Optional*__
**createdTime**? | <code>date</code> | Time when this was created.<br/>__*Optional*__
**lastUpdatedTime**? | <code>date</code> | Time when this was last updated.<br/>__*Optional*__
**name**? | <code>string</code> | The display name of the template.<br/>__*Optional*__
**templateId**? | <code>string</code> | The ID for the template.<br/>__*Optional*__
**version**? | <code>[TemplateVersion](#cdk-quicksight-constructs-templateversion)</code> | A structure describing the versions of the template.<br/>__*Optional*__



## struct TemplateAlias  <a id="cdk-quicksight-constructs-templatealias"></a>






Name | Type | Description 
-----|------|-------------
**aliasName**? | <code>string</code> | The display name of the template alias.<br/>__*Optional*__
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the template alias.<br/>__*Optional*__
**templateVersionNumber**? | <code>number</code> | The version number of the template alias.<br/>__*Optional*__



## struct TemplateError  <a id="cdk-quicksight-constructs-templateerror"></a>






Name | Type | Description 
-----|------|-------------
**message**? | <code>string</code> | Description of the error type.<br/>__*Optional*__
**type**? | <code>string</code> | Type of error.<br/>__*Optional*__



## struct TemplateSourceAnalysis  <a id="cdk-quicksight-constructs-templatesourceanalysis"></a>






Name | Type | Description 
-----|------|-------------
**arn** | <code>string</code> | The Amazon Resource Name (ARN) of the resource.
**dataSetReferences** | <code>Array<[DataSetReference](#cdk-quicksight-constructs-datasetreference)></code> | A structure containing information about the dataset references used as placeholders in the template.



## struct TemplateSourceEntity  <a id="cdk-quicksight-constructs-templatesourceentity"></a>






Name | Type | Description 
-----|------|-------------
**sourceAnalysis**? | <code>[TemplateSourceAnalysis](#cdk-quicksight-constructs-templatesourceanalysis)</code> | The source analysis, if it is based on an analysis.<br/>__*Optional*__
**sourceTemplate**? | <code>[TemplateSourceTemplate](#cdk-quicksight-constructs-templatesourcetemplate)</code> | The source template, if it is based on an template.<br/>__*Optional*__



## struct TemplateSourceTemplate  <a id="cdk-quicksight-constructs-templatesourcetemplate"></a>






Name | Type | Description 
-----|------|-------------
**arn** | <code>string</code> | The Amazon Resource Name (ARN) of the resource.



## struct TemplateSummary  <a id="cdk-quicksight-constructs-templatesummary"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | A summary of a template.<br/>__*Optional*__
**createdTime**? | <code>date</code> | The last time that this template was created.<br/>__*Optional*__
**lastUpdatedTime**? | <code>date</code> | The last time that this template was updated.<br/>__*Optional*__
**latestVersionNumber**? | <code>number</code> | A structure containing a list of version numbers for the template summary.<br/>__*Optional*__
**name**? | <code>string</code> | A display name for the template.<br/>__*Optional*__
**templateId**? | <code>string</code> | The ID of the template.<br/>__*Optional*__



## struct TemplateVersion  <a id="cdk-quicksight-constructs-templateversion"></a>






Name | Type | Description 
-----|------|-------------
**createdTime**? | <code>date</code> | The time that this template version was created.<br/>__*Optional*__
**dataSetConfigurations**? | <code>Array<[DataSetConfiguration](#cdk-quicksight-constructs-datasetconfiguration)></code> | Schema of the dataset identified by the placeholder.<br/>__*Optional*__
**description**? | <code>string</code> | The description of the template.<br/>__*Optional*__
**errors**? | <code>Array<[TemplateError](#cdk-quicksight-constructs-templateerror)></code> | Errors associated with this template version.<br/>__*Optional*__
**sheets**? | <code>Array<[Sheet](#cdk-quicksight-constructs-sheet)></code> | A list of the associated sheets with the unique identifier and name of each sheet.<br/>__*Optional*__
**sourceEntityArn**? | <code>string</code> | The Amazon Resource Name (ARN) of an analysis or template that was used to create this template.<br/>__*Optional*__
**status**? | <code>string</code> | The HTTP status of the request.<br/>__*Optional*__
**themeArn**? | <code>string</code> | The ARN of the theme associated with this version of the template.<br/>__*Optional*__
**versionNumber**? | <code>number</code> | The version number of the template version.<br/>__*Optional*__



## struct TemplateVersionSummary  <a id="cdk-quicksight-constructs-templateversionsummary"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the template version.<br/>__*Optional*__
**createdTime**? | <code>date</code> | The time that this template version was created.<br/>__*Optional*__
**description**? | <code>string</code> | The description of the template version.<br/>__*Optional*__
**status**? | <code>string</code> | The status of the template version.<br/>__*Optional*__
**versionNumber**? | <code>number</code> | The version number of the template version.<br/>__*Optional*__



## struct TeradataParameters  <a id="cdk-quicksight-constructs-teradataparameters"></a>






Name | Type | Description 
-----|------|-------------
**database** | <code>string</code> | Database.
**host** | <code>string</code> | Host.
**port** | <code>number</code> | Port.



## struct Theme  <a id="cdk-quicksight-constructs-theme"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the theme.<br/>__*Optional*__
**createdTime**? | <code>date</code> | The date and time that the theme was created.<br/>__*Optional*__
**lastUpdatedTime**? | <code>date</code> | The date and time that the theme was last updated.<br/>__*Optional*__
**name**? | <code>string</code> | The name that the user gives to the theme.<br/>__*Optional*__
**themeId**? | <code>string</code> | The identifier that the user gives to the theme.<br/>__*Optional*__
**type**? | <code>string</code> | The type of theme, based on how it was created.<br/>__*Optional*__
**version**? | <code>[ThemeVersion](#cdk-quicksight-constructs-themeversion)</code> | __*Optional*__



## struct ThemeAlias  <a id="cdk-quicksight-constructs-themealias"></a>






Name | Type | Description 
-----|------|-------------
**aliasName**? | <code>string</code> | The display name of the theme alias.<br/>__*Optional*__
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the theme alias.<br/>__*Optional*__
**themeVersionNumber**? | <code>number</code> | The version number of the theme alias.<br/>__*Optional*__



## struct ThemeConfiguration  <a id="cdk-quicksight-constructs-themeconfiguration"></a>






Name | Type | Description 
-----|------|-------------
**dataColorPalette**? | <code>[DataColorPalette](#cdk-quicksight-constructs-datacolorpalette)</code> | Color properties that apply to chart data colors.<br/>__*Optional*__
**sheet**? | <code>[SheetStyle](#cdk-quicksight-constructs-sheetstyle)</code> | Display options related to sheets.<br/>__*Optional*__
**uIColorPalette**? | <code>[UIColorPalette](#cdk-quicksight-constructs-uicolorpalette)</code> | Color properties that apply to the UI and to charts, excluding the colors that apply to data.<br/>__*Optional*__



## struct ThemeError  <a id="cdk-quicksight-constructs-themeerror"></a>






Name | Type | Description 
-----|------|-------------
**message**? | <code>string</code> | The error message.<br/>__*Optional*__
**type**? | <code>string</code> | The type of error.<br/>__*Optional*__



## struct ThemeSummary  <a id="cdk-quicksight-constructs-themesummary"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the resource.<br/>__*Optional*__
**createdTime**? | <code>date</code> | The date and time that this theme was created.<br/>__*Optional*__
**lastUpdatedTime**? | <code>date</code> | The last date and time that this theme was updated.<br/>__*Optional*__
**latestVersionNumber**? | <code>number</code> | The latest version number for the theme.<br/>__*Optional*__
**name**? | <code>string</code> | the display name for the theme.<br/>__*Optional*__
**themeId**? | <code>string</code> | The ID of the theme.<br/>__*Optional*__



## struct ThemeVersion  <a id="cdk-quicksight-constructs-themeversion"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the resource.<br/>__*Optional*__
**baseThemeId**? | <code>string</code> | The Amazon QuickSight-defined ID of the theme that a custom theme inherits from.<br/>__*Optional*__
**configuration**? | <code>[ThemeConfiguration](#cdk-quicksight-constructs-themeconfiguration)</code> | The theme configuration, which contains all the theme display properties.<br/>__*Optional*__
**createdTime**? | <code>date</code> | The date and time that this theme version was created.<br/>__*Optional*__
**description**? | <code>string</code> | The description of the theme.<br/>__*Optional*__
**errors**? | <code>Array<[ThemeError](#cdk-quicksight-constructs-themeerror)></code> | Errors associated with the theme.<br/>__*Optional*__
**status**? | <code>string</code> | The status of the theme version.<br/>__*Optional*__
**versionNumber**? | <code>number</code> | The version number of the theme.<br/>__*Optional*__



## struct ThemeVersionSummary  <a id="cdk-quicksight-constructs-themeversionsummary"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the theme version.<br/>__*Optional*__
**createdTime**? | <code>date</code> | The date and time that this theme version was created.<br/>__*Optional*__
**description**? | <code>string</code> | The description of the theme version.<br/>__*Optional*__
**status**? | <code>string</code> | The status of the theme version.<br/>__*Optional*__
**versionNumber**? | <code>number</code> | The version number of the theme version.<br/>__*Optional*__



## struct TileLayoutStyle  <a id="cdk-quicksight-constructs-tilelayoutstyle"></a>






Name | Type | Description 
-----|------|-------------
**gutter**? | <code>[GutterStyle](#cdk-quicksight-constructs-gutterstyle)</code> | The gutter settings that apply between tiles.<br/>__*Optional*__
**margin**? | <code>[MarginStyle](#cdk-quicksight-constructs-marginstyle)</code> | The margin settings that apply around the outside edge of sheets.<br/>__*Optional*__



## struct TileStyle  <a id="cdk-quicksight-constructs-tilestyle"></a>






Name | Type | Description 
-----|------|-------------
**border**? | <code>[BorderStyle](#cdk-quicksight-constructs-borderstyle)</code> | The border around a tile.<br/>__*Optional*__



## struct TransformOperation  <a id="cdk-quicksight-constructs-transformoperation"></a>






Name | Type | Description 
-----|------|-------------
**castColumnTypeOperation**? | <code>[CastColumnTypeOperation](#cdk-quicksight-constructs-castcolumntypeoperation)</code> | A transform operation that casts a column to a different type.<br/>__*Optional*__
**createColumnsOperation**? | <code>[CreateColumnsOperation](#cdk-quicksight-constructs-createcolumnsoperation)</code> | An operation that creates calculated columns.<br/>__*Optional*__
**filterOperation**? | <code>[FilterOperation](#cdk-quicksight-constructs-filteroperation)</code> | An operation that filters rows based on some condition.<br/>__*Optional*__
**projectOperation**? | <code>[ProjectOperation](#cdk-quicksight-constructs-projectoperation)</code> | An operation that projects columns.<br/>__*Optional*__
**renameColumnOperation**? | <code>[RenameColumnOperation](#cdk-quicksight-constructs-renamecolumnoperation)</code> | An operation that renames a column.<br/>__*Optional*__
**tagColumnOperation**? | <code>[TagColumnOperation](#cdk-quicksight-constructs-tagcolumnoperation)</code> | An operation that tags a column with additional information.<br/>__*Optional*__



## struct TwitterParameters  <a id="cdk-quicksight-constructs-twitterparameters"></a>






Name | Type | Description 
-----|------|-------------
**maxRows** | <code>number</code> | Maximum number of rows to query Twitter.
**query** | <code>string</code> | Twitter query string.



## struct UIColorPalette  <a id="cdk-quicksight-constructs-uicolorpalette"></a>






Name | Type | Description 
-----|------|-------------
**accent**? | <code>string</code> | This color is that applies to selected states and buttons.<br/>__*Optional*__
**accentForeground**? | <code>string</code> | The foreground color that applies to any text or other elements that appear over the accent color.<br/>__*Optional*__
**danger**? | <code>string</code> | The color that applies to error messages.<br/>__*Optional*__
**dangerForeground**? | <code>string</code> | The foreground color that applies to any text or other elements that appear over the error color.<br/>__*Optional*__
**dimension**? | <code>string</code> | The color that applies to the names of fields that are identified as dimensions.<br/>__*Optional*__
**dimensionForeground**? | <code>string</code> | The foreground color that applies to any text or other elements that appear over the dimension color.<br/>__*Optional*__
**measure**? | <code>string</code> | The color that applies to the names of fields that are identified as measures.<br/>__*Optional*__
**measureForeground**? | <code>string</code> | The foreground color that applies to any text or other elements that appear over the measure color.<br/>__*Optional*__
**primaryBackground**? | <code>string</code> | The background color that applies to visuals and other high emphasis UI.<br/>__*Optional*__
**primaryForeground**? | <code>string</code> | The color of text and other foreground elements that appear over the primary background regions, such as grid lines, borders, table banding, icons, and so on.<br/>__*Optional*__
**secondaryBackground**? | <code>string</code> | The background color that applies to the sheet background and sheet controls.<br/>__*Optional*__
**secondaryForeground**? | <code>string</code> | The foreground color that applies to any sheet title, sheet control text, or UI that appears over the secondary background.<br/>__*Optional*__
**success**? | <code>string</code> | The color that applies to success messages, for example the check mark for a successful download.<br/>__*Optional*__
**successForeground**? | <code>string</code> | The foreground color that applies to any text or other elements that appear over the success color.<br/>__*Optional*__
**warning**? | <code>string</code> | This color that applies to warning and informational messages.<br/>__*Optional*__
**warningForeground**? | <code>string</code> | The foreground color that applies to any text or other elements that appear over the warning color.<br/>__*Optional*__



## struct UntagResourceRequest  <a id="cdk-quicksight-constructs-untagresourcerequest"></a>






Name | Type | Description 
-----|------|-------------
**resourceArn** | <code>string</code> | The Amazon Resource Name (ARN) of the resource that you want to untag.
**tagKeys** | <code>Array<string></code> | The keys of the key-value pairs for the resource tag or tags assigned to the resource.



## struct UntagResourceResponse  <a id="cdk-quicksight-constructs-untagresourceresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct UpdateAccountCustomizationRequest  <a id="cdk-quicksight-constructs-updateaccountcustomizationrequest"></a>






Name | Type | Description 
-----|------|-------------
**accountCustomization** | <code>[AccountCustomization](#cdk-quicksight-constructs-accountcustomization)</code> | The QuickSight customizations you're updating in the current AWS Region.
**awsAccountId** | <code>string</code> | The ID for the AWS account that you want to update QuickSight customizations for.
**namespace**? | <code>string</code> | The namespace that you want to update QuickSight customizations for.<br/>__*Optional*__



## struct UpdateAccountCustomizationResponse  <a id="cdk-quicksight-constructs-updateaccountcustomizationresponse"></a>






Name | Type | Description 
-----|------|-------------
**accountCustomization**? | <code>[AccountCustomization](#cdk-quicksight-constructs-accountcustomization)</code> | The QuickSight customizations you're updating in the current AWS Region.<br/>__*Optional*__
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) for the updated customization for this AWS account.<br/>__*Optional*__
**awsAccountId**? | <code>string</code> | The ID for the AWS account that you want to update QuickSight customizations for.<br/>__*Optional*__
**namespace**? | <code>string</code> | The namespace associated with the customization that you're updating.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct UpdateAccountSettingsRequest  <a id="cdk-quicksight-constructs-updateaccountsettingsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that contains the QuickSight settings that you want to list.
**defaultNamespace** | <code>string</code> | The default namespace for this AWS account.
**notificationEmail**? | <code>string</code> | The email address that you want QuickSight to send notifications to regarding your AWS account or QuickSight subscription.<br/>__*Optional*__



## struct UpdateAccountSettingsResponse  <a id="cdk-quicksight-constructs-updateaccountsettingsresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct UpdateAnalysisPermissionsRequest  <a id="cdk-quicksight-constructs-updateanalysispermissionsrequest"></a>






Name | Type | Description 
-----|------|-------------
**analysisId** | <code>string</code> | The ID of the analysis whose permissions you're updating.
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the analysis whose permissions you're updating.
**grantPermissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A structure that describes the permissions to add and the principal to add them to.<br/>__*Optional*__
**revokePermissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A structure that describes the permissions to remove and the principal to remove them from.<br/>__*Optional*__



## struct UpdateAnalysisPermissionsResponse  <a id="cdk-quicksight-constructs-updateanalysispermissionsresponse"></a>






Name | Type | Description 
-----|------|-------------
**analysisArn**? | <code>string</code> | The Amazon Resource Name (ARN) of the analysis that you updated.<br/>__*Optional*__
**analysisId**? | <code>string</code> | The ID of the analysis that you updated permissions for.<br/>__*Optional*__
**permissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A structure that describes the principals and the resource-level permissions on an analysis.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct UpdateAnalysisRequest  <a id="cdk-quicksight-constructs-updateanalysisrequest"></a>






Name | Type | Description 
-----|------|-------------
**analysisId** | <code>string</code> | The ID for the analysis that you're updating.
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the analysis that you're updating.
**name** | <code>string</code> | A descriptive name for the analysis that you're updating.
**sourceEntity** | <code>[AnalysisSourceEntity](#cdk-quicksight-constructs-analysissourceentity)</code> | A source entity to use for the analysis that you're updating.
**parameters**? | <code>[Parameters](#cdk-quicksight-constructs-parameters)</code> | The parameter names and override values that you want to use.<br/>__*Optional*__
**themeArn**? | <code>string</code> | The Amazon Resource Name (ARN) for the theme to apply to the analysis that you're creating.<br/>__*Optional*__



## struct UpdateAnalysisResponse  <a id="cdk-quicksight-constructs-updateanalysisresponse"></a>






Name | Type | Description 
-----|------|-------------
**analysisId**? | <code>string</code> | The ID of the analysis.<br/>__*Optional*__
**arn**? | <code>string</code> | The ARN of the analysis that you're updating.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**updateStatus**? | <code>string</code> | The update status of the last update that was made to the analysis.<br/>__*Optional*__



## struct UpdateDashboardPermissionsRequest  <a id="cdk-quicksight-constructs-updatedashboardpermissionsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the dashboard whose permissions you're updating.
**dashboardId** | <code>string</code> | The ID for the dashboard.
**grantPermissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | The permissions that you want to grant on this resource.<br/>__*Optional*__
**revokePermissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | The permissions that you want to revoke from this resource.<br/>__*Optional*__



## struct UpdateDashboardPermissionsResponse  <a id="cdk-quicksight-constructs-updatedashboardpermissionsresponse"></a>






Name | Type | Description 
-----|------|-------------
**dashboardArn**? | <code>string</code> | The Amazon Resource Name (ARN) of the dashboard.<br/>__*Optional*__
**dashboardId**? | <code>string</code> | The ID for the dashboard.<br/>__*Optional*__
**permissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | Information about the permissions on the dashboard.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct UpdateDashboardPublishedVersionRequest  <a id="cdk-quicksight-constructs-updatedashboardpublishedversionrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the dashboard that you're updating.
**dashboardId** | <code>string</code> | The ID for the dashboard.
**versionNumber** | <code>number</code> | The version number of the dashboard.



## struct UpdateDashboardPublishedVersionResponse  <a id="cdk-quicksight-constructs-updatedashboardpublishedversionresponse"></a>






Name | Type | Description 
-----|------|-------------
**dashboardArn**? | <code>string</code> | The Amazon Resource Name (ARN) of the dashboard.<br/>__*Optional*__
**dashboardId**? | <code>string</code> | The ID for the dashboard.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct UpdateDashboardRequest  <a id="cdk-quicksight-constructs-updatedashboardrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the dashboard that you're updating.
**dashboardId** | <code>string</code> | The ID for the dashboard.
**name** | <code>string</code> | The display name of the dashboard.
**sourceEntity** | <code>[DashboardSourceEntity](#cdk-quicksight-constructs-dashboardsourceentity)</code> | The entity that you are using as a source when you update the dashboard.
**dashboardPublishOptions**? | <code>[DashboardPublishOptions](#cdk-quicksight-constructs-dashboardpublishoptions)</code> | Options for publishing the dashboard when you create it:    AvailabilityStatus for AdHocFilteringOption - This status can be either ENABLED or DISABLED.<br/>__*Optional*__
**parameters**? | <code>[Parameters](#cdk-quicksight-constructs-parameters)</code> | A structure that contains the parameters of the dashboard.<br/>__*Optional*__
**themeArn**? | <code>string</code> | The Amazon Resource Name (ARN) of the theme that is being used for this dashboard.<br/>__*Optional*__
**versionDescription**? | <code>string</code> | A description for the first version of the dashboard being created.<br/>__*Optional*__



## struct UpdateDashboardResponse  <a id="cdk-quicksight-constructs-updatedashboardresponse"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the resource.<br/>__*Optional*__
**creationStatus**? | <code>string</code> | The creation status of the request.<br/>__*Optional*__
**dashboardId**? | <code>string</code> | The ID for the dashboard.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**versionArn**? | <code>string</code> | The ARN of the dashboard, including the version number.<br/>__*Optional*__



## struct UpdateDataSetPermissionsRequest  <a id="cdk-quicksight-constructs-updatedatasetpermissionsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID.
**dataSetId** | <code>string</code> | The ID for the dataset whose permissions you want to update.
**grantPermissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | The resource permissions that you want to grant to the dataset.<br/>__*Optional*__
**revokePermissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | The resource permissions that you want to revoke from the dataset.<br/>__*Optional*__



## struct UpdateDataSetPermissionsResponse  <a id="cdk-quicksight-constructs-updatedatasetpermissionsresponse"></a>






Name | Type | Description 
-----|------|-------------
**dataSetArn**? | <code>string</code> | The Amazon Resource Name (ARN) of the dataset.<br/>__*Optional*__
**dataSetId**? | <code>string</code> | The ID for the dataset whose permissions you want to update.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct UpdateDataSetRequest  <a id="cdk-quicksight-constructs-updatedatasetrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID.
**dataSetId** | <code>string</code> | The ID for the dataset that you want to update.
**importMode** | <code>string</code> | Indicates whether you want to import the data into SPICE.
**name** | <code>string</code> | The display name for the dataset.
**physicalTableMap** | <code>Map<string, [PhysicalTable](#cdk-quicksight-constructs-physicaltable)></code> | Declares the physical tables that are available in the underlying data sources.
**columnGroups**? | <code>Array<[ColumnGroup](#cdk-quicksight-constructs-columngroup)></code> | Groupings of columns that work together in certain QuickSight features.<br/>__*Optional*__
**columnLevelPermissionRules**? | <code>Array<[ColumnLevelPermissionRule](#cdk-quicksight-constructs-columnlevelpermissionrule)></code> | A set of one or more definitions of a  ColumnLevelPermissionRule .<br/>__*Optional*__
**fieldFolders**? | <code>Map<string, [FieldFolder](#cdk-quicksight-constructs-fieldfolder)></code> | The folder that contains fields and nested subfolders for your dataset.<br/>__*Optional*__
**logicalTableMap**? | <code>Map<string, [LogicalTable](#cdk-quicksight-constructs-logicaltable)></code> | Configures the combination and transformation of the data from the physical tables.<br/>__*Optional*__
**rowLevelPermissionDataSet**? | <code>[RowLevelPermissionDataSet](#cdk-quicksight-constructs-rowlevelpermissiondataset)</code> | The row-level security configuration for the data you want to create.<br/>__*Optional*__



## struct UpdateDataSetResponse  <a id="cdk-quicksight-constructs-updatedatasetresponse"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the dataset.<br/>__*Optional*__
**dataSetId**? | <code>string</code> | The ID for the dataset that you want to create.<br/>__*Optional*__
**ingestionArn**? | <code>string</code> | The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.<br/>__*Optional*__
**ingestionId**? | <code>string</code> | The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct UpdateDataSourcePermissionsRequest  <a id="cdk-quicksight-constructs-updatedatasourcepermissionsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID.
**dataSourceId** | <code>string</code> | The ID of the data source.
**grantPermissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A list of resource permissions that you want to grant on the data source.<br/>__*Optional*__
**revokePermissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A list of resource permissions that you want to revoke on the data source.<br/>__*Optional*__



## struct UpdateDataSourcePermissionsResponse  <a id="cdk-quicksight-constructs-updatedatasourcepermissionsresponse"></a>






Name | Type | Description 
-----|------|-------------
**dataSourceArn**? | <code>string</code> | The Amazon Resource Name (ARN) of the data source.<br/>__*Optional*__
**dataSourceId**? | <code>string</code> | The ID of the data source.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct UpdateDataSourceRequest  <a id="cdk-quicksight-constructs-updatedatasourcerequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The AWS account ID.
**dataSourceId** | <code>string</code> | The ID of the data source.
**name** | <code>string</code> | A display name for the data source.
**credentials**? | <code>[DataSourceCredentials](#cdk-quicksight-constructs-datasourcecredentials)</code> | The credentials that QuickSight that uses to connect to your underlying source.<br/>__*Optional*__
**dataSourceParameters**? | <code>[DataSourceParameters](#cdk-quicksight-constructs-datasourceparameters)</code> | The parameters that QuickSight uses to connect to your underlying source.<br/>__*Optional*__
**sslProperties**? | <code>[SslProperties](#cdk-quicksight-constructs-sslproperties)</code> | Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying source.<br/>__*Optional*__
**vpcConnectionProperties**? | <code>[VpcConnectionProperties](#cdk-quicksight-constructs-vpcconnectionproperties)</code> | Use this parameter only when you want QuickSight to use a VPC connection when connecting to your underlying source.<br/>__*Optional*__



## struct UpdateDataSourceResponse  <a id="cdk-quicksight-constructs-updatedatasourceresponse"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) of the data source.<br/>__*Optional*__
**dataSourceId**? | <code>string</code> | The ID of the data source.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**updateStatus**? | <code>string</code> | The update status of the data source's last update.<br/>__*Optional*__



## struct UpdateGroupRequest  <a id="cdk-quicksight-constructs-updategrouprequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that the group is in.
**groupName** | <code>string</code> | The name of the group that you want to update.
**namespace** | <code>string</code> | The namespace.
**description**? | <code>string</code> | The description for the group that you want to update.<br/>__*Optional*__



## struct UpdateGroupResponse  <a id="cdk-quicksight-constructs-updategroupresponse"></a>






Name | Type | Description 
-----|------|-------------
**group**? | <code>[Group](#cdk-quicksight-constructs-group)</code> | The name of the group.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct UpdateIAMPolicyAssignmentRequest  <a id="cdk-quicksight-constructs-updateiampolicyassignmentrequest"></a>






Name | Type | Description 
-----|------|-------------
**assignmentName** | <code>string</code> | The name of the assignment, also called a rule.
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the IAM policy assignment.
**namespace** | <code>string</code> | The namespace of the assignment.
**assignmentStatus**? | <code>string</code> | The status of the assignment.<br/>__*Optional*__
**identities**? | <code>Map<string, Array<string>></code> | The QuickSight users, groups, or both that you want to assign the policy to.<br/>__*Optional*__
**policyArn**? | <code>string</code> | The ARN for the IAM policy to apply to the QuickSight users and groups specified in this assignment.<br/>__*Optional*__



## struct UpdateIAMPolicyAssignmentResponse  <a id="cdk-quicksight-constructs-updateiampolicyassignmentresponse"></a>






Name | Type | Description 
-----|------|-------------
**assignmentId**? | <code>string</code> | The ID of the assignment.<br/>__*Optional*__
**assignmentName**? | <code>string</code> | The name of the assignment or rule.<br/>__*Optional*__
**assignmentStatus**? | <code>string</code> | The status of the assignment.<br/>__*Optional*__
**identities**? | <code>Map<string, Array<string>></code> | The QuickSight users, groups, or both that the IAM policy is assigned to.<br/>__*Optional*__
**policyArn**? | <code>string</code> | The ARN for the IAM policy applied to the QuickSight users and groups specified in this assignment.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__



## struct UpdateTemplateAliasRequest  <a id="cdk-quicksight-constructs-updatetemplatealiasrequest"></a>






Name | Type | Description 
-----|------|-------------
**aliasName** | <code>string</code> | The alias of the template that you want to update.
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the template alias that you're updating.
**templateId** | <code>string</code> | The ID for the template.
**templateVersionNumber** | <code>number</code> | The version number of the template.



## struct UpdateTemplateAliasResponse  <a id="cdk-quicksight-constructs-updatetemplatealiasresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**templateAlias**? | <code>[TemplateAlias](#cdk-quicksight-constructs-templatealias)</code> | The template alias.<br/>__*Optional*__



## struct UpdateTemplatePermissionsRequest  <a id="cdk-quicksight-constructs-updatetemplatepermissionsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the template.
**templateId** | <code>string</code> | The ID for the template.
**grantPermissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A list of resource permissions to be granted on the template.<br/>__*Optional*__
**revokePermissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A list of resource permissions to be revoked from the template.<br/>__*Optional*__



## struct UpdateTemplatePermissionsResponse  <a id="cdk-quicksight-constructs-updatetemplatepermissionsresponse"></a>






Name | Type | Description 
-----|------|-------------
**permissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A list of resource permissions to be set on the template.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**templateArn**? | <code>string</code> | The Amazon Resource Name (ARN) of the template.<br/>__*Optional*__
**templateId**? | <code>string</code> | The ID for the template.<br/>__*Optional*__



## struct UpdateTemplateRequest  <a id="cdk-quicksight-constructs-updatetemplaterequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the template that you're updating.
**sourceEntity** | <code>[TemplateSourceEntity](#cdk-quicksight-constructs-templatesourceentity)</code> | The entity that you are using as a source when you update the template.
**templateId** | <code>string</code> | The ID for the template.
**name**? | <code>string</code> | The name for the template.<br/>__*Optional*__
**versionDescription**? | <code>string</code> | A description of the current template version that is being updated.<br/>__*Optional*__



## struct UpdateTemplateResponse  <a id="cdk-quicksight-constructs-updatetemplateresponse"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) for the template.<br/>__*Optional*__
**creationStatus**? | <code>string</code> | The creation status of the template.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**templateId**? | <code>string</code> | The ID for the template.<br/>__*Optional*__
**versionArn**? | <code>string</code> | The ARN for the template, including the version information of the first version.<br/>__*Optional*__



## struct UpdateThemeAliasRequest  <a id="cdk-quicksight-constructs-updatethemealiasrequest"></a>






Name | Type | Description 
-----|------|-------------
**aliasName** | <code>string</code> | The name of the theme alias that you want to update.
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the theme alias that you're updating.
**themeId** | <code>string</code> | The ID for the theme.
**themeVersionNumber** | <code>number</code> | The version number of the theme that the alias should reference.



## struct UpdateThemeAliasResponse  <a id="cdk-quicksight-constructs-updatethemealiasresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**themeAlias**? | <code>[ThemeAlias](#cdk-quicksight-constructs-themealias)</code> | Information about the theme alias.<br/>__*Optional*__



## struct UpdateThemePermissionsRequest  <a id="cdk-quicksight-constructs-updatethemepermissionsrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the theme.
**themeId** | <code>string</code> | The ID for the theme.
**grantPermissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A list of resource permissions to be granted for the theme.<br/>__*Optional*__
**revokePermissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | A list of resource permissions to be revoked from the theme.<br/>__*Optional*__



## struct UpdateThemePermissionsResponse  <a id="cdk-quicksight-constructs-updatethemepermissionsresponse"></a>






Name | Type | Description 
-----|------|-------------
**permissions**? | <code>Array<[ResourcePermission](#cdk-quicksight-constructs-resourcepermission)></code> | The resulting list of resource permissions for the theme.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**themeArn**? | <code>string</code> | The Amazon Resource Name (ARN) of the theme.<br/>__*Optional*__
**themeId**? | <code>string</code> | The ID for the theme.<br/>__*Optional*__



## struct UpdateThemeRequest  <a id="cdk-quicksight-constructs-updatethemerequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID of the AWS account that contains the theme that you're updating.
**baseThemeId** | <code>string</code> | The theme ID, defined by Amazon QuickSight, that a custom theme inherits from.
**themeId** | <code>string</code> | The ID for the theme.
**configuration**? | <code>[ThemeConfiguration](#cdk-quicksight-constructs-themeconfiguration)</code> | The theme configuration, which contains the theme display properties.<br/>__*Optional*__
**name**? | <code>string</code> | The name for the theme.<br/>__*Optional*__
**versionDescription**? | <code>string</code> | A description of the theme version that you're updating Every time that you call UpdateTheme, you create a new version of the theme.<br/>__*Optional*__



## struct UpdateThemeResponse  <a id="cdk-quicksight-constructs-updatethemeresponse"></a>






Name | Type | Description 
-----|------|-------------
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) for the theme.<br/>__*Optional*__
**creationStatus**? | <code>string</code> | The creation status of the theme.<br/>__*Optional*__
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**themeId**? | <code>string</code> | The ID for the theme.<br/>__*Optional*__
**versionArn**? | <code>string</code> | The Amazon Resource Name (ARN) for the new version of the theme.<br/>__*Optional*__



## struct UpdateUserRequest  <a id="cdk-quicksight-constructs-updateuserrequest"></a>






Name | Type | Description 
-----|------|-------------
**awsAccountId** | <code>string</code> | The ID for the AWS account that the user is in.
**email** | <code>string</code> | The email address of the user that you want to update.
**namespace** | <code>string</code> | The namespace.
**role** | <code>string</code> | The Amazon QuickSight role of the user.
**userName** | <code>string</code> | The Amazon QuickSight user name that you want to update.
**customPermissionsName**? | <code>string</code> | (Enterprise edition only) The name of the custom permissions profile that you want to assign to this user.<br/>__*Optional*__
**unapplyCustomPermissions**? | <code>boolean</code> | A flag that you use to indicate that you want to remove all custom permissions from this user.<br/>__*Optional*__



## struct UpdateUserResponse  <a id="cdk-quicksight-constructs-updateuserresponse"></a>






Name | Type | Description 
-----|------|-------------
**requestId**? | <code>string</code> | The AWS request ID for this operation.<br/>__*Optional*__
**status**? | <code>number</code> | The HTTP status of the request.<br/>__*Optional*__
**user**? | <code>[User](#cdk-quicksight-constructs-user)</code> | The Amazon QuickSight user.<br/>__*Optional*__



## struct UploadSettings  <a id="cdk-quicksight-constructs-uploadsettings"></a>






Name | Type | Description 
-----|------|-------------
**containsHeader**? | <code>boolean</code> | Whether the file has a header row, or the files each have a header row.<br/>__*Optional*__
**delimiter**? | <code>string</code> | The delimiter between values in the file.<br/>__*Optional*__
**format**? | <code>string</code> | File format.<br/>__*Optional*__
**startFromRow**? | <code>number</code> | A row number to start reading data from.<br/>__*Optional*__
**textQualifier**? | <code>string</code> | Text qualifier.<br/>__*Optional*__



## struct User  <a id="cdk-quicksight-constructs-user"></a>






Name | Type | Description 
-----|------|-------------
**active**? | <code>boolean</code> | The active status of user.<br/>__*Optional*__
**arn**? | <code>string</code> | The Amazon Resource Name (ARN) for the user.<br/>__*Optional*__
**customPermissionsName**? | <code>string</code> | The custom permissions profile associated with this user.<br/>__*Optional*__
**email**? | <code>string</code> | The user's email address.<br/>__*Optional*__
**identityType**? | <code>string</code> | The type of identity authentication used by the user.<br/>__*Optional*__
**principalId**? | <code>string</code> | The principal ID of the user.<br/>__*Optional*__
**role**? | <code>string</code> | The Amazon QuickSight role for the user.<br/>__*Optional*__
**userName**? | <code>string</code> | The user's user name.<br/>__*Optional*__



## struct VpcConnectionProperties  <a id="cdk-quicksight-constructs-vpcconnectionproperties"></a>






Name | Type | Description 
-----|------|-------------
**vpcConnectionArn** | <code>string</code> | The Amazon Resource Name (ARN) for the VPC connection.



