# -*- coding: utf-8 -*-
# Copyright 2022 Cohesity Inc.

import cohesity_management_sdk.models.app_instance_settings
import cohesity_management_sdk.models.user_ssh_key
import cohesity_management_sdk.models.vm_group

class AppInstance(object):

    """Implementation of the 'AppInstance' model.

    AppInstance provides application instance's information.

    Attributes:
        app_access_token (string): Specifies the token to access with the app.
        app_instance_id (long|int): Specifies unique id across all instances
            of all apps.
        app_name (string): Specifies name of the app that is launched in this
            instance.
        app_uid (long|int): Specifies id of the app that is launched in this
            instance.
        app_version (long|int): Specifies the version of the app that is
            launched in this instance.
        created_time_usecs (long |int): Specifies timestamp (in microseconds)
            when the app instance was first created.
        creation_uid (string): Specifies a unique identifier generated by the
            client to let the backend identify retries of the app launch
            request. type: string
        description (string): Specifies user configured description for the
            app instance.
        dev_version (string):Specifies version of the app provided by the
            developer.
        duration_usecs (long|int):  Specifies duration (in microseconds) for
            which the app instance
        health_detail (string): Specifies the reason the app instance is
            unhealthy. Only set if app instance is unhealthy.
        health_status (int|long): Specifies the current health status of the
            app instance.
        https_ui (bool): Specifies app ui http config. If set to true, the
            App's UI uses https. Otherwise it uses http.
        namespace (string): TODO: Type description here.
        node_ip (string): Specifies the ip of the node which can be used to
            contact app instance external services.
        node_port (long|int): Specifies the node port on which the app
            instance services external requests.
        settings (AppInstanceSettings): Specifies settings used to launch an
            app instance.
        state (StateAppInstanceEnum):
            Specifies the current state of the app instance.
            Specifies operational status of an app instance.
            kInitializing - The app instance has been launched or resumed, but
            is not fully running yet.
            kRunning - The app instance is running. Check health_status for
            the actual health.
            kPausing - The app instance is being paused.
            kPaused - The app instance has been paused.
            kTerminating - The app instance is being terminated.
            kTerminated -  The app instance has been terminated.
            kFailed - The app instance has failed due to an unrecoverable
            error.
        state_detail (string): Specifies the failure reason when the app
            instance's state is kFailed.
        user_ssh_key (UserSshKey): Specifies username and corresponding ssh
            key to be inserted into the VMs.
        vm_groups (list of VmGroup):  Specifies list of all VM groups for this
            application. Each VM group contains a list of VMs. Information
            needed for UI like the nodePort, the port type etc. is stored for
            each VM.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "app_access_token":'appAccessToken',
        "app_instance_id":'appInstanceId',
        "app_name":'appName',
        "app_uid":'appUid',
        "app_version":'appVersion',
        "created_time_usecs":'createdTimeUsecs',
        "creation_uid":'creationUid',
        "description":'description',
        "dev_version":'devVersion',
        "duration_usecs":'durationUsecs',
        "health_detail":'healthDetail',
        "health_status":'healthStatus',
        "https_ui":'httpsUi',
        "namespace":'namespace',
        "node_ip":'nodeIp',
        "node_port":'nodePort',
        "settings":'settings',
        "state":'state',
        "state_detail":'stateDetail',
        "user_ssh_key":'userSshKey',
        "vm_groups":'vmGroups'
    }

    def __init__(self,
                 app_access_token=None,
                 app_instance_id=None,
                 app_name=None,
                 app_uid=None,
                 app_version=None,
                 created_time_usecs=None,
                 creation_uid=None,
                 description=None,
                 dev_version=None,
                 duration_usecs=None,
                 health_detail=None,
                 health_status=None,
                 https_ui=None,
                 namespace=None,
                 node_ip=None,
                 node_port=None,
                 settings=None,
                 state=None,
                 state_detail=None,
                 user_ssh_key=None,
                 vm_groups=None):
        """Constructor for the AppInstance class"""

        # Initialize members of the class
        self.app_access_token = app_access_token
        self.app_instance_id = app_instance_id
        self.app_name = app_name
        self.app_uid = app_uid
        self.app_version = app_version
        self.created_time_usecs = created_time_usecs
        self.creation_uid = creation_uid
        self.description = description
        self.dev_version = dev_version
        self.duration_usecs = duration_usecs
        self.health_detail = health_detail
        self.health_status = health_status
        self.https_ui = https_ui
        self.namespace = namespace
        self.node_ip = node_ip
        self.node_port = node_port
        self.settings = settings
        self.state = state
        self.state_detail = state_detail
        self.user_ssh_key = user_ssh_key
        self.vm_groups = vm_groups


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        app_access_token = dictionary.get('appAccessToken')
        app_instance_id = dictionary.get('appInstanceId') 
        app_name = dictionary.get('appName')
        app_uid = dictionary.get('appUid') 
        app_version = dictionary.get('appVersion')
        created_time_usecs = dictionary.get('createdTimeUsecs')
        creation_uid = dictionary.get('creationUid')
        description = dictionary.get('description') 
        dev_version = dictionary.get('devVersion')
        duration_usecs = dictionary.get('durationUsecs')
        health_detail = dictionary.get('healthDetail')
        health_status = dictionary.get('healthStatus') 
        https_ui = dictionary.get('httpsUi')
        namespace = dictionary.get('namespace')
        node_ip = dictionary.get('nodeIp')
        node_port = dictionary.get('nodePort')
        settings = cohesity_management_sdk.models.app_instance_settings.AppInstanceSettings.from_dictionary(dictionary.get('settings')) if dictionary.get('settings') else None
        state = dictionary.get('state')
        state_detail = dictionary.get('stateDetail') 
        user_ssh_key = cohesity_management_sdk.models.user_ssh_key.UserSshKey.from_dictionary(dictionary.get('userSshKey')) if dictionary.get('userSshKey') else None
        vm_groups = None
        if dictionary.get('vmGroups'):
            vm_groups = list()
            for group in dictionary.get('vmGroups'):
                vm_groups.append(cohesity_management_sdk.models.vm_group.VmGroup.from_dictionary(group))

        # Return an object of this model
        return cls(app_access_token,
                   app_instance_id,
                   app_name,
                   app_uid,
                   app_version,
                   created_time_usecs,
                   creation_uid,
                   description,
                   dev_version,
                   duration_usecs,
                   health_detail,
                   health_status,
                   https_ui,
                   namespace,
                   node_ip,
                   node_port,
                   settings,
                   state,
                   state_detail,
                   user_ssh_key,
                   vm_groups)

