# GymBuddy
## Project Description
GymBuddy is a web application for anyone who is committed to pursuing a healthier lifestyle. GymBuddy helps its users keep track of the numerous health aspects of their lives: through logging macros, calories, exercises, meals, and weight. The information is tracked over time and portrayed in the form of graphs to visually display the progress you have made over time.

## Features
**To use any features of GymBuddy you must create a user account and be logged in**
* Users can track their macros/calories by logging the food they eat. Users can either manually log their food's macros/calories or search for a food by its name and have the food's macros/calories automatically filled. When a user searches for a food, our app web scrapes myfitnesspal.com to find the macros/calories of the searched food. Users can go to their profile page in order to view their macro distribution in the form a graph.
* Users can browse GymBuddy's selection of healthy meals. Each meal provides instructions, ingredients, as well as tags for easy filtering. All meals are web scraped from skinnytaste.com.
* Users can log their exercies over time to keep track of improvements and progress. GymBuddy also provides a huge catalog of different exercies that users can look through for exercise recommendations. There is also the option to filter exercises by a specific muscle group. From the profile page, users can view their weight records in the form of a graph for any exercise they've recorded. All exercises are web scraped from acefitness.org. 
* Users can log ther body weight to monitor their body weight over time. Weight history for a user can be viewed in their profile page. 
* If a user need to update any of their health information, they can do so from their profile page.

## Pip Installation
* If project has already been previously installed on testing machine run ``` pip uninstall GymBuddy```  to ensure pip updates you to the most recent version. 

```
pip install GymBuddy
```

## Command to start project
```
launch runserver
```
* An then navigate to  http://127.0.0.1:8000/ in your browser

## Command to create superuser
* To be able to view the admin console, you can create a superuser using the command below and then navigate to /admin
```
launch createsuperuser
```

## GitHub Link
[GymBuddy GitHub](https://urldefense.proofpoint.com/v2/url?u=https-3A__github.com_CTKogstrom_GymBuddyApp&d=DwIGAg&c=sJ6xIWYx-zLMB3EPkvcnVg&r=iBtJv8aA_GdaWP2f1Jfg-Q&m=JlI2fcLdD2_Z40s29sj6y5LXq-K-L9ygAsW06ukBMBE&s=8JYmXZOpU4ZrNh_OzvwnblpBzkbGBMCUqdce0thrl-Y&e=)

** Notes: Because our performance element included active webscraping on load, slow internet speeds may result in long wait times for the meals and exercises pages. With normal internet speed wait times should not exceed 3 seconds.

