# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['KafkaConnectorArgs', 'KafkaConnector']

@pulumi.input_type
class KafkaConnectorArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 properties: pulumi.Input[Mapping[str, Any]],
                 name: Optional[pulumi.Input[str]] = None,
                 running_state: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a KafkaConnector resource.
        :param pulumi.Input[str] cluster_id: Name of the connector
        :param pulumi.Input[Mapping[str, Any]] properties: Properties that the connector will have
        :param pulumi.Input[str] name: Name of the connector
        :param pulumi.Input[str] running_state: Running state of the connector. Can be either 'paused', 'running' or 'restart'
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "properties", properties)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if running_state is not None:
            pulumi.set(__self__, "running_state", running_state)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        Name of the connector
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Input[Mapping[str, Any]]:
        """
        Properties that the connector will have
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: pulumi.Input[Mapping[str, Any]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the connector
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="runningState")
    def running_state(self) -> Optional[pulumi.Input[str]]:
        """
        Running state of the connector. Can be either 'paused', 'running' or 'restart'
        """
        return pulumi.get(self, "running_state")

    @running_state.setter
    def running_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "running_state", value)


@pulumi.input_type
class _KafkaConnectorState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 connector_id: Optional[pulumi.Input[str]] = None,
                 creation_time: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 running_state: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering KafkaConnector resources.
        :param pulumi.Input[str] cluster_id: Name of the connector
        :param pulumi.Input[str] connector_id: Unique Connector ID for created connector
        :param pulumi.Input[int] creation_time: Creation of the connector
        :param pulumi.Input[str] name: Name of the connector
        :param pulumi.Input[Mapping[str, Any]] properties: Properties that the connector will have
        :param pulumi.Input[str] running_state: Running state of the connector. Can be either 'paused', 'running' or 'restart'
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if connector_id is not None:
            pulumi.set(__self__, "connector_id", connector_id)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if running_state is not None:
            pulumi.set(__self__, "running_state", running_state)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the connector
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique Connector ID for created connector
        """
        return pulumi.get(self, "connector_id")

    @connector_id.setter
    def connector_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connector_id", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[int]]:
        """
        Creation of the connector
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the connector
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Properties that the connector will have
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="runningState")
    def running_state(self) -> Optional[pulumi.Input[str]]:
        """
        Running state of the connector. Can be either 'paused', 'running' or 'restart'
        """
        return pulumi.get(self, "running_state")

    @running_state.setter
    def running_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "running_state", value)


class KafkaConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 running_state: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import upstash_pulumi as upstash

        # Not necessary if the topic belongs to an already created cluster.
        example_kafka_cluster = upstash.KafkaCluster("exampleKafkaCluster",
            cluster_name="Terraform_Upstash_Cluster",
            region="eu-west-1",
            multizone=False)
        example_kafka_topic = upstash.KafkaTopic("exampleKafkaTopic",
            topic_name="TerraformTopic",
            partitions=1,
            retention_time=625135,
            retention_size=725124,
            max_message_size=829213,
            cleanup_policy="delete",
            cluster_id=resource["upstash_kafka_cluster"]["exampleKafkaCluster"]["cluster_id"])
        example_kafka_connector = upstash.KafkaConnector("exampleKafkaConnector",
            cluster_id=example_kafka_cluster.cluster_id,
            properties={
                "collection": "user123",
                "connection.uri": "mongodb+srv://test:test@cluster0.fohyg7p.mongodb.net/?retryWrites=true&w=majority",
                "connector.class": "com.mongodb.kafka.connect.MongoSourceConnector",
                "database": "myshinynewdb2",
                "topics": example_kafka_topic.topic_name,
            })
        # OPTIONAL: change between restart-running-paused
        # running_state = "running"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: Name of the connector
        :param pulumi.Input[str] name: Name of the connector
        :param pulumi.Input[Mapping[str, Any]] properties: Properties that the connector will have
        :param pulumi.Input[str] running_state: Running state of the connector. Can be either 'paused', 'running' or 'restart'
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KafkaConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import upstash_pulumi as upstash

        # Not necessary if the topic belongs to an already created cluster.
        example_kafka_cluster = upstash.KafkaCluster("exampleKafkaCluster",
            cluster_name="Terraform_Upstash_Cluster",
            region="eu-west-1",
            multizone=False)
        example_kafka_topic = upstash.KafkaTopic("exampleKafkaTopic",
            topic_name="TerraformTopic",
            partitions=1,
            retention_time=625135,
            retention_size=725124,
            max_message_size=829213,
            cleanup_policy="delete",
            cluster_id=resource["upstash_kafka_cluster"]["exampleKafkaCluster"]["cluster_id"])
        example_kafka_connector = upstash.KafkaConnector("exampleKafkaConnector",
            cluster_id=example_kafka_cluster.cluster_id,
            properties={
                "collection": "user123",
                "connection.uri": "mongodb+srv://test:test@cluster0.fohyg7p.mongodb.net/?retryWrites=true&w=majority",
                "connector.class": "com.mongodb.kafka.connect.MongoSourceConnector",
                "database": "myshinynewdb2",
                "topics": example_kafka_topic.topic_name,
            })
        # OPTIONAL: change between restart-running-paused
        # running_state = "running"
        ```

        :param str resource_name: The name of the resource.
        :param KafkaConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KafkaConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 running_state: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KafkaConnectorArgs.__new__(KafkaConnectorArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["name"] = name
            if properties is None and not opts.urn:
                raise TypeError("Missing required property 'properties'")
            __props__.__dict__["properties"] = properties
            __props__.__dict__["running_state"] = running_state
            __props__.__dict__["connector_id"] = None
            __props__.__dict__["creation_time"] = None
        super(KafkaConnector, __self__).__init__(
            'upstash:index/kafkaConnector:KafkaConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            connector_id: Optional[pulumi.Input[str]] = None,
            creation_time: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            properties: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            running_state: Optional[pulumi.Input[str]] = None) -> 'KafkaConnector':
        """
        Get an existing KafkaConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: Name of the connector
        :param pulumi.Input[str] connector_id: Unique Connector ID for created connector
        :param pulumi.Input[int] creation_time: Creation of the connector
        :param pulumi.Input[str] name: Name of the connector
        :param pulumi.Input[Mapping[str, Any]] properties: Properties that the connector will have
        :param pulumi.Input[str] running_state: Running state of the connector. Can be either 'paused', 'running' or 'restart'
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KafkaConnectorState.__new__(_KafkaConnectorState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["connector_id"] = connector_id
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["name"] = name
        __props__.__dict__["properties"] = properties
        __props__.__dict__["running_state"] = running_state
        return KafkaConnector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        Name of the connector
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> pulumi.Output[str]:
        """
        Unique Connector ID for created connector
        """
        return pulumi.get(self, "connector_id")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[int]:
        """
        Creation of the connector
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the connector
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Properties that the connector will have
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="runningState")
    def running_state(self) -> pulumi.Output[Optional[str]]:
        """
        Running state of the connector. Can be either 'paused', 'running' or 'restart'
        """
        return pulumi.get(self, "running_state")

