# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['QStashScheduleArgs', 'QStashSchedule']

@pulumi.input_type
class QStashScheduleArgs:
    def __init__(__self__, *,
                 cron: pulumi.Input[str],
                 destination: pulumi.Input[str],
                 body: Optional[pulumi.Input[str]] = None,
                 callback: Optional[pulumi.Input[str]] = None,
                 content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 deduplication_id: Optional[pulumi.Input[str]] = None,
                 delay: Optional[pulumi.Input[str]] = None,
                 forward_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 not_before: Optional[pulumi.Input[int]] = None,
                 retries: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a QStashSchedule resource.
        :param pulumi.Input[str] cron: Cron string for Qstash Schedule
        :param pulumi.Input[str] destination: Destination for Qstash Schedule. Either Topic ID or valid URL
        :param pulumi.Input[str] body: Body to send for the POST request in string format. Needs escaping (\) double quotes.
        :param pulumi.Input[str] callback: Callback URL for Qstash Schedule.
        :param pulumi.Input[bool] content_based_deduplication: Content Based Deduplication (bool) for Qstash Scheduling.
        :param pulumi.Input[str] content_type: Content type for Qstash Scheduling.
        :param pulumi.Input[str] deduplication_id: Deduplication ID for Qstash Scheduling.
        :param pulumi.Input[str] delay: Delay for Qstash Schedule.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] forward_headers: Forward headers to your API
        :param pulumi.Input[int] not_before: Start time for Qstash Scheduling.
        :param pulumi.Input[int] retries: Retries for Qstash Schedule requests.
        """
        pulumi.set(__self__, "cron", cron)
        pulumi.set(__self__, "destination", destination)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if callback is not None:
            pulumi.set(__self__, "callback", callback)
        if content_based_deduplication is not None:
            pulumi.set(__self__, "content_based_deduplication", content_based_deduplication)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if deduplication_id is not None:
            pulumi.set(__self__, "deduplication_id", deduplication_id)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if forward_headers is not None:
            pulumi.set(__self__, "forward_headers", forward_headers)
        if not_before is not None:
            pulumi.set(__self__, "not_before", not_before)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)

    @property
    @pulumi.getter
    def cron(self) -> pulumi.Input[str]:
        """
        Cron string for Qstash Schedule
        """
        return pulumi.get(self, "cron")

    @cron.setter
    def cron(self, value: pulumi.Input[str]):
        pulumi.set(self, "cron", value)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input[str]:
        """
        Destination for Qstash Schedule. Either Topic ID or valid URL
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        """
        Body to send for the POST request in string format. Needs escaping (\) double quotes.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter
    def callback(self) -> Optional[pulumi.Input[str]]:
        """
        Callback URL for Qstash Schedule.
        """
        return pulumi.get(self, "callback")

    @callback.setter
    def callback(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "callback", value)

    @property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> Optional[pulumi.Input[bool]]:
        """
        Content Based Deduplication (bool) for Qstash Scheduling.
        """
        return pulumi.get(self, "content_based_deduplication")

    @content_based_deduplication.setter
    def content_based_deduplication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "content_based_deduplication", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        Content type for Qstash Scheduling.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="deduplicationId")
    def deduplication_id(self) -> Optional[pulumi.Input[str]]:
        """
        Deduplication ID for Qstash Scheduling.
        """
        return pulumi.get(self, "deduplication_id")

    @deduplication_id.setter
    def deduplication_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deduplication_id", value)

    @property
    @pulumi.getter
    def delay(self) -> Optional[pulumi.Input[str]]:
        """
        Delay for Qstash Schedule.
        """
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delay", value)

    @property
    @pulumi.getter(name="forwardHeaders")
    def forward_headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Forward headers to your API
        """
        return pulumi.get(self, "forward_headers")

    @forward_headers.setter
    def forward_headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "forward_headers", value)

    @property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> Optional[pulumi.Input[int]]:
        """
        Start time for Qstash Scheduling.
        """
        return pulumi.get(self, "not_before")

    @not_before.setter
    def not_before(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "not_before", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[int]]:
        """
        Retries for Qstash Schedule requests.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retries", value)


@pulumi.input_type
class _QStashScheduleState:
    def __init__(__self__, *,
                 body: Optional[pulumi.Input[str]] = None,
                 callback: Optional[pulumi.Input[str]] = None,
                 content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[int]] = None,
                 cron: Optional[pulumi.Input[str]] = None,
                 deduplication_id: Optional[pulumi.Input[str]] = None,
                 delay: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 forward_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 not_before: Optional[pulumi.Input[int]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 schedule_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering QStashSchedule resources.
        :param pulumi.Input[str] body: Body to send for the POST request in string format. Needs escaping (\) double quotes.
        :param pulumi.Input[str] callback: Callback URL for Qstash Schedule.
        :param pulumi.Input[bool] content_based_deduplication: Content Based Deduplication (bool) for Qstash Scheduling.
        :param pulumi.Input[str] content_type: Content type for Qstash Scheduling.
        :param pulumi.Input[int] created_at: Creation time for Qstash Schedule.
        :param pulumi.Input[str] cron: Cron string for Qstash Schedule
        :param pulumi.Input[str] deduplication_id: Deduplication ID for Qstash Scheduling.
        :param pulumi.Input[str] delay: Delay for Qstash Schedule.
        :param pulumi.Input[str] destination: Destination for Qstash Schedule. Either Topic ID or valid URL
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] forward_headers: Forward headers to your API
        :param pulumi.Input[int] not_before: Start time for Qstash Scheduling.
        :param pulumi.Input[int] retries: Retries for Qstash Schedule requests.
        :param pulumi.Input[str] schedule_id: Unique Qstash Schedule ID for requested schedule
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if callback is not None:
            pulumi.set(__self__, "callback", callback)
        if content_based_deduplication is not None:
            pulumi.set(__self__, "content_based_deduplication", content_based_deduplication)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if cron is not None:
            pulumi.set(__self__, "cron", cron)
        if deduplication_id is not None:
            pulumi.set(__self__, "deduplication_id", deduplication_id)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if forward_headers is not None:
            pulumi.set(__self__, "forward_headers", forward_headers)
        if not_before is not None:
            pulumi.set(__self__, "not_before", not_before)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if schedule_id is not None:
            pulumi.set(__self__, "schedule_id", schedule_id)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        """
        Body to send for the POST request in string format. Needs escaping (\) double quotes.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter
    def callback(self) -> Optional[pulumi.Input[str]]:
        """
        Callback URL for Qstash Schedule.
        """
        return pulumi.get(self, "callback")

    @callback.setter
    def callback(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "callback", value)

    @property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> Optional[pulumi.Input[bool]]:
        """
        Content Based Deduplication (bool) for Qstash Scheduling.
        """
        return pulumi.get(self, "content_based_deduplication")

    @content_based_deduplication.setter
    def content_based_deduplication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "content_based_deduplication", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        Content type for Qstash Scheduling.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[int]]:
        """
        Creation time for Qstash Schedule.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def cron(self) -> Optional[pulumi.Input[str]]:
        """
        Cron string for Qstash Schedule
        """
        return pulumi.get(self, "cron")

    @cron.setter
    def cron(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cron", value)

    @property
    @pulumi.getter(name="deduplicationId")
    def deduplication_id(self) -> Optional[pulumi.Input[str]]:
        """
        Deduplication ID for Qstash Scheduling.
        """
        return pulumi.get(self, "deduplication_id")

    @deduplication_id.setter
    def deduplication_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deduplication_id", value)

    @property
    @pulumi.getter
    def delay(self) -> Optional[pulumi.Input[str]]:
        """
        Delay for Qstash Schedule.
        """
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delay", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[str]]:
        """
        Destination for Qstash Schedule. Either Topic ID or valid URL
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="forwardHeaders")
    def forward_headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Forward headers to your API
        """
        return pulumi.get(self, "forward_headers")

    @forward_headers.setter
    def forward_headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "forward_headers", value)

    @property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> Optional[pulumi.Input[int]]:
        """
        Start time for Qstash Scheduling.
        """
        return pulumi.get(self, "not_before")

    @not_before.setter
    def not_before(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "not_before", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[int]]:
        """
        Retries for Qstash Schedule requests.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter(name="scheduleId")
    def schedule_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique Qstash Schedule ID for requested schedule
        """
        return pulumi.get(self, "schedule_id")

    @schedule_id.setter
    def schedule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_id", value)


class QStashSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 callback: Optional[pulumi.Input[str]] = None,
                 content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 cron: Optional[pulumi.Input[str]] = None,
                 deduplication_id: Optional[pulumi.Input[str]] = None,
                 delay: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 forward_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 not_before: Optional[pulumi.Input[int]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import upstash_pulumi as upstash

        example_qstash_schedule = upstash.QStashSchedule("exampleQstashSchedule",
            destination=resource["upstash_qstash_topic"]["exampleQstashTopic"]["topic_id"],
            cron="* * * * */2")
        # or simply provide a link
        # destination = "https://***.***"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] body: Body to send for the POST request in string format. Needs escaping (\) double quotes.
        :param pulumi.Input[str] callback: Callback URL for Qstash Schedule.
        :param pulumi.Input[bool] content_based_deduplication: Content Based Deduplication (bool) for Qstash Scheduling.
        :param pulumi.Input[str] content_type: Content type for Qstash Scheduling.
        :param pulumi.Input[str] cron: Cron string for Qstash Schedule
        :param pulumi.Input[str] deduplication_id: Deduplication ID for Qstash Scheduling.
        :param pulumi.Input[str] delay: Delay for Qstash Schedule.
        :param pulumi.Input[str] destination: Destination for Qstash Schedule. Either Topic ID or valid URL
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] forward_headers: Forward headers to your API
        :param pulumi.Input[int] not_before: Start time for Qstash Scheduling.
        :param pulumi.Input[int] retries: Retries for Qstash Schedule requests.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QStashScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import upstash_pulumi as upstash

        example_qstash_schedule = upstash.QStashSchedule("exampleQstashSchedule",
            destination=resource["upstash_qstash_topic"]["exampleQstashTopic"]["topic_id"],
            cron="* * * * */2")
        # or simply provide a link
        # destination = "https://***.***"
        ```

        :param str resource_name: The name of the resource.
        :param QStashScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QStashScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 callback: Optional[pulumi.Input[str]] = None,
                 content_based_deduplication: Optional[pulumi.Input[bool]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 cron: Optional[pulumi.Input[str]] = None,
                 deduplication_id: Optional[pulumi.Input[str]] = None,
                 delay: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 forward_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 not_before: Optional[pulumi.Input[int]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QStashScheduleArgs.__new__(QStashScheduleArgs)

            __props__.__dict__["body"] = body
            __props__.__dict__["callback"] = callback
            __props__.__dict__["content_based_deduplication"] = content_based_deduplication
            __props__.__dict__["content_type"] = content_type
            if cron is None and not opts.urn:
                raise TypeError("Missing required property 'cron'")
            __props__.__dict__["cron"] = cron
            __props__.__dict__["deduplication_id"] = deduplication_id
            __props__.__dict__["delay"] = delay
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["forward_headers"] = forward_headers
            __props__.__dict__["not_before"] = not_before
            __props__.__dict__["retries"] = retries
            __props__.__dict__["created_at"] = None
            __props__.__dict__["schedule_id"] = None
        super(QStashSchedule, __self__).__init__(
            'upstash:index/qStashSchedule:QStashSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            body: Optional[pulumi.Input[str]] = None,
            callback: Optional[pulumi.Input[str]] = None,
            content_based_deduplication: Optional[pulumi.Input[bool]] = None,
            content_type: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[int]] = None,
            cron: Optional[pulumi.Input[str]] = None,
            deduplication_id: Optional[pulumi.Input[str]] = None,
            delay: Optional[pulumi.Input[str]] = None,
            destination: Optional[pulumi.Input[str]] = None,
            forward_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            not_before: Optional[pulumi.Input[int]] = None,
            retries: Optional[pulumi.Input[int]] = None,
            schedule_id: Optional[pulumi.Input[str]] = None) -> 'QStashSchedule':
        """
        Get an existing QStashSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] body: Body to send for the POST request in string format. Needs escaping (\) double quotes.
        :param pulumi.Input[str] callback: Callback URL for Qstash Schedule.
        :param pulumi.Input[bool] content_based_deduplication: Content Based Deduplication (bool) for Qstash Scheduling.
        :param pulumi.Input[str] content_type: Content type for Qstash Scheduling.
        :param pulumi.Input[int] created_at: Creation time for Qstash Schedule.
        :param pulumi.Input[str] cron: Cron string for Qstash Schedule
        :param pulumi.Input[str] deduplication_id: Deduplication ID for Qstash Scheduling.
        :param pulumi.Input[str] delay: Delay for Qstash Schedule.
        :param pulumi.Input[str] destination: Destination for Qstash Schedule. Either Topic ID or valid URL
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] forward_headers: Forward headers to your API
        :param pulumi.Input[int] not_before: Start time for Qstash Scheduling.
        :param pulumi.Input[int] retries: Retries for Qstash Schedule requests.
        :param pulumi.Input[str] schedule_id: Unique Qstash Schedule ID for requested schedule
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QStashScheduleState.__new__(_QStashScheduleState)

        __props__.__dict__["body"] = body
        __props__.__dict__["callback"] = callback
        __props__.__dict__["content_based_deduplication"] = content_based_deduplication
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["cron"] = cron
        __props__.__dict__["deduplication_id"] = deduplication_id
        __props__.__dict__["delay"] = delay
        __props__.__dict__["destination"] = destination
        __props__.__dict__["forward_headers"] = forward_headers
        __props__.__dict__["not_before"] = not_before
        __props__.__dict__["retries"] = retries
        __props__.__dict__["schedule_id"] = schedule_id
        return QStashSchedule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def body(self) -> pulumi.Output[Optional[str]]:
        """
        Body to send for the POST request in string format. Needs escaping (\) double quotes.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def callback(self) -> pulumi.Output[Optional[str]]:
        """
        Callback URL for Qstash Schedule.
        """
        return pulumi.get(self, "callback")

    @property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> pulumi.Output[Optional[bool]]:
        """
        Content Based Deduplication (bool) for Qstash Scheduling.
        """
        return pulumi.get(self, "content_based_deduplication")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[Optional[str]]:
        """
        Content type for Qstash Scheduling.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[int]:
        """
        Creation time for Qstash Schedule.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def cron(self) -> pulumi.Output[str]:
        """
        Cron string for Qstash Schedule
        """
        return pulumi.get(self, "cron")

    @property
    @pulumi.getter(name="deduplicationId")
    def deduplication_id(self) -> pulumi.Output[Optional[str]]:
        """
        Deduplication ID for Qstash Scheduling.
        """
        return pulumi.get(self, "deduplication_id")

    @property
    @pulumi.getter
    def delay(self) -> pulumi.Output[Optional[str]]:
        """
        Delay for Qstash Schedule.
        """
        return pulumi.get(self, "delay")

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output[str]:
        """
        Destination for Qstash Schedule. Either Topic ID or valid URL
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="forwardHeaders")
    def forward_headers(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Forward headers to your API
        """
        return pulumi.get(self, "forward_headers")

    @property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> pulumi.Output[Optional[int]]:
        """
        Start time for Qstash Scheduling.
        """
        return pulumi.get(self, "not_before")

    @property
    @pulumi.getter
    def retries(self) -> pulumi.Output[Optional[int]]:
        """
        Retries for Qstash Schedule requests.
        """
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter(name="scheduleId")
    def schedule_id(self) -> pulumi.Output[str]:
        """
        Unique Qstash Schedule ID for requested schedule
        """
        return pulumi.get(self, "schedule_id")

