import { Resource } from "@cdktf/provider-null";
import { ITerraformDependable, TerraformProvider, TerraformResourceLifecycle } from "cdktf";
import { Construct } from "constructs";
export interface LocalExecOptions {
    readonly dependsOn?: ITerraformDependable[];
    readonly provider?: TerraformProvider;
    readonly lifecycle?: TerraformResourceLifecycle;
    readonly triggers?: {
        [key: string]: string;
    };
    /**
     * The command to run.
     */
    readonly command: string;
    /**
     * The working directory to run the command in.
     * Defaults to process.pwd().
     * If copyBeforeRun is set to true it will copy the working directory to an asset directory and take that as the base to run.
     */
    readonly cwd: string;
    /**
     * If set to true, the working directory will be copied to an asset directory.
     *
     * @default true
     */
    readonly copyBeforeRun?: boolean;
}
export { NullProvider as Provider } from "@cdktf/provider-null";
export declare class LocalExec extends Resource {
    cwd: string;
    command: string;
    constructor(scope: Construct, id: string, config: LocalExecOptions);
}
