<a id="mypy-boto3-machinelearning"></a>

# mypy-boto3-machinelearning

[![PyPI - mypy-boto3-machinelearning](https://img.shields.io/pypi/v/mypy-boto3-machinelearning.svg?color=blue)](https://pypi.org/project/mypy-boto3-machinelearning)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-machinelearning.svg?color=blue)](https://pypi.org/project/mypy-boto3-machinelearning)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/mypy-boto3-machinelearning?color=blue)](https://pypistats.org/packages/mypy-boto3-machinelearning)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.MachineLearning 1.19.12](https://boto3.amazonaws.com/v1/documentation/api/1.19.12/reference/services/machinelearning.html#MachineLearning)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.1.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-machinelearning docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_machinelearning/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-machinelearning](#mypy-boto3-machinelearning)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `MachineLearning` service.

```bash
python -m pip install boto3-stubs[machinelearning]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[machinelearning]` in your environment:
  `python -m pip install 'boto3-stubs[machinelearning]'`

Both type checking and auto-complete should work for `MachineLearning` service.
No explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[machinelearning]` in your environment:
  `python -m pip install 'boto3-stubs[machinelearning]'`

Both type checking and auto-complete should work for `MachineLearning` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[machinelearning]` in your environment:
  `python -m pip install 'boto3-stubs[machinelearning]'`
- Run `mypy` as usual

Type checking should work for `MachineLearning` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[machinelearning]` in your environment:
  `python -m pip install 'boto3-stubs[machinelearning]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `MachineLearning` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`MachineLearningClient` provides annotations for
`boto3.client("machinelearning")`.

```python
import boto3

from mypy_boto3_machinelearning import MachineLearningClient

client: MachineLearningClient = boto3.client("machinelearning")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: MachineLearningClient = session.client("machinelearning")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_machinelearning.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_machinelearning import MachineLearningClient
from mypy_boto3_machinelearning.paginator import (
    DescribeBatchPredictionsPaginator,
    DescribeDataSourcesPaginator,
    DescribeEvaluationsPaginator,
    DescribeMLModelsPaginator,
)

client: MachineLearningClient = boto3.client("machinelearning")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_batch_predictions_paginator: DescribeBatchPredictionsPaginator = client.get_paginator("describe_batch_predictions")
describe_data_sources_paginator: DescribeDataSourcesPaginator = client.get_paginator("describe_data_sources")
describe_evaluations_paginator: DescribeEvaluationsPaginator = client.get_paginator("describe_evaluations")
describe_ml_models_paginator: DescribeMLModelsPaginator = client.get_paginator("describe_ml_models")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_machinelearning.waiter` module contains type annotations for all
waiters.

```python
from mypy_boto3_machinelearning import MachineLearningClient
from mypy_boto3_machinelearning.waiter import (
    BatchPredictionAvailableWaiter,
    DataSourceAvailableWaiter,
    EvaluationAvailableWaiter,
    MLModelAvailableWaiter,
)

client: MachineLearningClient = boto3.client("machinelearning")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
batch_prediction_available_waiter: BatchPredictionAvailableWaiter = client.get_waiter("batch_prediction_available")
data_source_available_waiter: DataSourceAvailableWaiter = client.get_waiter("data_source_available")
evaluation_available_waiter: EvaluationAvailableWaiter = client.get_waiter("evaluation_available")
ml_model_available_waiter: MLModelAvailableWaiter = client.get_waiter("ml_model_available")
```

<a id="literals"></a>

### Literals

`mypy_boto3_machinelearning.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_machinelearning.literals import (
    AlgorithmType,
    BatchPredictionAvailableWaiterName,
    BatchPredictionFilterVariableType,
    DataSourceAvailableWaiterName,
    DataSourceFilterVariableType,
    DescribeBatchPredictionsPaginatorName,
    DescribeDataSourcesPaginatorName,
    DescribeEvaluationsPaginatorName,
    DescribeMLModelsPaginatorName,
    DetailsAttributesType,
    EntityStatusType,
    EvaluationAvailableWaiterName,
    EvaluationFilterVariableType,
    MLModelAvailableWaiterName,
    MLModelFilterVariableType,
    MLModelTypeType,
    RealtimeEndpointStatusType,
    SortOrderType,
    TaggableResourceTypeType,
    ServiceName,
    PaginatorName,
    WaiterName,
)

def check_value(value: AlgorithmType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_machinelearning.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_machinelearning.type_defs import (
    AddTagsInputRequestTypeDef,
    AddTagsOutputTypeDef,
    BatchPredictionTypeDef,
    CreateBatchPredictionInputRequestTypeDef,
    CreateBatchPredictionOutputTypeDef,
    CreateDataSourceFromRDSInputRequestTypeDef,
    CreateDataSourceFromRDSOutputTypeDef,
    CreateDataSourceFromRedshiftInputRequestTypeDef,
    CreateDataSourceFromRedshiftOutputTypeDef,
    CreateDataSourceFromS3InputRequestTypeDef,
    CreateDataSourceFromS3OutputTypeDef,
    CreateEvaluationInputRequestTypeDef,
    CreateEvaluationOutputTypeDef,
    CreateMLModelInputRequestTypeDef,
    CreateMLModelOutputTypeDef,
    CreateRealtimeEndpointInputRequestTypeDef,
    CreateRealtimeEndpointOutputTypeDef,
    DataSourceTypeDef,
    DeleteBatchPredictionInputRequestTypeDef,
    DeleteBatchPredictionOutputTypeDef,
    DeleteDataSourceInputRequestTypeDef,
    DeleteDataSourceOutputTypeDef,
    DeleteEvaluationInputRequestTypeDef,
    DeleteEvaluationOutputTypeDef,
    DeleteMLModelInputRequestTypeDef,
    DeleteMLModelOutputTypeDef,
    DeleteRealtimeEndpointInputRequestTypeDef,
    DeleteRealtimeEndpointOutputTypeDef,
    DeleteTagsInputRequestTypeDef,
    DeleteTagsOutputTypeDef,
    DescribeBatchPredictionsInputRequestTypeDef,
    DescribeBatchPredictionsOutputTypeDef,
    DescribeDataSourcesInputRequestTypeDef,
    DescribeDataSourcesOutputTypeDef,
    DescribeEvaluationsInputRequestTypeDef,
    DescribeEvaluationsOutputTypeDef,
    DescribeMLModelsInputRequestTypeDef,
    DescribeMLModelsOutputTypeDef,
    DescribeTagsInputRequestTypeDef,
    DescribeTagsOutputTypeDef,
    EvaluationTypeDef,
    GetBatchPredictionInputRequestTypeDef,
    GetBatchPredictionOutputTypeDef,
    GetDataSourceInputRequestTypeDef,
    GetDataSourceOutputTypeDef,
    GetEvaluationInputRequestTypeDef,
    GetEvaluationOutputTypeDef,
    GetMLModelInputRequestTypeDef,
    GetMLModelOutputTypeDef,
    MLModelTypeDef,
    PaginatorConfigTypeDef,
    PerformanceMetricsTypeDef,
    PredictInputRequestTypeDef,
    PredictOutputTypeDef,
    PredictionTypeDef,
    RDSDataSpecTypeDef,
    RDSDatabaseCredentialsTypeDef,
    RDSDatabaseTypeDef,
    RDSMetadataTypeDef,
    RealtimeEndpointInfoTypeDef,
    RedshiftDataSpecTypeDef,
    RedshiftDatabaseCredentialsTypeDef,
    RedshiftDatabaseTypeDef,
    RedshiftMetadataTypeDef,
    ResponseMetadataTypeDef,
    S3DataSpecTypeDef,
    TagTypeDef,
    UpdateBatchPredictionInputRequestTypeDef,
    UpdateBatchPredictionOutputTypeDef,
    UpdateDataSourceInputRequestTypeDef,
    UpdateDataSourceOutputTypeDef,
    UpdateEvaluationInputRequestTypeDef,
    UpdateEvaluationOutputTypeDef,
    UpdateMLModelInputRequestTypeDef,
    UpdateMLModelOutputTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AddTagsInputRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-machinelearning` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-machinelearning docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_machinelearning/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
