import { aws_iam as iam, aws_secretsmanager as secretsmanager, aws_kms as kms } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * The properties of a new set of SMTP Credentials
 */
export interface SesSmtpCredentialsProps {
    /**
     * The name of the IAM user to create
     */
    readonly iamUserName: string;
    /**
     * The resource policy to apply to the resulting secret
     */
    readonly secretResourcePolicy?: iam.PolicyDocument;
    /**
     * If a secret is pending deletion should it be restored?
     *
     * This helps in cases where cloudformation roll backs puts a secret in pending delete state.
     *
     * @default true
     */
    readonly restoreSecret?: boolean;
    /**
     * If a secret already exists should it be overwritten?
     *
     * This helps in cases where cloudformation creates a secret successfully but it gets orphaned for some reason.
     *
     * @default true
     */
    readonly overwriteSecret?: boolean;
    /**
     * The KMS key to use for the secret
     *
     * @default - default key
     */
    readonly kmsKey?: kms.IKey;
}
export declare class SesSmtpCredentials extends Construct {
    /**
     * The IAM user to which the SMTP credentials are attached.
     */
    readonly iamUser: iam.User;
    /**
     * The AWS secrets manager secret that contains the SMTP credentials.
     */
    readonly secret: secretsmanager.ISecret;
    constructor(scope: Construct, id: string, props: SesSmtpCredentialsProps);
}
