# coding: utf-8

"""
    VeeRoute.LSS Delivery

    VeeRoute.LSS Delivery API  # noqa: E501

    The version of the OpenAPI document: 3.5.162365
    Contact: support@veeroute.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from vrt_lss_delivery.configuration import Configuration


class Order(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'key': 'str',
        'type': 'OrderType',
        'warehouse_keys': 'list[str]',
        'customer': 'Customer',
        'cargos': 'list[Cargo]',
        'warehouse_duration': 'float',
        'customer_duration': 'float',
        'cost': 'OrderCost',
        'order_features': 'list[str]',
        'order_restrictions': 'list[str]',
        'performer_restrictions': 'list[str]',
        'performer_blacklist': 'list[str]'
    }

    attribute_map = {
        'key': 'key',
        'type': 'type',
        'warehouse_keys': 'warehouse_keys',
        'customer': 'customer',
        'cargos': 'cargos',
        'warehouse_duration': 'warehouse_duration',
        'customer_duration': 'customer_duration',
        'cost': 'cost',
        'order_features': 'order_features',
        'order_restrictions': 'order_restrictions',
        'performer_restrictions': 'performer_restrictions',
        'performer_blacklist': 'performer_blacklist'
    }

    def __init__(self, key=None, type=None, warehouse_keys=None, customer=None, cargos=None, warehouse_duration=0, customer_duration=0, cost=None, order_features=None, order_restrictions=None, performer_restrictions=[], performer_blacklist=[], local_vars_configuration=None):  # noqa: E501
        """Order - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._key = None
        self._type = None
        self._warehouse_keys = None
        self._customer = None
        self._cargos = None
        self._warehouse_duration = None
        self._customer_duration = None
        self._cost = None
        self._order_features = None
        self._order_restrictions = None
        self._performer_restrictions = None
        self._performer_blacklist = None
        self.discriminator = None

        self.key = key
        if type is not None:
            self.type = type
        self.warehouse_keys = warehouse_keys
        self.customer = customer
        self.cargos = cargos
        if warehouse_duration is not None:
            self.warehouse_duration = warehouse_duration
        if customer_duration is not None:
            self.customer_duration = customer_duration
        if cost is not None:
            self.cost = cost
        if order_features is not None:
            self.order_features = order_features
        if order_restrictions is not None:
            self.order_restrictions = order_restrictions
        if performer_restrictions is not None:
            self.performer_restrictions = performer_restrictions
        if performer_blacklist is not None:
            self.performer_blacklist = performer_blacklist

    @property
    def key(self):
        """Gets the key of this Order.  # noqa: E501

        Order key. unique ID.  # noqa: E501

        :return: The key of this Order.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this Order.

        Order key. unique ID.  # noqa: E501

        :param key: The key of this Order.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and key is None:  # noqa: E501
            raise ValueError("Invalid value for `key`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                key is not None and len(key) > 1024):
            raise ValueError("Invalid value for `key`, length must be less than or equal to `1024`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                key is not None and len(key) < 1):
            raise ValueError("Invalid value for `key`, length must be greater than or equal to `1`")  # noqa: E501

        self._key = key

    @property
    def type(self):
        """Gets the type of this Order.  # noqa: E501


        :return: The type of this Order.  # noqa: E501
        :rtype: OrderType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Order.


        :param type: The type of this Order.  # noqa: E501
        :type: OrderType
        """

        self._type = type

    @property
    def warehouse_keys(self):
        """Gets the warehouse_keys of this Order.  # noqa: E501

        List of possible warehouses for cargo pickup or drop.  # noqa: E501

        :return: The warehouse_keys of this Order.  # noqa: E501
        :rtype: list[str]
        """
        return self._warehouse_keys

    @warehouse_keys.setter
    def warehouse_keys(self, warehouse_keys):
        """Sets the warehouse_keys of this Order.

        List of possible warehouses for cargo pickup or drop.  # noqa: E501

        :param warehouse_keys: The warehouse_keys of this Order.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and warehouse_keys is None:  # noqa: E501
            raise ValueError("Invalid value for `warehouse_keys`, must not be `None`")  # noqa: E501

        self._warehouse_keys = warehouse_keys

    @property
    def customer(self):
        """Gets the customer of this Order.  # noqa: E501


        :return: The customer of this Order.  # noqa: E501
        :rtype: Customer
        """
        return self._customer

    @customer.setter
    def customer(self, customer):
        """Sets the customer of this Order.


        :param customer: The customer of this Order.  # noqa: E501
        :type: Customer
        """
        if self.local_vars_configuration.client_side_validation and customer is None:  # noqa: E501
            raise ValueError("Invalid value for `customer`, must not be `None`")  # noqa: E501

        self._customer = customer

    @property
    def cargos(self):
        """Gets the cargos of this Order.  # noqa: E501

        Cargoes list. All mentioned cargoes are delivered from one location to other by one performer during one trip.   # noqa: E501

        :return: The cargos of this Order.  # noqa: E501
        :rtype: list[Cargo]
        """
        return self._cargos

    @cargos.setter
    def cargos(self, cargos):
        """Sets the cargos of this Order.

        Cargoes list. All mentioned cargoes are delivered from one location to other by one performer during one trip.   # noqa: E501

        :param cargos: The cargos of this Order.  # noqa: E501
        :type: list[Cargo]
        """
        if self.local_vars_configuration.client_side_validation and cargos is None:  # noqa: E501
            raise ValueError("Invalid value for `cargos`, must not be `None`")  # noqa: E501

        self._cargos = cargos

    @property
    def warehouse_duration(self):
        """Gets the warehouse_duration of this Order.  # noqa: E501

        Average pickup time for all cargoes in one trip, in minutes.  # noqa: E501

        :return: The warehouse_duration of this Order.  # noqa: E501
        :rtype: float
        """
        return self._warehouse_duration

    @warehouse_duration.setter
    def warehouse_duration(self, warehouse_duration):
        """Sets the warehouse_duration of this Order.

        Average pickup time for all cargoes in one trip, in minutes.  # noqa: E501

        :param warehouse_duration: The warehouse_duration of this Order.  # noqa: E501
        :type: float
        """
        if (self.local_vars_configuration.client_side_validation and
                warehouse_duration is not None and warehouse_duration > 43800):  # noqa: E501
            raise ValueError("Invalid value for `warehouse_duration`, must be a value less than or equal to `43800`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                warehouse_duration is not None and warehouse_duration < 0):  # noqa: E501
            raise ValueError("Invalid value for `warehouse_duration`, must be a value greater than or equal to `0`")  # noqa: E501

        self._warehouse_duration = warehouse_duration

    @property
    def customer_duration(self):
        """Gets the customer_duration of this Order.  # noqa: E501

        Average drop time for all cargoes in one trip, in minutes.  # noqa: E501

        :return: The customer_duration of this Order.  # noqa: E501
        :rtype: float
        """
        return self._customer_duration

    @customer_duration.setter
    def customer_duration(self, customer_duration):
        """Sets the customer_duration of this Order.

        Average drop time for all cargoes in one trip, in minutes.  # noqa: E501

        :param customer_duration: The customer_duration of this Order.  # noqa: E501
        :type: float
        """
        if (self.local_vars_configuration.client_side_validation and
                customer_duration is not None and customer_duration > 43800):  # noqa: E501
            raise ValueError("Invalid value for `customer_duration`, must be a value less than or equal to `43800`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                customer_duration is not None and customer_duration < 0):  # noqa: E501
            raise ValueError("Invalid value for `customer_duration`, must be a value greater than or equal to `0`")  # noqa: E501

        self._customer_duration = customer_duration

    @property
    def cost(self):
        """Gets the cost of this Order.  # noqa: E501


        :return: The cost of this Order.  # noqa: E501
        :rtype: OrderCost
        """
        return self._cost

    @cost.setter
    def cost(self, cost):
        """Sets the cost of this Order.


        :param cost: The cost of this Order.  # noqa: E501
        :type: OrderCost
        """

        self._cost = cost

    @property
    def order_features(self):
        """Gets the order_features of this Order.  # noqa: E501

        Order features list.  # noqa: E501

        :return: The order_features of this Order.  # noqa: E501
        :rtype: list[str]
        """
        return self._order_features

    @order_features.setter
    def order_features(self, order_features):
        """Sets the order_features of this Order.

        Order features list.  # noqa: E501

        :param order_features: The order_features of this Order.  # noqa: E501
        :type: list[str]
        """

        self._order_features = order_features

    @property
    def order_restrictions(self):
        """Gets the order_restrictions of this Order.  # noqa: E501

        List of requirements for an order being delivered during the same trip.  # noqa: E501

        :return: The order_restrictions of this Order.  # noqa: E501
        :rtype: list[str]
        """
        return self._order_restrictions

    @order_restrictions.setter
    def order_restrictions(self, order_restrictions):
        """Sets the order_restrictions of this Order.

        List of requirements for an order being delivered during the same trip.  # noqa: E501

        :param order_restrictions: The order_restrictions of this Order.  # noqa: E501
        :type: list[str]
        """

        self._order_restrictions = order_restrictions

    @property
    def performer_restrictions(self):
        """Gets the performer_restrictions of this Order.  # noqa: E501

        Requirements list for the performer. Used for checking the compatibility of the performer and the order (work).   # noqa: E501

        :return: The performer_restrictions of this Order.  # noqa: E501
        :rtype: list[str]
        """
        return self._performer_restrictions

    @performer_restrictions.setter
    def performer_restrictions(self, performer_restrictions):
        """Sets the performer_restrictions of this Order.

        Requirements list for the performer. Used for checking the compatibility of the performer and the order (work).   # noqa: E501

        :param performer_restrictions: The performer_restrictions of this Order.  # noqa: E501
        :type: list[str]
        """

        self._performer_restrictions = performer_restrictions

    @property
    def performer_blacklist(self):
        """Gets the performer_blacklist of this Order.  # noqa: E501

        A list of requirements that the performer is not allowed to have. Used for checking the compatibility of the performer and the order (work). This list should not intersect with `performer_restrictions`.   # noqa: E501

        :return: The performer_blacklist of this Order.  # noqa: E501
        :rtype: list[str]
        """
        return self._performer_blacklist

    @performer_blacklist.setter
    def performer_blacklist(self, performer_blacklist):
        """Sets the performer_blacklist of this Order.

        A list of requirements that the performer is not allowed to have. Used for checking the compatibility of the performer and the order (work). This list should not intersect with `performer_restrictions`.   # noqa: E501

        :param performer_blacklist: The performer_blacklist of this Order.  # noqa: E501
        :type: list[str]
        """

        self._performer_blacklist = performer_blacklist

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Order):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Order):
            return True

        return self.to_dict() != other.to_dict()
