import os

DEFAULT_ENDPOINTS_PATH = "endpoints.yml"
DEFAULT_CREDENTIALS_PATH = "credentials.yml"
DEFAULT_CONFIG_PATH = "config.yml"
DEFAULT_DOMAIN_PATH = "domain.yml"
DEFAULT_ACTIONS_PATH = "actions"
DEFAULT_MODELS_PATH = "models"
DEFAULT_DATA_PATH = "data"
DEFAULT_RESULTS_PATH = "results"
DEFAULT_NLU_RESULTS_PATH = "nlu_comparison_results"
DEFAULT_CORE_SUBDIRECTORY_NAME = "core"
DEFAULT_REQUEST_TIMEOUT = 60 * 5  # 5 minutes

TEST_DATA_FILE = "test.md"
TRAIN_DATA_FILE = "train.md"
RESULTS_FILE = "results.json"
NUMBER_OF_TRAINING_STORIES_FILE = "num_stories.json"
PERCENTAGE_KEY = "__percentage__"

PACKAGE_NAME = "rasa"

CONFIG_SCHEMA_FILE = "nlu/schemas/config.yml"
DOMAIN_SCHEMA_FILE = "core/schemas/domain.yml"

DEFAULT_RASA_X_PORT = 5002
DEFAULT_RASA_PORT = 5005

DOCS_BASE_URL = "https://rasa.com/docs/rasa"
LEGACY_DOCS_BASE_URL = "http://legacy-docs.rasa.com"

CONFIG_MANDATORY_KEYS_CORE = ["policies"]
CONFIG_MANDATORY_KEYS_NLU = ["language", "pipeline"]
CONFIG_MANDATORY_KEYS = CONFIG_MANDATORY_KEYS_CORE + CONFIG_MANDATORY_KEYS_NLU

MINIMUM_COMPATIBLE_VERSION = "1.3.0a2"

GLOBAL_USER_CONFIG_PATH = os.path.expanduser("~/.config/rasa/global.yml")

DEFAULT_LOG_LEVEL = "INFO"
DEFAULT_LOG_LEVEL_RASA_X = "WARNING"
DEFAULT_LOG_LEVEL_LIBRARIES = "ERROR"
LOG_LEVEL = "LOG_LEVEL"
LOG_LEVEL_LIBRARIES = "LOG_LEVEL_LIBRARIES"

DEFAULT_SANIC_WORKERS = 1
SANIC_WORKERS = "SANIC_WORKERS"

ENV_JAEGER_REPORTING_HOST = os.environ.get('JAEGER_REPORTING_HOST', 'dplai01.vail')
ENV_JAEGER_REPORTING_PORT = os.environ.get('JAEGER_REPORTING_PORT', '6831')
ENV_SANIC_BACKLOG = int(os.environ.get("SANIC_BACKLOG", "100"))
ENV_ENABLE_JSON_LOGGING = os.environ.get('ENABLE_JSON_LOGGING', False)
ENV_LOG_LEVEL = os.environ.get('LOG_LEVEL', 'INFO')
ENV_READY_CHECK_OFF = os.environ.get('READY_CHECK_OFF', None)
ENV_LOCK_LIFETIME = int(os.environ.get("TICKET_LOCK_LIFETIME", 60))
ENV_MAX_NUMBER_OF_PREDICTIONS = int(os.environ.get("MAX_NUMBER_OF_PREDICTIONS", "10"))
ENV_MAX_PARTIALS_PROCESSED = int(os.environ.get("MAX_PARTIALS_PROCESSED", 2))
ENV_SANIC_WORKERS = os.environ.get("SANIC_WORKERS")
ENV_KEEP_ALIVE_TIMEOUT = int(os.environ.get("KEEP_ALIVE_TIMEOUT", 5))
ENV_SANIC_KEEP_ALIVE = os.environ.get("SANIC_KEEP_ALIVE", True) != "False"
ENV_SANIC_ACCESS_LOG = os.environ.get("SANIC_ACCESS_LOG", False)
ENV_SANIC_DEBUG_MODE = os.environ.get("SANIC_DEBUG_MODE", False)
ENV_RABBITMQ_SSL_CLIENT_CERTIFICATE = os.environ.get("RABBITMQ_SSL_CLIENT_CERTIFICATE")
ENV_RABBITMQ_SSL_CLIENT_KEY = os.environ.get("RABBITMQ_SSL_CLIENT_KEY")
ENV_RABBITMQ_SSL_CA_FILE = os.environ.get("RABBITMQ_SSL_CA_FILE")
ENV_RABBITMQ_SSL_KEY_PASSWORD = os.environ.get("RABBITMQ_SSL_KEY_PASSWORD")
ENV_LOG_LEVEL_LIBRARIES = os.environ.get("LOG_LEVEL_LIBRARIES", "ERROR")
ENV_RASA_ENVIRONMENT = os.environ.get("RASA_ENVIRONMENT")
ENV_AUTHENTICATION_STATE = os.environ.get('AUTHENTICATION_STATE', 'authentication_form')
ENV_REDIS_SOCKET_TIMEOUT = float(os.environ.get('REDIS_SOCKET_TIMEOUT', 2.0))
ENV_SKIP_FULL_COVERAGE_CHECK = bool(os.environ.get('SKIP_FULL_COVERAGE_CHECK', True))
ENV_DB_SCHEMA = os.environ.get('DB_SCHEMA', 'dbo')
ENV_SQL_POOL_SIZE = int(os.environ.get("SQL_POOL_SIZE", "50"))
ENV_SQL_MAX_OVERFLOW = int(os.environ.get("SQL_MAX_OVERFLOW", "100"))
ENV_OMNI_API_URL = os.environ.get("OMNI_API_URL", "http://omni-api:80")
ENV_CHANNEL_ID = os.environ.get("CHANNEL_ID", 3)
ENV_BUCKET_NAME = os.environ.get("BUCKET_NAME")
ENV_AWS_ENDPOINT_URL = os.environ.get("AWS_ENDPOINT_URL")
ENV_AZURE_CONTAINER = os.environ.get("AZURE_CONTAINER")
ENV_AZURE_ACCOUNT_NAME = os.environ.get("AZURE_ACCOUNT_NAME")
ENV_AZURE_ACCOUNT_KEY = os.environ.get("AZURE_ACCOUNT_KEY")
ENV_RASA_DUCKLING_HTTP_URL = os.environ.get("RASA_DUCKLING_HTTP_URL")
ENV_TRAVIS_TAG = os.environ.get("TRAVIS_TAG")
ENV_GITHUB_TOKEN = os.environ.get("GITHUB_TOKEN")
ENV_TRAVIS_REPO_SLUG = os.environ.get("TRAVIS_REPO_SLUG")
ENV_IDENTITY_PROVIDER_HOST = os.environ.get("IDENTITY_PROVIDER_HOST")
ENV_IDENTITY_PROVIDER_PORT = os.environ.get("IDENTITY_PROVIDER_PORT")