# -*- coding: utf-8 -*-
"""
    author: jiege
    url: http://jieguone.top
    copyright: © jieguone.top
    license: none
    date : 2019/4/8 20:34
    ide : PyCharm
"""
import logging
import os
from logging import handlers
from jgpycshare.DateTime import DateTime


class LogTools(object):

    @staticmethod
    def get_logger(channel__name, level):
        filename = DateTime.Now().ToString('%Y%m%d')
        filepath = os.getcwd() + '/Log/' + channel__name
        if not os.path.exists(filepath):
            os.makedirs(filepath)
        log = LogTools(filepath + '/' + filename + '.txt', level=level)
        return log.logger

    level_relations = {
        'debug': logging.DEBUG,
        'info': logging.INFO,
        'warning': logging.WARNING,
        'error': logging.ERROR,
        'crit': logging.CRITICAL
    }  # 日志级别关系映射

    def __init__(self, filename, level='info', when='D', backCount=100, fmt='[%(asctime)s]-%(levelname)s:%(message)s'):
        self.logger = logging.getLogger(filename)
        format_str = logging.Formatter(fmt)  # 设置日志格式
        self.logger.setLevel(self.level_relations.get(level))  # 设置日志级别
        sh = logging.StreamHandler()  # 往屏幕上输出
        sh.setFormatter(format_str)  # 设置屏幕上显示的格式
        th = handlers.TimedRotatingFileHandler(filename=filename, when=when, backupCount=backCount,
                                               encoding='utf-8')  # 往文件里写入#指定间隔时间自动生成文件的处理器
        # 实例化TimedRotatingFileHandler
        # interval是时间间隔，backupCount是备份文件的个数，如果超过这个个数，就会自动删除，when是间隔的时间单位，单位有以下几种：
        # S 秒
        # M 分
        # H 小时、
        # D 天、
        # W 每星期（interval==0时代表星期一）
        # midnight 每天凌晨
        th.setFormatter(format_str)  # 设置文件里写入的格式
        self.logger.addHandler(sh)  # 把对象加到logger里
        self.logger.addHandler(th)


# if __name__ == '__main__':
#     log = LogTools.get_logger('info','info')
#     log.info('asdfsadf')