import { S as SvelteComponent, i as init, s as safe_not_equal, a as svg_element, b as attr, c as insert, d as append, n as noop, e as detach, f as element, h as text, Y as set_style, aa as add_render_callback, ad as add_resize_listener, j as set_data, m as space, o as destroy_each, k as empty, I as action_destroyer, g as is_function, A as createEventDispatcher, a9 as onMount, a2 as colors, q as create_component, u as mount_component, v as transition_in, w as transition_out, x as destroy_component, K as component_subscribe, X, L as assign, M as StatusTracker, N as get_spread_update, O as get_spread_object, y as group_outros, z as check_outros } from './index.8b5dc707.js';
import { U as Upload } from './Upload.1447ba6c.js';
import { B as Block } from './Block.65d4cff8.js';
import { B as BlockLabel } from './BlockLabel.a8dcb76f.js';
import { g as get_next_color } from './color.ff571f56.js';
import { d as dsvFormat } from './dsv.7fe76a93.js';
import './styles.db46e346.js';

/* home/runner/work/gradio/gradio/ui/packages/icons/src/Chart.svelte generated by Svelte v3.49.0 */

function create_fragment$3(ctx) {
	let svg;
	let line0;
	let line1;
	let line2;

	return {
		c() {
			svg = svg_element("svg");
			line0 = svg_element("line");
			line1 = svg_element("line");
			line2 = svg_element("line");
			attr(line0, "x1", "18");
			attr(line0, "y1", "20");
			attr(line0, "x2", "18");
			attr(line0, "y2", "10");
			attr(line1, "x1", "12");
			attr(line1, "y1", "20");
			attr(line1, "x2", "12");
			attr(line1, "y2", "4");
			attr(line2, "x1", "6");
			attr(line2, "y1", "20");
			attr(line2, "x2", "6");
			attr(line2, "y2", "14");
			attr(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr(svg, "width", "100%");
			attr(svg, "height", "100%");
			attr(svg, "viewBox", "0 0 24 24");
			attr(svg, "fill", "none");
			attr(svg, "stroke", "currentColor");
			attr(svg, "stroke-width", "1.5");
			attr(svg, "stroke-linecap", "round");
			attr(svg, "stroke-linejoin", "round");
			attr(svg, "class", "feather feather-bar-chart-2");
		},
		m(target, anchor) {
			insert(target, svg, anchor);
			append(svg, line0);
			append(svg, line1);
			append(svg, line2);
		},
		p: noop,
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(svg);
		}
	};
}

class Chart$1 extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, null, create_fragment$3, safe_not_equal, {});
	}
}

var csv = dsvFormat(",");

var csvParse = csv.parse;

function ascending(a, b) {
  return a == null || b == null ? NaN : a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
}

function bisector(f) {
  let delta = f;
  let compare1 = f;
  let compare2 = f;

  if (f.length !== 2) {
    delta = (d, x) => f(d) - x;
    compare1 = ascending;
    compare2 = (d, x) => ascending(f(d), x);
  }

  function left(a, x, lo = 0, hi = a.length) {
    if (lo < hi) {
      if (compare1(x, x) !== 0) return hi;
      do {
        const mid = (lo + hi) >>> 1;
        if (compare2(a[mid], x) < 0) lo = mid + 1;
        else hi = mid;
      } while (lo < hi);
    }
    return lo;
  }

  function right(a, x, lo = 0, hi = a.length) {
    if (lo < hi) {
      if (compare1(x, x) !== 0) return hi;
      do {
        const mid = (lo + hi) >>> 1;
        if (compare2(a[mid], x) <= 0) lo = mid + 1;
        else hi = mid;
      } while (lo < hi);
    }
    return lo;
  }

  function center(a, x, lo = 0, hi = a.length) {
    const i = left(a, x, lo, hi - 1);
    return i > lo && delta(a[i - 1], x) > -delta(a[i], x) ? i - 1 : i;
  }

  return {left, center, right};
}

function number$1(x) {
  return x === null ? NaN : +x;
}

const ascendingBisect = bisector(ascending);
const bisectRight = ascendingBisect.right;
bisector(number$1).center;
var bisect = bisectRight;

var e10 = Math.sqrt(50),
    e5 = Math.sqrt(10),
    e2 = Math.sqrt(2);

function ticks(start, stop, count) {
  var reverse,
      i = -1,
      n,
      ticks,
      step;

  stop = +stop, start = +start, count = +count;
  if (start === stop && count > 0) return [start];
  if (reverse = stop < start) n = start, start = stop, stop = n;
  if ((step = tickIncrement(start, stop, count)) === 0 || !isFinite(step)) return [];

  if (step > 0) {
    let r0 = Math.round(start / step), r1 = Math.round(stop / step);
    if (r0 * step < start) ++r0;
    if (r1 * step > stop) --r1;
    ticks = new Array(n = r1 - r0 + 1);
    while (++i < n) ticks[i] = (r0 + i) * step;
  } else {
    step = -step;
    let r0 = Math.round(start * step), r1 = Math.round(stop * step);
    if (r0 / step < start) ++r0;
    if (r1 / step > stop) --r1;
    ticks = new Array(n = r1 - r0 + 1);
    while (++i < n) ticks[i] = (r0 + i) / step;
  }

  if (reverse) ticks.reverse();

  return ticks;
}

function tickIncrement(start, stop, count) {
  var step = (stop - start) / Math.max(0, count),
      power = Math.floor(Math.log(step) / Math.LN10),
      error = step / Math.pow(10, power);
  return power >= 0
      ? (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1) * Math.pow(10, power)
      : -Math.pow(10, -power) / (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1);
}

function tickStep(start, stop, count) {
  var step0 = Math.abs(stop - start) / Math.max(0, count),
      step1 = Math.pow(10, Math.floor(Math.log(step0) / Math.LN10)),
      error = step0 / step1;
  if (error >= e10) step1 *= 10;
  else if (error >= e5) step1 *= 5;
  else if (error >= e2) step1 *= 2;
  return stop < start ? -step1 : step1;
}

function initRange(domain, range) {
  switch (arguments.length) {
    case 0: break;
    case 1: this.range(domain); break;
    default: this.range(range).domain(domain); break;
  }
  return this;
}

function define(constructor, factory, prototype) {
  constructor.prototype = factory.prototype = prototype;
  prototype.constructor = constructor;
}

function extend(parent, definition) {
  var prototype = Object.create(parent.prototype);
  for (var key in definition) prototype[key] = definition[key];
  return prototype;
}

function Color() {}

var darker = 0.7;
var brighter = 1 / darker;

var reI = "\\s*([+-]?\\d+)\\s*",
    reN = "\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)\\s*",
    reP = "\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)%\\s*",
    reHex = /^#([0-9a-f]{3,8})$/,
    reRgbInteger = new RegExp("^rgb\\(" + [reI, reI, reI] + "\\)$"),
    reRgbPercent = new RegExp("^rgb\\(" + [reP, reP, reP] + "\\)$"),
    reRgbaInteger = new RegExp("^rgba\\(" + [reI, reI, reI, reN] + "\\)$"),
    reRgbaPercent = new RegExp("^rgba\\(" + [reP, reP, reP, reN] + "\\)$"),
    reHslPercent = new RegExp("^hsl\\(" + [reN, reP, reP] + "\\)$"),
    reHslaPercent = new RegExp("^hsla\\(" + [reN, reP, reP, reN] + "\\)$");

var named = {
  aliceblue: 0xf0f8ff,
  antiquewhite: 0xfaebd7,
  aqua: 0x00ffff,
  aquamarine: 0x7fffd4,
  azure: 0xf0ffff,
  beige: 0xf5f5dc,
  bisque: 0xffe4c4,
  black: 0x000000,
  blanchedalmond: 0xffebcd,
  blue: 0x0000ff,
  blueviolet: 0x8a2be2,
  brown: 0xa52a2a,
  burlywood: 0xdeb887,
  cadetblue: 0x5f9ea0,
  chartreuse: 0x7fff00,
  chocolate: 0xd2691e,
  coral: 0xff7f50,
  cornflowerblue: 0x6495ed,
  cornsilk: 0xfff8dc,
  crimson: 0xdc143c,
  cyan: 0x00ffff,
  darkblue: 0x00008b,
  darkcyan: 0x008b8b,
  darkgoldenrod: 0xb8860b,
  darkgray: 0xa9a9a9,
  darkgreen: 0x006400,
  darkgrey: 0xa9a9a9,
  darkkhaki: 0xbdb76b,
  darkmagenta: 0x8b008b,
  darkolivegreen: 0x556b2f,
  darkorange: 0xff8c00,
  darkorchid: 0x9932cc,
  darkred: 0x8b0000,
  darksalmon: 0xe9967a,
  darkseagreen: 0x8fbc8f,
  darkslateblue: 0x483d8b,
  darkslategray: 0x2f4f4f,
  darkslategrey: 0x2f4f4f,
  darkturquoise: 0x00ced1,
  darkviolet: 0x9400d3,
  deeppink: 0xff1493,
  deepskyblue: 0x00bfff,
  dimgray: 0x696969,
  dimgrey: 0x696969,
  dodgerblue: 0x1e90ff,
  firebrick: 0xb22222,
  floralwhite: 0xfffaf0,
  forestgreen: 0x228b22,
  fuchsia: 0xff00ff,
  gainsboro: 0xdcdcdc,
  ghostwhite: 0xf8f8ff,
  gold: 0xffd700,
  goldenrod: 0xdaa520,
  gray: 0x808080,
  green: 0x008000,
  greenyellow: 0xadff2f,
  grey: 0x808080,
  honeydew: 0xf0fff0,
  hotpink: 0xff69b4,
  indianred: 0xcd5c5c,
  indigo: 0x4b0082,
  ivory: 0xfffff0,
  khaki: 0xf0e68c,
  lavender: 0xe6e6fa,
  lavenderblush: 0xfff0f5,
  lawngreen: 0x7cfc00,
  lemonchiffon: 0xfffacd,
  lightblue: 0xadd8e6,
  lightcoral: 0xf08080,
  lightcyan: 0xe0ffff,
  lightgoldenrodyellow: 0xfafad2,
  lightgray: 0xd3d3d3,
  lightgreen: 0x90ee90,
  lightgrey: 0xd3d3d3,
  lightpink: 0xffb6c1,
  lightsalmon: 0xffa07a,
  lightseagreen: 0x20b2aa,
  lightskyblue: 0x87cefa,
  lightslategray: 0x778899,
  lightslategrey: 0x778899,
  lightsteelblue: 0xb0c4de,
  lightyellow: 0xffffe0,
  lime: 0x00ff00,
  limegreen: 0x32cd32,
  linen: 0xfaf0e6,
  magenta: 0xff00ff,
  maroon: 0x800000,
  mediumaquamarine: 0x66cdaa,
  mediumblue: 0x0000cd,
  mediumorchid: 0xba55d3,
  mediumpurple: 0x9370db,
  mediumseagreen: 0x3cb371,
  mediumslateblue: 0x7b68ee,
  mediumspringgreen: 0x00fa9a,
  mediumturquoise: 0x48d1cc,
  mediumvioletred: 0xc71585,
  midnightblue: 0x191970,
  mintcream: 0xf5fffa,
  mistyrose: 0xffe4e1,
  moccasin: 0xffe4b5,
  navajowhite: 0xffdead,
  navy: 0x000080,
  oldlace: 0xfdf5e6,
  olive: 0x808000,
  olivedrab: 0x6b8e23,
  orange: 0xffa500,
  orangered: 0xff4500,
  orchid: 0xda70d6,
  palegoldenrod: 0xeee8aa,
  palegreen: 0x98fb98,
  paleturquoise: 0xafeeee,
  palevioletred: 0xdb7093,
  papayawhip: 0xffefd5,
  peachpuff: 0xffdab9,
  peru: 0xcd853f,
  pink: 0xffc0cb,
  plum: 0xdda0dd,
  powderblue: 0xb0e0e6,
  purple: 0x800080,
  rebeccapurple: 0x663399,
  red: 0xff0000,
  rosybrown: 0xbc8f8f,
  royalblue: 0x4169e1,
  saddlebrown: 0x8b4513,
  salmon: 0xfa8072,
  sandybrown: 0xf4a460,
  seagreen: 0x2e8b57,
  seashell: 0xfff5ee,
  sienna: 0xa0522d,
  silver: 0xc0c0c0,
  skyblue: 0x87ceeb,
  slateblue: 0x6a5acd,
  slategray: 0x708090,
  slategrey: 0x708090,
  snow: 0xfffafa,
  springgreen: 0x00ff7f,
  steelblue: 0x4682b4,
  tan: 0xd2b48c,
  teal: 0x008080,
  thistle: 0xd8bfd8,
  tomato: 0xff6347,
  turquoise: 0x40e0d0,
  violet: 0xee82ee,
  wheat: 0xf5deb3,
  white: 0xffffff,
  whitesmoke: 0xf5f5f5,
  yellow: 0xffff00,
  yellowgreen: 0x9acd32
};

define(Color, color, {
  copy: function(channels) {
    return Object.assign(new this.constructor, this, channels);
  },
  displayable: function() {
    return this.rgb().displayable();
  },
  hex: color_formatHex, // Deprecated! Use color.formatHex.
  formatHex: color_formatHex,
  formatHsl: color_formatHsl,
  formatRgb: color_formatRgb,
  toString: color_formatRgb
});

function color_formatHex() {
  return this.rgb().formatHex();
}

function color_formatHsl() {
  return hslConvert(this).formatHsl();
}

function color_formatRgb() {
  return this.rgb().formatRgb();
}

function color(format) {
  var m, l;
  format = (format + "").trim().toLowerCase();
  return (m = reHex.exec(format)) ? (l = m[1].length, m = parseInt(m[1], 16), l === 6 ? rgbn(m) // #ff0000
      : l === 3 ? new Rgb((m >> 8 & 0xf) | (m >> 4 & 0xf0), (m >> 4 & 0xf) | (m & 0xf0), ((m & 0xf) << 4) | (m & 0xf), 1) // #f00
      : l === 8 ? rgba(m >> 24 & 0xff, m >> 16 & 0xff, m >> 8 & 0xff, (m & 0xff) / 0xff) // #ff000000
      : l === 4 ? rgba((m >> 12 & 0xf) | (m >> 8 & 0xf0), (m >> 8 & 0xf) | (m >> 4 & 0xf0), (m >> 4 & 0xf) | (m & 0xf0), (((m & 0xf) << 4) | (m & 0xf)) / 0xff) // #f000
      : null) // invalid hex
      : (m = reRgbInteger.exec(format)) ? new Rgb(m[1], m[2], m[3], 1) // rgb(255, 0, 0)
      : (m = reRgbPercent.exec(format)) ? new Rgb(m[1] * 255 / 100, m[2] * 255 / 100, m[3] * 255 / 100, 1) // rgb(100%, 0%, 0%)
      : (m = reRgbaInteger.exec(format)) ? rgba(m[1], m[2], m[3], m[4]) // rgba(255, 0, 0, 1)
      : (m = reRgbaPercent.exec(format)) ? rgba(m[1] * 255 / 100, m[2] * 255 / 100, m[3] * 255 / 100, m[4]) // rgb(100%, 0%, 0%, 1)
      : (m = reHslPercent.exec(format)) ? hsla(m[1], m[2] / 100, m[3] / 100, 1) // hsl(120, 50%, 50%)
      : (m = reHslaPercent.exec(format)) ? hsla(m[1], m[2] / 100, m[3] / 100, m[4]) // hsla(120, 50%, 50%, 1)
      : named.hasOwnProperty(format) ? rgbn(named[format]) // eslint-disable-line no-prototype-builtins
      : format === "transparent" ? new Rgb(NaN, NaN, NaN, 0)
      : null;
}

function rgbn(n) {
  return new Rgb(n >> 16 & 0xff, n >> 8 & 0xff, n & 0xff, 1);
}

function rgba(r, g, b, a) {
  if (a <= 0) r = g = b = NaN;
  return new Rgb(r, g, b, a);
}

function rgbConvert(o) {
  if (!(o instanceof Color)) o = color(o);
  if (!o) return new Rgb;
  o = o.rgb();
  return new Rgb(o.r, o.g, o.b, o.opacity);
}

function rgb$1(r, g, b, opacity) {
  return arguments.length === 1 ? rgbConvert(r) : new Rgb(r, g, b, opacity == null ? 1 : opacity);
}

function Rgb(r, g, b, opacity) {
  this.r = +r;
  this.g = +g;
  this.b = +b;
  this.opacity = +opacity;
}

define(Rgb, rgb$1, extend(Color, {
  brighter: function(k) {
    k = k == null ? brighter : Math.pow(brighter, k);
    return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
  },
  darker: function(k) {
    k = k == null ? darker : Math.pow(darker, k);
    return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
  },
  rgb: function() {
    return this;
  },
  displayable: function() {
    return (-0.5 <= this.r && this.r < 255.5)
        && (-0.5 <= this.g && this.g < 255.5)
        && (-0.5 <= this.b && this.b < 255.5)
        && (0 <= this.opacity && this.opacity <= 1);
  },
  hex: rgb_formatHex, // Deprecated! Use color.formatHex.
  formatHex: rgb_formatHex,
  formatRgb: rgb_formatRgb,
  toString: rgb_formatRgb
}));

function rgb_formatHex() {
  return "#" + hex(this.r) + hex(this.g) + hex(this.b);
}

function rgb_formatRgb() {
  var a = this.opacity; a = isNaN(a) ? 1 : Math.max(0, Math.min(1, a));
  return (a === 1 ? "rgb(" : "rgba(")
      + Math.max(0, Math.min(255, Math.round(this.r) || 0)) + ", "
      + Math.max(0, Math.min(255, Math.round(this.g) || 0)) + ", "
      + Math.max(0, Math.min(255, Math.round(this.b) || 0))
      + (a === 1 ? ")" : ", " + a + ")");
}

function hex(value) {
  value = Math.max(0, Math.min(255, Math.round(value) || 0));
  return (value < 16 ? "0" : "") + value.toString(16);
}

function hsla(h, s, l, a) {
  if (a <= 0) h = s = l = NaN;
  else if (l <= 0 || l >= 1) h = s = NaN;
  else if (s <= 0) h = NaN;
  return new Hsl(h, s, l, a);
}

function hslConvert(o) {
  if (o instanceof Hsl) return new Hsl(o.h, o.s, o.l, o.opacity);
  if (!(o instanceof Color)) o = color(o);
  if (!o) return new Hsl;
  if (o instanceof Hsl) return o;
  o = o.rgb();
  var r = o.r / 255,
      g = o.g / 255,
      b = o.b / 255,
      min = Math.min(r, g, b),
      max = Math.max(r, g, b),
      h = NaN,
      s = max - min,
      l = (max + min) / 2;
  if (s) {
    if (r === max) h = (g - b) / s + (g < b) * 6;
    else if (g === max) h = (b - r) / s + 2;
    else h = (r - g) / s + 4;
    s /= l < 0.5 ? max + min : 2 - max - min;
    h *= 60;
  } else {
    s = l > 0 && l < 1 ? 0 : h;
  }
  return new Hsl(h, s, l, o.opacity);
}

function hsl(h, s, l, opacity) {
  return arguments.length === 1 ? hslConvert(h) : new Hsl(h, s, l, opacity == null ? 1 : opacity);
}

function Hsl(h, s, l, opacity) {
  this.h = +h;
  this.s = +s;
  this.l = +l;
  this.opacity = +opacity;
}

define(Hsl, hsl, extend(Color, {
  brighter: function(k) {
    k = k == null ? brighter : Math.pow(brighter, k);
    return new Hsl(this.h, this.s, this.l * k, this.opacity);
  },
  darker: function(k) {
    k = k == null ? darker : Math.pow(darker, k);
    return new Hsl(this.h, this.s, this.l * k, this.opacity);
  },
  rgb: function() {
    var h = this.h % 360 + (this.h < 0) * 360,
        s = isNaN(h) || isNaN(this.s) ? 0 : this.s,
        l = this.l,
        m2 = l + (l < 0.5 ? l : 1 - l) * s,
        m1 = 2 * l - m2;
    return new Rgb(
      hsl2rgb(h >= 240 ? h - 240 : h + 120, m1, m2),
      hsl2rgb(h, m1, m2),
      hsl2rgb(h < 120 ? h + 240 : h - 120, m1, m2),
      this.opacity
    );
  },
  displayable: function() {
    return (0 <= this.s && this.s <= 1 || isNaN(this.s))
        && (0 <= this.l && this.l <= 1)
        && (0 <= this.opacity && this.opacity <= 1);
  },
  formatHsl: function() {
    var a = this.opacity; a = isNaN(a) ? 1 : Math.max(0, Math.min(1, a));
    return (a === 1 ? "hsl(" : "hsla(")
        + (this.h || 0) + ", "
        + (this.s || 0) * 100 + "%, "
        + (this.l || 0) * 100 + "%"
        + (a === 1 ? ")" : ", " + a + ")");
  }
}));

/* From FvD 13.37, CSS Color Module Level 3 */
function hsl2rgb(h, m1, m2) {
  return (h < 60 ? m1 + (m2 - m1) * h / 60
      : h < 180 ? m2
      : h < 240 ? m1 + (m2 - m1) * (240 - h) / 60
      : m1) * 255;
}

var constant$1 = x => () => x;

function linear$1(a, d) {
  return function(t) {
    return a + t * d;
  };
}

function exponential(a, b, y) {
  return a = Math.pow(a, y), b = Math.pow(b, y) - a, y = 1 / y, function(t) {
    return Math.pow(a + t * b, y);
  };
}

function gamma(y) {
  return (y = +y) === 1 ? nogamma : function(a, b) {
    return b - a ? exponential(a, b, y) : constant$1(isNaN(a) ? b : a);
  };
}

function nogamma(a, b) {
  var d = b - a;
  return d ? linear$1(a, d) : constant$1(isNaN(a) ? b : a);
}

var rgb = (function rgbGamma(y) {
  var color = gamma(y);

  function rgb(start, end) {
    var r = color((start = rgb$1(start)).r, (end = rgb$1(end)).r),
        g = color(start.g, end.g),
        b = color(start.b, end.b),
        opacity = nogamma(start.opacity, end.opacity);
    return function(t) {
      start.r = r(t);
      start.g = g(t);
      start.b = b(t);
      start.opacity = opacity(t);
      return start + "";
    };
  }

  rgb.gamma = rgbGamma;

  return rgb;
})(1);

function numberArray(a, b) {
  if (!b) b = [];
  var n = a ? Math.min(b.length, a.length) : 0,
      c = b.slice(),
      i;
  return function(t) {
    for (i = 0; i < n; ++i) c[i] = a[i] * (1 - t) + b[i] * t;
    return c;
  };
}

function isNumberArray(x) {
  return ArrayBuffer.isView(x) && !(x instanceof DataView);
}

function genericArray(a, b) {
  var nb = b ? b.length : 0,
      na = a ? Math.min(nb, a.length) : 0,
      x = new Array(na),
      c = new Array(nb),
      i;

  for (i = 0; i < na; ++i) x[i] = interpolate(a[i], b[i]);
  for (; i < nb; ++i) c[i] = b[i];

  return function(t) {
    for (i = 0; i < na; ++i) c[i] = x[i](t);
    return c;
  };
}

function date(a, b) {
  var d = new Date;
  return a = +a, b = +b, function(t) {
    return d.setTime(a * (1 - t) + b * t), d;
  };
}

function interpolateNumber(a, b) {
  return a = +a, b = +b, function(t) {
    return a * (1 - t) + b * t;
  };
}

function object(a, b) {
  var i = {},
      c = {},
      k;

  if (a === null || typeof a !== "object") a = {};
  if (b === null || typeof b !== "object") b = {};

  for (k in b) {
    if (k in a) {
      i[k] = interpolate(a[k], b[k]);
    } else {
      c[k] = b[k];
    }
  }

  return function(t) {
    for (k in i) c[k] = i[k](t);
    return c;
  };
}

var reA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,
    reB = new RegExp(reA.source, "g");

function zero(b) {
  return function() {
    return b;
  };
}

function one(b) {
  return function(t) {
    return b(t) + "";
  };
}

function string(a, b) {
  var bi = reA.lastIndex = reB.lastIndex = 0, // scan index for next number in b
      am, // current match in a
      bm, // current match in b
      bs, // string preceding current number in b, if any
      i = -1, // index in s
      s = [], // string constants and placeholders
      q = []; // number interpolators

  // Coerce inputs to strings.
  a = a + "", b = b + "";

  // Interpolate pairs of numbers in a & b.
  while ((am = reA.exec(a))
      && (bm = reB.exec(b))) {
    if ((bs = bm.index) > bi) { // a string precedes the next number in b
      bs = b.slice(bi, bs);
      if (s[i]) s[i] += bs; // coalesce with previous string
      else s[++i] = bs;
    }
    if ((am = am[0]) === (bm = bm[0])) { // numbers in a & b match
      if (s[i]) s[i] += bm; // coalesce with previous string
      else s[++i] = bm;
    } else { // interpolate non-matching numbers
      s[++i] = null;
      q.push({i: i, x: interpolateNumber(am, bm)});
    }
    bi = reB.lastIndex;
  }

  // Add remains of b.
  if (bi < b.length) {
    bs = b.slice(bi);
    if (s[i]) s[i] += bs; // coalesce with previous string
    else s[++i] = bs;
  }

  // Special optimization for only a single match.
  // Otherwise, interpolate each of the numbers and rejoin the string.
  return s.length < 2 ? (q[0]
      ? one(q[0].x)
      : zero(b))
      : (b = q.length, function(t) {
          for (var i = 0, o; i < b; ++i) s[(o = q[i]).i] = o.x(t);
          return s.join("");
        });
}

function interpolate(a, b) {
  var t = typeof b, c;
  return b == null || t === "boolean" ? constant$1(b)
      : (t === "number" ? interpolateNumber
      : t === "string" ? ((c = color(b)) ? (b = c, rgb) : string)
      : b instanceof color ? rgb
      : b instanceof Date ? date
      : isNumberArray(b) ? numberArray
      : Array.isArray(b) ? genericArray
      : typeof b.valueOf !== "function" && typeof b.toString !== "function" || isNaN(b) ? object
      : interpolateNumber)(a, b);
}

function interpolateRound(a, b) {
  return a = +a, b = +b, function(t) {
    return Math.round(a * (1 - t) + b * t);
  };
}

function constants(x) {
  return function() {
    return x;
  };
}

function number(x) {
  return +x;
}

var unit = [0, 1];

function identity$1(x) {
  return x;
}

function normalize(a, b) {
  return (b -= (a = +a))
      ? function(x) { return (x - a) / b; }
      : constants(isNaN(b) ? NaN : 0.5);
}

function clamper(a, b) {
  var t;
  if (a > b) t = a, a = b, b = t;
  return function(x) { return Math.max(a, Math.min(b, x)); };
}

// normalize(a, b)(x) takes a domain value x in [a,b] and returns the corresponding parameter t in [0,1].
// interpolate(a, b)(t) takes a parameter t in [0,1] and returns the corresponding range value x in [a,b].
function bimap(domain, range, interpolate) {
  var d0 = domain[0], d1 = domain[1], r0 = range[0], r1 = range[1];
  if (d1 < d0) d0 = normalize(d1, d0), r0 = interpolate(r1, r0);
  else d0 = normalize(d0, d1), r0 = interpolate(r0, r1);
  return function(x) { return r0(d0(x)); };
}

function polymap(domain, range, interpolate) {
  var j = Math.min(domain.length, range.length) - 1,
      d = new Array(j),
      r = new Array(j),
      i = -1;

  // Reverse descending domains.
  if (domain[j] < domain[0]) {
    domain = domain.slice().reverse();
    range = range.slice().reverse();
  }

  while (++i < j) {
    d[i] = normalize(domain[i], domain[i + 1]);
    r[i] = interpolate(range[i], range[i + 1]);
  }

  return function(x) {
    var i = bisect(domain, x, 1, j) - 1;
    return r[i](d[i](x));
  };
}

function copy(source, target) {
  return target
      .domain(source.domain())
      .range(source.range())
      .interpolate(source.interpolate())
      .clamp(source.clamp())
      .unknown(source.unknown());
}

function transformer() {
  var domain = unit,
      range = unit,
      interpolate$1 = interpolate,
      transform,
      untransform,
      unknown,
      clamp = identity$1,
      piecewise,
      output,
      input;

  function rescale() {
    var n = Math.min(domain.length, range.length);
    if (clamp !== identity$1) clamp = clamper(domain[0], domain[n - 1]);
    piecewise = n > 2 ? polymap : bimap;
    output = input = null;
    return scale;
  }

  function scale(x) {
    return x == null || isNaN(x = +x) ? unknown : (output || (output = piecewise(domain.map(transform), range, interpolate$1)))(transform(clamp(x)));
  }

  scale.invert = function(y) {
    return clamp(untransform((input || (input = piecewise(range, domain.map(transform), interpolateNumber)))(y)));
  };

  scale.domain = function(_) {
    return arguments.length ? (domain = Array.from(_, number), rescale()) : domain.slice();
  };

  scale.range = function(_) {
    return arguments.length ? (range = Array.from(_), rescale()) : range.slice();
  };

  scale.rangeRound = function(_) {
    return range = Array.from(_), interpolate$1 = interpolateRound, rescale();
  };

  scale.clamp = function(_) {
    return arguments.length ? (clamp = _ ? true : identity$1, rescale()) : clamp !== identity$1;
  };

  scale.interpolate = function(_) {
    return arguments.length ? (interpolate$1 = _, rescale()) : interpolate$1;
  };

  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : unknown;
  };

  return function(t, u) {
    transform = t, untransform = u;
    return rescale();
  };
}

function continuous() {
  return transformer()(identity$1, identity$1);
}

function formatDecimal(x) {
  return Math.abs(x = Math.round(x)) >= 1e21
      ? x.toLocaleString("en").replace(/,/g, "")
      : x.toString(10);
}

// Computes the decimal coefficient and exponent of the specified number x with
// significant digits p, where x is positive and p is in [1, 21] or undefined.
// For example, formatDecimalParts(1.23) returns ["123", 0].
function formatDecimalParts(x, p) {
  if ((i = (x = p ? x.toExponential(p - 1) : x.toExponential()).indexOf("e")) < 0) return null; // NaN, ±Infinity
  var i, coefficient = x.slice(0, i);

  // The string returned by toExponential either has the form \d\.\d+e[-+]\d+
  // (e.g., 1.2e+3) or the form \de[-+]\d+ (e.g., 1e+3).
  return [
    coefficient.length > 1 ? coefficient[0] + coefficient.slice(2) : coefficient,
    +x.slice(i + 1)
  ];
}

function exponent(x) {
  return x = formatDecimalParts(Math.abs(x)), x ? x[1] : NaN;
}

function formatGroup(grouping, thousands) {
  return function(value, width) {
    var i = value.length,
        t = [],
        j = 0,
        g = grouping[0],
        length = 0;

    while (i > 0 && g > 0) {
      if (length + g + 1 > width) g = Math.max(1, width - length);
      t.push(value.substring(i -= g, i + g));
      if ((length += g + 1) > width) break;
      g = grouping[j = (j + 1) % grouping.length];
    }

    return t.reverse().join(thousands);
  };
}

function formatNumerals(numerals) {
  return function(value) {
    return value.replace(/[0-9]/g, function(i) {
      return numerals[+i];
    });
  };
}

// [[fill]align][sign][symbol][0][width][,][.precision][~][type]
var re = /^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;

function formatSpecifier(specifier) {
  if (!(match = re.exec(specifier))) throw new Error("invalid format: " + specifier);
  var match;
  return new FormatSpecifier({
    fill: match[1],
    align: match[2],
    sign: match[3],
    symbol: match[4],
    zero: match[5],
    width: match[6],
    comma: match[7],
    precision: match[8] && match[8].slice(1),
    trim: match[9],
    type: match[10]
  });
}

formatSpecifier.prototype = FormatSpecifier.prototype; // instanceof

function FormatSpecifier(specifier) {
  this.fill = specifier.fill === undefined ? " " : specifier.fill + "";
  this.align = specifier.align === undefined ? ">" : specifier.align + "";
  this.sign = specifier.sign === undefined ? "-" : specifier.sign + "";
  this.symbol = specifier.symbol === undefined ? "" : specifier.symbol + "";
  this.zero = !!specifier.zero;
  this.width = specifier.width === undefined ? undefined : +specifier.width;
  this.comma = !!specifier.comma;
  this.precision = specifier.precision === undefined ? undefined : +specifier.precision;
  this.trim = !!specifier.trim;
  this.type = specifier.type === undefined ? "" : specifier.type + "";
}

FormatSpecifier.prototype.toString = function() {
  return this.fill
      + this.align
      + this.sign
      + this.symbol
      + (this.zero ? "0" : "")
      + (this.width === undefined ? "" : Math.max(1, this.width | 0))
      + (this.comma ? "," : "")
      + (this.precision === undefined ? "" : "." + Math.max(0, this.precision | 0))
      + (this.trim ? "~" : "")
      + this.type;
};

// Trims insignificant zeros, e.g., replaces 1.2000k with 1.2k.
function formatTrim(s) {
  out: for (var n = s.length, i = 1, i0 = -1, i1; i < n; ++i) {
    switch (s[i]) {
      case ".": i0 = i1 = i; break;
      case "0": if (i0 === 0) i0 = i; i1 = i; break;
      default: if (!+s[i]) break out; if (i0 > 0) i0 = 0; break;
    }
  }
  return i0 > 0 ? s.slice(0, i0) + s.slice(i1 + 1) : s;
}

var prefixExponent;

function formatPrefixAuto(x, p) {
  var d = formatDecimalParts(x, p);
  if (!d) return x + "";
  var coefficient = d[0],
      exponent = d[1],
      i = exponent - (prefixExponent = Math.max(-8, Math.min(8, Math.floor(exponent / 3))) * 3) + 1,
      n = coefficient.length;
  return i === n ? coefficient
      : i > n ? coefficient + new Array(i - n + 1).join("0")
      : i > 0 ? coefficient.slice(0, i) + "." + coefficient.slice(i)
      : "0." + new Array(1 - i).join("0") + formatDecimalParts(x, Math.max(0, p + i - 1))[0]; // less than 1y!
}

function formatRounded(x, p) {
  var d = formatDecimalParts(x, p);
  if (!d) return x + "";
  var coefficient = d[0],
      exponent = d[1];
  return exponent < 0 ? "0." + new Array(-exponent).join("0") + coefficient
      : coefficient.length > exponent + 1 ? coefficient.slice(0, exponent + 1) + "." + coefficient.slice(exponent + 1)
      : coefficient + new Array(exponent - coefficient.length + 2).join("0");
}

var formatTypes = {
  "%": (x, p) => (x * 100).toFixed(p),
  "b": (x) => Math.round(x).toString(2),
  "c": (x) => x + "",
  "d": formatDecimal,
  "e": (x, p) => x.toExponential(p),
  "f": (x, p) => x.toFixed(p),
  "g": (x, p) => x.toPrecision(p),
  "o": (x) => Math.round(x).toString(8),
  "p": (x, p) => formatRounded(x * 100, p),
  "r": formatRounded,
  "s": formatPrefixAuto,
  "X": (x) => Math.round(x).toString(16).toUpperCase(),
  "x": (x) => Math.round(x).toString(16)
};

function identity(x) {
  return x;
}

var map = Array.prototype.map,
    prefixes = ["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"];

function formatLocale(locale) {
  var group = locale.grouping === undefined || locale.thousands === undefined ? identity : formatGroup(map.call(locale.grouping, Number), locale.thousands + ""),
      currencyPrefix = locale.currency === undefined ? "" : locale.currency[0] + "",
      currencySuffix = locale.currency === undefined ? "" : locale.currency[1] + "",
      decimal = locale.decimal === undefined ? "." : locale.decimal + "",
      numerals = locale.numerals === undefined ? identity : formatNumerals(map.call(locale.numerals, String)),
      percent = locale.percent === undefined ? "%" : locale.percent + "",
      minus = locale.minus === undefined ? "−" : locale.minus + "",
      nan = locale.nan === undefined ? "NaN" : locale.nan + "";

  function newFormat(specifier) {
    specifier = formatSpecifier(specifier);

    var fill = specifier.fill,
        align = specifier.align,
        sign = specifier.sign,
        symbol = specifier.symbol,
        zero = specifier.zero,
        width = specifier.width,
        comma = specifier.comma,
        precision = specifier.precision,
        trim = specifier.trim,
        type = specifier.type;

    // The "n" type is an alias for ",g".
    if (type === "n") comma = true, type = "g";

    // The "" type, and any invalid type, is an alias for ".12~g".
    else if (!formatTypes[type]) precision === undefined && (precision = 12), trim = true, type = "g";

    // If zero fill is specified, padding goes after sign and before digits.
    if (zero || (fill === "0" && align === "=")) zero = true, fill = "0", align = "=";

    // Compute the prefix and suffix.
    // For SI-prefix, the suffix is lazily computed.
    var prefix = symbol === "$" ? currencyPrefix : symbol === "#" && /[boxX]/.test(type) ? "0" + type.toLowerCase() : "",
        suffix = symbol === "$" ? currencySuffix : /[%p]/.test(type) ? percent : "";

    // What format function should we use?
    // Is this an integer type?
    // Can this type generate exponential notation?
    var formatType = formatTypes[type],
        maybeSuffix = /[defgprs%]/.test(type);

    // Set the default precision if not specified,
    // or clamp the specified precision to the supported range.
    // For significant precision, it must be in [1, 21].
    // For fixed precision, it must be in [0, 20].
    precision = precision === undefined ? 6
        : /[gprs]/.test(type) ? Math.max(1, Math.min(21, precision))
        : Math.max(0, Math.min(20, precision));

    function format(value) {
      var valuePrefix = prefix,
          valueSuffix = suffix,
          i, n, c;

      if (type === "c") {
        valueSuffix = formatType(value) + valueSuffix;
        value = "";
      } else {
        value = +value;

        // Determine the sign. -0 is not less than 0, but 1 / -0 is!
        var valueNegative = value < 0 || 1 / value < 0;

        // Perform the initial formatting.
        value = isNaN(value) ? nan : formatType(Math.abs(value), precision);

        // Trim insignificant zeros.
        if (trim) value = formatTrim(value);

        // If a negative value rounds to zero after formatting, and no explicit positive sign is requested, hide the sign.
        if (valueNegative && +value === 0 && sign !== "+") valueNegative = false;

        // Compute the prefix and suffix.
        valuePrefix = (valueNegative ? (sign === "(" ? sign : minus) : sign === "-" || sign === "(" ? "" : sign) + valuePrefix;
        valueSuffix = (type === "s" ? prefixes[8 + prefixExponent / 3] : "") + valueSuffix + (valueNegative && sign === "(" ? ")" : "");

        // Break the formatted value into the integer “value” part that can be
        // grouped, and fractional or exponential “suffix” part that is not.
        if (maybeSuffix) {
          i = -1, n = value.length;
          while (++i < n) {
            if (c = value.charCodeAt(i), 48 > c || c > 57) {
              valueSuffix = (c === 46 ? decimal + value.slice(i + 1) : value.slice(i)) + valueSuffix;
              value = value.slice(0, i);
              break;
            }
          }
        }
      }

      // If the fill character is not "0", grouping is applied before padding.
      if (comma && !zero) value = group(value, Infinity);

      // Compute the padding.
      var length = valuePrefix.length + value.length + valueSuffix.length,
          padding = length < width ? new Array(width - length + 1).join(fill) : "";

      // If the fill character is "0", grouping is applied after padding.
      if (comma && zero) value = group(padding + value, padding.length ? width - valueSuffix.length : Infinity), padding = "";

      // Reconstruct the final output based on the desired alignment.
      switch (align) {
        case "<": value = valuePrefix + value + valueSuffix + padding; break;
        case "=": value = valuePrefix + padding + value + valueSuffix; break;
        case "^": value = padding.slice(0, length = padding.length >> 1) + valuePrefix + value + valueSuffix + padding.slice(length); break;
        default: value = padding + valuePrefix + value + valueSuffix; break;
      }

      return numerals(value);
    }

    format.toString = function() {
      return specifier + "";
    };

    return format;
  }

  function formatPrefix(specifier, value) {
    var f = newFormat((specifier = formatSpecifier(specifier), specifier.type = "f", specifier)),
        e = Math.max(-8, Math.min(8, Math.floor(exponent(value) / 3))) * 3,
        k = Math.pow(10, -e),
        prefix = prefixes[8 + e / 3];
    return function(value) {
      return f(k * value) + prefix;
    };
  }

  return {
    format: newFormat,
    formatPrefix: formatPrefix
  };
}

var locale;
var format;
var formatPrefix;

defaultLocale({
  thousands: ",",
  grouping: [3],
  currency: ["$", ""]
});

function defaultLocale(definition) {
  locale = formatLocale(definition);
  format = locale.format;
  formatPrefix = locale.formatPrefix;
  return locale;
}

function precisionFixed(step) {
  return Math.max(0, -exponent(Math.abs(step)));
}

function precisionPrefix(step, value) {
  return Math.max(0, Math.max(-8, Math.min(8, Math.floor(exponent(value) / 3))) * 3 - exponent(Math.abs(step)));
}

function precisionRound(step, max) {
  step = Math.abs(step), max = Math.abs(max) - step;
  return Math.max(0, exponent(max) - exponent(step)) + 1;
}

function tickFormat(start, stop, count, specifier) {
  var step = tickStep(start, stop, count),
      precision;
  specifier = formatSpecifier(specifier == null ? ",f" : specifier);
  switch (specifier.type) {
    case "s": {
      var value = Math.max(Math.abs(start), Math.abs(stop));
      if (specifier.precision == null && !isNaN(precision = precisionPrefix(step, value))) specifier.precision = precision;
      return formatPrefix(specifier, value);
    }
    case "":
    case "e":
    case "g":
    case "p":
    case "r": {
      if (specifier.precision == null && !isNaN(precision = precisionRound(step, Math.max(Math.abs(start), Math.abs(stop))))) specifier.precision = precision - (specifier.type === "e");
      break;
    }
    case "f":
    case "%": {
      if (specifier.precision == null && !isNaN(precision = precisionFixed(step))) specifier.precision = precision - (specifier.type === "%") * 2;
      break;
    }
  }
  return format(specifier);
}

function linearish(scale) {
  var domain = scale.domain;

  scale.ticks = function(count) {
    var d = domain();
    return ticks(d[0], d[d.length - 1], count == null ? 10 : count);
  };

  scale.tickFormat = function(count, specifier) {
    var d = domain();
    return tickFormat(d[0], d[d.length - 1], count == null ? 10 : count, specifier);
  };

  scale.nice = function(count) {
    if (count == null) count = 10;

    var d = domain();
    var i0 = 0;
    var i1 = d.length - 1;
    var start = d[i0];
    var stop = d[i1];
    var prestep;
    var step;
    var maxIter = 10;

    if (stop < start) {
      step = start, start = stop, stop = step;
      step = i0, i0 = i1, i1 = step;
    }
    
    while (maxIter-- > 0) {
      step = tickIncrement(start, stop, count);
      if (step === prestep) {
        d[i0] = start;
        d[i1] = stop;
        return domain(d);
      } else if (step > 0) {
        start = Math.floor(start / step) * step;
        stop = Math.ceil(stop / step) * step;
      } else if (step < 0) {
        start = Math.ceil(start * step) / step;
        stop = Math.floor(stop * step) / step;
      } else {
        break;
      }
      prestep = step;
    }

    return scale;
  };

  return scale;
}

function linear() {
  var scale = continuous();

  scale.copy = function() {
    return copy(scale, linear());
  };

  initRange.apply(scale, arguments);

  return linearish(scale);
}

const pi = Math.PI,
    tau = 2 * pi,
    epsilon = 1e-6,
    tauEpsilon = tau - epsilon;

function Path() {
  this._x0 = this._y0 = // start of current subpath
  this._x1 = this._y1 = null; // end of current subpath
  this._ = "";
}

function path() {
  return new Path;
}

Path.prototype = path.prototype = {
  constructor: Path,
  moveTo: function(x, y) {
    this._ += "M" + (this._x0 = this._x1 = +x) + "," + (this._y0 = this._y1 = +y);
  },
  closePath: function() {
    if (this._x1 !== null) {
      this._x1 = this._x0, this._y1 = this._y0;
      this._ += "Z";
    }
  },
  lineTo: function(x, y) {
    this._ += "L" + (this._x1 = +x) + "," + (this._y1 = +y);
  },
  quadraticCurveTo: function(x1, y1, x, y) {
    this._ += "Q" + (+x1) + "," + (+y1) + "," + (this._x1 = +x) + "," + (this._y1 = +y);
  },
  bezierCurveTo: function(x1, y1, x2, y2, x, y) {
    this._ += "C" + (+x1) + "," + (+y1) + "," + (+x2) + "," + (+y2) + "," + (this._x1 = +x) + "," + (this._y1 = +y);
  },
  arcTo: function(x1, y1, x2, y2, r) {
    x1 = +x1, y1 = +y1, x2 = +x2, y2 = +y2, r = +r;
    var x0 = this._x1,
        y0 = this._y1,
        x21 = x2 - x1,
        y21 = y2 - y1,
        x01 = x0 - x1,
        y01 = y0 - y1,
        l01_2 = x01 * x01 + y01 * y01;

    // Is the radius negative? Error.
    if (r < 0) throw new Error("negative radius: " + r);

    // Is this path empty? Move to (x1,y1).
    if (this._x1 === null) {
      this._ += "M" + (this._x1 = x1) + "," + (this._y1 = y1);
    }

    // Or, is (x1,y1) coincident with (x0,y0)? Do nothing.
    else if (!(l01_2 > epsilon));

    // Or, are (x0,y0), (x1,y1) and (x2,y2) collinear?
    // Equivalently, is (x1,y1) coincident with (x2,y2)?
    // Or, is the radius zero? Line to (x1,y1).
    else if (!(Math.abs(y01 * x21 - y21 * x01) > epsilon) || !r) {
      this._ += "L" + (this._x1 = x1) + "," + (this._y1 = y1);
    }

    // Otherwise, draw an arc!
    else {
      var x20 = x2 - x0,
          y20 = y2 - y0,
          l21_2 = x21 * x21 + y21 * y21,
          l20_2 = x20 * x20 + y20 * y20,
          l21 = Math.sqrt(l21_2),
          l01 = Math.sqrt(l01_2),
          l = r * Math.tan((pi - Math.acos((l21_2 + l01_2 - l20_2) / (2 * l21 * l01))) / 2),
          t01 = l / l01,
          t21 = l / l21;

      // If the start tangent is not coincident with (x0,y0), line to.
      if (Math.abs(t01 - 1) > epsilon) {
        this._ += "L" + (x1 + t01 * x01) + "," + (y1 + t01 * y01);
      }

      this._ += "A" + r + "," + r + ",0,0," + (+(y01 * x20 > x01 * y20)) + "," + (this._x1 = x1 + t21 * x21) + "," + (this._y1 = y1 + t21 * y21);
    }
  },
  arc: function(x, y, r, a0, a1, ccw) {
    x = +x, y = +y, r = +r, ccw = !!ccw;
    var dx = r * Math.cos(a0),
        dy = r * Math.sin(a0),
        x0 = x + dx,
        y0 = y + dy,
        cw = 1 ^ ccw,
        da = ccw ? a0 - a1 : a1 - a0;

    // Is the radius negative? Error.
    if (r < 0) throw new Error("negative radius: " + r);

    // Is this path empty? Move to (x0,y0).
    if (this._x1 === null) {
      this._ += "M" + x0 + "," + y0;
    }

    // Or, is (x0,y0) not coincident with the previous point? Line to (x0,y0).
    else if (Math.abs(this._x1 - x0) > epsilon || Math.abs(this._y1 - y0) > epsilon) {
      this._ += "L" + x0 + "," + y0;
    }

    // Is this arc empty? We’re done.
    if (!r) return;

    // Does the angle go the wrong way? Flip the direction.
    if (da < 0) da = da % tau + tau;

    // Is this a complete circle? Draw two arcs to complete the circle.
    if (da > tauEpsilon) {
      this._ += "A" + r + "," + r + ",0,1," + cw + "," + (x - dx) + "," + (y - dy) + "A" + r + "," + r + ",0,1," + cw + "," + (this._x1 = x0) + "," + (this._y1 = y0);
    }

    // Is this arc non-empty? Draw an arc!
    else if (da > epsilon) {
      this._ += "A" + r + "," + r + ",0," + (+(da >= pi)) + "," + cw + "," + (this._x1 = x + r * Math.cos(a1)) + "," + (this._y1 = y + r * Math.sin(a1));
    }
  },
  rect: function(x, y, w, h) {
    this._ += "M" + (this._x0 = this._x1 = +x) + "," + (this._y0 = this._y1 = +y) + "h" + (+w) + "v" + (+h) + "h" + (-w) + "Z";
  },
  toString: function() {
    return this._;
  }
};

function constant(x) {
  return function constant() {
    return x;
  };
}

function array(x) {
  return typeof x === "object" && "length" in x
    ? x // Array, TypedArray, NodeList, array-like
    : Array.from(x); // Map, Set, iterable, string, or anything else
}

function Linear(context) {
  this._context = context;
}

Linear.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._point = 0;
  },
  lineEnd: function() {
    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x, y) {
    x = +x, y = +y;
    switch (this._point) {
      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;
      case 1: this._point = 2; // falls through
      default: this._context.lineTo(x, y); break;
    }
  }
};

function curveLinear(context) {
  return new Linear(context);
}

function x(p) {
  return p[0];
}

function y(p) {
  return p[1];
}

function _line(x$1, y$1) {
  var defined = constant(true),
      context = null,
      curve = curveLinear,
      output = null;

  x$1 = typeof x$1 === "function" ? x$1 : (x$1 === undefined) ? x : constant(x$1);
  y$1 = typeof y$1 === "function" ? y$1 : (y$1 === undefined) ? y : constant(y$1);

  function line(data) {
    var i,
        n = (data = array(data)).length,
        d,
        defined0 = false,
        buffer;

    if (context == null) output = curve(buffer = path());

    for (i = 0; i <= n; ++i) {
      if (!(i < n && defined(d = data[i], i, data)) === defined0) {
        if (defined0 = !defined0) output.lineStart();
        else output.lineEnd();
      }
      if (defined0) output.point(+x$1(d, i, data), +y$1(d, i, data));
    }

    if (buffer) return output = null, buffer + "" || null;
  }

  line.x = function(_) {
    return arguments.length ? (x$1 = typeof _ === "function" ? _ : constant(+_), line) : x$1;
  };

  line.y = function(_) {
    return arguments.length ? (y$1 = typeof _ === "function" ? _ : constant(+_), line) : y$1;
  };

  line.defined = function(_) {
    return arguments.length ? (defined = typeof _ === "function" ? _ : constant(!!_), line) : defined;
  };

  line.curve = function(_) {
    return arguments.length ? (curve = _, context != null && (output = curve(context)), line) : curve;
  };

  line.context = function(_) {
    return arguments.length ? (_ == null ? context = output = null : output = curve(context = _), line) : context;
  };

  return line;
}

function get_domains(values) {
  let _vs;
  if (Array.isArray(values)) {
    _vs = values.reduce((acc, { values: values2 }) => {
      return [...acc, ...values2.map(({ y }) => y)];
    }, []);
  } else {
    _vs = values.values;
  }
  return [Math.min(..._vs), Math.max(..._vs)];
}
function transform_values(values, x, y) {
  const transformed_values = Object.entries(values[0]).reduce((acc, next, i) => {
    if (!x && i === 0 || x && next[0] === x) {
      acc.x.name = next[0];
    } else if (!y || y && y.includes(next[0])) {
      acc.y.push({ name: next[0], values: [] });
    }
    return acc;
  }, { x: { name: "", values: [] }, y: [] });
  for (let i = 0; i < values.length; i++) {
    const _a = Object.entries(values[i]);
    for (let j = 0; j < _a.length; j++) {
      let [name, x2] = _a[j];
      if (name === transformed_values.x.name) {
        transformed_values.x.values.push(parseFloat(x2));
      } else {
        transformed_values.y[j - 1].values.push({
          y: parseFloat(_a[j][1]),
          x: parseFloat(_a[0][1])
        });
      }
    }
  }
  return transformed_values;
}

/* home/runner/work/gradio/gradio/ui/packages/tooltip/src/Tooltip.svelte generated by Svelte v3.49.0 */

function create_fragment$2(ctx) {
	let div;
	let span;
	let t;
	let div_resize_listener;

	return {
		c() {
			div = element("div");
			span = element("span");
			t = text(/*text*/ ctx[0]);
			attr(span, "class", "inline-block w-3 h-3 mr-1 rounded-sm");
			set_style(span, "background", /*color*/ ctx[3]);
			attr(div, "class", "bg-black bg-opacity-80 text-white py-1 px-[0.4rem] absolute text-xs flex items-center justify-center rounded");
			set_style(div, "top", /*y*/ ctx[2] - /*h*/ ctx[5] / 2 + "px");
			set_style(div, "left", /*x*/ ctx[1] - /*w*/ ctx[4] - 7 + "px");
			add_render_callback(() => /*div_elementresize_handler*/ ctx[6].call(div));
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, span);
			append(div, t);
			div_resize_listener = add_resize_listener(div, /*div_elementresize_handler*/ ctx[6].bind(div));
		},
		p(ctx, [dirty]) {
			if (dirty & /*color*/ 8) {
				set_style(span, "background", /*color*/ ctx[3]);
			}

			if (dirty & /*text*/ 1) set_data(t, /*text*/ ctx[0]);

			if (dirty & /*y, h*/ 36) {
				set_style(div, "top", /*y*/ ctx[2] - /*h*/ ctx[5] / 2 + "px");
			}

			if (dirty & /*x, w*/ 18) {
				set_style(div, "left", /*x*/ ctx[1] - /*w*/ ctx[4] - 7 + "px");
			}
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div);
			div_resize_listener();
		}
	};
}

function instance$2($$self, $$props, $$invalidate) {
	let { text } = $$props;
	let { x } = $$props;
	let { y } = $$props;
	let { color } = $$props;
	let w;
	let h;

	function div_elementresize_handler() {
		w = this.offsetWidth;
		h = this.offsetHeight;
		$$invalidate(4, w);
		$$invalidate(5, h);
	}

	$$self.$$set = $$props => {
		if ('text' in $$props) $$invalidate(0, text = $$props.text);
		if ('x' in $$props) $$invalidate(1, x = $$props.x);
		if ('y' in $$props) $$invalidate(2, y = $$props.y);
		if ('color' in $$props) $$invalidate(3, color = $$props.color);
	};

	return [text, x, y, color, w, h, div_elementresize_handler];
}

class Tooltip extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$2, create_fragment$2, safe_not_equal, { text: 0, x: 1, y: 2, color: 3 });
	}
}

function tooltip(element, { color, text }) {
  let tooltipComponent;
  function mouse_over(event) {
    tooltipComponent = new Tooltip({
      props: {
        text,
        x: event.pageX,
        y: event.pageY,
        color
      },
      target: document.body
    });
    return event;
  }
  function mouseMove(event) {
    tooltipComponent.$set({
      x: event.pageX,
      y: event.pageY
    });
  }
  function mouseLeave() {
    tooltipComponent.$destroy();
  }
  const el = element;
  el.addEventListener("mouseover", mouse_over);
  el.addEventListener("mouseleave", mouseLeave);
  el.addEventListener("mousemove", mouseMove);
  return {
    destroy() {
      el.removeEventListener("mouseover", mouse_over);
      el.removeEventListener("mouseleave", mouseLeave);
      el.removeEventListener("mousemove", mouseMove);
    }
  };
}

/* home/runner/work/gradio/gradio/ui/packages/chart/src/Chart.svelte generated by Svelte v3.49.0 */

function get_each_context(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[16] = list[i].name;
	child_ctx[17] = list[i].values;
	const constants_0 = /*color_map*/ child_ctx[8][/*name*/ child_ctx[16]];
	child_ctx[18] = constants_0;
	return child_ctx;
}

function get_each_context_1(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[0] = list[i].x;
	child_ctx[1] = list[i].y;
	return child_ctx;
}

function get_each_context_2(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[16] = list[i].name;
	child_ctx[17] = list[i].values;
	const constants_0 = /*color_map*/ child_ctx[8][/*name*/ child_ctx[16]];
	child_ctx[18] = constants_0;
	return child_ctx;
}

function get_each_context_3(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[0] = list[i].x;
	child_ctx[1] = list[i].y;
	return child_ctx;
}

function get_each_context_4(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[27] = list[i];
	return child_ctx;
}

function get_each_context_5(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[27] = list[i];
	return child_ctx;
}

function get_each_context_6(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[16] = list[i].name;
	return child_ctx;
}

// (47:2) {#each _y as { name }}
function create_each_block_6(ctx) {
	let div;
	let span;
	let t0;
	let t1_value = /*name*/ ctx[16] + "";
	let t1;
	let t2;

	return {
		c() {
			div = element("div");
			span = element("span");
			t0 = space();
			t1 = text(t1_value);
			t2 = space();
			attr(span, "class", "inline-block w-[12px] h-[12px] rounded-sm ");
			set_style(span, "background-color", /*color_map*/ ctx[8][/*name*/ ctx[16]]);
			attr(div, "class", "mx-2 flex gap-1 items-center");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, span);
			append(div, t0);
			append(div, t1);
			append(div, t2);
		},
		p(ctx, dirty) {
			if (dirty[0] & /*color_map, _y*/ 260) {
				set_style(span, "background-color", /*color_map*/ ctx[8][/*name*/ ctx[16]]);
			}

			if (dirty[0] & /*_y*/ 4 && t1_value !== (t1_value = /*name*/ ctx[16] + "")) set_data(t1, t1_value);
		},
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

// (59:3) {#each x_ticks as tick}
function create_each_block_5(ctx) {
	let line;
	let line_x__value;
	let line_x__value_1;
	let line_y__value;
	let line_y__value_1;
	let text_1;
	let t_value = /*tick*/ ctx[27] + "";
	let t;
	let text_1_x_value;
	let text_1_y_value;

	return {
		c() {
			line = svg_element("line");
			text_1 = svg_element("text");
			t = text(t_value);
			attr(line, "stroke-width", "0.5");
			attr(line, "x1", line_x__value = /*scale_x*/ ctx[5](/*tick*/ ctx[27]));
			attr(line, "x2", line_x__value_1 = /*scale_x*/ ctx[5](/*tick*/ ctx[27]));

			attr(line, "y1", line_y__value = /*scale_y*/ ctx[4](/*y_ticks*/ ctx[9][0] < /*y_domain*/ ctx[6][0]
			? /*y_ticks*/ ctx[9][0]
			: /*y_domain*/ ctx[6][0]) + 10);

			attr(line, "y2", line_y__value_1 = /*scale_y*/ ctx[4](/*y_domain*/ ctx[6][1] > /*y_ticks*/ ctx[9][/*y_ticks*/ ctx[9].length - 1]
			? /*y_domain*/ ctx[6][1]
			: /*y_ticks*/ ctx[9][/*y_ticks*/ ctx[9].length - 1]));

			attr(line, "stroke", "#aaa");
			attr(text_1, "class", "font-mono text-xs dark:fill-slate-200");
			attr(text_1, "text-anchor", "middle");
			attr(text_1, "x", text_1_x_value = /*scale_x*/ ctx[5](/*tick*/ ctx[27]));
			attr(text_1, "y", text_1_y_value = /*scale_y*/ ctx[4](/*y_ticks*/ ctx[9][0]) + 30);
		},
		m(target, anchor) {
			insert(target, line, anchor);
			insert(target, text_1, anchor);
			append(text_1, t);
		},
		p(ctx, dirty) {
			if (dirty[0] & /*scale_x, x_ticks*/ 1056 && line_x__value !== (line_x__value = /*scale_x*/ ctx[5](/*tick*/ ctx[27]))) {
				attr(line, "x1", line_x__value);
			}

			if (dirty[0] & /*scale_x, x_ticks*/ 1056 && line_x__value_1 !== (line_x__value_1 = /*scale_x*/ ctx[5](/*tick*/ ctx[27]))) {
				attr(line, "x2", line_x__value_1);
			}

			if (dirty[0] & /*scale_y, y_ticks, y_domain*/ 592 && line_y__value !== (line_y__value = /*scale_y*/ ctx[4](/*y_ticks*/ ctx[9][0] < /*y_domain*/ ctx[6][0]
			? /*y_ticks*/ ctx[9][0]
			: /*y_domain*/ ctx[6][0]) + 10)) {
				attr(line, "y1", line_y__value);
			}

			if (dirty[0] & /*scale_y, y_domain, y_ticks*/ 592 && line_y__value_1 !== (line_y__value_1 = /*scale_y*/ ctx[4](/*y_domain*/ ctx[6][1] > /*y_ticks*/ ctx[9][/*y_ticks*/ ctx[9].length - 1]
			? /*y_domain*/ ctx[6][1]
			: /*y_ticks*/ ctx[9][/*y_ticks*/ ctx[9].length - 1]))) {
				attr(line, "y2", line_y__value_1);
			}

			if (dirty[0] & /*x_ticks*/ 1024 && t_value !== (t_value = /*tick*/ ctx[27] + "")) set_data(t, t_value);

			if (dirty[0] & /*scale_x, x_ticks*/ 1056 && text_1_x_value !== (text_1_x_value = /*scale_x*/ ctx[5](/*tick*/ ctx[27]))) {
				attr(text_1, "x", text_1_x_value);
			}

			if (dirty[0] & /*scale_y, y_ticks*/ 528 && text_1_y_value !== (text_1_y_value = /*scale_y*/ ctx[4](/*y_ticks*/ ctx[9][0]) + 30)) {
				attr(text_1, "y", text_1_y_value);
			}
		},
		d(detaching) {
			if (detaching) detach(line);
			if (detaching) detach(text_1);
		}
	};
}

// (82:3) {#each y_ticks as tick}
function create_each_block_4(ctx) {
	let line;
	let line_y__value;
	let line_y__value_1;
	let line_x__value;
	let line_x__value_1;
	let text_1;
	let t_value = /*tick*/ ctx[27] + "";
	let t;
	let text_1_y_value;
	let text_1_x_value;

	return {
		c() {
			line = svg_element("line");
			text_1 = svg_element("text");
			t = text(t_value);
			attr(line, "stroke-width", "0.5");
			attr(line, "y1", line_y__value = /*scale_y*/ ctx[4](/*tick*/ ctx[27]));
			attr(line, "y2", line_y__value_1 = /*scale_y*/ ctx[4](/*tick*/ ctx[27]));

			attr(line, "x1", line_x__value = /*scale_x*/ ctx[5](/*x_ticks*/ ctx[10][0] < /*x_domain*/ ctx[7][0]
			? /*x_ticks*/ ctx[10][0]
			: /*x_domain*/ ctx[7][0]) - 10);

			attr(line, "x2", line_x__value_1 = /*scale_x*/ ctx[5](/*x_domain*/ ctx[7][1] > /*x_ticks*/ ctx[10][/*x_ticks*/ ctx[10].length - 1]
			? /*x_domain*/ ctx[7][1]
			: /*x_ticks*/ ctx[10][/*x_ticks*/ ctx[10].length - 1]));

			attr(line, "stroke", "#aaa");
			attr(text_1, "class", "font-mono text-xs dark:fill-slate-200");
			attr(text_1, "text-anchor", "end");
			attr(text_1, "y", text_1_y_value = /*scale_y*/ ctx[4](/*tick*/ ctx[27]) + 4);
			attr(text_1, "x", text_1_x_value = /*scale_x*/ ctx[5](/*x_ticks*/ ctx[10][0]) - 20);
		},
		m(target, anchor) {
			insert(target, line, anchor);
			insert(target, text_1, anchor);
			append(text_1, t);
		},
		p(ctx, dirty) {
			if (dirty[0] & /*scale_y, y_ticks*/ 528 && line_y__value !== (line_y__value = /*scale_y*/ ctx[4](/*tick*/ ctx[27]))) {
				attr(line, "y1", line_y__value);
			}

			if (dirty[0] & /*scale_y, y_ticks*/ 528 && line_y__value_1 !== (line_y__value_1 = /*scale_y*/ ctx[4](/*tick*/ ctx[27]))) {
				attr(line, "y2", line_y__value_1);
			}

			if (dirty[0] & /*scale_x, x_ticks, x_domain*/ 1184 && line_x__value !== (line_x__value = /*scale_x*/ ctx[5](/*x_ticks*/ ctx[10][0] < /*x_domain*/ ctx[7][0]
			? /*x_ticks*/ ctx[10][0]
			: /*x_domain*/ ctx[7][0]) - 10)) {
				attr(line, "x1", line_x__value);
			}

			if (dirty[0] & /*scale_x, x_domain, x_ticks*/ 1184 && line_x__value_1 !== (line_x__value_1 = /*scale_x*/ ctx[5](/*x_domain*/ ctx[7][1] > /*x_ticks*/ ctx[10][/*x_ticks*/ ctx[10].length - 1]
			? /*x_domain*/ ctx[7][1]
			: /*x_ticks*/ ctx[10][/*x_ticks*/ ctx[10].length - 1]))) {
				attr(line, "x2", line_x__value_1);
			}

			if (dirty[0] & /*y_ticks*/ 512 && t_value !== (t_value = /*tick*/ ctx[27] + "")) set_data(t, t_value);

			if (dirty[0] & /*scale_y, y_ticks*/ 528 && text_1_y_value !== (text_1_y_value = /*scale_y*/ ctx[4](/*tick*/ ctx[27]) + 4)) {
				attr(text_1, "y", text_1_y_value);
			}

			if (dirty[0] & /*scale_x, x_ticks*/ 1056 && text_1_x_value !== (text_1_x_value = /*scale_x*/ ctx[5](/*x_ticks*/ ctx[10][0]) - 20)) {
				attr(text_1, "x", text_1_x_value);
			}
		},
		d(detaching) {
			if (detaching) detach(line);
			if (detaching) detach(text_1);
		}
	};
}

// (106:3) {#if y_domain[1] > y_ticks[y_ticks.length - 1]}
function create_if_block$1(ctx) {
	let line;
	let line_y__value;
	let line_y__value_1;
	let line_x__value;
	let line_x__value_1;
	let text_1;
	let t_value = /*y_domain*/ ctx[6][1] + "";
	let t;
	let text_1_y_value;
	let text_1_x_value;

	return {
		c() {
			line = svg_element("line");
			text_1 = svg_element("text");
			t = text(t_value);
			attr(line, "stroke-width", "0.5");
			attr(line, "y1", line_y__value = /*scale_y*/ ctx[4](/*y_domain*/ ctx[6][1]));
			attr(line, "y2", line_y__value_1 = /*scale_y*/ ctx[4](/*y_domain*/ ctx[6][1]));
			attr(line, "x1", line_x__value = /*scale_x*/ ctx[5](/*x_ticks*/ ctx[10][0]));
			attr(line, "x2", line_x__value_1 = /*scale_x*/ ctx[5](/*x_domain*/ ctx[7][1]));
			attr(line, "stroke", "#aaa");
			attr(text_1, "class", "font-mono text-xs dark:fill-slate-200");
			attr(text_1, "text-anchor", "end");
			attr(text_1, "y", text_1_y_value = /*scale_y*/ ctx[4](/*y_domain*/ ctx[6][1]) + 4);
			attr(text_1, "x", text_1_x_value = /*scale_x*/ ctx[5](/*x_ticks*/ ctx[10][0]) - 20);
		},
		m(target, anchor) {
			insert(target, line, anchor);
			insert(target, text_1, anchor);
			append(text_1, t);
		},
		p(ctx, dirty) {
			if (dirty[0] & /*scale_y, y_domain*/ 80 && line_y__value !== (line_y__value = /*scale_y*/ ctx[4](/*y_domain*/ ctx[6][1]))) {
				attr(line, "y1", line_y__value);
			}

			if (dirty[0] & /*scale_y, y_domain*/ 80 && line_y__value_1 !== (line_y__value_1 = /*scale_y*/ ctx[4](/*y_domain*/ ctx[6][1]))) {
				attr(line, "y2", line_y__value_1);
			}

			if (dirty[0] & /*scale_x, x_ticks*/ 1056 && line_x__value !== (line_x__value = /*scale_x*/ ctx[5](/*x_ticks*/ ctx[10][0]))) {
				attr(line, "x1", line_x__value);
			}

			if (dirty[0] & /*scale_x, x_domain*/ 160 && line_x__value_1 !== (line_x__value_1 = /*scale_x*/ ctx[5](/*x_domain*/ ctx[7][1]))) {
				attr(line, "x2", line_x__value_1);
			}

			if (dirty[0] & /*y_domain*/ 64 && t_value !== (t_value = /*y_domain*/ ctx[6][1] + "")) set_data(t, t_value);

			if (dirty[0] & /*scale_y, y_domain*/ 80 && text_1_y_value !== (text_1_y_value = /*scale_y*/ ctx[4](/*y_domain*/ ctx[6][1]) + 4)) {
				attr(text_1, "y", text_1_y_value);
			}

			if (dirty[0] & /*scale_x, x_ticks*/ 1056 && text_1_x_value !== (text_1_x_value = /*scale_x*/ ctx[5](/*x_ticks*/ ctx[10][0]) - 20)) {
				attr(text_1, "x", text_1_x_value);
			}
		},
		d(detaching) {
			if (detaching) detach(line);
			if (detaching) detach(text_1);
		}
	};
}

// (128:3) {#each values as { x, y }}
function create_each_block_3(ctx) {
	let circle;
	let circle_cx_value;
	let circle_cy_value;
	let circle_stroke_value;

	return {
		c() {
			circle = svg_element("circle");
			attr(circle, "r", "3.5");
			attr(circle, "cx", circle_cx_value = /*scale_x*/ ctx[5](/*x*/ ctx[0]));
			attr(circle, "cy", circle_cy_value = /*scale_y*/ ctx[4](/*y*/ ctx[1]));
			attr(circle, "stroke-width", "1.5");
			attr(circle, "stroke", circle_stroke_value = /*color*/ ctx[18]);
			attr(circle, "fill", "none");
		},
		m(target, anchor) {
			insert(target, circle, anchor);
		},
		p(ctx, dirty) {
			if (dirty[0] & /*scale_x, _y*/ 36 && circle_cx_value !== (circle_cx_value = /*scale_x*/ ctx[5](/*x*/ ctx[0]))) {
				attr(circle, "cx", circle_cx_value);
			}

			if (dirty[0] & /*scale_y, _y*/ 20 && circle_cy_value !== (circle_cy_value = /*scale_y*/ ctx[4](/*y*/ ctx[1]))) {
				attr(circle, "cy", circle_cy_value);
			}

			if (dirty[0] & /*color_map, _y*/ 260 && circle_stroke_value !== (circle_stroke_value = /*color*/ ctx[18])) {
				attr(circle, "stroke", circle_stroke_value);
			}
		},
		d(detaching) {
			if (detaching) detach(circle);
		}
	};
}

// (126:2) {#each _y as { name, values }}
function create_each_block_2(ctx) {
	let path;
	let path_d_value;
	let path_stroke_value;
	let each_value_3 = /*values*/ ctx[17];
	let each_blocks = [];

	for (let i = 0; i < each_value_3.length; i += 1) {
		each_blocks[i] = create_each_block_3(get_each_context_3(ctx, each_value_3, i));
	}

	return {
		c() {
			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			path = svg_element("path");
			attr(path, "d", path_d_value = _line().curve(curveLinear)(/*values*/ ctx[17].map(/*func*/ ctx[13])));
			attr(path, "fill", "none");
			attr(path, "stroke", path_stroke_value = /*color*/ ctx[18]);
			attr(path, "stroke-width", "3");
		},
		m(target, anchor) {
			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(target, anchor);
			}

			insert(target, path, anchor);
		},
		p(ctx, dirty) {
			if (dirty[0] & /*scale_x, _y, scale_y, color_map*/ 308) {
				each_value_3 = /*values*/ ctx[17];
				let i;

				for (i = 0; i < each_value_3.length; i += 1) {
					const child_ctx = get_each_context_3(ctx, each_value_3, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block_3(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(path.parentNode, path);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value_3.length;
			}

			if (dirty[0] & /*_y, scale_x, scale_y*/ 52 && path_d_value !== (path_d_value = _line().curve(curveLinear)(/*values*/ ctx[17].map(/*func*/ ctx[13])))) {
				attr(path, "d", path_d_value);
			}

			if (dirty[0] & /*color_map, _y*/ 260 && path_stroke_value !== (path_stroke_value = /*color*/ ctx[18])) {
				attr(path, "stroke", path_stroke_value);
			}
		},
		d(detaching) {
			destroy_each(each_blocks, detaching);
			if (detaching) detach(path);
		}
	};
}

// (150:3) {#each values as { x, y }}
function create_each_block_1(ctx) {
	let circle;
	let circle_cx_value;
	let circle_cy_value;
	let tooltip_action;
	let mounted;
	let dispose;

	return {
		c() {
			circle = svg_element("circle");
			attr(circle, "r", "7");
			attr(circle, "cx", circle_cx_value = /*scale_x*/ ctx[5](/*x*/ ctx[0]));
			attr(circle, "cy", circle_cy_value = /*scale_y*/ ctx[4](/*y*/ ctx[1]));
			attr(circle, "stroke", "black");
			attr(circle, "fill", "black");
			set_style(circle, "cursor", "pointer");
			set_style(circle, "opacity", "0");
		},
		m(target, anchor) {
			insert(target, circle, anchor);

			if (!mounted) {
				dispose = action_destroyer(tooltip_action = tooltip.call(null, circle, {
					color: /*color*/ ctx[18],
					text: `(${/*x*/ ctx[0]}, ${/*y*/ ctx[1]})`
				}));

				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;

			if (dirty[0] & /*scale_x, _y*/ 36 && circle_cx_value !== (circle_cx_value = /*scale_x*/ ctx[5](/*x*/ ctx[0]))) {
				attr(circle, "cx", circle_cx_value);
			}

			if (dirty[0] & /*scale_y, _y*/ 20 && circle_cy_value !== (circle_cy_value = /*scale_y*/ ctx[4](/*y*/ ctx[1]))) {
				attr(circle, "cy", circle_cy_value);
			}

			if (tooltip_action && is_function(tooltip_action.update) && dirty[0] & /*color_map, _y*/ 260) tooltip_action.update.call(null, {
				color: /*color*/ ctx[18],
				text: `(${/*x*/ ctx[0]}, ${/*y*/ ctx[1]})`
			});
		},
		d(detaching) {
			if (detaching) detach(circle);
			mounted = false;
			dispose();
		}
	};
}

// (148:2) {#each _y as { name, values }}
function create_each_block(ctx) {
	let each_1_anchor;
	let each_value_1 = /*values*/ ctx[17];
	let each_blocks = [];

	for (let i = 0; i < each_value_1.length; i += 1) {
		each_blocks[i] = create_each_block_1(get_each_context_1(ctx, each_value_1, i));
	}

	return {
		c() {
			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			each_1_anchor = empty();
		},
		m(target, anchor) {
			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(target, anchor);
			}

			insert(target, each_1_anchor, anchor);
		},
		p(ctx, dirty) {
			if (dirty[0] & /*scale_x, _y, scale_y, color_map*/ 308) {
				each_value_1 = /*values*/ ctx[17];
				let i;

				for (i = 0; i < each_value_1.length; i += 1) {
					const child_ctx = get_each_context_1(ctx, each_value_1, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block_1(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(each_1_anchor.parentNode, each_1_anchor);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value_1.length;
			}
		},
		d(detaching) {
			destroy_each(each_blocks, detaching);
			if (detaching) detach(each_1_anchor);
		}
	};
}

function create_fragment$1(ctx) {
	let div2;
	let div0;
	let t0;
	let svg;
	let g;
	let each1_anchor;
	let each2_anchor;
	let each3_anchor;
	let t1;
	let div1;
	let t2_value = /*_x*/ ctx[3].name + "";
	let t2;
	let each_value_6 = /*_y*/ ctx[2];
	let each_blocks_4 = [];

	for (let i = 0; i < each_value_6.length; i += 1) {
		each_blocks_4[i] = create_each_block_6(get_each_context_6(ctx, each_value_6, i));
	}

	let each_value_5 = /*x_ticks*/ ctx[10];
	let each_blocks_3 = [];

	for (let i = 0; i < each_value_5.length; i += 1) {
		each_blocks_3[i] = create_each_block_5(get_each_context_5(ctx, each_value_5, i));
	}

	let each_value_4 = /*y_ticks*/ ctx[9];
	let each_blocks_2 = [];

	for (let i = 0; i < each_value_4.length; i += 1) {
		each_blocks_2[i] = create_each_block_4(get_each_context_4(ctx, each_value_4, i));
	}

	let if_block = /*y_domain*/ ctx[6][1] > /*y_ticks*/ ctx[9][/*y_ticks*/ ctx[9].length - 1] && create_if_block$1(ctx);
	let each_value_2 = /*_y*/ ctx[2];
	let each_blocks_1 = [];

	for (let i = 0; i < each_value_2.length; i += 1) {
		each_blocks_1[i] = create_each_block_2(get_each_context_2(ctx, each_value_2, i));
	}

	let each_value = /*_y*/ ctx[2];
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));
	}

	return {
		c() {
			div2 = element("div");
			div0 = element("div");

			for (let i = 0; i < each_blocks_4.length; i += 1) {
				each_blocks_4[i].c();
			}

			t0 = space();
			svg = svg_element("svg");
			g = svg_element("g");

			for (let i = 0; i < each_blocks_3.length; i += 1) {
				each_blocks_3[i].c();
			}

			each1_anchor = empty();

			for (let i = 0; i < each_blocks_2.length; i += 1) {
				each_blocks_2[i].c();
			}

			each2_anchor = empty();
			if (if_block) if_block.c();

			for (let i = 0; i < each_blocks_1.length; i += 1) {
				each_blocks_1[i].c();
			}

			each3_anchor = empty();

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			t1 = space();
			div1 = element("div");
			t2 = text(t2_value);
			attr(div0, "class", "flex justify-center items-center text-sm dark:text-slate-200");
			attr(svg, "class", "w-full");
			attr(svg, "viewBox", "-70 -20 700 420");
			attr(div1, "class", "flex justify-center align-items-center text-sm dark:text-slate-200");
			attr(div2, "class", "mt-3");
		},
		m(target, anchor) {
			insert(target, div2, anchor);
			append(div2, div0);

			for (let i = 0; i < each_blocks_4.length; i += 1) {
				each_blocks_4[i].m(div0, null);
			}

			append(div2, t0);
			append(div2, svg);
			append(svg, g);

			for (let i = 0; i < each_blocks_3.length; i += 1) {
				each_blocks_3[i].m(g, null);
			}

			append(g, each1_anchor);

			for (let i = 0; i < each_blocks_2.length; i += 1) {
				each_blocks_2[i].m(g, null);
			}

			append(g, each2_anchor);
			if (if_block) if_block.m(g, null);

			for (let i = 0; i < each_blocks_1.length; i += 1) {
				each_blocks_1[i].m(svg, null);
			}

			append(svg, each3_anchor);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(svg, null);
			}

			append(div2, t1);
			append(div2, div1);
			append(div1, t2);
		},
		p(ctx, dirty) {
			if (dirty[0] & /*_y, color_map*/ 260) {
				each_value_6 = /*_y*/ ctx[2];
				let i;

				for (i = 0; i < each_value_6.length; i += 1) {
					const child_ctx = get_each_context_6(ctx, each_value_6, i);

					if (each_blocks_4[i]) {
						each_blocks_4[i].p(child_ctx, dirty);
					} else {
						each_blocks_4[i] = create_each_block_6(child_ctx);
						each_blocks_4[i].c();
						each_blocks_4[i].m(div0, null);
					}
				}

				for (; i < each_blocks_4.length; i += 1) {
					each_blocks_4[i].d(1);
				}

				each_blocks_4.length = each_value_6.length;
			}

			if (dirty[0] & /*scale_x, x_ticks, scale_y, y_ticks, y_domain*/ 1648) {
				each_value_5 = /*x_ticks*/ ctx[10];
				let i;

				for (i = 0; i < each_value_5.length; i += 1) {
					const child_ctx = get_each_context_5(ctx, each_value_5, i);

					if (each_blocks_3[i]) {
						each_blocks_3[i].p(child_ctx, dirty);
					} else {
						each_blocks_3[i] = create_each_block_5(child_ctx);
						each_blocks_3[i].c();
						each_blocks_3[i].m(g, each1_anchor);
					}
				}

				for (; i < each_blocks_3.length; i += 1) {
					each_blocks_3[i].d(1);
				}

				each_blocks_3.length = each_value_5.length;
			}

			if (dirty[0] & /*scale_y, y_ticks, scale_x, x_ticks, x_domain*/ 1712) {
				each_value_4 = /*y_ticks*/ ctx[9];
				let i;

				for (i = 0; i < each_value_4.length; i += 1) {
					const child_ctx = get_each_context_4(ctx, each_value_4, i);

					if (each_blocks_2[i]) {
						each_blocks_2[i].p(child_ctx, dirty);
					} else {
						each_blocks_2[i] = create_each_block_4(child_ctx);
						each_blocks_2[i].c();
						each_blocks_2[i].m(g, each2_anchor);
					}
				}

				for (; i < each_blocks_2.length; i += 1) {
					each_blocks_2[i].d(1);
				}

				each_blocks_2.length = each_value_4.length;
			}

			if (/*y_domain*/ ctx[6][1] > /*y_ticks*/ ctx[9][/*y_ticks*/ ctx[9].length - 1]) {
				if (if_block) {
					if_block.p(ctx, dirty);
				} else {
					if_block = create_if_block$1(ctx);
					if_block.c();
					if_block.m(g, null);
				}
			} else if (if_block) {
				if_block.d(1);
				if_block = null;
			}

			if (dirty[0] & /*_y, scale_x, scale_y, color_map*/ 308) {
				each_value_2 = /*_y*/ ctx[2];
				let i;

				for (i = 0; i < each_value_2.length; i += 1) {
					const child_ctx = get_each_context_2(ctx, each_value_2, i);

					if (each_blocks_1[i]) {
						each_blocks_1[i].p(child_ctx, dirty);
					} else {
						each_blocks_1[i] = create_each_block_2(child_ctx);
						each_blocks_1[i].c();
						each_blocks_1[i].m(svg, each3_anchor);
					}
				}

				for (; i < each_blocks_1.length; i += 1) {
					each_blocks_1[i].d(1);
				}

				each_blocks_1.length = each_value_2.length;
			}

			if (dirty[0] & /*_y, scale_x, scale_y, color_map*/ 308) {
				each_value = /*_y*/ ctx[2];
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(svg, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}

			if (dirty[0] & /*_x*/ 8 && t2_value !== (t2_value = /*_x*/ ctx[3].name + "")) set_data(t2, t2_value);
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div2);
			destroy_each(each_blocks_4, detaching);
			destroy_each(each_blocks_3, detaching);
			destroy_each(each_blocks_2, detaching);
			if (if_block) if_block.d();
			destroy_each(each_blocks_1, detaching);
			destroy_each(each_blocks, detaching);
		}
	};
}

function instance$1($$self, $$props, $$invalidate) {
	let _x;
	let _y;
	let x_domain;
	let y_domain;
	let scale_x;
	let scale_y;
	let x_ticks;
	let y_ticks;
	let { value } = $$props;
	let { x = undefined } = $$props;
	let { y = undefined } = $$props;
	let { colors: colors$1 = [] } = $$props;
	const dispatch = createEventDispatcher();
	let color_map;

	function get_color(index) {
		let current_color = colors$1[index % colors$1.length];

		if (current_color && current_color in colors) {
			return colors[current_color]?.primary;
		} else if (!current_color) {
			return colors[get_next_color(index)].primary;
		} else {
			return current_color;
		}
	}

	onMount(() => {
		dispatch("process", { x: _x, y: _y });
	});

	const func = ({ x, y }) => [scale_x(x), scale_y(y)];

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(11, value = $$props.value);
		if ('x' in $$props) $$invalidate(0, x = $$props.x);
		if ('y' in $$props) $$invalidate(1, y = $$props.y);
		if ('colors' in $$props) $$invalidate(12, colors$1 = $$props.colors);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty[0] & /*value, x, y*/ 2051) {
			$$invalidate(
				3,
				{ x: _x, y: _y } = typeof value === "string"
				? transform_values(csvParse(value), x, y)
				: transform_values(value, x, y),
				_x,
				((($$invalidate(2, _y), $$invalidate(11, value)), $$invalidate(0, x)), $$invalidate(1, y))
			);
		}

		if ($$self.$$.dirty[0] & /*_x*/ 8) {
			$$invalidate(7, x_domain = get_domains(_x));
		}

		if ($$self.$$.dirty[0] & /*_y*/ 4) {
			$$invalidate(6, y_domain = get_domains(_y));
		}

		if ($$self.$$.dirty[0] & /*x_domain*/ 128) {
			$$invalidate(5, scale_x = linear(x_domain, [0, 600]).nice());
		}

		if ($$self.$$.dirty[0] & /*y_domain*/ 64) {
			$$invalidate(4, scale_y = linear(y_domain, [350, 0]).nice());
		}

		if ($$self.$$.dirty[0] & /*scale_x*/ 32) {
			$$invalidate(10, x_ticks = scale_x.ticks(8));
		}

		if ($$self.$$.dirty[0] & /*scale_y*/ 16) {
			$$invalidate(9, y_ticks = scale_y.ticks(8));
		}

		if ($$self.$$.dirty[0] & /*_y*/ 4) {
			$$invalidate(8, color_map = _y.reduce((acc, next, i) => ({ ...acc, [next.name]: get_color(i) }), {}));
		}
	};

	return [
		x,
		y,
		_y,
		_x,
		scale_y,
		scale_x,
		y_domain,
		x_domain,
		color_map,
		y_ticks,
		x_ticks,
		value,
		colors$1,
		func
	];
}

class Chart extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$1, create_fragment$1, safe_not_equal, { value: 11, x: 0, y: 1, colors: 12 }, null, [-1, -1]);
	}
}

/* src/components/TimeSeries/TimeSeries.svelte generated by Svelte v3.49.0 */

function create_if_block_3(ctx) {
	let div;
	let upload;
	let current;

	upload = new Upload({
			props: {
				filetype: "text/csv",
				include_file_metadata: false,
				$$slots: { default: [create_default_slot_1] },
				$$scope: { ctx }
			}
		});

	upload.$on("load", /*load_handler*/ ctx[16]);

	return {
		c() {
			div = element("div");
			create_component(upload.$$.fragment);
			attr(div, "class", "h-full min-h-[8rem]");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			mount_component(upload, div, null);
			current = true;
		},
		p(ctx, dirty) {
			const upload_changes = {};

			if (dirty & /*$$scope, $_*/ 532480) {
				upload_changes.$$scope = { dirty, ctx };
			}

			upload.$set(upload_changes);
		},
		i(local) {
			if (current) return;
			transition_in(upload.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(upload.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div);
			destroy_component(upload);
		}
	};
}

// (93:18) 
function create_if_block_2(ctx) {
	let chart;
	let current;

	chart = new Chart({
			props: {
				value: /*_value*/ ctx[11],
				y: /*y*/ ctx[4],
				x: /*x*/ ctx[5],
				colors: /*colors*/ ctx[9]
			}
		});

	chart.$on("process", /*process_handler*/ ctx[15]);

	return {
		c() {
			create_component(chart.$$.fragment);
		},
		m(target, anchor) {
			mount_component(chart, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const chart_changes = {};
			if (dirty & /*_value*/ 2048) chart_changes.value = /*_value*/ ctx[11];
			if (dirty & /*y*/ 16) chart_changes.y = /*y*/ ctx[4];
			if (dirty & /*x*/ 32) chart_changes.x = /*x*/ ctx[5];
			if (dirty & /*colors*/ 512) chart_changes.colors = /*colors*/ ctx[9];
			chart.$set(chart_changes);
		},
		i(local) {
			if (current) return;
			transition_in(chart.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(chart.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(chart, detaching);
		}
	};
}

// (85:1) {#if mode === "static"}
function create_if_block(ctx) {
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;
	const if_block_creators = [create_if_block_1, create_else_block];
	const if_blocks = [];

	function select_block_type_1(ctx, dirty) {
		if (/*static_data*/ ctx[12]) return 0;
		return 1;
	}

	current_block_type_index = select_block_type_1(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			if_blocks[current_block_type_index].m(target, anchor);
			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type_1(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i(local) {
			if (current) return;
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach(if_block_anchor);
		}
	};
}

// (103:3) <Upload     filetype="text/csv"     on:load={({ detail }) => handle_load(detail)}     include_file_metadata={false}    >
function create_default_slot_1(ctx) {
	let t0_value = /*$_*/ ctx[13]("interface.drop_csv") + "";
	let t0;
	let t1;
	let br0;
	let t2;
	let t3_value = /*$_*/ ctx[13]("or") + "";
	let t3;
	let t4;
	let br1;
	let t5;
	let t6_value = /*$_*/ ctx[13]("interface.click_to_upload") + "";
	let t6;

	return {
		c() {
			t0 = text(t0_value);
			t1 = space();
			br0 = element("br");
			t2 = text("- ");
			t3 = text(t3_value);
			t4 = text(" -");
			br1 = element("br");
			t5 = space();
			t6 = text(t6_value);
		},
		m(target, anchor) {
			insert(target, t0, anchor);
			insert(target, t1, anchor);
			insert(target, br0, anchor);
			insert(target, t2, anchor);
			insert(target, t3, anchor);
			insert(target, t4, anchor);
			insert(target, br1, anchor);
			insert(target, t5, anchor);
			insert(target, t6, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*$_*/ 8192 && t0_value !== (t0_value = /*$_*/ ctx[13]("interface.drop_csv") + "")) set_data(t0, t0_value);
			if (dirty & /*$_*/ 8192 && t3_value !== (t3_value = /*$_*/ ctx[13]("or") + "")) set_data(t3, t3_value);
			if (dirty & /*$_*/ 8192 && t6_value !== (t6_value = /*$_*/ ctx[13]("interface.click_to_upload") + "")) set_data(t6, t6_value);
		},
		d(detaching) {
			if (detaching) detach(t0);
			if (detaching) detach(t1);
			if (detaching) detach(br0);
			if (detaching) detach(t2);
			if (detaching) detach(t3);
			if (detaching) detach(t4);
			if (detaching) detach(br1);
			if (detaching) detach(t5);
			if (detaching) detach(t6);
		}
	};
}

// (88:2) {:else}
function create_else_block(ctx) {
	let div1;
	let div0;
	let charticon;
	let current;
	charticon = new Chart$1({});

	return {
		c() {
			div1 = element("div");
			div0 = element("div");
			create_component(charticon.$$.fragment);
			attr(div0, "class", "h-5 dark:text-white opacity-50");
			attr(div1, "class", "h-full min-h-[15rem] flex justify-center items-center");
		},
		m(target, anchor) {
			insert(target, div1, anchor);
			append(div1, div0);
			mount_component(charticon, div0, null);
			current = true;
		},
		p: noop,
		i(local) {
			if (current) return;
			transition_in(charticon.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(charticon.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div1);
			destroy_component(charticon);
		}
	};
}

// (86:2) {#if static_data}
function create_if_block_1(ctx) {
	let chart;
	let current;

	chart = new Chart({
			props: {
				value: /*static_data*/ ctx[12],
				colors: /*colors*/ ctx[9]
			}
		});

	return {
		c() {
			create_component(chart.$$.fragment);
		},
		m(target, anchor) {
			mount_component(chart, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const chart_changes = {};
			if (dirty & /*static_data*/ 4096) chart_changes.value = /*static_data*/ ctx[12];
			if (dirty & /*colors*/ 512) chart_changes.colors = /*colors*/ ctx[9];
			chart.$set(chart_changes);
		},
		i(local) {
			if (current) return;
			transition_in(chart.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(chart.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(chart, detaching);
		}
	};
}

// (74:0) <Block  {visible}  variant={mode === "dynamic" && !_value ? "dashed" : "solid"}  color={"grey"}  padding={false}  {elem_id}  style={{ rounded: style.rounded }} >
function create_default_slot(ctx) {
	let blocklabel;
	let t0;
	let statustracker;
	let t1;
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;

	blocklabel = new BlockLabel({
			props: {
				show_label: /*show_label*/ ctx[8],
				Icon: Chart$1,
				label: /*label*/ ctx[7] || "TimeSeries"
			}
		});

	const statustracker_spread_levels = [/*loading_status*/ ctx[10]];
	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new StatusTracker({ props: statustracker_props });
	const if_block_creators = [create_if_block, create_if_block_2, create_if_block_3];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*mode*/ ctx[6] === "static") return 0;
		if (/*_value*/ ctx[11]) return 1;
		if (/*value*/ ctx[0] === undefined) return 2;
		return -1;
	}

	if (~(current_block_type_index = select_block_type(ctx))) {
		if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
	}

	return {
		c() {
			create_component(blocklabel.$$.fragment);
			t0 = space();
			create_component(statustracker.$$.fragment);
			t1 = space();
			if (if_block) if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			mount_component(blocklabel, target, anchor);
			insert(target, t0, anchor);
			mount_component(statustracker, target, anchor);
			insert(target, t1, anchor);

			if (~current_block_type_index) {
				if_blocks[current_block_type_index].m(target, anchor);
			}

			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const blocklabel_changes = {};
			if (dirty & /*show_label*/ 256) blocklabel_changes.show_label = /*show_label*/ ctx[8];
			if (dirty & /*label*/ 128) blocklabel_changes.label = /*label*/ ctx[7] || "TimeSeries";
			blocklabel.$set(blocklabel_changes);

			const statustracker_changes = (dirty & /*loading_status*/ 1024)
			? get_spread_update(statustracker_spread_levels, [get_spread_object(/*loading_status*/ ctx[10])])
			: {};

			statustracker.$set(statustracker_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if (~current_block_type_index) {
					if_blocks[current_block_type_index].p(ctx, dirty);
				}
			} else {
				if (if_block) {
					group_outros();

					transition_out(if_blocks[previous_block_index], 1, 1, () => {
						if_blocks[previous_block_index] = null;
					});

					check_outros();
				}

				if (~current_block_type_index) {
					if_block = if_blocks[current_block_type_index];

					if (!if_block) {
						if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
						if_block.c();
					} else {
						if_block.p(ctx, dirty);
					}

					transition_in(if_block, 1);
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				} else {
					if_block = null;
				}
			}
		},
		i(local) {
			if (current) return;
			transition_in(blocklabel.$$.fragment, local);
			transition_in(statustracker.$$.fragment, local);
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(blocklabel.$$.fragment, local);
			transition_out(statustracker.$$.fragment, local);
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			destroy_component(blocklabel, detaching);
			if (detaching) detach(t0);
			destroy_component(statustracker, detaching);
			if (detaching) detach(t1);

			if (~current_block_type_index) {
				if_blocks[current_block_type_index].d(detaching);
			}

			if (detaching) detach(if_block_anchor);
		}
	};
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				visible: /*visible*/ ctx[3],
				variant: /*mode*/ ctx[6] === "dynamic" && !/*_value*/ ctx[11]
				? "dashed"
				: "solid",
				color: "grey",
				padding: false,
				elem_id: /*elem_id*/ ctx[2],
				style: { rounded: /*style*/ ctx[1].rounded },
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			create_component(block.$$.fragment);
		},
		m(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const block_changes = {};
			if (dirty & /*visible*/ 8) block_changes.visible = /*visible*/ ctx[3];

			if (dirty & /*mode, _value*/ 2112) block_changes.variant = /*mode*/ ctx[6] === "dynamic" && !/*_value*/ ctx[11]
			? "dashed"
			: "solid";

			if (dirty & /*elem_id*/ 4) block_changes.elem_id = /*elem_id*/ ctx[2];
			if (dirty & /*style*/ 2) block_changes.style = { rounded: /*style*/ ctx[1].rounded };

			if (dirty & /*$$scope, static_data, colors, mode, _value, y, x, value, $_, loading_status, show_label, label*/ 540657) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(block, detaching);
		}
	};
}

function format_value(val) {
	return val.data.map(r => r.reduce((acc, next, i) => ({ ...acc, [val.headers[i]]: next }), {}));
}

function data_uri_to_blob(data_uri) {
	const byte_str = atob(data_uri.split(",")[1]);
	const mime_str = data_uri.split(",")[0].split(":")[1].split(";")[0];
	const ab = new ArrayBuffer(byte_str.length);
	const ia = new Uint8Array(ab);

	for (let i = 0; i < byte_str.length; i++) {
		ia[i] = byte_str.charCodeAt(i);
	}

	return new Blob([ab], { type: mime_str });
}

function make_dict(x, y) {
	const headers = [];
	const data = [];
	headers.push(x.name);
	y.forEach(({ name }) => headers.push(name));

	for (let i = 0; i < x.values.length; i++) {
		let _data = [];
		_data.push(x.values[i]);
		y.forEach(({ values }) => _data.push(values[i].y));
		data.push(_data);
	}

	return { headers, data };
}

function instance($$self, $$props, $$invalidate) {
	let static_data;
	let $_;
	component_subscribe($$self, X, $$value => $$invalidate(13, $_ = $$value));
	let { style = {} } = $$props;
	const dispatch = createEventDispatcher();
	let { elem_id = "" } = $$props;
	let { visible = true } = $$props;
	let { value } = $$props;
	let { y } = $$props;
	let { x } = $$props;
	let { mode } = $$props;
	let { label } = $$props;
	let { show_label } = $$props;
	let { colors } = $$props;
	let { loading_status } = $$props;
	let _value;

	function blob_to_string(blob) {
		const reader = new FileReader();

		reader.addEventListener("loadend", e => {
			//@ts-ignore
			$$invalidate(11, _value = e.srcElement.result);
		});

		reader.readAsText(blob);
	}

	function handle_load(v) {
		$$invalidate(0, value = { data: v });

		// setValue({ data: v as string });
		return v;
	}

	const process_handler = ({ detail: { x, y } }) => $$invalidate(0, value = make_dict(x, y));
	const load_handler = ({ detail }) => handle_load(detail);

	$$self.$$set = $$props => {
		if ('style' in $$props) $$invalidate(1, style = $$props.style);
		if ('elem_id' in $$props) $$invalidate(2, elem_id = $$props.elem_id);
		if ('visible' in $$props) $$invalidate(3, visible = $$props.visible);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('y' in $$props) $$invalidate(4, y = $$props.y);
		if ('x' in $$props) $$invalidate(5, x = $$props.x);
		if ('mode' in $$props) $$invalidate(6, mode = $$props.mode);
		if ('label' in $$props) $$invalidate(7, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(8, show_label = $$props.show_label);
		if ('colors' in $$props) $$invalidate(9, colors = $$props.colors);
		if ('loading_status' in $$props) $$invalidate(10, loading_status = $$props.loading_status);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value*/ 1) {
			{
				if (value && value.data && typeof value.data === "string") {
					if (!value) $$invalidate(11, _value = null); else blob_to_string(data_uri_to_blob(value.data));
				}
			}
		}

		if ($$self.$$.dirty & /*value, _value*/ 2049) {
			$$invalidate(11, _value = value == null ? null : _value);
		}

		if ($$self.$$.dirty & /*mode, value*/ 65) {
			$$invalidate(12, static_data = mode === "static" && value && format_value(value));
		}

		if ($$self.$$.dirty & /*value*/ 1) {
			(dispatch("change"));
		}
	};

	return [
		value,
		style,
		elem_id,
		visible,
		y,
		x,
		mode,
		label,
		show_label,
		colors,
		loading_status,
		_value,
		static_data,
		$_,
		handle_load,
		process_handler,
		load_handler
	];
}

class TimeSeries extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance, create_fragment, safe_not_equal, {
			style: 1,
			elem_id: 2,
			visible: 3,
			value: 0,
			y: 4,
			x: 5,
			mode: 6,
			label: 7,
			show_label: 8,
			colors: 9,
			loading_status: 10
		});
	}
}

var TimeSeries$1 = TimeSeries;

const modes = ["static", "dynamic"];

export { TimeSeries$1 as Component, modes };
