"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionFilter = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const logs_generated_1 = require("./logs.generated");
/**
 * A new Subscription on a CloudWatch log group.
 */
class SubscriptionFilter extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_logs_SubscriptionFilterProps(props);
        const destProps = props.destination.bind(this, props.logGroup);
        new logs_generated_1.CfnSubscriptionFilter(this, 'Resource', {
            logGroupName: props.logGroup.logGroupName,
            destinationArn: destProps.arn,
            roleArn: destProps.role && destProps.role.roleArn,
            filterPattern: props.filterPattern.logPatternString,
        });
    }
}
exports.SubscriptionFilter = SubscriptionFilter;
_a = JSII_RTTI_SYMBOL_1;
SubscriptionFilter[_a] = { fqn: "@aws-cdk/aws-logs.SubscriptionFilter", version: "1.146.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3Vic2NyaXB0aW9uLWZpbHRlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInN1YnNjcmlwdGlvbi1maWx0ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQ0Esd0NBQXlDO0FBR3pDLHFEQUF5RDtBQWtEekQ7O0dBRUc7QUFDSCxNQUFhLGtCQUFtQixTQUFRLGVBQVE7SUFDOUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE4QjtRQUN0RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDOztRQUVqQixNQUFNLFNBQVMsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBRS9ELElBQUksc0NBQXFCLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUMxQyxZQUFZLEVBQUUsS0FBSyxDQUFDLFFBQVEsQ0FBQyxZQUFZO1lBQ3pDLGNBQWMsRUFBRSxTQUFTLENBQUMsR0FBRztZQUM3QixPQUFPLEVBQUUsU0FBUyxDQUFDLElBQUksSUFBSSxTQUFTLENBQUMsSUFBSSxDQUFDLE9BQU87WUFDakQsYUFBYSxFQUFFLEtBQUssQ0FBQyxhQUFhLENBQUMsZ0JBQWdCO1NBQ3BELENBQUMsQ0FBQztLQUNKOztBQVpILGdEQWFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgaWFtIGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0IHsgUmVzb3VyY2UgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgSUxvZ0dyb3VwLCBTdWJzY3JpcHRpb25GaWx0ZXJPcHRpb25zIH0gZnJvbSAnLi9sb2ctZ3JvdXAnO1xuaW1wb3J0IHsgQ2ZuU3Vic2NyaXB0aW9uRmlsdGVyIH0gZnJvbSAnLi9sb2dzLmdlbmVyYXRlZCc7XG5cbi8vIHYyIC0ga2VlcCB0aGlzIHNlY3Rpb24gc2VwYXJhdGUgdG8gcmVkdWNlIG1lcmdlIGNvbmZsaWN0cyB3aGVuIG1lcmdpbmcgZm9yd3JhZCBpbnRvIHYyIGJyYW5jaFxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lXG5pbXBvcnQgeyBDb25zdHJ1Y3QgYXMgQ29yZUNvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4vKipcbiAqIEludGVyZmFjZSBmb3IgY2xhc3NlcyB0aGF0IGNhbiBiZSB0aGUgZGVzdGluYXRpb24gb2YgYSBsb2cgU3Vic2NyaXB0aW9uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSUxvZ1N1YnNjcmlwdGlvbkRlc3RpbmF0aW9uIHtcbiAgLyoqXG4gICAqIFJldHVybiB0aGUgcHJvcGVydGllcyByZXF1aXJlZCB0byBzZW5kIHN1YnNjcmlwdGlvbiBldmVudHMgdG8gdGhpcyBkZXN0aW5hdGlvbi5cbiAgICpcbiAgICogSWYgbmVjZXNzYXJ5LCB0aGUgZGVzdGluYXRpb24gY2FuIHVzZSB0aGUgcHJvcGVydGllcyBvZiB0aGUgU3Vic2NyaXB0aW9uRmlsdGVyXG4gICAqIG9iamVjdCBpdHNlbGYgdG8gY29uZmlndXJlIGl0cyBwZXJtaXNzaW9ucyB0byBhbGxvdyB0aGUgc3Vic2NyaXB0aW9uIHRvIHdyaXRlXG4gICAqIHRvIGl0LlxuICAgKlxuICAgKiBUaGUgZGVzdGluYXRpb24gbWF5IHJlY29uZmlndXJlIGl0cyBvd24gcGVybWlzc2lvbnMgaW4gcmVzcG9uc2UgdG8gdGhpc1xuICAgKiBmdW5jdGlvbiBjYWxsLlxuICAgKi9cbiAgYmluZChzY29wZTogQ29yZUNvbnN0cnVjdCwgc291cmNlTG9nR3JvdXA6IElMb2dHcm91cCk6IExvZ1N1YnNjcmlwdGlvbkRlc3RpbmF0aW9uQ29uZmlnO1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgcmV0dXJuZWQgYnkgYSBTdWJzY3JpcHRpb24gZGVzdGluYXRpb25cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBMb2dTdWJzY3JpcHRpb25EZXN0aW5hdGlvbkNvbmZpZyB7XG4gIC8qKlxuICAgKiBUaGUgQVJOIG9mIHRoZSBzdWJzY3JpcHRpb24ncyBkZXN0aW5hdGlvblxuICAgKi9cbiAgcmVhZG9ubHkgYXJuOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSByb2xlIHRvIGFzc3VtZSB0byB3cml0ZSBsb2cgZXZlbnRzIHRvIHRoZSBkZXN0aW5hdGlvblxuICAgKlxuICAgKiBAZGVmYXVsdCBObyByb2xlIGFzc3VtZWRcbiAgICovXG4gIHJlYWRvbmx5IHJvbGU/OiBpYW0uSVJvbGU7XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgYSBTdWJzY3JpcHRpb25GaWx0ZXJcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTdWJzY3JpcHRpb25GaWx0ZXJQcm9wcyBleHRlbmRzIFN1YnNjcmlwdGlvbkZpbHRlck9wdGlvbnMge1xuICAvKipcbiAgICogVGhlIGxvZyBncm91cCB0byBjcmVhdGUgdGhlIHN1YnNjcmlwdGlvbiBvbi5cbiAgICovXG4gIHJlYWRvbmx5IGxvZ0dyb3VwOiBJTG9nR3JvdXA7XG59XG5cbi8qKlxuICogQSBuZXcgU3Vic2NyaXB0aW9uIG9uIGEgQ2xvdWRXYXRjaCBsb2cgZ3JvdXAuXG4gKi9cbmV4cG9ydCBjbGFzcyBTdWJzY3JpcHRpb25GaWx0ZXIgZXh0ZW5kcyBSZXNvdXJjZSB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBTdWJzY3JpcHRpb25GaWx0ZXJQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCBkZXN0UHJvcHMgPSBwcm9wcy5kZXN0aW5hdGlvbi5iaW5kKHRoaXMsIHByb3BzLmxvZ0dyb3VwKTtcblxuICAgIG5ldyBDZm5TdWJzY3JpcHRpb25GaWx0ZXIodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgbG9nR3JvdXBOYW1lOiBwcm9wcy5sb2dHcm91cC5sb2dHcm91cE5hbWUsXG4gICAgICBkZXN0aW5hdGlvbkFybjogZGVzdFByb3BzLmFybixcbiAgICAgIHJvbGVBcm46IGRlc3RQcm9wcy5yb2xlICYmIGRlc3RQcm9wcy5yb2xlLnJvbGVBcm4sXG4gICAgICBmaWx0ZXJQYXR0ZXJuOiBwcm9wcy5maWx0ZXJQYXR0ZXJuLmxvZ1BhdHRlcm5TdHJpbmcsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==