import { IFunction } from '@aws-cdk/aws-lambda';
import { NodejsFunctionProps } from '@aws-cdk/aws-lambda-nodejs';
import { IQueue } from '@aws-cdk/aws-sqs';
import { Construct } from '@aws-cdk/core';
/**
 *
 */
export interface SqsRedriveProps {
    /**
     * The SQS Queue that holds dead-letters.
     */
    readonly deadLetterQueue: IQueue;
    /**
     * The SQS Queue that will re-process the DLQ messages.
     */
    readonly mainQueue: IQueue;
    /**
     * The underlying Lambda Function that does all the heavy lifting.
     *
     * Code originally lifted from here: https://www.stackery.io/blog/failed-sqs-messages/
     */
    readonly lambdaProps?: NodejsFunctionProps;
}
/**
 *
 */
export declare class SqsRedrive extends Construct {
    /**
     *
     */
    redriveFunction: IFunction;
    /**
     *
     */
    constructor(scope: Construct, id: string, props: SqsRedriveProps);
}
