"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsRedrive = void 0;
const path_1 = require("path");
const aws_lambda_nodejs_1 = require("@aws-cdk/aws-lambda-nodejs");
const core_1 = require("@aws-cdk/core");
/**
 *
 */
class SqsRedrive extends core_1.Construct {
    /**
     *
     */
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        this.redriveFunction = new aws_lambda_nodejs_1.NodejsFunction(this, `${id}-queue-redrive`, {
            functionName: id,
            ...props.lambdaProps,
            entry: path_1.join(__dirname, 'sqs-redrive.queue-redrive.ts'),
            environment: {
                QUEUE_URL: props.mainQueue.queueUrl,
                DLQ_URL: props.deadLetterQueue.queueUrl,
                ...(_a = props === null || props === void 0 ? void 0 : props.lambdaProps) === null || _a === void 0 ? void 0 : _a.environment,
            },
        });
        props.deadLetterQueue.grantConsumeMessages(this.redriveFunction);
        props.mainQueue.grantSendMessages(this.redriveFunction);
    }
}
exports.SqsRedrive = SqsRedrive;
//# sourceMappingURL=data:application/json;base64,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