"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionFilter = void 0;
/**
 * A subscription filter for an attribute.
 *
 * @stability stable
 */
class SubscriptionFilter {
    /**
     * @param conditions conditions that specify the message attributes that should be included, excluded, matched, etc.
     * @stability stable
     */
    constructor(conditions = []) {
        this.conditions = conditions;
    }
    /**
     * Returns a subscription filter for a string attribute.
     *
     * @stability stable
     */
    static stringFilter(stringConditions) {
        const conditions = new Array();
        if (stringConditions.whitelist) {
            conditions.push(...stringConditions.whitelist);
        }
        if (stringConditions.blacklist) {
            conditions.push({ 'anything-but': stringConditions.blacklist });
        }
        if (stringConditions.matchPrefixes) {
            conditions.push(...stringConditions.matchPrefixes.map(p => ({ prefix: p })));
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * Returns a subscription filter for a numeric attribute.
     *
     * @stability stable
     */
    static numericFilter(numericConditions) {
        const conditions = new Array();
        if (numericConditions.whitelist) {
            conditions.push(...numericConditions.whitelist.map(v => ({ numeric: ['=', v] })));
        }
        if (numericConditions.greaterThan) {
            conditions.push({ numeric: ['>', numericConditions.greaterThan] });
        }
        if (numericConditions.greaterThanOrEqualTo) {
            conditions.push({ numeric: ['>=', numericConditions.greaterThanOrEqualTo] });
        }
        if (numericConditions.lessThan) {
            conditions.push({ numeric: ['<', numericConditions.lessThan] });
        }
        if (numericConditions.lessThanOrEqualTo) {
            conditions.push({ numeric: ['<=', numericConditions.lessThanOrEqualTo] });
        }
        if (numericConditions.between) {
            conditions.push({ numeric: ['>=', numericConditions.between.start, '<=', numericConditions.between.stop] });
        }
        if (numericConditions.betweenStrict) {
            conditions.push({ numeric: ['>', numericConditions.betweenStrict.start, '<', numericConditions.betweenStrict.stop] });
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * Returns a subscription filter for attribute key matching.
     *
     * @stability stable
     */
    static existsFilter() {
        return new SubscriptionFilter([{ exists: true }]);
    }
}
exports.SubscriptionFilter = SubscriptionFilter;
//# sourceMappingURL=data:application/json;base64,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