"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBInstance = exports.DBInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "DBInstanceProperty", { enumerable: true, get: function () { return rds_generated_1.RosDBInstance; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::DBInstance`
 */
class DBInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::DBInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBInstance = new rds_generated_1.RosDBInstance(this, id, {
            periodType: props.periodType === undefined || props.periodType === null ? 'Month' : props.periodType,
            resourceGroupId: props.resourceGroupId,
            archiveBackupRetentionPeriod: props.archiveBackupRetentionPeriod,
            dbTimeZone: props.dbTimeZone,
            port: props.port,
            archiveBackupKeepCount: props.archiveBackupKeepCount,
            logBackupRetentionPeriod: props.logBackupRetentionPeriod,
            dbInstanceStorage: props.dbInstanceStorage,
            dbMappings: props.dbMappings,
            connectionStringPrefix: props.connectionStringPrefix,
            multiAz: props.multiAz === undefined || props.multiAz === null ? false : props.multiAz,
            engine: props.engine,
            tags: props.tags,
            dbInstanceDescription: props.dbInstanceDescription,
            targetDedicatedHostIdForMaster: props.targetDedicatedHostIdForMaster,
            engineVersion: props.engineVersion,
            dbInstanceClass: props.dbInstanceClass,
            archiveBackupKeepPolicy: props.archiveBackupKeepPolicy,
            vSwitchId: props.vSwitchId,
            backupPolicyMode: props.backupPolicyMode,
            period: props.period === undefined || props.period === null ? 1 : props.period,
            localLogRetentionHours: props.localLogRetentionHours,
            payType: props.payType === undefined || props.payType === null ? 'Postpaid' : props.payType,
            highSpaceUsageProtection: props.highSpaceUsageProtection,
            roleArn: props.roleArn,
            masterUserPassword: props.masterUserPassword,
            vpcId: props.vpcId,
            sslSetting: props.sslSetting === undefined || props.sslSetting === null ? 'Disabled' : props.sslSetting,
            masterUsername: props.masterUsername,
            connectionMode: props.connectionMode,
            localLogRetentionSpace: props.localLogRetentionSpace,
            category: props.category,
            privateIpAddress: props.privateIpAddress,
            targetDedicatedHostIdForSlave: props.targetDedicatedHostIdForSlave,
            dbInstanceNetType: props.dbInstanceNetType === undefined || props.dbInstanceNetType === null ? 'Intranet' : props.dbInstanceNetType,
            releasedKeepPolicy: props.releasedKeepPolicy,
            dedicatedHostGroupId: props.dedicatedHostGroupId,
            autoRenew: props.autoRenew,
            encryptionKey: props.encryptionKey,
            preferredBackupPeriod: props.preferredBackupPeriod,
            logBackupLocalRetentionNumber: props.logBackupLocalRetentionNumber,
            slaveZoneIds: props.slaveZoneIds,
            securityIpList: props.securityIpList,
            dbIsIgnoreCase: props.dbIsIgnoreCase,
            maintainTime: props.maintainTime,
            dbParamGroupId: props.dbParamGroupId,
            zoneId: props.zoneId,
            targetDedicatedHostIdForLog: props.targetDedicatedHostIdForLog,
            allocatePublicConnection: props.allocatePublicConnection,
            preferredBackupTime: props.preferredBackupTime,
            securityGroupId: props.securityGroupId,
            dbInstanceStorageType: props.dbInstanceStorageType,
            backUpCategory: props.backUpCategory,
            compressType: props.compressType,
            logBackupFrequency: props.logBackupFrequency,
            connectionStringType: props.connectionStringType === undefined || props.connectionStringType === null ? 'Inner' : props.connectionStringType,
            masterUserType: props.masterUserType === undefined || props.masterUserType === null ? 'Normal' : props.masterUserType,
            enableBackupLog: props.enableBackupLog,
            sqlCollectorStatus: props.sqlCollectorStatus,
            backupRetentionPeriod: props.backupRetentionPeriod === undefined || props.backupRetentionPeriod === null ? 7 : props.backupRetentionPeriod,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBInstance;
        this.attrDbInstanceId = rosDBInstance.attrDbInstanceId;
        this.attrInnerConnectionString = rosDBInstance.attrInnerConnectionString;
        this.attrInnerIpAddress = rosDBInstance.attrInnerIpAddress;
        this.attrInnerPort = rosDBInstance.attrInnerPort;
        this.attrPublicConnectionString = rosDBInstance.attrPublicConnectionString;
        this.attrPublicIpAddress = rosDBInstance.attrPublicIpAddress;
        this.attrPublicPort = rosDBInstance.attrPublicPort;
    }
}
exports.DBInstance = DBInstance;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGJpbnN0YW5jZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImRiaW5zdGFuY2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsOENBQThDO0FBQzlDLG1EQUFnRDtBQUV0QixtR0FGakIsNkJBQWEsT0FFc0I7QUFpWjVDOztHQUVHO0FBQ0gsTUFBYSxVQUFXLFNBQVEsR0FBRyxDQUFDLFFBQVE7SUEwQ3hDOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBc0IsRUFBRSxtQ0FBMkMsSUFBSTtRQUNqSCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sYUFBYSxHQUFHLElBQUksNkJBQWEsQ0FBQyxJQUFJLEVBQUUsRUFBRSxFQUFHO1lBQy9DLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVSxLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsVUFBVSxLQUFLLElBQUksQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsVUFBVTtZQUNwRyxlQUFlLEVBQUUsS0FBSyxDQUFDLGVBQWU7WUFDdEMsNEJBQTRCLEVBQUUsS0FBSyxDQUFDLDRCQUE0QjtZQUNoRSxVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVU7WUFDNUIsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1lBQ2hCLHNCQUFzQixFQUFFLEtBQUssQ0FBQyxzQkFBc0I7WUFDcEQsd0JBQXdCLEVBQUUsS0FBSyxDQUFDLHdCQUF3QjtZQUN4RCxpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCO1lBQzFDLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtZQUM1QixzQkFBc0IsRUFBRSxLQUFLLENBQUMsc0JBQXNCO1lBQ3BELE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTyxLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsT0FBTyxLQUFLLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsT0FBTztZQUN0RixNQUFNLEVBQUUsS0FBSyxDQUFDLE1BQU07WUFDcEIsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1lBQ2hCLHFCQUFxQixFQUFFLEtBQUssQ0FBQyxxQkFBcUI7WUFDbEQsOEJBQThCLEVBQUUsS0FBSyxDQUFDLDhCQUE4QjtZQUNwRSxhQUFhLEVBQUUsS0FBSyxDQUFDLGFBQWE7WUFDbEMsZUFBZSxFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ3RDLHVCQUF1QixFQUFFLEtBQUssQ0FBQyx1QkFBdUI7WUFDdEQsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTO1lBQzFCLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxnQkFBZ0I7WUFDeEMsTUFBTSxFQUFFLEtBQUssQ0FBQyxNQUFNLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxNQUFNLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxNQUFNO1lBQzlFLHNCQUFzQixFQUFFLEtBQUssQ0FBQyxzQkFBc0I7WUFDcEQsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxPQUFPLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxPQUFPO1lBQzNGLHdCQUF3QixFQUFFLEtBQUssQ0FBQyx3QkFBd0I7WUFDeEQsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPO1lBQ3RCLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxrQkFBa0I7WUFDNUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxLQUFLO1lBQ2xCLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVSxLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsVUFBVSxLQUFLLElBQUksQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsVUFBVTtZQUN2RyxjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7WUFDcEMsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO1lBQ3BDLHNCQUFzQixFQUFFLEtBQUssQ0FBQyxzQkFBc0I7WUFDcEQsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO1lBQ3hCLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxnQkFBZ0I7WUFDeEMsNkJBQTZCLEVBQUUsS0FBSyxDQUFDLDZCQUE2QjtZQUNsRSxpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxpQkFBaUIsS0FBSyxJQUFJLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLGlCQUFpQjtZQUNuSSxrQkFBa0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCO1lBQzVDLG9CQUFvQixFQUFFLEtBQUssQ0FBQyxvQkFBb0I7WUFDaEQsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTO1lBQzFCLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtZQUNsQyxxQkFBcUIsRUFBRSxLQUFLLENBQUMscUJBQXFCO1lBQ2xELDZCQUE2QixFQUFFLEtBQUssQ0FBQyw2QkFBNkI7WUFDbEUsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO1lBQ2hDLGNBQWMsRUFBRSxLQUFLLENBQUMsY0FBYztZQUNwQyxjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7WUFDcEMsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO1lBQ2hDLGNBQWMsRUFBRSxLQUFLLENBQUMsY0FBYztZQUNwQyxNQUFNLEVBQUUsS0FBSyxDQUFDLE1BQU07WUFDcEIsMkJBQTJCLEVBQUUsS0FBSyxDQUFDLDJCQUEyQjtZQUM5RCx3QkFBd0IsRUFBRSxLQUFLLENBQUMsd0JBQXdCO1lBQ3hELG1CQUFtQixFQUFFLEtBQUssQ0FBQyxtQkFBbUI7WUFDOUMsZUFBZSxFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ3RDLHFCQUFxQixFQUFFLEtBQUssQ0FBQyxxQkFBcUI7WUFDbEQsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO1lBQ3BDLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtZQUNoQyxrQkFBa0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCO1lBQzVDLG9CQUFvQixFQUFFLEtBQUssQ0FBQyxvQkFBb0IsS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLG9CQUFvQixLQUFLLElBQUksQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsb0JBQW9CO1lBQzVJLGNBQWMsRUFBRSxLQUFLLENBQUMsY0FBYyxLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsY0FBYyxLQUFLLElBQUksQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsY0FBYztZQUNySCxlQUFlLEVBQUUsS0FBSyxDQUFDLGVBQWU7WUFDdEMsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQjtZQUM1QyxxQkFBcUIsRUFBRSxLQUFLLENBQUMscUJBQXFCLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxxQkFBcUIsS0FBSyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLHFCQUFxQjtTQUM3SSxFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLGFBQWEsQ0FBQztRQUM5QixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsYUFBYSxDQUFDLGdCQUFnQixDQUFDO1FBQ3ZELElBQUksQ0FBQyx5QkFBeUIsR0FBRyxhQUFhLENBQUMseUJBQXlCLENBQUM7UUFDekUsSUFBSSxDQUFDLGtCQUFrQixHQUFHLGFBQWEsQ0FBQyxrQkFBa0IsQ0FBQztRQUMzRCxJQUFJLENBQUMsYUFBYSxHQUFHLGFBQWEsQ0FBQyxhQUFhLENBQUM7UUFDakQsSUFBSSxDQUFDLDBCQUEwQixHQUFHLGFBQWEsQ0FBQywwQkFBMEIsQ0FBQztRQUMzRSxJQUFJLENBQUMsbUJBQW1CLEdBQUcsYUFBYSxDQUFDLG1CQUFtQixDQUFDO1FBQzdELElBQUksQ0FBQyxjQUFjLEdBQUcsYUFBYSxDQUFDLGNBQWMsQ0FBQztJQUN2RCxDQUFDO0NBQ0o7QUEzSEQsZ0NBMkhDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcm9zIGZyb20gJ0BhbGljbG91ZC9yb3MtY2RrLWNvcmUnO1xuaW1wb3J0IHsgUm9zREJJbnN0YW5jZSB9IGZyb20gJy4vcmRzLmdlbmVyYXRlZCc7XG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cbmV4cG9ydCB7IFJvc0RCSW5zdGFuY2UgYXMgREJJbnN0YW5jZVByb3BlcnR5IH07XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQUxJWVVOOjpSRFM6OkRCSW5zdGFuY2VgXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgREJJbnN0YW5jZVByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRiSW5zdGFuY2VDbGFzczogRGF0YWJhc2UgaW5zdGFuY2UgdHlwZS4gUmVmZXIgdGhlIFJEUyBkYXRhYmFzZSBpbnN0YW5jZSB0eXBlIHJlZmVyZW5jZSwgc3VjaCBhcyAncmRzLm15czIubGFyZ2UnLCAncmRzLm1zczEubGFyZ2UnLCAncmRzLnBnLnMxLnNtYWxsJyBldGNcbiAgICAgKi9cbiAgICByZWFkb25seSBkYkluc3RhbmNlQ2xhc3M6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRiSW5zdGFuY2VTdG9yYWdlOiBEYXRhYmFzZSBpbnN0YW5jZSBzdG9yYWdlIHNpemUuIG15c3FsIGlzIFs1LDEwMDBdLiBzcWwgc2VydmVyIDIwMDhyMiBpcyBbMTAsMTAwMF0sIHNxbCBzZXJ2ZXIgMjAxMi8yMDEyX3dlYi8yMDE2LXdlYiBpcyBbMjAsMTAwMF0uIFBvc3RncmVTUUwgYW5kIFBQQVMgaXMgWzUsMjAwMF0uIEluY3JlYXNlZCBldmVyeSA1IEdCLCBVbml0IGluIEdCXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGJJbnN0YW5jZVN0b3JhZ2U6IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGVuZ2luZTogRGF0YWJhc2UgaW5zdGFuY2UgZW5naW5lIHR5cGUuIFN1cHBvcnQgTXlTUUwvU1FMU2VydmVyL1Bvc3RncmVTUUwvUFBBUy9NYXJpYURCIG5vdy5cbiAgICAgKi9cbiAgICByZWFkb25seSBlbmdpbmU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGVuZ2luZVZlcnNpb246IERhdGFiYXNlIGluc3RhbmNlIHZlcnNpb24gb2YgdGhlIHJlbGF0aXZlIGVuZ2luZSB0eXBlLlN1cHBvcnQgTXlTUUw6IDUuNS81LjYvNS43LzguMDtcbiAgICAgKiBTUUxTZXJ2ZXI6IDIwMDhyMi8yMDEyLzIwMTJfZW50X2hhLzIwMTJfc3RkX2hhLzIwMTJfd2ViLzIwMTZfZW50X2hhLzIwMTZfc3RkX2hhLzIwMTZfd2ViLzIwMTdfc3RkX2hhLzIwMTdfZW50O1xuICAgICAqIFBvc3RncmVTUUw6IDkuNC8xMC4wLzExLjAvMTIuMDtcbiAgICAgKiBQUEFTOiA5LjMvMTAuMDtcbiAgICAgKiBNYXJpYURCOiAxMC4zLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVuZ2luZVZlcnNpb246IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHNlY3VyaXR5SXBMaXN0OiBTZWN1cml0eSBpcCB0byBhY2Nlc3MgdGhlIGRhdGFiYXNlIGluc3RhbmNlLCBjb21iaW5lIHdpdGggY29tbWEsIDAuMC4wLjAvMCBtZWFucyBubyBsaW1pdGF0aW9uLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNlY3VyaXR5SXBMaXN0OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBhbGxvY2F0ZVB1YmxpY0Nvbm5lY3Rpb246IElmIHRydWUsIGFsbG9jYXRlIHB1YmxpYyBjb25uZWN0aW9uIGF1dG9tYXRlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGFsbG9jYXRlUHVibGljQ29ubmVjdGlvbj86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBhcmNoaXZlQmFja3VwS2VlcENvdW50OiBUaGUgbnVtYmVyIG9mIGFyY2hpdmVkIGJhY2t1cHMgdGhhdCBjYW4gYmUgcmV0YWluZWQuIERlZmF1bHQgdmFsdWU6IDEuIFZhbGlkIHZhbHVlczogXG4gICAgICogVGhlIHZhbHVlIG9mIHRoaXMgcGFyYW1ldGVyIHJhbmdlcyBmcm9tIDEgdG8gMzEgd2hlbiB0aGUgQXJjaGl2ZUJhY2t1cEtlZXBQb2xpY3kgXG4gICAgICogIHBhcmFtZXRlciBpcyBzZXQgdG8gQnlNb250aC4gXG4gICAgICogVGhlIHZhbHVlIG9mIHRoaXMgcGFyYW1ldGVyIHJhbmdlcyBmcm9tIDEgdG8gNyB3aGVuIHRoZSBBcmNoaXZlQmFja3VwS2VlcFBvbGljeSBcbiAgICAgKiAgcGFyYW1ldGVyIGlzIHNldCB0byBCeVdlZWsuIFxuICAgICAqIE5vdGUgWW91IGRvIG5vdCBuZWVkIHRvIHNwZWNpZnkgdGhpcyBwYXJhbWV0ZXIgd2hlbiB0aGUgQXJjaGl2ZUJhY2t1cEtlZXBQb2xpY3kgXG4gICAgICogcGFyYW1ldGVyIGlzIHNldCB0byBLZWVwQWxsLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGFyY2hpdmVCYWNrdXBLZWVwQ291bnQ/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBhcmNoaXZlQmFja3VwS2VlcFBvbGljeTogVGhlIHBlcmlvZCBmb3Igd2hpY2ggdG8gcmV0YWluIGFyY2hpdmVkIGJhY2t1cHMuIFRoZSBudW1iZXIgb2YgYXJjaGl2ZWQgYmFja3VwcyB0aGF0IGNhbiBcbiAgICAgKiAgYmUgcmV0YWluZWQgd2l0aGluIHRoZSBzcGVjaWZpZWQgcGVyaW9kIGlzIGRldGVybWluZWQgYnkgdGhlIEFyY2hpdmVCYWNrdXBLZWVwQ291bnQgcGFyYW1ldGVyLiBcbiAgICAgKiAgRGVmYXVsdCB2YWx1ZTogMC4gVmFsaWQgdmFsdWVzOiBcbiAgICAgKiBCeU1vbnRoIFxuICAgICAqICBCeVdlZWsgXG4gICAgICogIEtlZXBBbGxcbiAgICAgKi9cbiAgICByZWFkb25seSBhcmNoaXZlQmFja3VwS2VlcFBvbGljeT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGFyY2hpdmVCYWNrdXBSZXRlbnRpb25QZXJpb2Q6IFRoZSBudW1iZXIgb2YgZGF5cyBmb3Igd2hpY2ggdG8gcmV0YWluIGFyY2hpdmVkIGJhY2t1cHMuIFxuICAgICAqICBUaGUgZGVmYXVsdCB2YWx1ZSAwIHNwZWNpZmllcyBub3QgdG8gZW5hYmxlIHRoZSBiYWNrdXAgYXJjaGl2aW5nIGZ1bmN0aW9uLiBWYWxpZCB2YWx1ZXM6IDMwIHRvIDEwOTUuXG4gICAgICovXG4gICAgcmVhZG9ubHkgYXJjaGl2ZUJhY2t1cFJldGVudGlvblBlcmlvZD86IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGF1dG9SZW5ldzogU3BlY2lmaWVzIHdoZXRoZXIgdG8gZW5hYmxlIGF1dG8tcmVuZXdhbC4gVmFsaWQgdmFsdWVzOiB0cnVlIGFuZCBmYWxzZS4gTm90ZVxuICAgICAqIDpNb250aGx5IHN1YnNjcmlwdGlvbjogVGhlIGF1dG8tcmVuZXdhbCBjeWNsZSBpcyBvbmUgbW9udGguXG4gICAgICogQW5udWFsIHN1YnNjcmlwdGlvbjogVGhlIGF1dG8tcmVuZXdhbCBjeWNsZSBpcyBvbmUgeWVhci5cbiAgICAgKi9cbiAgICByZWFkb25seSBhdXRvUmVuZXc/OiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgYmFja1VwQ2F0ZWdvcnk6IFNwZWNpZmllcyB3aGV0aGVyIHRvIGVuYWJsZSB0aGUgc2Vjb25kLWxldmVsIGJhY2t1cCBmdW5jdGlvbi4gVGhpcyBmdW5jdGlvbiBhbGxvd3MgYSBiYWNrdXAgXG4gICAgICogdG8gYmUgY29tcGxldGVkIHdpdGhpbiBzZWNvbmRzLiBWYWxpZCB2YWx1ZXM6IFxuICAgICAqIEZsYXNoOiBzcGVjaWZpZXMgdG8gZW5hYmxlIHRoZSBzZWNvbmQtbGV2ZWwgYmFja3VwIGZ1bmN0aW9uLiBcbiAgICAgKiAgU3RhbmRhcmQ6IHNwZWNpZmllcyB0byBkaXNhYmxlIHRoZSBzZWNvbmQtbGV2ZWwgYmFja3VwIGZ1bmN0aW9uLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGJhY2tVcENhdGVnb3J5Pzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgYmFja3VwUG9saWN5TW9kZTogQmFja3VwIHR5cGUsIFxuICAgICAqIERhdGFCYWNrdXBQb2xpY3k6IGRhdGEgYmFja3VwIFxuICAgICAqIExvZ0JhY2t1cFBvbGljeTogbG9nIGJhY2t1cFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGJhY2t1cFBvbGljeU1vZGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBiYWNrdXBSZXRlbnRpb25QZXJpb2Q6IFRoZSByZXRlbnRpb24gcGVyaW9kIG9mIHRoZSBkYXRhIGJhY2t1cC4gVmFsdWUgcmFuZ2U6IDcgdG8gNzMwLiBUaGUgZGVmYXVsdCB2YWx1ZSBpcyB0aGUgb3JpZ2luYWwgdmFsdWUuIE5vdGUgV2hlbiB0aGUgQmFja3VwUG9saWN5TW9kZSBwYXJhbWV0ZXIgaXMgc2V0IHRvIExvZ0JhY2t1cFBvbGljeSwgdGhpcyBwYXJhbWV0ZXIgaXMgcmVxdWlyZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgYmFja3VwUmV0ZW50aW9uUGVyaW9kPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgY2F0ZWdvcnk6IFRoZSBlZGl0aW9uIG9mIHRoZSBpbnN0YW5jZS4gVmFsaWQgdmFsdWVzOlxuICAgICAqIEJhc2ljOiBzcGVjaWZpZXMgdG8gdXNlIHRoZSBCYXNpYyBFZGl0aW9uLlxuICAgICAqIEhpZ2hBdmFpbGFiaWxpdHk6IHNwZWNpZmllcyB0byB1c2UgdGhlIEhpZ2gtYXZhaWxhYmlsaXR5IEVkaXRpb24uXG4gICAgICogQWx3YXlzT246IHNwZWNpZmllcyB0byB1c2UgdGhlIENsdXN0ZXIgRWRpdGlvbi5cbiAgICAgKiBGaW5hbmNlOiBzcGVjaWZpZXMgdG8gdXNlIHRoZSBFbnRlcnByaXNlIEVkaXRpb24uXG4gICAgICovXG4gICAgcmVhZG9ubHkgY2F0ZWdvcnk/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBjb21wcmVzc1R5cGU6IFRoZSBmb3JtYXQgdXNlZCB0byBjb21wcmVzcyBiYWNrdXBzLiBWYWxpZCB2YWx1ZXM6IFxuICAgICAqICAxOiBUaGUgemxpYiB0b29sIGlzIHVzZWQgdG8gY29tcHJlc3MgYmFja3VwcyBpbnRvIC50YXIuZ3ogZmlsZXMuIFxuICAgICAqICA0OiBUaGUgUXVpY2tMWiB0b29sIGlzIHVzZWQgdG8gY29tcHJlc3MgYmFja3VwcyBpbnRvIC54Yi5neiBmaWxlcy4gXG4gICAgICogVGhpcyBjb21wcmVzc2lvbiBmb3JtYXQgaXMgc3VwcG9ydGVkIG9ubHkgd2hlbiB0aGUgaW5zdGFuY2UgcnVucyBNeVNRTCA1LjYgb3IgNS43LiBcbiAgICAgKiBJdCBjYW4gYmUgdXNlZCB0byByZXN0b3JlIGluZGl2aWR1YWwgZGF0YWJhc2VzIGFuZCB0YWJsZXMuIFxuICAgICAqICA4OiBUaGUgUXVpY2tMWiB0b29sIGlzIHVzZWQgdG8gY29tcHJlc3MgYmFja3VwcyBpbnRvIC54Yi5neiBmaWxlcy4gXG4gICAgICogIFRoaXMgY29tcHJlc3Npb24gZm9ybWF0IGlzIHN1cHBvcnRlZCBvbmx5IHdoZW4gdGhlIGluc3RhbmNlIHJ1bnMgTXlTUUwgOC4wLiBcbiAgICAgKiBJdCBjYW5ub3QgYmUgdXNlZCB0byByZXN0b3JlIGluZGl2aWR1YWwgZGF0YWJhc2VzIG9yIHRhYmxlcy5cbiAgICAgKi9cbiAgICByZWFkb25seSBjb21wcmVzc1R5cGU/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBjb25uZWN0aW9uTW9kZTogQ29ubmVjdGlvbiBNb2RlIGZvciBkYXRhYmFzZSBpbnN0YW5jZSxzdXBwb3J0ICdTdGFuZGFyZCcgYW5kICdTYWZlJyBtb2RlLiBEZWZhdWx0IGlzIFJEUyBzeXN0ZW0gYXNzaWducy5cbiAgICAgKi9cbiAgICByZWFkb25seSBjb25uZWN0aW9uTW9kZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGNvbm5lY3Rpb25TdHJpbmdQcmVmaXg6IFRoZSBwcmVmaXggb2YgdGhlIGVuZHBvaW50LiBcbiAgICAgKiBPbmx5IHRoZSBwcmVmaXggb2YgdGhlIEN1cnJlbnRDb25uZWN0aW9uU3RyaW5nIHBhcmFtZXRlciB2YWx1ZSBjYW4gYmUgbW9kaWZpZWQuXG4gICAgICogVGhlIHByZWZpeCBtdXN0IGJlIDggdG8gNjQgY2hhcmFjdGVycyBpbiBsZW5ndGggYW5kIGNhbiBjb250YWluIGxldHRlcnMsIGRpZ2l0cywgYW5kIGh5cGhlbnMgKC0pLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGNvbm5lY3Rpb25TdHJpbmdQcmVmaXg/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBjb25uZWN0aW9uU3RyaW5nVHlwZTogVGhlIGVuZHBvaW50IHR5cGUgb2YgdGhlIGluc3RhbmNlLCBhbGxvdyB2YWx1ZXM6IElubmVyLCBQdWJsaWNcbiAgICAgKi9cbiAgICByZWFkb25seSBjb25uZWN0aW9uU3RyaW5nVHlwZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRiSW5zdGFuY2VEZXNjcmlwdGlvbjogRGVzY3JpcHRpb24gb2YgY3JlYXRlZCBkYXRhYmFzZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBkYkluc3RhbmNlRGVzY3JpcHRpb24/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkYkluc3RhbmNlTmV0VHlwZTogRGF0YWJhc2UgaW5zdGFuY2UgbmV0IHR5cGUsIGRlZmF1bHQgaXMgSW50cmFuZXQuSW50ZXJuZXQgZm9yIHB1YmxpYyBhY2Nlc3MsIEludHJhbmV0IGZvciBwcml2YXRlIGFjY2Vzcy5cbiAgICAgKi9cbiAgICByZWFkb25seSBkYkluc3RhbmNlTmV0VHlwZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRiSW5zdGFuY2VTdG9yYWdlVHlwZTogVGhlIHN0b3JhZ2UgdHlwZSBvZiB0aGUgaW5zdGFuY2UuIFZhbGlkIHZhbHVlczpcbiAgICAgKiBsb2NhbF9zc2Q6IHNwZWNpZmllcyB0byB1c2UgbG9jYWwgU1NEcy4gVGhpcyBpcyB0aGUgcmVjb21tZW5kZWQgc3RvcmFnZSB0eXBlLlxuICAgICAqIGNsb3VkX3NzZDogc3BlY2lmaWVzIHRvIHVzZSBzdGFuZGFyZCBTU0RzLlxuICAgICAqIGNsb3VkX2Vzc2Q6IGVuaGFuY2VkIFNTRCBvZiBwZXJmb3JtYW5jZSBsZXZlbCAoUEwpMS5cbiAgICAgKiBjbG91ZF9lc3NkMjogZW5oYW5jZWQgU1NEIG9mIFBMMi5cbiAgICAgKiBjbG91ZF9lc3NkMzogZW5oYW5jZWQgU1NEIG9mIFBMMy5cbiAgICAgKi9cbiAgICByZWFkb25seSBkYkluc3RhbmNlU3RvcmFnZVR5cGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkYklzSWdub3JlQ2FzZTogU3BlY2lmaWVzIHdoZXRoZXIgdGFibGUgbmFtZXMgYXJlIGNhc2Utc2Vuc2l0aXZlLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogMTogVGFibGUgbmFtZXMgYXJlIG5vdCBjYXNlLXNlbnNpdGl2ZS4gVGhpcyBpcyB0aGUgZGVmYXVsdCB2YWx1ZS5cbiAgICAgKiAwOiBUYWJsZSBuYW1lcyBhcmUgY2FzZS1zZW5zaXRpdmUuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGJJc0lnbm9yZUNhc2U/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkYk1hcHBpbmdzOiBEYXRhYmFzZSBtYXBwaW5ncyB0byBhdHRhY2ggdG8gZGIgaW5zdGFuY2UuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGJNYXBwaW5ncz86IEFycmF5PFJvc0RCSW5zdGFuY2UuREJNYXBwaW5nc1Byb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlPiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRiUGFyYW1Hcm91cElkOiBUaGUgSUQgb2YgdGhlIHBhcmFtZXRlciB0ZW1wbGF0ZSB1c2VkIGJ5IHRoZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBkYlBhcmFtR3JvdXBJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRiVGltZVpvbmU6IFRoZSBVVEMgdGltZSB6b25lIG9mIHRoZSBpbnN0YW5jZS4gVmFsaWQgdmFsdWVzOiAtMTI6MDAgdG8gKzEyOjAwLiBUaGUgdGltZSB6b25lIG11c3QgYmUgYW4gaW50ZWdlciB2YWx1ZSBzdWNoIGFzICswODowMC4gVmFsdWVzIHN1Y2ggYXMgKzA4OjMwIGFyZSBub3QgYWxsb3dlZC5cbiAgICAgKi9cbiAgICByZWFkb25seSBkYlRpbWVab25lPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZGVkaWNhdGVkSG9zdEdyb3VwSWQ6IFRoZSBJRCBvZiB0aGUgaG9zdCBncm91cCB0byB3aGljaCB0aGUgaW5zdGFuY2UgYmVsb25ncyBpZiB5b3UgY3JlYXRlIGFuIGluc3RhbmNlIGluIGEgaG9zdCBncm91cC5cbiAgICAgKi9cbiAgICByZWFkb25seSBkZWRpY2F0ZWRIb3N0R3JvdXBJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGVuYWJsZUJhY2t1cExvZzogU3BlY2lmaWVzIHdoZXRoZXIgdG8gZW5hYmxlIHRoZSBsb2cgYmFja3VwIGZ1bmN0aW9uLiBWYWxpZCB2YWx1ZXM6IFxuICAgICAqIFRydWU6IHNwZWNpZmllcyB0byBlbmFibGUgdGhlIGxvZyBiYWNrdXAgZnVuY3Rpb24uIFxuICAgICAqIEZhbHNlOiBzcGVjaWZpZXMgdG8gZGlzYWJsZSB0aGUgbG9nIGJhY2t1cCBmdW5jdGlvbi4gXG4gICAgICogTm90ZSBZb3UgbXVzdCBzcGVjaWZ5IHRoaXMgcGFyYW1ldGVyIHdoZW4gdGhlIEJhY2t1cFBvbGljeU1vZGUgcGFyYW1ldGVyIGlzIHNldCB0byBMb2dCYWNrdXBQb2xpY3kuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZW5hYmxlQmFja3VwTG9nPzogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGVuY3J5cHRpb25LZXk6IFRoZSBJRCBvZiB0aGUgZW5jcnlwdGlvbiBrZXkgdGhhdCBpcyB1c2VkIHRvIGVuY3J5cHQgZGF0YSBvbiBTU0RzIGluIHRoZSByZWdpb24uIFlvdSBjYW4gdmlldyB0aGUgZW5jcnlwdGlvbiBrZXkgSUQgaW4gdGhlIEtleSBNYW5hZ2VtZW50IFNlcnZpY2UgKEtNUykgY29uc29sZS4gWW91IGNhbiBhbHNvIGNyZWF0ZSBhbiBlbmNyeXB0aW9uIGtleS5cbiAgICAgKi9cbiAgICByZWFkb25seSBlbmNyeXB0aW9uS2V5Pzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgaGlnaFNwYWNlVXNhZ2VQcm90ZWN0aW9uOiBTcGVjaWZpZXMgd2hldGhlciB0byBmb3JjaWJseSBkZWxldGUgbG9nIGJhY2t1cCBmaWxlcyB3aGVuIHRoZSBzcGFjZSB1c2FnZSBvZiB0aGUgXG4gICAgICogIGluc3RhbmNlIGV4Y2VlZHMgODAlIG9yIHRoZSByZW1haW5pbmcgc3BhY2UgaXMgbGVzcyB0aGFuIDUgR0IuIFZhbGlkIHZhbHVlczogXG4gICAgICogIEVuYWJsZSBhbmQgRGlzYWJsZS4gWW91IGNhbiByZXRhaW4gdGhlIGRlZmF1bHQgdmFsdWUuIE5vdGUgWW91IG11c3Qgc3BlY2lmeSBcbiAgICAgKiAgdGhpcyBwYXJhbWV0ZXIgd2hlbiB0aGUgQmFja3VwUG9saWN5TW9kZSBwYXJhbWV0ZXIgaXMgc2V0IHRvIExvZ0JhY2t1cFBvbGljeS5cbiAgICAgKi9cbiAgICByZWFkb25seSBoaWdoU3BhY2VVc2FnZVByb3RlY3Rpb24/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBsb2NhbExvZ1JldGVudGlvbkhvdXJzOiBUaGUgbnVtYmVyIG9mIGhvdXJzIGZvciB3aGljaCB0byByZXRhaW4gbG9nIGJhY2t1cCBmaWxlcyBvbiB0aGUgaW5zdGFuY2UuIFxuICAgICAqIFZhbGlkIHZhbHVlczogMCB0byAxNjguIFRoZSB2YWx1ZSAwIHNwZWNpZmllcyBub3QgdG8gcmV0YWluIGxvZyBiYWNrdXAgZmlsZXMgb24gdGhlIGluc3RhbmNlLiBcbiAgICAgKiBZb3UgY2FuIHJldGFpbiB0aGUgZGVmYXVsdCB2YWx1ZS4gTm90ZSBZb3UgbXVzdCBzcGVjaWZ5IHRoaXMgcGFyYW1ldGVyIHdoZW4gdGhlIEJhY2t1cFBvbGljeU1vZGUgXG4gICAgICogcGFyYW1ldGVyIGlzIHNldCB0byBMb2dCYWNrdXBQb2xpY3kuXG4gICAgICovXG4gICAgcmVhZG9ubHkgbG9jYWxMb2dSZXRlbnRpb25Ib3Vycz86IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGxvY2FsTG9nUmV0ZW50aW9uU3BhY2U6IFRoZSBtYXhpbXVtIHBlcmNlbnRhZ2Ugb2Ygc3BhY2UgdGhhdCBpcyBhbGxvd2VkIHRvIHN0b3JlIGxvZyBiYWNrdXAgZmlsZXMgb24gdGhlIGluc3RhbmNlLiBcbiAgICAgKiAgSWYgdGhlIHNwYWNlIHVzYWdlIGZvciBsb2cgYmFja3VwIGZpbGVzIGV4Y2VlZHMgdGhpcyBwZXJjZW50YWdlLCB0aGUgc3lzdGVtIGRlbGV0ZXMgZWFybGllciBcbiAgICAgKiAgbG9nIGJhY2t1cCBmaWxlcyB1bnRpbCB0aGUgc3BhY2UgdXNhZ2UgZmFsbHMgYmVsb3cgdGhpcyBwZXJjZW50YWdlLiBWYWxpZCB2YWx1ZXM6MCB0byA1MC4gXG4gICAgICogIFlvdSBjYW4gcmV0YWluIHRoZSBkZWZhdWx0IHZhbHVlLiBOb3RlIFlvdSBtdXN0IHNwZWNpZnkgdGhpcyBwYXJhbWV0ZXIgd2hlbiB0aGUgXG4gICAgICogIEJhY2t1cFBvbGljeU1vZGUgcGFyYW1ldGVyIGlzIHNldCB0byBMb2dCYWNrdXBQb2xpY3kuXG4gICAgICovXG4gICAgcmVhZG9ubHkgbG9jYWxMb2dSZXRlbnRpb25TcGFjZT86IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGxvZ0JhY2t1cEZyZXF1ZW5jeTogVGhlIGZyZXF1ZW5jeSBhdCB3aGljaCB0byBiYWNrIHVwIGxvZ3MuIFZhbGlkIHZhbHVlczogXG4gICAgICogVGhlIHZhbHVlIExvZ0ludGVydmFsIHNwZWNpZmllcyB0byBiYWNrIHVwIGxvZ3MgZXZlcnkgMzAgbWludXRlcy4gXG4gICAgICogIFRoZSBkZWZhdWx0IHZhbHVlIG9mIHRoaXMgcGFyYW1ldGVyIGlzIHRoZSBzYW1lIGFzIHRoZSBkYXRhIGJhY2t1cCBmcmVxdWVuY3kuIFxuICAgICAqIE5vdGUgVGhlIHZhbHVlIExvZ0ludGVydmFsIGlzIHN1cHBvcnRlZCBvbmx5IHdoZW4gdGhlIGluc3RhbmNlIHJ1bnMgU1FMIFNlcnZlci5cbiAgICAgKi9cbiAgICByZWFkb25seSBsb2dCYWNrdXBGcmVxdWVuY3k/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBsb2dCYWNrdXBMb2NhbFJldGVudGlvbk51bWJlcjogVGhlIG51bWJlciBvZiBsb2cgYmFja3VwIGZpbGVzIHRoYXQgY2FuIGJlIHJldGFpbmVkIG9uIHRoZSBpbnN0YW5jZS4gXG4gICAgICogRGVmYXVsdCB2YWx1ZTogNjAuIFZhbGlkIHZhbHVlczogNiB0byAxMDAuXG4gICAgICovXG4gICAgcmVhZG9ubHkgbG9nQmFja3VwTG9jYWxSZXRlbnRpb25OdW1iZXI/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBsb2dCYWNrdXBSZXRlbnRpb25QZXJpb2Q6IFRoZSBudW1iZXIgb2YgZGF5cyBmb3Igd2hpY2ggdG8gcmV0YWluIGxvZyBiYWNrdXAgZmlsZXMuIFZhbGlkIHZhbHVlczogNyB0byA3MzAuIFRoZSBsb2cgYmFja3VwIFxuICAgICAqICByZXRlbnRpb24gcGVyaW9kIGNhbm5vdCBiZSBsb25nZXIgdGhhbiB0aGUgZGF0YSBiYWNrdXAgcmV0ZW50aW9uIHBlcmlvZC5Ob3RlIElmIHlvdSBlbmFibGUgdGhlIGxvZyBcbiAgICAgKiAgYmFja3VwIGZ1bmN0aW9uLCB5b3UgY2FuIHNwZWNpZnkgdGhlIGxvZyBiYWNrdXAgcmV0ZW50aW9uIHBlcmlvZC4gVGhpcyBhcHBsaWVzIG9ubHkgd2hlbiB0aGUgXG4gICAgICogIGluc3RhbmNlIHJ1bnMgTXlTUUwsIFBvc3RncmVTUUwsIG9yIFBQQVMuXG4gICAgICovXG4gICAgcmVhZG9ubHkgbG9nQmFja3VwUmV0ZW50aW9uUGVyaW9kPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgbWFpbnRhaW5UaW1lOiBUaGUgcGVyaW9kIGR1cmluZyB3aGljaCB0aGUgbWFpbnRlbmFuY2UgcGVyZm9ybXMuIFRoZSBmb3JtYXQgaXMgSEg6bW1aLUhIOm1tWi5cbiAgICAgKi9cbiAgICByZWFkb25seSBtYWludGFpblRpbWU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBtYXN0ZXJVc2VybmFtZTogVGhlIG1hc3RlciB1c2VyIG5hbWUgZm9yIHRoZSBkYXRhYmFzZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBtYXN0ZXJVc2VybmFtZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IG1hc3RlclVzZXJQYXNzd29yZDogVGhlIG1hc3RlciBwYXNzd29yZCBmb3IgdGhlIGRhdGFiYXNlIGluc3RhbmNlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG1hc3RlclVzZXJQYXNzd29yZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IG1hc3RlclVzZXJUeXBlOiBQcml2aWxlZ2UgdHlwZSBvZiBhY2NvdW50LlxuICAgICAqICBOb3JtYWw6IENvbW1vbiBwcml2aWxlZ2UuIFxuICAgICAqICBTdXBlcjogSGlnaCBwcml2aWxlZ2UuIFxuICAgICAqIFN5c2FkbWluOiBTdXBlciBwcml2aWxlZ2VzIChTQSkgKG9ubHkgc3VwcG9ydGVkIGJ5IFNRTCBTZXJ2ZXIpXG4gICAgICogVGhlIGRlZmF1bHQgdmFsdWUgaXMgTm9ybWFsLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG1hc3RlclVzZXJUeXBlPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgbXVsdGlBejogU3BlY2lmaWVzIGlmIHRoZSBkYXRhYmFzZSBpbnN0YW5jZSBpcyBhIG11bHRpcGxlIEF2YWlsYWJpbGl0eSBab25lIGRlcGxveW1lbnQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgbXVsdGlBej86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwYXlUeXBlOiBUaGUgY2hhcmdlIHR5cGUgb2YgY3JlYXRlZCBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBwYXlUeXBlPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcGVyaW9kOiBUaGUgc3Vic2NyaXB0aW9uIGR1cmF0aW9uLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogV2hlbiBQZXJpb2RUeXBlIGlzIE1vbnRoLCBpdCBjb3VsZCBiZSBmcm9tIDEgdG8gMTIsIDI0LCAzNiwgNDgsIDYwLlxuICAgICAqICBXaGVuIFBlcmlvZFR5cGUgaXMgWWVhciwgaXQgY291bGQgYmUgZnJvbSAxIHRvIDUuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcGVyaW9kPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcGVyaW9kVHlwZTogQ2hhcmdlIHBlcmlvZCBmb3IgY3JlYXRlZCBpbnN0YW5jZXMuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcGVyaW9kVHlwZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHBvcnQ6IFRoZSBwb3J0IG9mIHRoZSBkYXRhYmFzZSBzZXJ2aWNlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHBvcnQ/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwcmVmZXJyZWRCYWNrdXBQZXJpb2Q6IFRoZSBiYWNrdXAgcGVyaW9kLiBTZXBhcmF0ZSBtdWx0aXBsZSB2YWx1ZXMgd2l0aCBjb21tYXMgKCwpLiBUaGUgZGVmYXVsdCB2YWx1ZSBpcyB0aGUgb3JpZ2luYWwgdmFsdWUuIFZhbGlkIHZhbHVlczpNb25kYXkgVHVlc2RheSBXZWRuZXNkYXkgVGh1cnNkYXkgRnJpZGF5IFNhdHVyZGF5IFN1bmRheSBOb3RlIFdoZW4gdGhlIEJhY2t1cFBvbGljeU1vZGUgcGFyYW1ldGVyIGlzIHNldCB0byBEYXRhQmFja3VwUG9saWN5LCB0aGlzIHBhcmFtZXRlciBpcyByZXF1aXJlZC5cbiAgICAgKi9cbiAgICByZWFkb25seSBwcmVmZXJyZWRCYWNrdXBQZXJpb2Q/OiBBcnJheTxhbnkgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcHJlZmVycmVkQmFja3VwVGltZTogVGhlIHRpbWUgd2hlbiB0aGUgYmFja3VwIHRhc2sgaXMgcGVyZm9ybWVkLiBGb3JtYXQ6IHl5eXktTU0tZGRaLUhIOm1tOnNzWi5Ob3RlIFdoZW4gdGhlIEJhY2t1cFBvbGljeU1vZGUgcGFyYW1ldGVyIGlzIHNldCB0byBEYXRhQmFja3VwUG9saWN5LCB0aGlzIHBhcmFtZXRlciBpcyByZXF1aXJlZC5cbiAgICAgKi9cbiAgICByZWFkb25seSBwcmVmZXJyZWRCYWNrdXBUaW1lPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcHJpdmF0ZUlwQWRkcmVzczogVGhlIHByaXZhdGUgaXAgZm9yIGNyZWF0ZWQgaW5zdGFuY2UuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcHJpdmF0ZUlwQWRkcmVzcz86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHJlbGVhc2VkS2VlcFBvbGljeTogVGhlIHBvbGljeSB1c2VkIHRvIHJldGFpbiBhcmNoaXZlZCBiYWNrdXBzIGlmIHRoZSBpbnN0YW5jZSBpcyByZWxlYXNlZC4gRGVmYXVsdCB2YWx1ZTogTm9uZS4gXG4gICAgICogIFZhbGlkIHZhbHVlczogXG4gICAgICogTGFzdGVzdDogT25seSB0aGUgbGFzdCBhcmNoaXZlZCBiYWNrdXAgaXMgcmV0YWluZWQuIFxuICAgICAqICBBbGw6IEFsbCBvZiB0aGUgYXJjaGl2ZWQgYmFja3VwcyBhcmUgcmV0YWluZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcmVsZWFzZWRLZWVwUG9saWN5Pzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcmVzb3VyY2VHcm91cElkOiBSZXNvdXJjZSBncm91cCBpZC5cbiAgICAgKi9cbiAgICByZWFkb25seSByZXNvdXJjZUdyb3VwSWQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSByb2xlQXJuOiBUaGUgQWxpYmFiYSBDbG91ZCBSZXNvdXJjZSBOYW1lIChBUk4pIHByb3ZpZGVkIHRvIHRoZSBzZXJ2aWNlIGFjY291bnQgb2YgdGhlIGluc3RhbmNlIGJ5IHlvdXIgQWxpYmFiYSBDbG91ZCBhY2NvdW50IHRvIGNvbm5lY3QgdG8gS01TLiBZb3UgY2FuIGNvcHkgdGhlIEFSTiBmcm9tIHRoZSBSQU0gY29uc29sZS5cbiAgICAgKi9cbiAgICByZWFkb25seSByb2xlQXJuPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgc2VjdXJpdHlHcm91cElkOiBUaGUgSUQgb2YgdGhlIEVDUyBzZWN1cml0eSBncm91cHMuIFxuICAgICAqIEVhY2ggUkRTIGluc3RhbmNlIGNhbiBiZSBhc3NvY2lhdGVkIHdpdGggdXAgdG8gdGhyZWUgRUNTIHNlY3VyaXR5IGdyb3Vwcy4gXG4gICAgICogWW91IG11c3Qgc2VwYXJhdGUgdGhlbSB3aXRoIGNvbW1hcyAoLCkuIFxuICAgICAqIFRvIGRlbGV0ZSBhbiBFQ1MgU2VjdXJpdHkgZ3JvdXAsIGxlYXZlIHRoaXMgcGFyYW1ldGVyIGVtcHR5LiBcbiAgICAgKlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNlY3VyaXR5R3JvdXBJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHNsYXZlWm9uZUlkczogTGlzdCBvZiBzbGF2ZSB6b25lIGlkcyBjYW4gc3BlY2lmeSBzbGF2ZSB6b25lIGlkcyB3aGVuIGNyZWF0aW5nIHRoZSBoaWdoLWF2YWlsYWJpbGl0eSBvciBlbnRlcnByaXNlIGVkaXRpb24gaW5zdGFuY2UuIE1lYW53aGlsZSwgVlN3aXRjaElkIG5lZWRzIHRvIHBhc3MgaW4gdGhlIGNvcnJlc3BvbmRpbmcgdnN3aXRjaCBpZCB0byB0aGUgc2xhdmUgem9uZSBieSBvcmRlci4gRm9yIGV4YW1wbGUsIFpvbmVJZCA9IFwiem9uZS1hXCIgYW5kIFNsYXZlWm9uZUlkcyA9IFtcInpvbmUtY1wiLCBcInpvbmUtYlwiXSwgdGhlbiB0aGUgVlN3aXRjaElkIG11c3QgYmUgXCJ2c3ctem9uZS1hLHZzdy16b25lLWMsdnN3LXpvbmUtYlwiLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNsYXZlWm9uZUlkcz86IEFycmF5PHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBzcWxDb2xsZWN0b3JTdGF0dXM6IFNwZWNpZmllcyB3aGV0aGVyIHRvIGVuYWJsZSBvciBkaXNhYmxlIHRoZSBTUUwgRXhwbG9yZXIgKFNRTCBhdWRpdCkgZmVhdHVyZS4gXG4gICAgICogVmFsaWQgdmFsdWVzOkVuYWJsZSB8IERpc2FibGVkLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNxbENvbGxlY3RvclN0YXR1cz86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHNzbFNldHRpbmc6IFNlY3VyZSBTb2NrZXRzIExheWVyIChTU0wpIGxpbmsgc2V0dGluZyBvZiB0aGUgaW5zdGFuY2UuIFZhbGlkIHZhbHVlczpcbiAgICAgKiBEaXNhYmxlZDogRGlzYWJsZSBTU0xcbiAgICAgKiBFbmFibGVkRm9yUHVibGljQ29ubmVjdGlvbjogUHVibGljIGNvbm5lY3Rpb24gYWRkcmVzcyB3aWxsIGJlIHByb3RlY3RlZCBieSB0aGUgU1NMIGNlcnRpZmljYXRlLiBJdCByZXF1aXJlcyBBbGxvY2F0ZVB1YmxpY0Nvbm5lY3Rpb24gaXMgdHJ1ZS5cbiAgICAgKiBFbmFibGVkRm9ySW5uZXJDb25uZWN0aW9uOiBQcml2YXRlIGNvbm5lY3Rpb24gYWRkcmVzcyB3aWxsIGJlIHByb3RlY3RlZCBieSB0aGUgU1NMIGNlcnRpZmljYXRlLlxuICAgICAqIERlZmF1bHQgdmFsdWUgaXMgRGlzYWJsZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgc3NsU2V0dGluZz86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHRhZ3M6IFRoZSB0YWdzIG9mIGFuIGluc3RhbmNlLlxuICAgICAqIFlvdSBzaG91bGQgaW5wdXQgdGhlIGluZm9ybWF0aW9uIG9mIHRoZSB0YWcgd2l0aCB0aGUgZm9ybWF0IG9mIHRoZSBLZXktVmFsdWUsIHN1Y2ggYXMge1wia2V5MVwiOlwidmFsdWUxXCIsXCJrZXkyXCI6XCJ2YWx1ZTJcIiwgLi4uIFwia2V5NVwiOlwidmFsdWU1XCJ9LlxuICAgICAqIEF0IG1vc3QgNSB0YWdzIGNhbiBiZSBzcGVjaWZpZWQuXG4gICAgICogS2V5XG4gICAgICogSXQgY2FuIGJlIHVwIHRvIDY0IGNoYXJhY3RlcnMgaW4gbGVuZ3RoLlxuICAgICAqIENhbm5vdCBiZWdpbiB3aXRoIGFsaXl1bi5cbiAgICAgKiBDYW5ub3QgYmVnaW4gd2l0aCBodHRwOi8vIG9yIGh0dHBzOi8vLlxuICAgICAqIENhbm5vdCBiZSBhIG51bGwgc3RyaW5nLlxuICAgICAqIFZhbHVlXG4gICAgICogSXQgY2FuIGJlIHVwIHRvIDEyOCBjaGFyYWN0ZXJzIGluIGxlbmd0aC5cbiAgICAgKiBDYW5ub3QgYmVnaW4gd2l0aCBhbGl5dW4uXG4gICAgICogQ2Fubm90IGJlZ2luIHdpdGggaHR0cDovLyBvciBodHRwczovLy5cbiAgICAgKiBDYW4gYmUgYSBudWxsIHN0cmluZy5cbiAgICAgKi9cbiAgICByZWFkb25seSB0YWdzPzogeyBba2V5OiBzdHJpbmddOiAoYW55KSB9O1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgdGFyZ2V0RGVkaWNhdGVkSG9zdElkRm9yTG9nOiBUaGUgSUQgb2YgdGhlIGhvc3QgdG8gd2hpY2ggdGhlIGluc3RhbmNlIGJlbG9uZ3MgaWYgeW91IGNyZWF0ZSBhIGxvZyBpbnN0YW5jZSBpbiBhIGhvc3QgZ3JvdXAuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFyZ2V0RGVkaWNhdGVkSG9zdElkRm9yTG9nPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgdGFyZ2V0RGVkaWNhdGVkSG9zdElkRm9yTWFzdGVyOiBUaGUgSUQgb2YgdGhlIGhvc3QgdG8gd2hpY2ggdGhlIGluc3RhbmNlIGJlbG9uZ3MgaWYgeW91IGNyZWF0ZSBhIHByaW1hcnkgaW5zdGFuY2UgaW4gYSBob3N0IGdyb3VwLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhcmdldERlZGljYXRlZEhvc3RJZEZvck1hc3Rlcj86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHRhcmdldERlZGljYXRlZEhvc3RJZEZvclNsYXZlOiBUaGUgSUQgb2YgdGhlIGhvc3QgdG8gd2hpY2ggdGhlIGluc3RhbmNlIGJlbG9uZ3MgaWYgeW91IGNyZWF0ZSBhIHNlY29uZGFyeSBpbnN0YW5jZSBpbiBhIGhvc3QgZ3JvdXAuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFyZ2V0RGVkaWNhdGVkSG9zdElkRm9yU2xhdmU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB2cGNJZDogVGhlIFZQQyBpZCBvZiBjcmVhdGVkIGRhdGFiYXNlIGluc3RhbmNlLiBGb3IgVlBDIG5ldHdvcmssIHRoZSBwcm9wZXJ0eSBpcyByZXF1aXJlZC5cbiAgICAgKi9cbiAgICByZWFkb25seSB2cGNJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHZTd2l0Y2hJZDogVGhlIHZTd2l0Y2ggaWQgb2YgY3JlYXRlZCBpbnN0YW5jZS4gRm9yIFZQQyBuZXR3b3JrLCB0aGUgcHJvcGVydHkgaXMgcmVxdWlyZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdlN3aXRjaElkPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgem9uZUlkOiBzZWxlY3RlZCB6b25lIHRvIGNyZWF0ZSBkYXRhYmFzZSBpbnN0YW5jZS4gWW91IGNhbm5vdCBzZXQgdGhlIFpvbmVJZCBwYXJhbWV0ZXIgaWYgdGhlIE11bHRpQVogcGFyYW1ldGVyIGlzIHNldCB0byB0cnVlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHpvbmVJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcbn1cblxuLyoqXG4gKiBBIFJPUyByZXNvdXJjZSB0eXBlOiAgYEFMSVlVTjo6UkRTOjpEQkluc3RhbmNlYFxuICovXG5leHBvcnQgY2xhc3MgREJJbnN0YW5jZSBleHRlbmRzIHJvcy5SZXNvdXJjZSB7XG5cbiAgICAvKipcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XG4gICAgICogY29udGFpbmluZyB0aGUgcHJvcGVydGllcyBvZiB0aGlzIFJPUyByZXNvdXJjZSwgd2hpY2ggd2lsbCBiZSBhc3NpZ25lZCB0byBST1MgcmVzb3VyY2UuXG4gICAgICovXG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgREJJbnN0YW5jZUlkOiBUaGUgaW5zdGFuY2UgaWQgb2YgY3JlYXRlZCBkYXRhYmFzZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckRiSW5zdGFuY2VJZDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIElubmVyQ29ubmVjdGlvblN0cmluZzogREIgaW5zdGFuY2UgY29ubmVjdGlvbiB1cmwgYnkgSW50cmFuZXQuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJJbm5lckNvbm5lY3Rpb25TdHJpbmc6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBJbm5lcklQQWRkcmVzczogSVAgQWRkcmVzcyBmb3IgY3JlYXRlZCBEQiBpbnN0YW5jZSBvZiBJbnRyYW5ldC5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0cklubmVySXBBZGRyZXNzOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgSW5uZXJQb3J0OiBJbnRyYW5ldCBwb3J0IG9mIGNyZWF0ZWQgREIgaW5zdGFuY2UuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJJbm5lclBvcnQ6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBQdWJsaWNDb25uZWN0aW9uU3RyaW5nOiBEQiBpbnN0YW5jZSBjb25uZWN0aW9uIHVybCBieSBJbnRlcm5ldC5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0clB1YmxpY0Nvbm5lY3Rpb25TdHJpbmc6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBQdWJsaWNJUEFkZHJlc3M6IElQIEFkZHJlc3MgZm9yIGNyZWF0ZWQgREIgaW5zdGFuY2Ugb2YgSW50ZXJuZXQuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJQdWJsaWNJcEFkZHJlc3M6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBQdWJsaWNQb3J0OiBJbnRlcm5ldCBwb3J0IG9mIGNyZWF0ZWQgREIgaW5zdGFuY2UuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJQdWJsaWNQb3J0OiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFMSVlVTjo6UkRTOjpEQkluc3RhbmNlYC5cbiAgICAgKlxuICAgICAqIFBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogUGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogUGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IHJvcy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBEQkluc3RhbmNlUHJvcHMsIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OmJvb2xlYW4gPSB0cnVlKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICAgICAgY29uc3Qgcm9zREJJbnN0YW5jZSA9IG5ldyBSb3NEQkluc3RhbmNlKHRoaXMsIGlkLCAge1xuICAgICAgICAgICAgcGVyaW9kVHlwZTogcHJvcHMucGVyaW9kVHlwZSA9PT0gdW5kZWZpbmVkIHx8IHByb3BzLnBlcmlvZFR5cGUgPT09IG51bGwgPyAnTW9udGgnIDogcHJvcHMucGVyaW9kVHlwZSxcbiAgICAgICAgICAgIHJlc291cmNlR3JvdXBJZDogcHJvcHMucmVzb3VyY2VHcm91cElkLFxuICAgICAgICAgICAgYXJjaGl2ZUJhY2t1cFJldGVudGlvblBlcmlvZDogcHJvcHMuYXJjaGl2ZUJhY2t1cFJldGVudGlvblBlcmlvZCxcbiAgICAgICAgICAgIGRiVGltZVpvbmU6IHByb3BzLmRiVGltZVpvbmUsXG4gICAgICAgICAgICBwb3J0OiBwcm9wcy5wb3J0LFxuICAgICAgICAgICAgYXJjaGl2ZUJhY2t1cEtlZXBDb3VudDogcHJvcHMuYXJjaGl2ZUJhY2t1cEtlZXBDb3VudCxcbiAgICAgICAgICAgIGxvZ0JhY2t1cFJldGVudGlvblBlcmlvZDogcHJvcHMubG9nQmFja3VwUmV0ZW50aW9uUGVyaW9kLFxuICAgICAgICAgICAgZGJJbnN0YW5jZVN0b3JhZ2U6IHByb3BzLmRiSW5zdGFuY2VTdG9yYWdlLFxuICAgICAgICAgICAgZGJNYXBwaW5nczogcHJvcHMuZGJNYXBwaW5ncyxcbiAgICAgICAgICAgIGNvbm5lY3Rpb25TdHJpbmdQcmVmaXg6IHByb3BzLmNvbm5lY3Rpb25TdHJpbmdQcmVmaXgsXG4gICAgICAgICAgICBtdWx0aUF6OiBwcm9wcy5tdWx0aUF6ID09PSB1bmRlZmluZWQgfHwgcHJvcHMubXVsdGlBeiA9PT0gbnVsbCA/IGZhbHNlIDogcHJvcHMubXVsdGlBeixcbiAgICAgICAgICAgIGVuZ2luZTogcHJvcHMuZW5naW5lLFxuICAgICAgICAgICAgdGFnczogcHJvcHMudGFncyxcbiAgICAgICAgICAgIGRiSW5zdGFuY2VEZXNjcmlwdGlvbjogcHJvcHMuZGJJbnN0YW5jZURlc2NyaXB0aW9uLFxuICAgICAgICAgICAgdGFyZ2V0RGVkaWNhdGVkSG9zdElkRm9yTWFzdGVyOiBwcm9wcy50YXJnZXREZWRpY2F0ZWRIb3N0SWRGb3JNYXN0ZXIsXG4gICAgICAgICAgICBlbmdpbmVWZXJzaW9uOiBwcm9wcy5lbmdpbmVWZXJzaW9uLFxuICAgICAgICAgICAgZGJJbnN0YW5jZUNsYXNzOiBwcm9wcy5kYkluc3RhbmNlQ2xhc3MsXG4gICAgICAgICAgICBhcmNoaXZlQmFja3VwS2VlcFBvbGljeTogcHJvcHMuYXJjaGl2ZUJhY2t1cEtlZXBQb2xpY3ksXG4gICAgICAgICAgICB2U3dpdGNoSWQ6IHByb3BzLnZTd2l0Y2hJZCxcbiAgICAgICAgICAgIGJhY2t1cFBvbGljeU1vZGU6IHByb3BzLmJhY2t1cFBvbGljeU1vZGUsXG4gICAgICAgICAgICBwZXJpb2Q6IHByb3BzLnBlcmlvZCA9PT0gdW5kZWZpbmVkIHx8IHByb3BzLnBlcmlvZCA9PT0gbnVsbCA/IDEgOiBwcm9wcy5wZXJpb2QsXG4gICAgICAgICAgICBsb2NhbExvZ1JldGVudGlvbkhvdXJzOiBwcm9wcy5sb2NhbExvZ1JldGVudGlvbkhvdXJzLFxuICAgICAgICAgICAgcGF5VHlwZTogcHJvcHMucGF5VHlwZSA9PT0gdW5kZWZpbmVkIHx8IHByb3BzLnBheVR5cGUgPT09IG51bGwgPyAnUG9zdHBhaWQnIDogcHJvcHMucGF5VHlwZSxcbiAgICAgICAgICAgIGhpZ2hTcGFjZVVzYWdlUHJvdGVjdGlvbjogcHJvcHMuaGlnaFNwYWNlVXNhZ2VQcm90ZWN0aW9uLFxuICAgICAgICAgICAgcm9sZUFybjogcHJvcHMucm9sZUFybixcbiAgICAgICAgICAgIG1hc3RlclVzZXJQYXNzd29yZDogcHJvcHMubWFzdGVyVXNlclBhc3N3b3JkLFxuICAgICAgICAgICAgdnBjSWQ6IHByb3BzLnZwY0lkLFxuICAgICAgICAgICAgc3NsU2V0dGluZzogcHJvcHMuc3NsU2V0dGluZyA9PT0gdW5kZWZpbmVkIHx8IHByb3BzLnNzbFNldHRpbmcgPT09IG51bGwgPyAnRGlzYWJsZWQnIDogcHJvcHMuc3NsU2V0dGluZyxcbiAgICAgICAgICAgIG1hc3RlclVzZXJuYW1lOiBwcm9wcy5tYXN0ZXJVc2VybmFtZSxcbiAgICAgICAgICAgIGNvbm5lY3Rpb25Nb2RlOiBwcm9wcy5jb25uZWN0aW9uTW9kZSxcbiAgICAgICAgICAgIGxvY2FsTG9nUmV0ZW50aW9uU3BhY2U6IHByb3BzLmxvY2FsTG9nUmV0ZW50aW9uU3BhY2UsXG4gICAgICAgICAgICBjYXRlZ29yeTogcHJvcHMuY2F0ZWdvcnksXG4gICAgICAgICAgICBwcml2YXRlSXBBZGRyZXNzOiBwcm9wcy5wcml2YXRlSXBBZGRyZXNzLFxuICAgICAgICAgICAgdGFyZ2V0RGVkaWNhdGVkSG9zdElkRm9yU2xhdmU6IHByb3BzLnRhcmdldERlZGljYXRlZEhvc3RJZEZvclNsYXZlLFxuICAgICAgICAgICAgZGJJbnN0YW5jZU5ldFR5cGU6IHByb3BzLmRiSW5zdGFuY2VOZXRUeXBlID09PSB1bmRlZmluZWQgfHwgcHJvcHMuZGJJbnN0YW5jZU5ldFR5cGUgPT09IG51bGwgPyAnSW50cmFuZXQnIDogcHJvcHMuZGJJbnN0YW5jZU5ldFR5cGUsXG4gICAgICAgICAgICByZWxlYXNlZEtlZXBQb2xpY3k6IHByb3BzLnJlbGVhc2VkS2VlcFBvbGljeSxcbiAgICAgICAgICAgIGRlZGljYXRlZEhvc3RHcm91cElkOiBwcm9wcy5kZWRpY2F0ZWRIb3N0R3JvdXBJZCxcbiAgICAgICAgICAgIGF1dG9SZW5ldzogcHJvcHMuYXV0b1JlbmV3LFxuICAgICAgICAgICAgZW5jcnlwdGlvbktleTogcHJvcHMuZW5jcnlwdGlvbktleSxcbiAgICAgICAgICAgIHByZWZlcnJlZEJhY2t1cFBlcmlvZDogcHJvcHMucHJlZmVycmVkQmFja3VwUGVyaW9kLFxuICAgICAgICAgICAgbG9nQmFja3VwTG9jYWxSZXRlbnRpb25OdW1iZXI6IHByb3BzLmxvZ0JhY2t1cExvY2FsUmV0ZW50aW9uTnVtYmVyLFxuICAgICAgICAgICAgc2xhdmVab25lSWRzOiBwcm9wcy5zbGF2ZVpvbmVJZHMsXG4gICAgICAgICAgICBzZWN1cml0eUlwTGlzdDogcHJvcHMuc2VjdXJpdHlJcExpc3QsXG4gICAgICAgICAgICBkYklzSWdub3JlQ2FzZTogcHJvcHMuZGJJc0lnbm9yZUNhc2UsXG4gICAgICAgICAgICBtYWludGFpblRpbWU6IHByb3BzLm1haW50YWluVGltZSxcbiAgICAgICAgICAgIGRiUGFyYW1Hcm91cElkOiBwcm9wcy5kYlBhcmFtR3JvdXBJZCxcbiAgICAgICAgICAgIHpvbmVJZDogcHJvcHMuem9uZUlkLFxuICAgICAgICAgICAgdGFyZ2V0RGVkaWNhdGVkSG9zdElkRm9yTG9nOiBwcm9wcy50YXJnZXREZWRpY2F0ZWRIb3N0SWRGb3JMb2csXG4gICAgICAgICAgICBhbGxvY2F0ZVB1YmxpY0Nvbm5lY3Rpb246IHByb3BzLmFsbG9jYXRlUHVibGljQ29ubmVjdGlvbixcbiAgICAgICAgICAgIHByZWZlcnJlZEJhY2t1cFRpbWU6IHByb3BzLnByZWZlcnJlZEJhY2t1cFRpbWUsXG4gICAgICAgICAgICBzZWN1cml0eUdyb3VwSWQ6IHByb3BzLnNlY3VyaXR5R3JvdXBJZCxcbiAgICAgICAgICAgIGRiSW5zdGFuY2VTdG9yYWdlVHlwZTogcHJvcHMuZGJJbnN0YW5jZVN0b3JhZ2VUeXBlLFxuICAgICAgICAgICAgYmFja1VwQ2F0ZWdvcnk6IHByb3BzLmJhY2tVcENhdGVnb3J5LFxuICAgICAgICAgICAgY29tcHJlc3NUeXBlOiBwcm9wcy5jb21wcmVzc1R5cGUsXG4gICAgICAgICAgICBsb2dCYWNrdXBGcmVxdWVuY3k6IHByb3BzLmxvZ0JhY2t1cEZyZXF1ZW5jeSxcbiAgICAgICAgICAgIGNvbm5lY3Rpb25TdHJpbmdUeXBlOiBwcm9wcy5jb25uZWN0aW9uU3RyaW5nVHlwZSA9PT0gdW5kZWZpbmVkIHx8IHByb3BzLmNvbm5lY3Rpb25TdHJpbmdUeXBlID09PSBudWxsID8gJ0lubmVyJyA6IHByb3BzLmNvbm5lY3Rpb25TdHJpbmdUeXBlLFxuICAgICAgICAgICAgbWFzdGVyVXNlclR5cGU6IHByb3BzLm1hc3RlclVzZXJUeXBlID09PSB1bmRlZmluZWQgfHwgcHJvcHMubWFzdGVyVXNlclR5cGUgPT09IG51bGwgPyAnTm9ybWFsJyA6IHByb3BzLm1hc3RlclVzZXJUeXBlLFxuICAgICAgICAgICAgZW5hYmxlQmFja3VwTG9nOiBwcm9wcy5lbmFibGVCYWNrdXBMb2csXG4gICAgICAgICAgICBzcWxDb2xsZWN0b3JTdGF0dXM6IHByb3BzLnNxbENvbGxlY3RvclN0YXR1cyxcbiAgICAgICAgICAgIGJhY2t1cFJldGVudGlvblBlcmlvZDogcHJvcHMuYmFja3VwUmV0ZW50aW9uUGVyaW9kID09PSB1bmRlZmluZWQgfHwgcHJvcHMuYmFja3VwUmV0ZW50aW9uUGVyaW9kID09PSBudWxsID8gNyA6IHByb3BzLmJhY2t1cFJldGVudGlvblBlcmlvZCxcbiAgICAgICAgfSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgJiYgdGhpcy5zdGFjay5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XG4gICAgICAgIHRoaXMucmVzb3VyY2UgPSByb3NEQkluc3RhbmNlO1xuICAgICAgICB0aGlzLmF0dHJEYkluc3RhbmNlSWQgPSByb3NEQkluc3RhbmNlLmF0dHJEYkluc3RhbmNlSWQ7XG4gICAgICAgIHRoaXMuYXR0cklubmVyQ29ubmVjdGlvblN0cmluZyA9IHJvc0RCSW5zdGFuY2UuYXR0cklubmVyQ29ubmVjdGlvblN0cmluZztcbiAgICAgICAgdGhpcy5hdHRySW5uZXJJcEFkZHJlc3MgPSByb3NEQkluc3RhbmNlLmF0dHJJbm5lcklwQWRkcmVzcztcbiAgICAgICAgdGhpcy5hdHRySW5uZXJQb3J0ID0gcm9zREJJbnN0YW5jZS5hdHRySW5uZXJQb3J0O1xuICAgICAgICB0aGlzLmF0dHJQdWJsaWNDb25uZWN0aW9uU3RyaW5nID0gcm9zREJJbnN0YW5jZS5hdHRyUHVibGljQ29ubmVjdGlvblN0cmluZztcbiAgICAgICAgdGhpcy5hdHRyUHVibGljSXBBZGRyZXNzID0gcm9zREJJbnN0YW5jZS5hdHRyUHVibGljSXBBZGRyZXNzO1xuICAgICAgICB0aGlzLmF0dHJQdWJsaWNQb3J0ID0gcm9zREJJbnN0YW5jZS5hdHRyUHVibGljUG9ydDtcbiAgICB9XG59XG4iXX0=