import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * (experimental) Statement provider for service [imagebuilder](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonec2imagebuilder.html).
 *
 * @experimental
 */
export declare class Imagebuilder extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [imagebuilder](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonec2imagebuilder.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to cancel an image creation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CancelImageCreation.html
     *
     * @experimental
     */
    toCancelImageCreation(): this;
    /**
     * (experimental) Grants permission to create a new component.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - imagebuilder:TagResource
     * - kms:Encrypt
     * - kms:GenerateDataKey
     * - kms:GenerateDataKeyWithoutPlaintext
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html
     *
     * @experimental
     */
    toCreateComponent(): this;
    /**
     * (experimental) Grants permission to create a new Container Recipe.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ecr:DescribeImages
     * - ecr:DescribeRepositories
     * - iam:CreateServiceLinkedRole
     * - imagebuilder:GetComponent
     * - imagebuilder:GetImage
     * - imagebuilder:TagResource
     * - kms:Encrypt
     * - kms:GenerateDataKey
     * - kms:GenerateDataKeyWithoutPlaintext
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateContainerRecipe.html
     *
     * @experimental
     */
    toCreateContainerRecipe(): this;
    /**
     * (experimental) Grants permission to create a new distribution configuration.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - imagebuilder:TagResource
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateDistributionConfiguration.html
     *
     * @experimental
     */
    toCreateDistributionConfiguration(): this;
    /**
     * (experimental) Grants permission to create a new image.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - imagebuilder:GetContainerRecipe
     * - imagebuilder:GetDistributionConfiguration
     * - imagebuilder:GetImageRecipe
     * - imagebuilder:GetInfrastructureConfiguration
     * - imagebuilder:TagResource
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateImage.html
     *
     * @experimental
     */
    toCreateImage(): this;
    /**
     * (experimental) Grants permission to create a new image pipeline.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - imagebuilder:GetContainerRecipe
     * - imagebuilder:GetImageRecipe
     * - imagebuilder:TagResource
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateImagePipeline.html
     *
     * @experimental
     */
    toCreateImagePipeline(): this;
    /**
     * (experimental) Grants permission to create a new Image Recipe.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:DescribeImages
     * - iam:CreateServiceLinkedRole
     * - imagebuilder:GetComponent
     * - imagebuilder:GetImage
     * - imagebuilder:TagResource
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateImageRecipe.html
     *
     * @experimental
     */
    toCreateImageRecipe(): this;
    /**
     * (experimental) Grants permission to create a new infrastructure configuration.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifCreatedResourceTagKeys()
     * - .ifCreatedResourceTag()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - iam:PassRole
     * - imagebuilder:TagResource
     * - sns:Publish
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateInfrastructureConfiguration.html
     *
     * @experimental
     */
    toCreateInfrastructureConfiguration(): this;
    /**
     * (experimental) Grants permission to delete a component.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_DeleteComponent.html
     *
     * @experimental
     */
    toDeleteComponent(): this;
    /**
     * (experimental) Grants permission to delete a container recipe.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_DeleteContainerRecipe.html
     *
     * @experimental
     */
    toDeleteContainerRecipe(): this;
    /**
     * (experimental) Grants permission to delete a distribution configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_DeleteDistributionConfiguration.html
     *
     * @experimental
     */
    toDeleteDistributionConfiguration(): this;
    /**
     * (experimental) Grants permission to delete an image.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_DeleteImage.html
     *
     * @experimental
     */
    toDeleteImage(): this;
    /**
     * (experimental) Grants permission to delete an image pipeline.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_DeleteImagePipeline.html
     *
     * @experimental
     */
    toDeleteImagePipeline(): this;
    /**
     * (experimental) Grants permission to delete an image recipe.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_DeleteImageRecipe.html
     *
     * @experimental
     */
    toDeleteImageRecipe(): this;
    /**
     * (experimental) Grants permission to delete an infrastructure configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_DeleteInfrastructureConfiguration.html
     *
     * @experimental
     */
    toDeleteInfrastructureConfiguration(): this;
    /**
     * (experimental) Grants permission to view details about a component.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - kms:Decrypt
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_GetComponent.html
     *
     * @experimental
     */
    toGetComponent(): this;
    /**
     * (experimental) Grants permission to view the resource policy associated with a component.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_GetComponentPolicy.html
     *
     * @experimental
     */
    toGetComponentPolicy(): this;
    /**
     * (experimental) Grants permission to view details about a container recipe.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_GetContainerRecipe.html
     *
     * @experimental
     */
    toGetContainerRecipe(): this;
    /**
     * (experimental) Grants permission to view the resource policy associated with a container recipe.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_GetContainerRecipePolicy.html
     *
     * @experimental
     */
    toGetContainerRecipePolicy(): this;
    /**
     * (experimental) Grants permission to view details about a distribution configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_GetDistributionConfiguration.html
     *
     * @experimental
     */
    toGetDistributionConfiguration(): this;
    /**
     * (experimental) Grants permission to view details about an image.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_GetImage.html
     *
     * @experimental
     */
    toGetImage(): this;
    /**
     * (experimental) Grants permission to view details about an image pipeline.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_GetImagePipeline.html
     *
     * @experimental
     */
    toGetImagePipeline(): this;
    /**
     * (experimental) Grants permission to view the resource policy associated with an image.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_GetImagePolicy.html
     *
     * @experimental
     */
    toGetImagePolicy(): this;
    /**
     * (experimental) Grants permission to view details about an image recipe.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_GetImageRecipe.html
     *
     * @experimental
     */
    toGetImageRecipe(): this;
    /**
     * (experimental) Grants permission to view the resource policy associated with an image recipe.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_GetImageRecipePolicy.html
     *
     * @experimental
     */
    toGetImageRecipePolicy(): this;
    /**
     * (experimental) Grants permission to view details about an infrastructure configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_GetInfrastructureConfiguration.html
     *
     * @experimental
     */
    toGetInfrastructureConfiguration(): this;
    /**
     * (experimental) Grants permission to import a new component.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - imagebuilder:TagResource
     * - kms:Encrypt
     * - kms:GenerateDataKey
     * - kms:GenerateDataKeyWithoutPlaintext
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ImportComponent.html
     *
     * @experimental
     */
    toImportComponent(): this;
    /**
     * (experimental) Grants permission to list the component build versions in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListComponentBuildVersions.html
     *
     * @experimental
     */
    toListComponentBuildVersions(): this;
    /**
     * (experimental) Grants permission to list the component versions owned by or shared with your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListComponents.html
     *
     * @experimental
     */
    toListComponents(): this;
    /**
     * (experimental) Grants permission to list the container recipes owned by or shared with your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListContainerRecipes.html
     *
     * @experimental
     */
    toListContainerRecipes(): this;
    /**
     * (experimental) Grants permission to list the distribution configurations in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListDistributionConfigurations.html
     *
     * @experimental
     */
    toListDistributionConfigurations(): this;
    /**
     * (experimental) Grants permission to list the image build versions in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListImageBuildVersions.html
     *
     * @experimental
     */
    toListImageBuildVersions(): this;
    /**
     * (experimental) Grants permission to returns a list of packages installed on the specified image.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListImagePackages.html
     *
     * @experimental
     */
    toListImagePackages(): this;
    /**
     * (experimental) Grants permission to returns a list of images created by the specified pipeline.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListImagePipelineImages.html
     *
     * @experimental
     */
    toListImagePipelineImages(): this;
    /**
     * (experimental) Grants permission to list the image pipelines in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListImagePipelines.html
     *
     * @experimental
     */
    toListImagePipelines(): this;
    /**
     * (experimental) Grants permission to list the image recipes owned by or shared with your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListImageRecipes.html
     *
     * @experimental
     */
    toListImageRecipes(): this;
    /**
     * (experimental) Grants permission to list the image versions owned by or shared with your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListImages.html
     *
     * @experimental
     */
    toListImages(): this;
    /**
     * (experimental) Grants permission to list the infrastructure configurations in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListInfrastructureConfigurations.html
     *
     * @experimental
     */
    toListInfrastructureConfigurations(): this;
    /**
     * (experimental) Grants permission to list tag for an Image Builder resource.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to set the resource policy associated with a component.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_PutComponentPolicy.html
     *
     * @experimental
     */
    toPutComponentPolicy(): this;
    /**
     * (experimental) Grants permission to set the resource policy associated with a container recipe.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_PutContainerRecipePolicy.html
     *
     * @experimental
     */
    toPutContainerRecipePolicy(): this;
    /**
     * (experimental) Grants permission to set the resource policy associated with an image.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_PutImagePolicy.html
     *
     * @experimental
     */
    toPutImagePolicy(): this;
    /**
     * (experimental) Grants permission to set the resource policy associated with an image recipe.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_PutImageRecipePolicy.html
     *
     * @experimental
     */
    toPutImageRecipePolicy(): this;
    /**
     * (experimental) Grants permission to create a new image from a pipeline.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - imagebuilder:GetImagePipeline
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_StartImagePipelineExecution.html
     *
     * @experimental
     */
    toStartImagePipelineExecution(): this;
    /**
     * (experimental) Grants permission to tag an Image Builder resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to untag an Image Builder resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update an existing distribution configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_UpdateDistributionConfiguration.html
     *
     * @experimental
     */
    toUpdateDistributionConfiguration(): this;
    /**
     * (experimental) Grants permission to update an existing image pipeline.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_UpdateImagePipeline.html
     *
     * @experimental
     */
    toUpdateImagePipeline(): this;
    /**
     * (experimental) Grants permission to update an existing infrastructure configuration.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifCreatedResourceTagKeys()
     * - .ifCreatedResourceTag()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sns:Publish
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_UpdateInfrastructureConfiguration.html
     *
     * @experimental
     */
    toUpdateInfrastructureConfiguration(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type component to the statement.
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_Component.html
     *
     * @param componentName - Identifier for the componentName.
     * @param componentVersion - Identifier for the componentVersion.
     * @param componentBuildVersion - Identifier for the componentBuildVersion.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onComponent(componentName: string, componentVersion: string, componentBuildVersion: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type componentVersion to the statement.
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ComponentVersion
     *
     * @param componentName - Identifier for the componentName.
     * @param componentVersion - Identifier for the componentVersion.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onComponentVersion(componentName: string, componentVersion: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type distributionConfiguration to the statement.
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_DistributionConfiguration.html
     *
     * @param distributionConfigurationName - Identifier for the distributionConfigurationName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDistributionConfiguration(distributionConfigurationName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type image to the statement.
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_Image.html
     *
     * @param imageName - Identifier for the imageName.
     * @param imageVersion - Identifier for the imageVersion.
     * @param imageBuildVersion - Identifier for the imageBuildVersion.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onImage(imageName: string, imageVersion: string, imageBuildVersion: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type imageVersion to the statement.
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ImageVersion.html
     *
     * @param imageName - Identifier for the imageName.
     * @param imageVersion - Identifier for the imageVersion.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onImageVersion(imageName: string, imageVersion: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type imageRecipe to the statement.
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ImageRecipe.html
     *
     * @param imageRecipeName - Identifier for the imageRecipeName.
     * @param imageRecipeVersion - Identifier for the imageRecipeVersion.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onImageRecipe(imageRecipeName: string, imageRecipeVersion: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type containerRecipe to the statement.
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ContainerRecipe.html
     *
     * @param containerRecipeName - Identifier for the containerRecipeName.
     * @param containerRecipeVersion - Identifier for the containerRecipeVersion.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onContainerRecipe(containerRecipeName: string, containerRecipeVersion: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type imagePipeline to the statement.
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ImagePipeline.html
     *
     * @param imagePipelineName - Identifier for the imagePipelineName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onImagePipeline(imagePipelineName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type infrastructureConfiguration to the statement.
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_InfrastructureConfiguration.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onInfrastructureConfiguration(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type kmsKey to the statement.
     *
     * https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys
     *
     * @param keyId - Identifier for the keyId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onKmsKey(keyId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by the tag key-value pairs attached to the resource created by Image Builder.
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/userguide/security_iam_service-with-iam.html#image-builder-security-createdresourcetag
     *
     * Applies to actions:
     * - .toCreateInfrastructureConfiguration()
     * - .toUpdateInfrastructureConfiguration()
     *
     * @param key The tag key to check.
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifCreatedResourceTag(key: string, value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the presence of tag keys in the request.
     *
     * https://docs.aws.amazon.com/imagebuilder/latest/userguide/security_iam_service-with-iam.html#image-builder-security-createdresourcetagkeys
     *
     * Applies to actions:
     * - .toCreateInfrastructureConfiguration()
     * - .toUpdateInfrastructureConfiguration()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifCreatedResourceTagKeys(value: string | string[], operator?: Operator | string): this;
}
