"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Launchwizard = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [launchwizard](https://docs.aws.amazon.com/service-authorization/latest/reference/list_launchwizard.html).
 *
 * @experimental
 */
class Launchwizard extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [launchwizard](https://docs.aws.amazon.com/service-authorization/latest/reference/list_launchwizard.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'launchwizard';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Write: [
                'DeleteApp',
                'StartProvisioning'
            ],
            Read: [
                'DescribeProvisionedApp',
                'DescribeProvisioningEvents',
                'GetInfrastructureSuggestion',
                'GetIpAddress',
                'GetResourceCostEstimate'
            ],
            List: [
                'ListProvisionedApps'
            ]
        };
    }
    /**
     * (experimental) Delete an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toDeleteApp() {
        return this.to('DeleteApp');
    }
    /**
     * (experimental) Describe provisioning applications.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toDescribeProvisionedApp() {
        return this.to('DescribeProvisionedApp');
    }
    /**
     * (experimental) Describe provisioning events.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toDescribeProvisioningEvents() {
        return this.to('DescribeProvisioningEvents');
    }
    /**
     * (experimental) Get infrastructure suggestion.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toGetInfrastructureSuggestion() {
        return this.to('GetInfrastructureSuggestion');
    }
    /**
     * (experimental) Get customer's ip address.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toGetIpAddress() {
        return this.to('GetIpAddress');
    }
    /**
     * (experimental) Get resource cost estimate.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toGetResourceCostEstimate() {
        return this.to('GetResourceCostEstimate');
    }
    /**
     * (experimental) List provisioning applications.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toListProvisionedApps() {
        return this.to('ListProvisionedApps');
    }
    /**
     * (experimental) Start a provisioning.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     *
     * @experimental
     */
    toStartProvisioning() {
        return this.to('StartProvisioning');
    }
}
exports.Launchwizard = Launchwizard;
_a = JSII_RTTI_SYMBOL_1;
Launchwizard[_a] = { fqn: "iam-floyd.Launchwizard", version: "0.284.0" };
//# sourceMappingURL=data:application/json;base64,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