import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [aws-marketplace-metering-service](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemeteringservice.html).
 *
 * @experimental
 */
export declare class AwsMarketplaceMeteringService extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [aws-marketplace-metering-service](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemeteringservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to post metering records for a set of customers for SaaS applications.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_BatchMeterUsage.html
     *
     * @experimental
     */
    toBatchMeterUsage(): this;
    /**
     * (experimental) Grants permission to emit metering records.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_MeterUsage.html
     *
     * @experimental
     */
    toMeterUsage(): this;
    /**
     * (experimental) Grants permission to to verify that the customer running your paid software is subscribed to your product on AWS Marketplace, enabling you to guard against unauthorized use.
     *
     * Meters software use per ECS task, per hour, with usage prorated to the second
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_RegisterUsage.html
     *
     * @experimental
     */
    toRegisterUsage(): this;
    /**
     * (experimental) Grants permission to resolve a registration token to obtain a CustomerIdentifier and product code.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_ResolveCustomer.html
     *
     * @experimental
     */
    toResolveCustomer(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
}
