import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [route53resolver](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53resolver.html).
 *
 * @experimental
 */
export declare class Route53resolver extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [route53resolver](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53resolver.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to associate an Amazon VPC with a specified firewall rule group.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateFirewallRuleGroup.html
     *
     * @experimental
     */
    toAssociateFirewallRuleGroup(): this;
    /**
     * (experimental) Grants permission to associate a specified IP address with a Resolver endpoint.
     *
     * This is an IP address that DNS queries pass through on the way to your network (outbound) or your VPCs (inbound)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverEndpointIpAddress.html
     *
     * @experimental
     */
    toAssociateResolverEndpointIpAddress(): this;
    /**
     * (experimental) Grants permission to associate an Amazon VPC with a specified query logging configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html
     *
     * @experimental
     */
    toAssociateResolverQueryLogConfig(): this;
    /**
     * (experimental) Grants permission to associate a specified Resolver rule with a specified VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html
     *
     * @experimental
     */
    toAssociateResolverRule(): this;
    /**
     * (experimental) Grants permission to create a Firewall domain list.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateFirewallDomainList.html
     *
     * @experimental
     */
    toCreateFirewallDomainList(): this;
    /**
     * (experimental) Grants permission to create a Firewall rule within a Firewall rule group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateFirewallRule.html
     *
     * @experimental
     */
    toCreateFirewallRule(): this;
    /**
     * (experimental) Grants permission to create a Firewall rule group.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateFirewallRuleGroup.html
     *
     * @experimental
     */
    toCreateFirewallRuleGroup(): this;
    /**
     * (experimental) Grants permission to create a Resolver endpoint. There are two types of Resolver endpoints, inbound and outbound.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html
     *
     * @experimental
     */
    toCreateResolverEndpoint(): this;
    /**
     * (experimental) Grants permission to create a Resolver query logging configuration, which defines where you want Resolver to save DNS query logs that originate in your VPCs.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverQueryLogConfig.html
     *
     * @experimental
     */
    toCreateResolverQueryLogConfig(): this;
    /**
     * (experimental) Grants permission to define how to route queries originating from your VPC out of the VPC.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html
     *
     * @experimental
     */
    toCreateResolverRule(): this;
    /**
     * (experimental) Grants permission to delete a Firewall domain list.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteFirewallDomainList.html
     *
     * @experimental
     */
    toDeleteFirewallDomainList(): this;
    /**
     * (experimental) Grants permission to delete a Firewall rule within a Firewall rule group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteFirewallRule.html
     *
     * @experimental
     */
    toDeleteFirewallRule(): this;
    /**
     * (experimental) Grants permission to delete a Firewall rule group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteFirewallRuleGroup.html
     *
     * @experimental
     */
    toDeleteFirewallRuleGroup(): this;
    /**
     * (experimental) Grants permission to delete a Resolver endpoint.
     *
     * The effect of deleting a Resolver endpoint depends on whether it's an inbound or an outbound endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverEndpoint.html
     *
     * @experimental
     */
    toDeleteResolverEndpoint(): this;
    /**
     * (experimental) Grants permission to delete a Resolver query logging configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverQueryLogConfig.html
     *
     * @experimental
     */
    toDeleteResolverQueryLogConfig(): this;
    /**
     * (experimental) Grants permission to delete a Resolver rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverRule.html
     *
     * @experimental
     */
    toDeleteResolverRule(): this;
    /**
     * (experimental) Grants permission to remove the association between a specified Firewall rule group and a specified VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateFirewallRuleGroup.html
     *
     * @experimental
     */
    toDisassociateFirewallRuleGroup(): this;
    /**
     * (experimental) Grants permission to remove a specified IP address from a Resolver endpoint.
     *
     * This is an IP address that DNS queries pass through on the way to your network (outbound) or your VPCs (inbound)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverEndpointIpAddress.html
     *
     * @experimental
     */
    toDisassociateResolverEndpointIpAddress(): this;
    /**
     * (experimental) Grants permission to remove the association between a specified Resolver query logging configuration and a specified VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html
     *
     * @experimental
     */
    toDisassociateResolverQueryLogConfig(): this;
    /**
     * (experimental) Grants permission to remove the association between a specified Resolver rule and a specified VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html
     *
     * @experimental
     */
    toDisassociateResolverRule(): this;
    /**
     * (experimental) Grants permission to get information about a specified Firewall config.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetFirewallConfig.html
     *
     * @experimental
     */
    toGetFirewallConfig(): this;
    /**
     * (experimental) Grants permission to get information about a specified Firewall domain list.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetFirewallDomainList.html
     *
     * @experimental
     */
    toGetFirewallDomainList(): this;
    /**
     * (experimental) Grants permission to get information about a specified Firewall rule group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetFirewallRuleGroup.html
     *
     * @experimental
     */
    toGetFirewallRuleGroup(): this;
    /**
     * (experimental) Grants permission to get information about an association between a specified Firewall rule group and a VPC.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetFirewallRuleGroupAssociation.html
     *
     * @experimental
     */
    toGetFirewallRuleGroupAssociation(): this;
    /**
     * (experimental) Grants permission to get information about a specified Firewall rule group policy, which specifies the Firewall rule group operations and resources that you want to allow another AWS account to use.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetFirewallRuleGroupPolicy.html
     *
     * @experimental
     */
    toGetFirewallRuleGroupPolicy(): this;
    /**
     * (experimental) Grants permission to get the Resolver Config status within the specified resource.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverConfig.html
     *
     * @experimental
     */
    toGetResolverConfig(): this;
    /**
     * (experimental) Grants permission to get the DNSSEC validation support status for DNS queries within the specified resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverDnssecConfig.html
     *
     * @experimental
     */
    toGetResolverDnssecConfig(): this;
    /**
     * (experimental) Grants permission to get information about a specified Resolver endpoint, such as whether it's an inbound or an outbound endpoint, and the IP addresses in your VPC that DNS queries are forwarded to on the way into or out of your VPC.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html
     *
     * @experimental
     */
    toGetResolverEndpoint(): this;
    /**
     * (experimental) Grants permission to get information about a specified Resolver query logging configuration, such as the number of VPCs that the configuration is logging queries for and the location that logs are sent to.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfig.html
     *
     * @experimental
     */
    toGetResolverQueryLogConfig(): this;
    /**
     * (experimental) Grants permission to get information about a specified association between a Resolver query logging configuration and an Amazon VPC.
     *
     * When you associate a VPC with a query logging configuration, Resolver logs DNS queries that originate in that VPC
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfigAssociation.html
     *
     * @experimental
     */
    toGetResolverQueryLogConfigAssociation(): this;
    /**
     * (experimental) Grants permission to get information about a specified Resolver query logging policy, which specifies the Resolver query logging operations and resources that you want to allow another AWS account to use.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfigPolicy.html
     *
     * @experimental
     */
    toGetResolverQueryLogConfigPolicy(): this;
    /**
     * (experimental) Grants permission to get information about a specified Resolver rule, such as the domain name that the rule forwards DNS queries for and the IP address that queries are forwarded to.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html
     *
     * @experimental
     */
    toGetResolverRule(): this;
    /**
     * (experimental) Grants permission to get information about an association between a specified Resolver rule and a VPC.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html
     *
     * @experimental
     */
    toGetResolverRuleAssociation(): this;
    /**
     * (experimental) Grants permission to get information about a Resolver rule policy, which specifies the Resolver operations and resources that you want to allow another AWS account to use.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRulePolicy.html
     *
     * @experimental
     */
    toGetResolverRulePolicy(): this;
    /**
     * (experimental) Grants permission to add, remove or replace Firewall domains in a Firewall domain list.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ImportFirewallDomains.html
     *
     * @experimental
     */
    toImportFirewallDomains(): this;
    /**
     * (experimental) Grants permission to list all the Firewall config that current AWS account is able to check.
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListFirewallConfigs.html
     *
     * @experimental
     */
    toListFirewallConfigs(): this;
    /**
     * (experimental) Grants permission to list all the Firewall domain list that current AWS account is able to use.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListFirewallDomainLists.html
     *
     * @experimental
     */
    toListFirewallDomainLists(): this;
    /**
     * (experimental) Grants permission to list all the Firewall domain under a speicfied Firewall domain list.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListFirewallDomains.html
     *
     * @experimental
     */
    toListFirewallDomains(): this;
    /**
     * (experimental) Grants permission to list information about associations between Amazon VPCs and Firewall rule group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListFirewallRuleGroupAssociations.html
     *
     * @experimental
     */
    toListFirewallRuleGroupAssociations(): this;
    /**
     * (experimental) Grants permission to list all the Firewall rule group that current AWS account is able to use.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListFirewallRuleGroups.html
     *
     * @experimental
     */
    toListFirewallRuleGroups(): this;
    /**
     * (experimental) Grants permission to list all the Firewall rule under a speicfied Firewall rule group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListFirewallRules.html
     *
     * @experimental
     */
    toListFirewallRules(): this;
    /**
     * (experimental) Grants permission to list Resolver Config statuses.
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverConfigs.html
     *
     * @experimental
     */
    toListResolverConfigs(): this;
    /**
     * (experimental) Grants permission to list the DNSSEC validation support status for DNS queries.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverDnssecConfigs.html
     *
     * @experimental
     */
    toListResolverDnssecConfigs(): this;
    /**
     * (experimental) Grants permission to list the IP addresses that DNS queries pass through on the way to your network (outbound) or your VPCs (inbound) for a specified Resolver endpoint.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpointIpAddresses.html
     *
     * @experimental
     */
    toListResolverEndpointIpAddresses(): this;
    /**
     * (experimental) Grants permission to list all the Resolver endpoints that were created using the current AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html
     *
     * @experimental
     */
    toListResolverEndpoints(): this;
    /**
     * (experimental) Grants permission to list information about associations between Amazon VPCs and query logging configurations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html
     *
     * @experimental
     */
    toListResolverQueryLogConfigAssociations(): this;
    /**
     * (experimental) Grants permission to list information about the specified query logging configurations, which define where you want Resolver to save DNS query logs and specify the VPCs that you want to log queries for.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html
     *
     * @experimental
     */
    toListResolverQueryLogConfigs(): this;
    /**
     * (experimental) Grants permission to list the associations that were created between Resolver rules and VPCs using the current AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html
     *
     * @experimental
     */
    toListResolverRuleAssociations(): this;
    /**
     * (experimental) Grants permission to list the Resolver rules that were created using the current AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html
     *
     * @experimental
     */
    toListResolverRules(): this;
    /**
     * (experimental) Grants permission to list the tags that you associated with the specified resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to specify an AWS account that you want to share a Firewall rule group with, the Firewall rule group that you want to share, and the operations that you want the account to be able to perform on the configuration.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_PutFirewallRuleGroupPolicy.html
     *
     * @experimental
     */
    toPutFirewallRuleGroupPolicy(): this;
    /**
     * (experimental) Grants permission to specify an AWS account that you want to share a query logging configuration with, the query logging configuration that you want to share, and the operations that you want the account to be able to perform on the configuration.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_PutResolverQueryLogConfigPolicy.html
     *
     * @experimental
     */
    toPutResolverQueryLogConfigPolicy(): this;
    /**
     * (experimental) Grants permission to specify an AWS account that you want to share rules with, the Resolver rules that you want to share, and the operations that you want the account to be able to perform on those rules.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_PutResolverRulePolicy.html
     *
     * @experimental
     */
    toPutResolverRulePolicy(): this;
    /**
     * (experimental) Grants permission to add one or more tags to a specified resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove one or more tags from a specified resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update selected settings for an Firewall config.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateFirewallConfig.html
     *
     * @experimental
     */
    toUpdateFirewallConfig(): this;
    /**
     * (experimental) Grants permission to add, remove or replace Firewall domains in a Firewall domain list.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateFirewallDomains.html
     *
     * @experimental
     */
    toUpdateFirewallDomains(): this;
    /**
     * (experimental) Grants permission to update selected settings for an Firewall rule in a Firewall rule group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateFirewallRule.html
     *
     * @experimental
     */
    toUpdateFirewallRule(): this;
    /**
     * (experimental) Grants permission to update selected settings for an Firewall rule group association.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateFirewallRuleGroupAssociation.html
     *
     * @experimental
     */
    toUpdateFirewallRuleGroupAssociation(): this;
    /**
     * (experimental) Grants permission to update the Resolver Config status within the specified resource.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverConfig.html
     *
     * @experimental
     */
    toUpdateResolverConfig(): this;
    /**
     * (experimental) Grants permission to update the DNSSEC validation support status for DNS queries within the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverDnssecConfig.html
     *
     * @experimental
     */
    toUpdateResolverDnssecConfig(): this;
    /**
     * (experimental) Grants permission to update selected settings for an inbound or an outbound Resolver endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverEndpoint.html
     *
     * @experimental
     */
    toUpdateResolverEndpoint(): this;
    /**
     * (experimental) Grants permission to update settings for a specified Resolver rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverRule.html
     *
     * @experimental
     */
    toUpdateResolverRule(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type resolver-dnssec-config to the statement.
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/access-control-overview.html/#access-control-resources
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onResolverDnssecConfig(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type resolver-query-log-config to the statement.
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/access-control-overview.html/#access-control-resources
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onResolverQueryLogConfig(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type resolver-rule to the statement.
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/access-control-overview.html/#access-control-resources
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onResolverRule(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type resolver-endpoint to the statement.
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/access-control-overview.html/#access-control-resources
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onResolverEndpoint(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type firewall-rule-group to the statement.
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/access-control-overview.html/#access-control-resources
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFirewallRuleGroup(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type firewall-rule-group-association to the statement.
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/access-control-overview.html/#access-control-resources
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFirewallRuleGroupAssociation(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type firewall-domain-list to the statement.
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/access-control-overview.html/#access-control-resources
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFirewallDomainList(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type firewall-config to the statement.
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/access-control-overview.html/#access-control-resources
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFirewallConfig(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type resolver-config to the statement.
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/access-control-overview.html/#access-control-resources
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onResolverConfig(resourceId: string, account?: string, region?: string, partition?: string): this;
}
