# Copyright (c) 2012-2020, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 18.6.0


from troposphere import Tags

from . import AWSObject, AWSProperty
from .validators import boolean, integer


class Alarm(AWSProperty):
    props = {
        "AlarmName": (str, True),
        "Severity": (str, False),
    }


class AlarmMetric(AWSProperty):
    props = {
        "AlarmMetricName": (str, True),
    }


class Log(AWSProperty):
    props = {
        "Encoding": (str, False),
        "LogGroupName": (str, False),
        "LogPath": (str, False),
        "LogType": (str, True),
        "PatternSet": (str, False),
    }


class WindowsEvent(AWSProperty):
    props = {
        "EventLevels": ([str], True),
        "EventName": (str, True),
        "LogGroupName": (str, True),
        "PatternSet": (str, False),
    }


class ConfigurationDetails(AWSProperty):
    props = {
        "AlarmMetrics": ([AlarmMetric], False),
        "Alarms": ([Alarm], False),
        "Logs": ([Log], False),
        "WindowsEvents": ([WindowsEvent], False),
    }


class SubComponentConfigurationDetails(AWSProperty):
    props = {
        "AlarmMetrics": ([AlarmMetric], False),
        "Logs": ([Log], False),
        "WindowsEvents": ([WindowsEvent], False),
    }


class SubComponentTypeConfiguration(AWSProperty):
    props = {
        "SubComponentConfigurationDetails": (SubComponentConfigurationDetails, True),
        "SubComponentType": (str, True),
    }


class ComponentConfiguration(AWSProperty):
    props = {
        "ConfigurationDetails": (ConfigurationDetails, False),
        "SubComponentTypeConfigurations": ([SubComponentTypeConfiguration], False),
    }


class ComponentMonitoringSetting(AWSProperty):
    props = {
        "ComponentARN": (str, False),
        "ComponentConfigurationMode": (str, False),
        "ComponentName": (str, False),
        "CustomComponentConfiguration": (ComponentConfiguration, False),
        "DefaultOverwriteComponentConfiguration": (ComponentConfiguration, False),
        "Tier": (str, False),
    }


class CustomComponent(AWSProperty):
    props = {
        "ComponentName": (str, True),
        "ResourceList": ([str], True),
    }


class LogPattern(AWSProperty):
    props = {
        "Pattern": (str, True),
        "PatternName": (str, True),
        "Rank": (integer, True),
    }


class LogPatternSet(AWSProperty):
    props = {
        "LogPatterns": ([LogPattern], True),
        "PatternSetName": (str, True),
    }


class Application(AWSObject):
    resource_type = "AWS::ApplicationInsights::Application"

    props = {
        "AutoConfigurationEnabled": (boolean, False),
        "CWEMonitorEnabled": (boolean, False),
        "ComponentMonitoringSettings": ([ComponentMonitoringSetting], False),
        "CustomComponents": ([CustomComponent], False),
        "LogPatternSets": ([LogPatternSet], False),
        "OpsCenterEnabled": (boolean, False),
        "OpsItemSNSTopicArn": (str, False),
        "ResourceGroupName": (str, True),
        "Tags": (Tags, False),
    }
