# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 39.1.0


from troposphere import Tags

from . import AWSObject, AWSProperty
from .validators import boolean, integer


class EncryptionConfiguration(AWSProperty):
    props = {
        "KmsKey": (str, True),
    }


class HealthCheckConfiguration(AWSProperty):
    props = {
        "HealthyThreshold": (integer, False),
        "Interval": (integer, False),
        "Path": (str, False),
        "Protocol": (str, False),
        "Timeout": (integer, False),
        "UnhealthyThreshold": (integer, False),
    }


class InstanceConfiguration(AWSProperty):
    props = {
        "Cpu": (str, False),
        "InstanceRoleArn": (str, False),
        "Memory": (str, False),
    }


class AuthenticationConfiguration(AWSProperty):
    props = {
        "AccessRoleArn": (str, False),
        "ConnectionArn": (str, False),
    }


class KeyValuePair(AWSProperty):
    props = {
        "Name": (str, False),
        "Value": (str, False),
    }


class CodeConfigurationValues(AWSProperty):
    props = {
        "BuildCommand": (str, False),
        "Port": (str, False),
        "Runtime": (str, True),
        "RuntimeEnvironmentVariables": ([KeyValuePair], False),
        "StartCommand": (str, False),
    }


class CodeConfiguration(AWSProperty):
    props = {
        "CodeConfigurationValues": (CodeConfigurationValues, False),
        "ConfigurationSource": (str, True),
    }


class SourceCodeVersion(AWSProperty):
    props = {
        "Type": (str, True),
        "Value": (str, True),
    }


class CodeRepository(AWSProperty):
    props = {
        "CodeConfiguration": (CodeConfiguration, False),
        "RepositoryUrl": (str, True),
        "SourceCodeVersion": (SourceCodeVersion, True),
    }


class ImageConfiguration(AWSProperty):
    props = {
        "Port": (str, False),
        "RuntimeEnvironmentVariables": ([KeyValuePair], False),
        "StartCommand": (str, False),
    }


class ImageRepository(AWSProperty):
    props = {
        "ImageConfiguration": (ImageConfiguration, False),
        "ImageIdentifier": (str, True),
        "ImageRepositoryType": (str, True),
    }


class SourceConfiguration(AWSProperty):
    props = {
        "AuthenticationConfiguration": (AuthenticationConfiguration, False),
        "AutoDeploymentsEnabled": (boolean, False),
        "CodeRepository": (CodeRepository, False),
        "ImageRepository": (ImageRepository, False),
    }


class Service(AWSObject):
    resource_type = "AWS::AppRunner::Service"

    props = {
        "AutoScalingConfigurationArn": (str, False),
        "EncryptionConfiguration": (EncryptionConfiguration, False),
        "HealthCheckConfiguration": (HealthCheckConfiguration, False),
        "InstanceConfiguration": (InstanceConfiguration, False),
        "ServiceName": (str, False),
        "SourceConfiguration": (SourceConfiguration, True),
        "Tags": (Tags, False),
    }
