# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 31.2.0


from troposphere import Tags

from . import AWSObject, AWSProperty
from .validators import boolean, integer


class Domain(AWSObject):
    resource_type = "AWS::CustomerProfiles::Domain"

    props = {
        "DeadLetterQueueUrl": (str, False),
        "DefaultEncryptionKey": (str, False),
        "DefaultExpirationDays": (integer, False),
        "DomainName": (str, True),
        "Tags": (Tags, False),
    }


class Integration(AWSObject):
    resource_type = "AWS::CustomerProfiles::Integration"

    props = {
        "DomainName": (str, True),
        "ObjectTypeName": (str, False),
        "Tags": (Tags, False),
        "Uri": (str, False),
    }


class ObjectTypeField(AWSProperty):
    props = {
        "ContentType": (str, False),
        "Source": (str, False),
        "Target": (str, False),
    }


class FieldMap(AWSProperty):
    props = {
        "Name": (str, False),
        "ObjectTypeField": (ObjectTypeField, False),
    }


class ObjectTypeKey(AWSProperty):
    props = {
        "FieldNames": ([str], False),
        "StandardIdentifiers": ([str], False),
    }


class KeyMap(AWSProperty):
    props = {
        "Name": (str, False),
        "ObjectTypeKeyList": ([ObjectTypeKey], False),
    }


class ObjectType(AWSObject):
    resource_type = "AWS::CustomerProfiles::ObjectType"

    props = {
        "AllowProfileCreation": (boolean, False),
        "Description": (str, False),
        "DomainName": (str, True),
        "EncryptionKey": (str, False),
        "ExpirationDays": (integer, False),
        "Fields": ([FieldMap], False),
        "Keys": ([KeyMap], False),
        "ObjectTypeName": (str, False),
        "Tags": (Tags, False),
        "TemplateId": (str, False),
    }
