# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 31.0.0


from troposphere import Tags

from . import AWSObject, AWSProperty
from .validators import integer


class Agent(AWSObject):
    resource_type = "AWS::DataSync::Agent"

    props = {
        "ActivationKey": (str, True),
        "AgentName": (str, False),
        "SecurityGroupArns": ([str], False),
        "SubnetArns": ([str], False),
        "Tags": (Tags, False),
        "VpcEndpointId": (str, False),
    }


class Ec2Config(AWSProperty):
    props = {
        "SecurityGroupArns": ([str], True),
        "SubnetArn": (str, True),
    }


class LocationEFS(AWSObject):
    resource_type = "AWS::DataSync::LocationEFS"

    props = {
        "Ec2Config": (Ec2Config, True),
        "EfsFilesystemArn": (str, True),
        "Subdirectory": (str, False),
        "Tags": (Tags, False),
    }


class LocationFSxWindows(AWSObject):
    resource_type = "AWS::DataSync::LocationFSxWindows"

    props = {
        "Domain": (str, False),
        "FsxFilesystemArn": (str, True),
        "Password": (str, True),
        "SecurityGroupArns": ([str], True),
        "Subdirectory": (str, False),
        "Tags": (Tags, False),
        "User": (str, True),
    }


class MountOptions(AWSProperty):
    props = {
        "Version": (str, False),
    }


class OnPremConfig(AWSProperty):
    props = {
        "AgentArns": ([str], True),
    }


class LocationNFS(AWSObject):
    resource_type = "AWS::DataSync::LocationNFS"

    props = {
        "MountOptions": (MountOptions, False),
        "OnPremConfig": (OnPremConfig, True),
        "ServerHostname": (str, True),
        "Subdirectory": (str, True),
        "Tags": (Tags, False),
    }


class LocationObjectStorage(AWSObject):
    resource_type = "AWS::DataSync::LocationObjectStorage"

    props = {
        "AccessKey": (str, False),
        "AgentArns": ([str], True),
        "BucketName": (str, True),
        "SecretKey": (str, False),
        "ServerHostname": (str, True),
        "ServerPort": (integer, False),
        "ServerProtocol": (str, False),
        "Subdirectory": (str, False),
        "Tags": (Tags, False),
    }


class S3Config(AWSProperty):
    props = {
        "BucketAccessRoleArn": (str, True),
    }


class LocationS3(AWSObject):
    resource_type = "AWS::DataSync::LocationS3"

    props = {
        "S3BucketArn": (str, True),
        "S3Config": (S3Config, True),
        "S3StorageClass": (str, False),
        "Subdirectory": (str, False),
        "Tags": (Tags, False),
    }


class LocationSMB(AWSObject):
    resource_type = "AWS::DataSync::LocationSMB"

    props = {
        "AgentArns": ([str], True),
        "Domain": (str, False),
        "MountOptions": (MountOptions, False),
        "Password": (str, True),
        "ServerHostname": (str, True),
        "Subdirectory": (str, True),
        "Tags": (Tags, False),
        "User": (str, True),
    }


class FilterRule(AWSProperty):
    props = {
        "FilterType": (str, False),
        "Value": (str, False),
    }


class Options(AWSProperty):
    props = {
        "Atime": (str, False),
        "BytesPerSecond": (integer, False),
        "Gid": (str, False),
        "LogLevel": (str, False),
        "Mtime": (str, False),
        "OverwriteMode": (str, False),
        "PosixPermissions": (str, False),
        "PreserveDeletedFiles": (str, False),
        "PreserveDevices": (str, False),
        "TaskQueueing": (str, False),
        "TransferMode": (str, False),
        "Uid": (str, False),
        "VerifyMode": (str, False),
    }


class TaskSchedule(AWSProperty):
    props = {
        "ScheduleExpression": (str, True),
    }


class Task(AWSObject):
    resource_type = "AWS::DataSync::Task"

    props = {
        "CloudWatchLogGroupArn": (str, False),
        "DestinationLocationArn": (str, True),
        "Excludes": ([FilterRule], False),
        "Name": (str, False),
        "Options": (Options, False),
        "Schedule": (TaskSchedule, False),
        "SourceLocationArn": (str, True),
        "Tags": (Tags, False),
    }
