# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 39.1.0


from troposphere import Tags

from . import AWSObject, AWSProperty
from .validators import boolean


class EntityType(AWSProperty):
    props = {
        "Arn": (str, False),
        "CreatedTime": (str, False),
        "Description": (str, False),
        "Inline": (boolean, False),
        "LastUpdatedTime": (str, False),
        "Name": (str, False),
        "Tags": (Tags, False),
    }


class EventVariable(AWSProperty):
    props = {
        "Arn": (str, False),
        "CreatedTime": (str, False),
        "DataSource": (str, False),
        "DataType": (str, False),
        "DefaultValue": (str, False),
        "Description": (str, False),
        "Inline": (boolean, False),
        "LastUpdatedTime": (str, False),
        "Name": (str, False),
        "Tags": (Tags, False),
        "VariableType": (str, False),
    }


class Label(AWSProperty):
    props = {
        "Arn": (str, False),
        "CreatedTime": (str, False),
        "Description": (str, False),
        "Inline": (boolean, False),
        "LastUpdatedTime": (str, False),
        "Name": (str, False),
        "Tags": (Tags, False),
    }


class EventType(AWSProperty):
    props = {
        "Arn": (str, False),
        "CreatedTime": (str, False),
        "Description": (str, False),
        "EntityTypes": ([EntityType], False),
        "EventVariables": ([EventVariable], False),
        "Inline": (boolean, False),
        "Labels": ([Label], False),
        "LastUpdatedTime": (str, False),
        "Name": (str, False),
        "Tags": (Tags, False),
    }


class Model(AWSProperty):
    props = {
        "Arn": (str, False),
    }


class Outcome(AWSProperty):
    props = {
        "Arn": (str, False),
        "CreatedTime": (str, False),
        "Description": (str, False),
        "Inline": (boolean, False),
        "LastUpdatedTime": (str, False),
        "Name": (str, False),
        "Tags": (Tags, False),
    }


class Rule(AWSProperty):
    props = {
        "Arn": (str, False),
        "CreatedTime": (str, False),
        "Description": (str, False),
        "DetectorId": (str, False),
        "Expression": (str, False),
        "Language": (str, False),
        "LastUpdatedTime": (str, False),
        "Outcomes": ([Outcome], False),
        "RuleId": (str, False),
        "RuleVersion": (str, False),
        "Tags": (Tags, False),
    }


class Detector(AWSObject):
    resource_type = "AWS::FraudDetector::Detector"

    props = {
        "AssociatedModels": ([Model], False),
        "Description": (str, False),
        "DetectorId": (str, True),
        "DetectorVersionStatus": (str, False),
        "EventType": (EventType, True),
        "RuleExecutionMode": (str, False),
        "Rules": ([Rule], True),
        "Tags": (Tags, False),
    }


class Variable(AWSObject):
    resource_type = "AWS::FraudDetector::Variable"

    props = {
        "DataSource": (str, True),
        "DataType": (str, True),
        "DefaultValue": (str, True),
        "Description": (str, False),
        "Name": (str, True),
        "Tags": (Tags, False),
        "VariableType": (str, False),
    }
