# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 31.0.0


from troposphere import Tags

from . import AWSObject, AWSProperty


class IamRole(AWSProperty):
    props = {
        "arn": (str, False),
    }


class IamUser(AWSProperty):
    props = {
        "arn": (str, False),
    }


class User(AWSProperty):
    props = {
        "id": (str, False),
    }


class AccessPolicyIdentity(AWSProperty):
    props = {
        "IamRole": (IamRole, False),
        "IamUser": (IamUser, False),
        "User": (User, False),
    }


class PortalProperty(AWSProperty):
    props = {
        "id": (str, False),
    }


class Project(AWSProperty):
    props = {
        "id": (str, False),
    }


class AccessPolicyResource(AWSProperty):
    props = {
        "Portal": (PortalProperty, False),
        "Project": (Project, False),
    }


class AccessPolicy(AWSObject):
    resource_type = "AWS::IoTSiteWise::AccessPolicy"

    props = {
        "AccessPolicyIdentity": (AccessPolicyIdentity, True),
        "AccessPolicyPermission": (str, True),
        "AccessPolicyResource": (AccessPolicyResource, True),
    }


class AssetHierarchy(AWSProperty):
    props = {
        "ChildAssetId": (str, True),
        "LogicalId": (str, True),
    }


class AssetProperty(AWSProperty):
    props = {
        "Alias": (str, False),
        "LogicalId": (str, True),
        "NotificationState": (str, False),
    }


class Asset(AWSObject):
    resource_type = "AWS::IoTSiteWise::Asset"

    props = {
        "AssetHierarchies": ([AssetHierarchy], False),
        "AssetModelId": (str, True),
        "AssetName": (str, True),
        "AssetProperties": ([AssetProperty], False),
        "Tags": (Tags, False),
    }


class Attribute(AWSProperty):
    props = {
        "DefaultValue": (str, False),
    }


class VariableValue(AWSProperty):
    props = {
        "HierarchyLogicalId": (str, False),
        "PropertyLogicalId": (str, True),
    }


class ExpressionVariable(AWSProperty):
    props = {
        "Name": (str, True),
        "Value": (VariableValue, True),
    }


class TumblingWindow(AWSProperty):
    props = {
        "Interval": (str, True),
    }


class MetricWindow(AWSProperty):
    props = {
        "Tumbling": (TumblingWindow, False),
    }


class Metric(AWSProperty):
    props = {
        "Expression": (str, True),
        "Variables": ([ExpressionVariable], True),
        "Window": (MetricWindow, True),
    }


class Transform(AWSProperty):
    props = {
        "Expression": (str, True),
        "Variables": ([ExpressionVariable], True),
    }


class PropertyType(AWSProperty):
    props = {
        "Attribute": (Attribute, False),
        "Metric": (Metric, False),
        "Transform": (Transform, False),
        "TypeName": (str, True),
    }


class AssetModelProperty(AWSProperty):
    props = {
        "DataType": (str, True),
        "DataTypeSpec": (str, False),
        "LogicalId": (str, True),
        "Name": (str, True),
        "Type": (PropertyType, True),
        "Unit": (str, False),
    }


class AssetModelCompositeModel(AWSProperty):
    props = {
        "CompositeModelProperties": ([AssetModelProperty], False),
        "Description": (str, False),
        "Name": (str, True),
        "Type": (str, True),
    }


class AssetModelHierarchy(AWSProperty):
    props = {
        "ChildAssetModelId": (str, True),
        "LogicalId": (str, True),
        "Name": (str, True),
    }


class AssetModel(AWSObject):
    resource_type = "AWS::IoTSiteWise::AssetModel"

    props = {
        "AssetModelCompositeModels": ([AssetModelCompositeModel], False),
        "AssetModelDescription": (str, False),
        "AssetModelHierarchies": ([AssetModelHierarchy], False),
        "AssetModelName": (str, True),
        "AssetModelProperties": ([AssetModelProperty], False),
        "Tags": (Tags, False),
    }


class Dashboard(AWSObject):
    resource_type = "AWS::IoTSiteWise::Dashboard"

    props = {
        "DashboardDefinition": (str, True),
        "DashboardDescription": (str, True),
        "DashboardName": (str, True),
        "ProjectId": (str, False),
        "Tags": (Tags, False),
    }


class GatewayCapabilitySummary(AWSProperty):
    props = {
        "CapabilityConfiguration": (str, False),
        "CapabilityNamespace": (str, True),
    }


class Greengrass(AWSProperty):
    props = {
        "GroupArn": (str, True),
    }


class GatewayPlatform(AWSProperty):
    props = {
        "Greengrass": (Greengrass, True),
    }


class Gateway(AWSObject):
    resource_type = "AWS::IoTSiteWise::Gateway"

    props = {
        "GatewayCapabilitySummaries": ([GatewayCapabilitySummary], False),
        "GatewayName": (str, True),
        "GatewayPlatform": (GatewayPlatform, True),
        "Tags": (Tags, False),
    }


class Portal(AWSObject):
    resource_type = "AWS::IoTSiteWise::Portal"

    props = {
        "PortalAuthMode": (str, False),
        "PortalContactEmail": (str, True),
        "PortalDescription": (str, False),
        "PortalName": (str, True),
        "RoleArn": (str, True),
        "Tags": (Tags, False),
    }
