# Copyright (c) 2012-2019, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 5.3.0


from . import AWSObject, AWSProperty


class Admins(AWSProperty):
    props = {}


class DataLakeSettings(AWSObject):
    resource_type = "AWS::LakeFormation::DataLakeSettings"

    props = {
        "Admins": (Admins, False),
    }


class DataLakePrincipal(AWSProperty):
    props = {
        "DataLakePrincipalIdentifier": (str, False),
    }


class DatabaseResource(AWSProperty):
    props = {
        "Name": (str, False),
    }


class TableResource(AWSProperty):
    props = {
        "DatabaseName": (str, False),
        "Name": (str, False),
    }


class DataLocationResource(AWSProperty):
    props = {
        "S3Resource": (str, False),
    }


class ColumnWildcard(AWSProperty):
    props = {
        "ExcludedColumnNames": ([str], False),
    }


class TableWithColumnsResource(AWSProperty):
    props = {
        "ColumnNames": ([str], False),
        "ColumnWildcard": (ColumnWildcard, False),
        "DatabaseName": (str, False),
        "Name": (str, False),
    }


class Resource(AWSProperty):
    props = {
        "DatabaseResource": (DatabaseResource, False),
        "DataLocationResource": (DataLocationResource, False),
        "TableResource": (TableResource, False),
        "TableWithColumnsResource": (TableWithColumnsResource, False),
    }


class Permissions(AWSObject):
    resource_type = "AWS::LakeFormation::Permissions"

    props = {
        "DataLakePrincipal": (DataLakePrincipal, True),
        "Permissions": ([str], False),
        "PermissionsWithGrantOption": ([str], False),
        "Resource": (Resource, True),
    }
