# Copyright (c) 2012-2019, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 5.3.0


from . import AWSObject, AWSProperty
from .validators import integer


class MemberFabricConfiguration(AWSProperty):
    props = {
        "AdminPassword": (str, True),
        "AdminUsername": (str, True),
    }


class MemberFrameworkConfiguration(AWSProperty):
    props = {
        "MemberFabricConfiguration": (MemberFabricConfiguration, False),
    }


class MemberConfiguration(AWSProperty):
    props = {
        "Description": (str, False),
        "MemberFrameworkConfiguration": (MemberFrameworkConfiguration, False),
        "Name": (str, True),
    }


class NetworkFabricConfiguration(AWSProperty):
    props = {
        "Edition": (str, True),
    }


class NetworkFrameworkConfiguration(AWSProperty):
    props = {
        "NetworkFabricConfiguration": (NetworkFabricConfiguration, False),
    }


class ApprovalThresholdPolicy(AWSProperty):
    props = {
        "ProposalDurationInHours": (integer, False),
        "ThresholdComparator": (str, False),
        "ThresholdPercentage": (integer, False),
    }


class VotingPolicy(AWSProperty):
    props = {
        "ApprovalThresholdPolicy": (ApprovalThresholdPolicy, False),
    }


class NetworkConfiguration(AWSProperty):
    props = {
        "Description": (str, False),
        "Framework": (str, True),
        "FrameworkVersion": (str, True),
        "Name": (str, True),
        "NetworkFrameworkConfiguration": (NetworkFrameworkConfiguration, False),
        "VotingPolicy": (VotingPolicy, True),
    }


class Member(AWSObject):
    resource_type = "AWS::ManagedBlockchain::Member"

    props = {
        "InvitationId": (str, False),
        "MemberConfiguration": (MemberConfiguration, True),
        "NetworkConfiguration": (NetworkConfiguration, False),
        "NetworkId": (str, False),
    }


class NodeConfiguration(AWSProperty):
    props = {
        "AvailabilityZone": (str, True),
        "InstanceType": (str, True),
    }


class Node(AWSObject):
    resource_type = "AWS::ManagedBlockchain::Node"

    props = {
        "MemberId": (str, True),
        "NetworkId": (str, True),
        "NodeConfiguration": (NodeConfiguration, True),
    }
