# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 31.0.0


from troposphere import Tags

from . import AWSObject, AWSProperty
from .validators import boolean, integer


class EgressEndpoint(AWSProperty):
    props = {
        "PackagingConfigurationId": (str, True),
        "Url": (str, True),
    }


class Asset(AWSObject):
    resource_type = "AWS::MediaPackage::Asset"

    props = {
        "EgressEndpoints": ([EgressEndpoint], False),
        "Id": (str, True),
        "PackagingGroupId": (str, True),
        "ResourceId": (str, False),
        "SourceArn": (str, True),
        "SourceRoleArn": (str, True),
        "Tags": (Tags, False),
    }


class LogConfiguration(AWSProperty):
    props = {
        "LogGroupName": (str, False),
    }


class Channel(AWSObject):
    resource_type = "AWS::MediaPackage::Channel"

    props = {
        "Description": (str, False),
        "EgressAccessLogs": (LogConfiguration, False),
        "Id": (str, True),
        "IngressAccessLogs": (LogConfiguration, False),
        "Tags": (Tags, False),
    }


class Authorization(AWSProperty):
    props = {
        "CdnIdentifierSecret": (str, True),
        "SecretsRoleArn": (str, True),
    }


class SpekeKeyProvider(AWSProperty):
    props = {
        "RoleArn": (str, True),
        "SystemIds": ([str], True),
        "Url": (str, True),
    }


class CmafEncryption(AWSProperty):
    props = {
        "SpekeKeyProvider": (SpekeKeyProvider, True),
    }


class StreamSelection(AWSProperty):
    props = {
        "MaxVideoBitsPerSecond": (integer, False),
        "MinVideoBitsPerSecond": (integer, False),
        "StreamOrder": (str, False),
    }


class HlsManifest(AWSProperty):
    props = {
        "AdMarkers": (str, False),
        "IncludeIframeOnlyStream": (boolean, False),
        "ManifestName": (str, False),
        "ProgramDateTimeIntervalSeconds": (integer, False),
        "RepeatExtXKey": (boolean, False),
        "StreamSelection": (StreamSelection, False),
    }


class CmafPackage(AWSProperty):
    props = {
        "Encryption": (CmafEncryption, False),
        "HlsManifests": ([HlsManifest], True),
        "IncludeEncoderConfigurationInSegments": (boolean, False),
        "SegmentDurationSeconds": (integer, False),
    }


class DashEncryption(AWSProperty):
    props = {
        "SpekeKeyProvider": (SpekeKeyProvider, True),
    }


class DashManifest(AWSProperty):
    props = {
        "ManifestLayout": (str, False),
        "ManifestName": (str, False),
        "MinBufferTimeSeconds": (integer, False),
        "Profile": (str, False),
        "StreamSelection": (StreamSelection, False),
    }


class DashPackage(AWSProperty):
    props = {
        "DashManifests": ([DashManifest], True),
        "Encryption": (DashEncryption, False),
        "PeriodTriggers": ([str], False),
        "SegmentDurationSeconds": (integer, False),
        "SegmentTemplateFormat": (str, False),
    }


class HlsEncryption(AWSProperty):
    props = {
        "ConstantInitializationVector": (str, False),
        "EncryptionMethod": (str, False),
        "SpekeKeyProvider": (SpekeKeyProvider, True),
    }


class HlsPackage(AWSProperty):
    props = {
        "Encryption": (HlsEncryption, False),
        "HlsManifests": ([HlsManifest], True),
        "SegmentDurationSeconds": (integer, False),
        "UseAudioRenditionGroup": (boolean, False),
    }


class MssEncryption(AWSProperty):
    props = {
        "SpekeKeyProvider": (SpekeKeyProvider, True),
    }


class MssManifest(AWSProperty):
    props = {
        "ManifestName": (str, False),
        "StreamSelection": (StreamSelection, False),
    }


class MssPackage(AWSProperty):
    props = {
        "Encryption": (MssEncryption, False),
        "MssManifests": ([MssManifest], True),
        "SegmentDurationSeconds": (integer, False),
    }


class OriginEndpoint(AWSObject):
    resource_type = "AWS::MediaPackage::OriginEndpoint"

    props = {
        "Authorization": (Authorization, False),
        "ChannelId": (str, True),
        "CmafPackage": (CmafPackage, False),
        "DashPackage": (DashPackage, False),
        "Description": (str, False),
        "HlsPackage": (HlsPackage, False),
        "Id": (str, True),
        "ManifestName": (str, False),
        "MssPackage": (MssPackage, False),
        "Origination": (str, False),
        "StartoverWindowSeconds": (integer, False),
        "Tags": (Tags, False),
        "TimeDelaySeconds": (integer, False),
        "Whitelist": ([str], False),
    }


class PackagingConfiguration(AWSObject):
    resource_type = "AWS::MediaPackage::PackagingConfiguration"

    props = {
        "CmafPackage": (CmafPackage, False),
        "DashPackage": (DashPackage, False),
        "HlsPackage": (HlsPackage, False),
        "Id": (str, True),
        "MssPackage": (MssPackage, False),
        "PackagingGroupId": (str, True),
        "Tags": (Tags, False),
    }


class PackagingGroup(AWSObject):
    resource_type = "AWS::MediaPackage::PackagingGroup"

    props = {
        "Authorization": (Authorization, False),
        "EgressAccessLogs": (LogConfiguration, False),
        "Id": (str, True),
        "Tags": (Tags, False),
    }
