# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 35.1.0


from troposphere import Tags

from . import AWSObject, AWSProperty
from .validators import double


class StreamConfiguration(AWSProperty):
    props = {
        "ClipboardMode": (str, True),
        "Ec2InstanceTypes": ([str], True),
        "MaxSessionLengthInMinutes": (double, False),
        "StreamingImageIds": ([str], True),
    }


class LaunchProfile(AWSObject):
    resource_type = "AWS::NimbleStudio::LaunchProfile"

    props = {
        "Description": (str, False),
        "Ec2SubnetIds": ([str], True),
        "LaunchProfileProtocolVersions": ([str], True),
        "Name": (str, True),
        "StreamConfiguration": (StreamConfiguration, True),
        "StudioComponentIds": ([str], True),
        "StudioId": (str, True),
        "Tags": (Tags, False),
    }


class StreamingImage(AWSObject):
    resource_type = "AWS::NimbleStudio::StreamingImage"

    props = {
        "Description": (str, False),
        "Ec2ImageId": (str, True),
        "Name": (str, True),
        "StudioId": (str, True),
        "Tags": (Tags, False),
    }


class StudioEncryptionConfiguration(AWSProperty):
    props = {
        "KeyArn": (str, False),
        "KeyType": (str, True),
    }


class Studio(AWSObject):
    resource_type = "AWS::NimbleStudio::Studio"

    props = {
        "AdminRoleArn": (str, True),
        "DisplayName": (str, True),
        "StudioEncryptionConfiguration": (StudioEncryptionConfiguration, False),
        "StudioName": (str, True),
        "Tags": (Tags, False),
        "UserRoleArn": (str, True),
    }


class ScriptParameterKeyValue(AWSProperty):
    props = {
        "Key": (str, False),
        "Value": (str, False),
    }


class ActiveDirectoryComputerAttribute(AWSProperty):
    props = {
        "Name": (str, False),
        "Value": (str, False),
    }


class ActiveDirectoryConfiguration(AWSProperty):
    props = {
        "ComputerAttributes": ([ActiveDirectoryComputerAttribute], False),
        "DirectoryId": (str, False),
        "OrganizationalUnitDistinguishedName": (str, False),
    }


class ComputeFarmConfiguration(AWSProperty):
    props = {
        "ActiveDirectoryUser": (str, False),
        "Endpoint": (str, False),
    }


class LicenseServiceConfiguration(AWSProperty):
    props = {
        "Endpoint": (str, False),
    }


class SharedFileSystemConfiguration(AWSProperty):
    props = {
        "Endpoint": (str, False),
        "FileSystemId": (str, False),
        "LinuxMountPoint": (str, False),
        "ShareName": (str, False),
        "WindowsMountDrive": (str, False),
    }


class StudioComponentConfiguration(AWSProperty):
    props = {
        "ActiveDirectoryConfiguration": (ActiveDirectoryConfiguration, False),
        "ComputeFarmConfiguration": (ComputeFarmConfiguration, False),
        "LicenseServiceConfiguration": (LicenseServiceConfiguration, False),
        "SharedFileSystemConfiguration": (SharedFileSystemConfiguration, False),
    }


class StudioComponentInitializationScript(AWSProperty):
    props = {
        "LaunchProfileProtocolVersion": (str, False),
        "Platform": (str, False),
        "RunContext": (str, False),
        "Script": (str, False),
    }


class StudioComponent(AWSObject):
    resource_type = "AWS::NimbleStudio::StudioComponent"

    props = {
        "Configuration": (StudioComponentConfiguration, False),
        "Description": (str, False),
        "Ec2SecurityGroupIds": ([str], False),
        "InitializationScripts": ([StudioComponentInitializationScript], False),
        "Name": (str, True),
        "ScriptParameters": ([ScriptParameterKeyValue], False),
        "StudioId": (str, True),
        "Subtype": (str, False),
        "Tags": (Tags, False),
        "Type": (str, True),
    }
