# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 35.0.0


from troposphere import Tags

from . import AWSObject, AWSProperty
from .validators import double


class HttpNamespace(AWSObject):
    resource_type = "AWS::ServiceDiscovery::HttpNamespace"

    props = {
        "Description": (str, False),
        "Name": (str, True),
        "Tags": (Tags, False),
    }


class Instance(AWSObject):
    resource_type = "AWS::ServiceDiscovery::Instance"

    props = {
        "InstanceAttributes": (dict, True),
        "InstanceId": (str, False),
        "ServiceId": (str, True),
    }


class PrivateDnsNamespace(AWSObject):
    resource_type = "AWS::ServiceDiscovery::PrivateDnsNamespace"

    props = {
        "Description": (str, False),
        "Name": (str, True),
        "Tags": (Tags, False),
        "Vpc": (str, True),
    }


class PublicDnsNamespace(AWSObject):
    resource_type = "AWS::ServiceDiscovery::PublicDnsNamespace"

    props = {
        "Description": (str, False),
        "Name": (str, True),
        "Tags": (Tags, False),
    }


class DnsRecord(AWSProperty):
    props = {
        "TTL": (double, True),
        "Type": (str, True),
    }


class DnsConfig(AWSProperty):
    props = {
        "DnsRecords": ([DnsRecord], True),
        "NamespaceId": (str, False),
        "RoutingPolicy": (str, False),
    }


class HealthCheckConfig(AWSProperty):
    props = {
        "FailureThreshold": (double, False),
        "ResourcePath": (str, False),
        "Type": (str, True),
    }


class HealthCheckCustomConfig(AWSProperty):
    props = {
        "FailureThreshold": (double, False),
    }


class Service(AWSObject):
    resource_type = "AWS::ServiceDiscovery::Service"

    props = {
        "Description": (str, False),
        "DnsConfig": (DnsConfig, False),
        "HealthCheckConfig": (HealthCheckConfig, False),
        "HealthCheckCustomConfig": (HealthCheckCustomConfig, False),
        "Name": (str, False),
        "NamespaceId": (str, False),
        "Tags": (Tags, False),
        "Type": (str, False),
    }
