# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 39.1.0


from . import AWSObject, AWSProperty
from .validators import boolean, integer


class ChannelTargetInfo(AWSProperty):
    props = {
        "ChannelId": (str, True),
        "RetryIntervalInMinutes": (integer, True),
    }


class ContactTargetInfo(AWSProperty):
    props = {
        "ContactId": (str, True),
        "IsEssential": (boolean, True),
    }


class Targets(AWSProperty):
    props = {
        "ChannelTargetInfo": (ChannelTargetInfo, False),
        "ContactTargetInfo": (ContactTargetInfo, False),
    }


class Stage(AWSProperty):
    props = {
        "DurationInMinutes": (integer, True),
        "Targets": ([Targets], False),
    }


class Contact(AWSObject):
    resource_type = "AWS::SSMContacts::Contact"

    props = {
        "Alias": (str, True),
        "DisplayName": (str, True),
        "Plan": ([Stage], True),
        "Type": (str, True),
    }


class ContactChannel(AWSObject):
    resource_type = "AWS::SSMContacts::ContactChannel"

    props = {
        "ChannelAddress": (str, True),
        "ChannelName": (str, True),
        "ChannelType": (str, True),
        "ContactId": (str, True),
        "DeferActivation": (boolean, False),
    }
