# Copyright (c) 2012-2019, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 3.3.0


from troposphere import Tags

from . import AWSObject, AWSProperty

VALID_HOMEDIRECTORY_TYPE = ("LOGICAL", "PATH")


def validate_homedirectory_type(homedirectory_type):
    """Validate HomeDirectoryType for User"""

    if homedirectory_type not in VALID_HOMEDIRECTORY_TYPE:  # NOQA
        raise ValueError(
            "User HomeDirectoryType must be one of: %s"
            % ", ".join(VALID_HOMEDIRECTORY_TYPE)  # NOQA
        )
    return homedirectory_type


class EndpointDetails(AWSProperty):
    props = {
        "AddressAllocationIds": ([str], False),
        "SecurityGroupIds": ([str], False),
        "SubnetIds": ([str], False),
        "VpcEndpointId": (str, False),
        "VpcId": (str, False),
    }


class IdentityProviderDetails(AWSProperty):
    props = {
        "InvocationRole": (str, True),
        "Url": (str, True),
    }


class ProtocolDetails(AWSProperty):
    props = {
        "PassiveIp": (str, False),
    }


class Server(AWSObject):
    resource_type = "AWS::Transfer::Server"

    props = {
        "Certificate": (str, False),
        "Domain": (str, False),
        "EndpointDetails": (EndpointDetails, False),
        "EndpointType": (str, False),
        "IdentityProviderDetails": (IdentityProviderDetails, False),
        "IdentityProviderType": (str, False),
        "LoggingRole": (str, False),
        "ProtocolDetails": (ProtocolDetails, False),
        "Protocols": ([str], False),
        "SecurityPolicyName": (str, False),
        "Tags": (Tags, False),
    }


class HomeDirectoryMapEntry(AWSProperty):
    props = {
        "Entry": (str, True),
        "Target": (str, True),
    }


class User(AWSObject):
    resource_type = "AWS::Transfer::User"

    props = {
        "HomeDirectory": (str, False),
        "HomeDirectoryMappings": ([HomeDirectoryMapEntry], False),
        "HomeDirectoryType": (validate_homedirectory_type, False),
        "Policy": (str, False),
        "Role": (str, True),
        "ServerId": (str, True),
        "SshPublicKeys": ([str], False),
        "Tags": (Tags, False),
        "UserName": (str, True),
    }
