# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 39.1.0


from troposphere import Tags

from . import AWSObject, AWSProperty
from .validators import boolean, double, integer


class InsightsConfiguration(AWSProperty):
    props = {
        "InsightsEnabled": (boolean, False),
        "NotificationsEnabled": (boolean, False),
    }


class Group(AWSObject):
    resource_type = "AWS::XRay::Group"

    props = {
        "FilterExpression": (str, False),
        "GroupName": (str, False),
        "InsightsConfiguration": (InsightsConfiguration, False),
        "Tags": (Tags, False),
    }


class SamplingRule(AWSProperty):
    props = {
        "Attributes": (dict, False),
        "FixedRate": (double, False),
        "HTTPMethod": (str, False),
        "Host": (str, False),
        "Priority": (integer, False),
        "ReservoirSize": (integer, False),
        "ResourceARN": (str, False),
        "RuleARN": (str, False),
        "RuleName": (str, False),
        "ServiceName": (str, False),
        "ServiceType": (str, False),
        "URLPath": (str, False),
        "Version": (integer, False),
    }


class SamplingRuleRecord(AWSProperty):
    props = {
        "CreatedAt": (str, False),
        "ModifiedAt": (str, False),
        "SamplingRule": (SamplingRule, False),
    }


class SamplingRuleUpdate(AWSProperty):
    props = {
        "Attributes": (dict, False),
        "FixedRate": (double, False),
        "HTTPMethod": (str, False),
        "Host": (str, False),
        "Priority": (integer, False),
        "ReservoirSize": (integer, False),
        "ResourceARN": (str, False),
        "RuleARN": (str, False),
        "RuleName": (str, False),
        "ServiceName": (str, False),
        "ServiceType": (str, False),
        "URLPath": (str, False),
    }
