import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [cases](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnectcases.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Cases extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [cases](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnectcases.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to retrieve information about the fields in the case domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_BatchGetField.html
     */
    toBatchGetField(): this;
    /**
     * Grants permission to update the field options in the case domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_BatchPutFieldOptions.html
     */
    toBatchPutFieldOptions(): this;
    /**
     * Grants permission to create a case in the case domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_CreateCase.html
     */
    toCreateCase(): this;
    /**
     * Grants permission to create a new case domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_CreateDomain.html
     */
    toCreateDomain(): this;
    /**
     * Grants permission to create a field in the case domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_CreateField.html
     */
    toCreateField(): this;
    /**
     * Grants permission to create a layout in the case domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_CreateLayout.html
     */
    toCreateLayout(): this;
    /**
     * Grants permission to create a related item associated to a case in the case domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_CreateRelatedItem.html
     */
    toCreateRelatedItem(): this;
    /**
     * Grants permission to create a template in the case domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_CreateTemplate.html
     */
    toCreateTemplate(): this;
    /**
     * Grants permission to retrieve information about a case in the case domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_GetCase.html
     */
    toGetCase(): this;
    /**
     * Grants permission to retrieve information about the case event configuraton in the case domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_GetCaseEventConfiguration.html
     */
    toGetCaseEventConfiguration(): this;
    /**
     * Grants permission to retrieve information about the case domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_GetDomain.html
     */
    toGetDomain(): this;
    /**
     * Grants permission to retrieve information about the layout in the case domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_GetLayout.html
     */
    toGetLayout(): this;
    /**
     * Grants permission to retrieve information about the template in the case domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_GetTemplate.html
     */
    toGetTemplate(): this;
    /**
     * Grants permission to list cases for a specific contact in the case domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_ListCasesForContact.html
     */
    toListCasesForContact(): this;
    /**
     * Grants permission to list all domains in the aws account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_ListDomains.html
     */
    toListDomains(): this;
    /**
     * Grants permission to list field options for a single select field in the case domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_ListFieldOptions.html
     */
    toListFieldOptions(): this;
    /**
     * Grants permission to list fields in the case domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_ListFields.html
     */
    toListFields(): this;
    /**
     * Grants permission to list layouts in the case domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_ListLayouts.html
     */
    toListLayouts(): this;
    /**
     * Grants permission to list the tags for the specified resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list templates in the case domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_ListTemplates.html
     */
    toListTemplates(): this;
    /**
     * Grants permission to insert or update the case event configuration in the case domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_PutCaseEventConfiguration.html
     */
    toPutCaseEventConfiguration(): this;
    /**
     * Grants permission to search for cases in the case domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_SearchCases.html
     */
    toSearchCases(): this;
    /**
     * Grants permission to search for related items associated to the case in the case domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_SearchRelatedItems.html
     */
    toSearchRelatedItems(): this;
    /**
     * Grants permission to add the specified tags to the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove the specified tags from the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the field values on the case in the case domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_UpdateCase.html
     */
    toUpdateCase(): this;
    /**
     * Grants permission to update the field in the case domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_UpdateField.html
     */
    toUpdateField(): this;
    /**
     * Grants permission to update the layout in the case domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_UpdateLayout.html
     */
    toUpdateLayout(): this;
    /**
     * Grants permission to update the template in the case domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cases/latest/APIReference/API_UpdateTemplate.html
     */
    toUpdateTemplate(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Case to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/cases.html
     *
     * @param domainId - Identifier for the domainId.
     * @param caseId - Identifier for the caseId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCase(domainId: string, caseId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Domain to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/cases.html
     *
     * @param domainId - Identifier for the domainId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDomain(domainId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Field to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/case-fields.html
     *
     * @param domainId - Identifier for the domainId.
     * @param fieldId - Identifier for the fieldId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onField(domainId: string, fieldId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Layout to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/case-layouts.html
     *
     * @param domainId - Identifier for the domainId.
     * @param layoutId - Identifier for the layoutId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLayout(domainId: string, layoutId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type RelatedItem to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/associatecontactandcase.html
     *
     * @param domainId - Identifier for the domainId.
     * @param caseId - Identifier for the caseId.
     * @param relatedItemId - Identifier for the relatedItemId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRelatedItem(domainId: string, caseId: string, relatedItemId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Template to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/case-templates.html
     *
     * @param domainId - Identifier for the domainId.
     * @param templateId - Identifier for the templateId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTemplate(domainId: string, templateId: string, account?: string, region?: string, partition?: string): this;
}
