import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [consolidatedbilling](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsconsolidatedbilling.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Consolidatedbilling extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [consolidatedbilling](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsconsolidatedbilling.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to get account role (Payer, Linked, Regular)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toGetAccountBillingRole(): this;
    /**
     * Grants permission to get list of member/linked accounts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toListLinkedAccounts(): this;
    protected accessLevelList: AccessLevelList;
}
