import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [iotroborunner](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotroborunner.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Iotroborunner extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [iotroborunner](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotroborunner.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateDestination.html
     */
    toCreateDestination(): this;
    /**
     * Grants permission to create a site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateSite.html
     */
    toCreateSite(): this;
    /**
     * Grants permission to create a worker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateWorker.html
     */
    toCreateWorker(): this;
    /**
     * Grants permission to create a worker fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateWorkerFleet.html
     */
    toCreateWorkerFleet(): this;
    /**
     * Grants permission to delete a destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteDestination.html
     */
    toDeleteDestination(): this;
    /**
     * Grants permission to delete a site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteSite.html
     */
    toDeleteSite(): this;
    /**
     * Grants permission to delete a worker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteWorker.html
     */
    toDeleteWorker(): this;
    /**
     * Grants permission to delete a worker fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteWorkerFleet.html
     */
    toDeleteWorkerFleet(): this;
    /**
     * Grants permission to get a destination
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetDestination.html
     */
    toGetDestination(): this;
    /**
     * Grants permission to get a site
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetSite.html
     */
    toGetSite(): this;
    /**
     * Grants permission to get a worker
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetWorker.html
     */
    toGetWorker(): this;
    /**
     * Grants permission to get a worker fleet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetWorkerFleet.html
     */
    toGetWorkerFleet(): this;
    /**
     * Grants permission to list destinations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListDestinations.html
     */
    toListDestinations(): this;
    /**
     * Grants permission to list sites
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListSites.html
     */
    toListSites(): this;
    /**
     * Grants permission to list worker fleets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListWorkerFleets.html
     */
    toListWorkerFleets(): this;
    /**
     * Grants permission to list workers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListWorkers.html
     */
    toListWorkers(): this;
    /**
     * Grants permission to update a destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_UpdateDestination.html
     */
    toUpdateDestination(): this;
    /**
     * Grants permission to update a site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_UpdateSite.html
     */
    toUpdateSite(): this;
    /**
     * Grants permission to update a worker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_UpdateWorker.html
     */
    toUpdateWorker(): this;
    /**
     * Grants permission to update a worker fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_UpdateWorkerFleet.html
     */
    toUpdateWorkerFleet(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type DestinationResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param siteId - Identifier for the siteId.
     * @param destinationId - Identifier for the destinationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifDestinationResourceId()
     */
    onDestinationResource(siteId: string, destinationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type SiteResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param siteId - Identifier for the siteId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifSiteResourceId()
     */
    onSiteResource(siteId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type WorkerFleetResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param siteId - Identifier for the siteId.
     * @param workerFleetId - Identifier for the workerFleetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifWorkerFleetResourceId()
     */
    onWorkerFleetResource(siteId: string, workerFleetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type WorkerResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param siteId - Identifier for the siteId.
     * @param workerFleetId - Identifier for the workerFleetId.
     * @param workerId - Identifier for the workerId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifWorkerResourceId()
     */
    onWorkerResource(siteId: string, workerFleetId: string, workerId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the destination's identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Destination
     *
     * Applies to resource types:
     * - DestinationResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifDestinationResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the site's identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Site
     *
     * Applies to resource types:
     * - SiteResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSiteResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the worker fleet's identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#WorkerFleet
     *
     * Applies to resource types:
     * - WorkerFleetResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifWorkerFleetResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the workers identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Worker
     *
     * Applies to resource types:
     * - WorkerResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifWorkerResourceId(value: string | string[], operator?: Operator | string): this;
}
