"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplaceSellerReporting = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [aws-marketplace-seller-reporting](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacesellerreporting.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplaceSellerReporting extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aws-marketplace-seller-reporting](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacesellerreporting.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'aws-marketplace';
        this.accessLevelList = {
            Read: [
                'GetSellerDashboard'
            ]
        };
    }
    /**
     * Grants permission to view a seller dashboard
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/dashboards.html#reports-accessing
     */
    toGetSellerDashboard() {
        return this.to('GetSellerDashboard');
    }
    /**
     * Adds a resource of type SellerDashboard to the statement
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/dashboards.html#reports-accessing
     *
     * @param catalog - Identifier for the catalog.
     * @param dashboardName - Identifier for the dashboardName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSellerDashboard(catalog, dashboardName, account, partition) {
        return this.on(`arn:${partition || AwsMarketplaceSellerReporting.defaultPartition}:aws-marketplace::${account || '*'}:${catalog}/SellerDashboard/${dashboardName}`);
    }
}
exports.AwsMarketplaceSellerReporting = AwsMarketplaceSellerReporting;
_a = JSII_RTTI_SYMBOL_1;
AwsMarketplaceSellerReporting[_a] = { fqn: "iam-floyd.AwsMarketplaceSellerReporting", version: "0.477.0" };
//# sourceMappingURL=data:application/json;base64,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