import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [arc-zonal-shift](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53applicationrecoverycontroller-zonalshift.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class ArcZonalShift extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [arc-zonal-shift](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53applicationrecoverycontroller-zonalshift.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to cancel an active zonal shift
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifElasticloadbalancingResourceTag()
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_CancelZonalShift.html
     */
    toCancelZonalShift(): this;
    /**
     * Grants permission to get information about a managed resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifElasticloadbalancingResourceTag()
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_GetManagedResource.html
     */
    toGetManagedResource(): this;
    /**
     * Grants permission to list managed resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_ListManagedResources.html
     */
    toListManagedResources(): this;
    /**
     * Grants permission to list zonal shifts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_ListZonalShifts.html
     */
    toListZonalShifts(): this;
    /**
     * Grants permission to start a zonal shift
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifElasticloadbalancingResourceTag()
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_StartZonalShift.html
     */
    toStartZonalShift(): this;
    /**
     * Grants permission to update an existing zonal shift
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifElasticloadbalancingResourceTag()
     *
     * https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_UpdateZonalShift.html
     */
    toUpdateZonalShift(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type ALB to the statement
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.html
     *
     * @param loadBalancerName - Identifier for the loadBalancerName.
     * @param loadBalancerId - Identifier for the loadBalancerId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifElasticloadbalancingResourceTag()
     */
    onALB(loadBalancerName: string, loadBalancerId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type NLB to the statement
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.html
     *
     * @param loadBalancerName - Identifier for the loadBalancerName.
     * @param loadBalancerId - Identifier for the loadBalancerId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifElasticloadbalancingResourceTag()
     */
    onNLB(loadBalancerName: string, loadBalancerId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags associated with the managed resource
     *
     * https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/load-balancer-authentication-access-control.html#elb-condition-keys
     *
     * Applies to actions:
     * - .toCancelZonalShift()
     * - .toGetManagedResource()
     * - .toStartZonalShift()
     * - .toUpdateZonalShift()
     *
     * Applies to resource types:
     * - ALB
     * - NLB
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifElasticloadbalancingResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
}
