"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route53domains = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [route53domains](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53domains.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Route53domains extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [route53domains](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53domains.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'route53domains';
        this.accessLevelList = {
            Write: [
                'AcceptDomainTransferFromAnotherAwsAccount',
                'AssociateDelegationSignerToDomain',
                'CancelDomainTransferToAnotherAwsAccount',
                'DeleteDomain',
                'DisableDomainAutoRenew',
                'DisableDomainTransferLock',
                'DisassociateDelegationSignerFromDomain',
                'EnableDomainAutoRenew',
                'EnableDomainTransferLock',
                'PushDomain',
                'RegisterDomain',
                'RejectDomainTransferFromAnotherAwsAccount',
                'RenewDomain',
                'ResendContactReachabilityEmail',
                'ResendOperationAuthorization',
                'RetrieveDomainAuthCode',
                'TransferDomain',
                'TransferDomainToAnotherAwsAccount',
                'UpdateDomainContact',
                'UpdateDomainContactPrivacy',
                'UpdateDomainNameservers'
            ],
            Read: [
                'CheckDomainAvailability',
                'CheckDomainTransferability',
                'GetContactReachabilityStatus',
                'GetDomainDetail',
                'GetDomainSuggestions',
                'GetOperationDetail',
                'ListTagsForDomain',
                'ViewBilling'
            ],
            Tagging: [
                'DeleteTagsForDomain',
                'UpdateTagsForDomain'
            ],
            List: [
                'ListDomains',
                'ListOperations',
                'ListPrices'
            ]
        };
    }
    /**
     * Grants permission to accept the transfer of a domain from another AWS account to the current AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html
     */
    toAcceptDomainTransferFromAnotherAwsAccount() {
        return this.to('AcceptDomainTransferFromAnotherAwsAccount');
    }
    /**
     * Grants permission to associate a new delegation signer to a domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AssociateDelegationSignerToDomain.html
     */
    toAssociateDelegationSignerToDomain() {
        return this.to('AssociateDelegationSignerToDomain');
    }
    /**
     * Grants permission to cancel the transfer of a domain from the current AWS account to another AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CancelDomainTransferToAnotherAwsAccount.html
     */
    toCancelDomainTransferToAnotherAwsAccount() {
        return this.to('CancelDomainTransferToAnotherAwsAccount');
    }
    /**
     * Grants permission to check the availability of one domain name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CheckDomainAvailability.html
     */
    toCheckDomainAvailability() {
        return this.to('CheckDomainAvailability');
    }
    /**
     * Grants permission to check whether a domain name can be transferred to Amazon Route 53
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CheckDomainTransferability.html
     */
    toCheckDomainTransferability() {
        return this.to('CheckDomainTransferability');
    }
    /**
     * Grants permission to delete domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DeleteDomain.html
     */
    toDeleteDomain() {
        return this.to('DeleteDomain');
    }
    /**
     * Grants permission to delete the specified tags for a domain
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DeleteTagsForDomain.html
     */
    toDeleteTagsForDomain() {
        return this.to('DeleteTagsForDomain');
    }
    /**
     * Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html
     */
    toDisableDomainAutoRenew() {
        return this.to('DisableDomainAutoRenew');
    }
    /**
     * Grants permission to remove the transfer lock on the domain (specifically the clientTransferProhibited status) to allow domain transfers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainTransferLock.html
     */
    toDisableDomainTransferLock() {
        return this.to('DisableDomainTransferLock');
    }
    /**
     * Grants permission to disassociate an existing delegation signer from a domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisassociateDelegationSignerFromDomain.html
     */
    toDisassociateDelegationSignerFromDomain() {
        return this.to('DisassociateDelegationSignerFromDomain');
    }
    /**
     * Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html
     */
    toEnableDomainAutoRenew() {
        return this.to('EnableDomainAutoRenew');
    }
    /**
     * Grants permission to set the transfer lock on the domain (specifically the clientTransferProhibited status) to prevent domain transfers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_EnableDomainTransferLock.html
     */
    toEnableDomainTransferLock() {
        return this.to('EnableDomainTransferLock');
    }
    /**
     * Grants permission to get information about whether the registrant contact has responded for operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetContactReachabilityStatus.html
     */
    toGetContactReachabilityStatus() {
        return this.to('GetContactReachabilityStatus');
    }
    /**
     * Grants permission to get detailed information about a domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainDetail.html
     */
    toGetDomainDetail() {
        return this.to('GetDomainDetail');
    }
    /**
     * Grants permission to get a list of suggested domain names given a string, which can either be a domain name or simply a word or phrase (without spaces)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainSuggestions.html
     */
    toGetDomainSuggestions() {
        return this.to('GetDomainSuggestions');
    }
    /**
     * Grants permission to get the current status of an operation that is not completed
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html
     */
    toGetOperationDetail() {
        return this.to('GetOperationDetail');
    }
    /**
     * Grants permission to list all the domain names registered with Amazon Route 53 for the current AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListDomains.html
     */
    toListDomains() {
        return this.to('ListDomains');
    }
    /**
     * Grants permission to list the operation IDs of operations that are not yet complete
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html
     */
    toListOperations() {
        return this.to('ListOperations');
    }
    /**
     * Grants permission to list the prices of operations for TLDs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListPrices.html
     */
    toListPrices() {
        return this.to('ListPrices');
    }
    /**
     * Grants permission to list all the tags that are associated with the specified domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListTagsForDomain.html
     */
    toListTagsForDomain() {
        return this.to('ListTagsForDomain');
    }
    /**
     * Grants permission to change the IPS tag of .uk domain to initiate a transfer process from Route 53 to another registrar
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_PushDomain.html
     */
    toPushDomain() {
        return this.to('PushDomain');
    }
    /**
     * Grants permission to register domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RegisterDomain.html
     */
    toRegisterDomain() {
        return this.to('RegisterDomain');
    }
    /**
     * Grants permission to reject the transfer of a domain from another AWS account to the current AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RejectDomainTransferFromAnotherAwsAccount.html
     */
    toRejectDomainTransferFromAnotherAwsAccount() {
        return this.to('RejectDomainTransferFromAnotherAwsAccount');
    }
    /**
     * Grants permission to renew domains for the specified number of years
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RenewDomain.html
     */
    toRenewDomain() {
        return this.to('RenewDomain');
    }
    /**
     * Grants permission to resend the confirmation email to the current email address for the registrant contact for operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendContactReachabilityEmail.html
     */
    toResendContactReachabilityEmail() {
        return this.to('ResendContactReachabilityEmail');
    }
    /**
     * Grants permission to resend the operation authorization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendOperationAuthorization.html
     */
    toResendOperationAuthorization() {
        return this.to('ResendOperationAuthorization');
    }
    /**
     * Grants permission to get the AuthCode for the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RetrieveDomainAuthCode.html
     */
    toRetrieveDomainAuthCode() {
        return this.to('RetrieveDomainAuthCode');
    }
    /**
     * Grants permission to transfer a domain from another registrar to Amazon Route 53
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomain.html
     */
    toTransferDomain() {
        return this.to('TransferDomain');
    }
    /**
     * Grants permission to transfer a domain from the current AWS account to another AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html
     */
    toTransferDomainToAnotherAwsAccount() {
        return this.to('TransferDomainToAnotherAwsAccount');
    }
    /**
     * Grants permission to update the contact information for domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContact.html
     */
    toUpdateDomainContact() {
        return this.to('UpdateDomainContact');
    }
    /**
     * Grants permission to update the domain contact privacy setting
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContactPrivacy.html
     */
    toUpdateDomainContactPrivacy() {
        return this.to('UpdateDomainContactPrivacy');
    }
    /**
     * Grants permission to replace the current set of name servers for a domain with the specified set of name servers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainNameservers.html
     */
    toUpdateDomainNameservers() {
        return this.to('UpdateDomainNameservers');
    }
    /**
     * Grants permission to add or update tags for a specified domain
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateTagsForDomain.html
     */
    toUpdateTagsForDomain() {
        return this.to('UpdateTagsForDomain');
    }
    /**
     * Grants permission to get all the domain-related billing records for the current AWS account for a specified period
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ViewBilling.html
     */
    toViewBilling() {
        return this.to('ViewBilling');
    }
}
exports.Route53domains = Route53domains;
_a = JSII_RTTI_SYMBOL_1;
Route53domains[_a] = { fqn: "iam-floyd.Route53domains", version: "0.477.0" };
//# sourceMappingURL=data:application/json;base64,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